/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.world.gen.nbt;

import com.hbm.util.Tuple;
import com.hbm.world.gen.nbt.JigsawPiece;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class JigsawPool {
    List<Tuple.Pair<JigsawPiece, Integer>> pieces = new ArrayList<Tuple.Pair<JigsawPiece, Integer>>();
    int totalWeight = 0;
    public String fallback;
    private boolean isClone;

    public void add(JigsawPiece piece, int weight) {
        if (weight <= 0) {
            throw new IllegalStateException("JigsawPool spawn weight must be positive!");
        }
        this.pieces.add(new Tuple.Pair<JigsawPiece, Integer>(piece, weight));
        this.totalWeight += weight;
    }

    protected JigsawPool clone() {
        JigsawPool clone = new JigsawPool();
        clone.pieces = new ArrayList<Tuple.Pair<JigsawPiece, Integer>>(this.pieces);
        clone.fallback = this.fallback;
        clone.totalWeight = this.totalWeight;
        clone.isClone = true;
        return clone;
    }

    public JigsawPiece get(Random rand) {
        if (this.totalWeight <= 0) {
            return null;
        }
        int weight = rand.nextInt(this.totalWeight);
        for (int i = 0; i < this.pieces.size(); ++i) {
            Tuple.Pair<JigsawPiece, Integer> pair = this.pieces.get(i);
            if ((weight -= pair.getValue().intValue()) >= 0) continue;
            if (this.isClone) {
                this.pieces.remove(i);
                this.totalWeight -= pair.getValue().intValue();
            }
            return pair.getKey();
        }
        return null;
    }
}

