/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util;

import com.hbm.config.GeneralConfig;
import com.hbm.handler.HazmatRegistry;
import com.hbm.inventory.FluidContainer;
import com.hbm.inventory.FluidContainerRegistry;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.main.MainRegistry;
import com.hbm.util.ItemStackUtil;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.eventhandler.EventBus;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class Compat {
    public static final String MOD_GT6 = "gregtech";
    public static final String MOD_GCC = "GalacticraftCore";
    public static final String MOD_AR = "advancedrocketry";
    public static final String MOD_EF = "etfuturum";
    public static final String MOD_REC = "ReactorCraft";
    public static final String MOD_TIC = "TConstruct";
    public static final String MOD_RC = "Railcraft";
    public static final String MOD_TC = "tc";
    public static final String MOD_EIDS = "endlessids";
    public static final String MOD_ANG = "angelica";
    public static final String MOD_TOR = "Torcherino";
    public static Method getBiomeShortArray;

    public static Item tryLoadItem(String domain, String name) {
        return (Item)Item.field_150901_e.func_82594_a(Compat.getReg(domain, name));
    }

    public static Block tryLoadBlock(String domain, String name) {
        return (Block)Block.field_149771_c.func_82594_a(Compat.getReg(domain, name));
    }

    private static String getReg(String domain, String name) {
        return domain + ":" + name;
    }

    public static ItemStack getPreferredOreOutput(List<ItemStack> oreList) {
        int lowestPref = -1;
        ItemStack preferredStack = null;
        block0: for (ItemStack item : oreList) {
            String modid = ItemStackUtil.getModIdFromItemStack(item);
            for (int i = 0; i < GeneralConfig.preferredOutputMod.length; ++i) {
                if (!modid.equals(GeneralConfig.preferredOutputMod[i])) continue;
                if (lowestPref >= 0 && i >= lowestPref) continue block0;
                preferredStack = item;
                lowestPref = i;
                continue block0;
            }
        }
        if (preferredStack != null) {
            return preferredStack.func_77946_l();
        }
        return oreList.get(0).func_77946_l();
    }

    public static boolean isModLoaded(String modid) {
        return Loader.isModLoaded((String)modid);
    }

    public static List<ItemStack> scrapeItemFromME(ItemStack meDrive) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        try {
            if (meDrive != null && meDrive.func_77942_o()) {
                NBTTagCompound nbt = meDrive.func_77978_p();
                int types = nbt.func_74765_d("it");
                for (int i = 0; i < types; ++i) {
                    int count;
                    NBTBase stackTag = nbt.func_74781_a("#" + i);
                    if (!(stackTag instanceof NBTTagCompound)) continue;
                    NBTTagCompound compound = (NBTTagCompound)stackTag;
                    ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)compound);
                    stack.field_77994_a = count = nbt.func_74762_e("@" + i);
                    stacks.add(stack);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stacks;
    }

    public static void registerCompatHazmat() {
        double helmet = 0.2;
        double chest = 0.4;
        double legs = 0.3;
        double boots = 0.1;
        double p90 = 1.0;
        double p99 = 2.0;
        Compat.tryRegisterHazmat(MOD_GT6, "gt.armor.hazmat.radiation.head", p90 * helmet);
        Compat.tryRegisterHazmat(MOD_GT6, "gt.armor.hazmat.radiation.chest", p90 * chest);
        Compat.tryRegisterHazmat(MOD_GT6, "gt.armor.hazmat.radiation.legs", p90 * legs);
        Compat.tryRegisterHazmat(MOD_GT6, "gt.armor.hazmat.radiation.boots", p90 * boots);
        Compat.tryRegisterHazmat(MOD_GT6, "gt.armor.hazmat.universal.head", p99 * helmet);
        Compat.tryRegisterHazmat(MOD_GT6, "gt.armor.hazmat.universal.chest", p99 * chest);
        Compat.tryRegisterHazmat(MOD_GT6, "gt.armor.hazmat.universal.legs", p99 * legs);
        Compat.tryRegisterHazmat(MOD_GT6, "gt.armor.hazmat.universal.boots", p99 * boots);
        Compat.tryRegisterHazmat(MOD_REC, "reactorcraft_item_hazhelmet", p99 * helmet);
        Compat.tryRegisterHazmat(MOD_REC, "reactorcraft_item_hazchest", p99 * chest);
        Compat.tryRegisterHazmat(MOD_REC, "reactorcraft_item_hazlegs", p99 * legs);
        Compat.tryRegisterHazmat(MOD_REC, "reactorcraft_item_hazboots", p99 * boots);
        Compat.tryRegisterHazmat(MOD_EF, "netherite_helmet", p90 * helmet);
        Compat.tryRegisterHazmat(MOD_EF, "netherite_chestplate", p90 * chest);
        Compat.tryRegisterHazmat(MOD_EF, "netherite_leggings", p90 * legs);
        Compat.tryRegisterHazmat(MOD_EF, "netherite_boots", p90 * boots);
    }

    private static void tryRegisterHazmat(String mod, String name, double resistance) {
        Item item = Compat.tryLoadItem(mod, name);
        if (item != null) {
            HazmatRegistry.registerHazmat(item, resistance);
        }
    }

    public static void registerCompatFluidContainers() {
        if (Compat.isModLoaded(MOD_TC) && GeneralConfig.enableFluidContainerCompat) {
            Item canister = Compat.tryLoadItem(MOD_TC, "emptyCanister");
            Item diesel = Compat.tryLoadItem(MOD_TC, "diesel");
            if (diesel != null && canister != null) {
                FluidContainerRegistry.registerContainer(new FluidContainer(new ItemStack(diesel), new ItemStack(canister), Fluids.DIESEL, 1000));
            }
        }
    }

    public static void handleRailcraftNonsense() {
        if (!Loader.isModLoaded((String)MOD_RC)) {
            return;
        }
        MainRegistry.logger.info("#######################################################");
        MainRegistry.logger.info("| Railcraft detected, deploying anti-nonsense measures...");
        try {
            ConcurrentHashMap listeners = (ConcurrentHashMap)ReflectionHelper.getPrivateValue(EventBus.class, (Object)FMLCommonHandler.instance().bus(), (String[])new String[]{"listeners"});
            Object nonsense = null;
            for (Object o : listeners.keySet()) {
                if (!o.getClass().getName().equals("mods.railcraft.common.blocks.hidden.TrailTicker")) continue;
                MainRegistry.logger.info("| Found TrailTicker!");
                nonsense = o;
                break;
            }
            FMLCommonHandler.instance().bus().unregister(nonsense);
            MainRegistry.logger.info("| Successfully removed Railcraft nonsense.");
        }
        catch (Exception x) {
            MainRegistry.logger.error("| Tried to remove Railcraft block but failed due to " + x.getMessage());
        }
        MainRegistry.logger.info("#######################################################");
    }

    public static Class getChunkBiomeHook() {
        try {
            return Class.forName("com.falsepattern.endlessids.mixin.helpers.ChunkBiomeHook");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Method getBiomeShortArray() {
        if (getBiomeShortArray != null) {
            return getBiomeShortArray;
        }
        try {
            Method m;
            getBiomeShortArray = m = Compat.getChunkBiomeHook().getDeclaredMethod("getBiomeShortArray", new Class[0]);
            return m;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static short[] getBiomeShortArray(Object instance) {
        Method m = Compat.getBiomeShortArray();
        if (m != null) {
            try {
                return (short[])m.invoke(instance, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static TileEntity getTileStandard(World world, int x, int y, int z) {
        if (!world.func_72863_F().func_73149_a(x >> 4, z >> 4)) {
            return null;
        }
        return world.func_147438_o(x, y, z);
    }

    public static void blacklistAccelerator(Class clazz) {
        FMLInterModComms.sendMessage((String)MOD_TOR, (String)"blacklist-tile", (String)clazz.getName());
    }

    public static enum ReikaIsotope {
        C14(6.25f),
        U235(1.0f),
        U238(0.25f),
        Pu239(5.0f),
        Pu244(1.0f),
        Th232(0.1f),
        Rn222(100.0f),
        Ra226(7.5f),
        Sr90(30.0f),
        Po210(75.0f),
        Cs134(50.0f),
        Xe135(1250.0f),
        Zr93(2.5f),
        Mo99(100.0f),
        Cs137(20.0f),
        Tc99(2.75f),
        I131(150.0f),
        Pm147(50.0f),
        I129(1.5f),
        Sm151(10.0f),
        Ru106(50.0f),
        Kr85(30.0f),
        Pd107(1.5f),
        Se79(5.0f),
        Gd155(50.0f),
        Sb125(50.0f),
        Sn126(5.0f),
        Xe136(0.0f),
        I135(2000.0f),
        Xe131(100.0f),
        Ru103(10000.0f),
        Pm149(100.0f),
        Rh105(2000.0f);

        private float rads;

        private ReikaIsotope(float rads) {
            this.rads = rads;
        }

        public float getRad() {
            return this.rads;
        }
    }
}

