/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.rbmk;

import api.hbm.fluid.IFluidStandardTransceiver;
import com.hbm.blocks.ModBlocks;
import com.hbm.entity.projectile.EntityRBMKDebris;
import com.hbm.handler.CompatHandler;
import com.hbm.inventory.container.ContainerRBMKHeater;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FT_Heatable;
import com.hbm.inventory.gui.GUIRBMKHeater;
import com.hbm.lib.Library;
import com.hbm.tileentity.machine.rbmk.RBMKDials;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKConsole;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKSlottedBase;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="opencomputers")})
public class TileEntityRBMKHeater
extends TileEntityRBMKSlottedBase
implements IFluidStandardTransceiver,
SimpleComponent,
CompatHandler.OCComponent {
    public FluidTank feed = new FluidTank(Fluids.COOLANT, 16000);
    public FluidTank steam = new FluidTank(Fluids.COOLANT_HOT, 16000);

    public TileEntityRBMKHeater() {
        super(1);
    }

    @Override
    public String getName() {
        return "container.rbmkHeater";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.feed.setType(0, this.slots);
            if (this.feed.getTankType().hasTrait(FT_Heatable.class)) {
                FT_Heatable trait = this.feed.getTankType().getTrait(FT_Heatable.class);
                FT_Heatable.HeatingStep step = trait.getFirstStep();
                this.steam.setTankType(step.typeProduced);
                double tempRange = this.heat - (double)this.steam.getTankType().temperature;
                double eff = trait.getEfficiency(FT_Heatable.HeatingType.HEATEXCHANGER);
                if (tempRange > 0.0 && eff > 0.0) {
                    double TU_PER_DEGREE = 2000.0 * eff;
                    int inputOps = this.feed.getFill() / step.amountReq;
                    int outputOps = (this.steam.getMaxFill() - this.steam.getFill()) / step.amountProduced;
                    int tempOps = (int)Math.floor(tempRange * TU_PER_DEGREE / (double)step.heatReq);
                    int ops = Math.min(inputOps, Math.min(outputOps, tempOps));
                    this.feed.setFill(this.feed.getFill() - step.amountReq * ops);
                    this.steam.setFill(this.steam.getFill() + step.amountProduced * ops);
                    this.heat -= (double)(step.heatReq * ops) / TU_PER_DEGREE * trait.getEfficiency(FT_Heatable.HeatingType.HEATEXCHANGER);
                }
            } else {
                this.steam.setTankType(Fluids.NONE);
            }
            this.trySubscribe(this.feed.getTankType(), this.field_145850_b, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, Library.NEG_Y);
            for (DirPos pos : this.getOutputPos()) {
                if (this.steam.getFill() <= 0) continue;
                this.sendFluid(this.steam, this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
        }
        super.func_145845_h();
    }

    protected DirPos[] getOutputPos() {
        if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) == ModBlocks.rbmk_loader) {
            return new DirPos[]{new DirPos(this.field_145851_c, this.field_145848_d + RBMKDials.getColumnHeight(this.field_145850_b) + 1, this.field_145849_e, Library.POS_Y), new DirPos(this.field_145851_c + 1, this.field_145848_d - 1, this.field_145849_e, Library.POS_X), new DirPos(this.field_145851_c - 1, this.field_145848_d - 1, this.field_145849_e, Library.NEG_X), new DirPos(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e + 1, Library.POS_Z), new DirPos(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e - 1, Library.NEG_Z), new DirPos(this.field_145851_c, this.field_145848_d - 2, this.field_145849_e, Library.NEG_Y)};
        }
        if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 2, this.field_145849_e) == ModBlocks.rbmk_loader) {
            return new DirPos[]{new DirPos(this.field_145851_c, this.field_145848_d + RBMKDials.getColumnHeight(this.field_145850_b) + 1, this.field_145849_e, Library.POS_Y), new DirPos(this.field_145851_c + 1, this.field_145848_d - 2, this.field_145849_e, Library.POS_X), new DirPos(this.field_145851_c - 1, this.field_145848_d - 2, this.field_145849_e, Library.NEG_X), new DirPos(this.field_145851_c, this.field_145848_d - 2, this.field_145849_e + 1, Library.POS_Z), new DirPos(this.field_145851_c, this.field_145848_d - 2, this.field_145849_e - 1, Library.NEG_Z), new DirPos(this.field_145851_c, this.field_145848_d - 3, this.field_145849_e, Library.NEG_Y)};
        }
        return new DirPos[]{new DirPos(this.field_145851_c, this.field_145848_d + RBMKDials.getColumnHeight(this.field_145850_b) + 1, this.field_145849_e, Library.POS_Y)};
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.feed.readFromNBT(nbt, "feed");
        this.steam.readFromNBT(nbt, "steam");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.feed.writeToNBT(nbt, "feed");
        this.steam.writeToNBT(nbt, "steam");
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        this.feed.serialize(buf);
        this.steam.serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.feed.deserialize(buf);
        this.steam.deserialize(buf);
    }

    @Override
    public void onMelt(int reduce) {
        int count = 1 + this.field_145850_b.field_73012_v.nextInt(2);
        for (int i = 0; i < count; ++i) {
            this.spawnDebris(EntityRBMKDebris.DebrisType.BLANK);
        }
        super.onMelt(reduce);
    }

    @Override
    public TileEntityRBMKConsole.ColumnType getConsoleType() {
        return TileEntityRBMKConsole.ColumnType.HEATEX;
    }

    @Override
    public NBTTagCompound getNBTForConsole() {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("water", this.feed.getFill());
        data.func_74768_a("maxWater", this.feed.getMaxFill());
        data.func_74768_a("steam", this.steam.getFill());
        data.func_74768_a("maxSteam", this.steam.getMaxFill());
        data.func_74777_a("type", (short)this.feed.getTankType().getID());
        data.func_74777_a("hottype", (short)this.steam.getTankType().getID());
        return data;
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.feed, this.steam};
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.steam};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.feed};
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "rbmk_heater";
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getHeat(Context context, Arguments args) {
        return new Object[]{this.heat};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getFill(Context context, Arguments args) {
        return new Object[]{this.feed.getFill()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getFillMax(Context context, Arguments args) {
        return new Object[]{this.feed.getMaxFill()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getExport(Context context, Arguments args) {
        return new Object[]{this.steam.getFill()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getExportMax(Context context, Arguments args) {
        return new Object[]{this.steam.getMaxFill()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getFillType(Context context, Arguments args) {
        return new Object[]{this.feed.getTankType().getName()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getExportType(Context context, Arguments args) {
        return new Object[]{this.steam.getTankType().getName()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getInfo(Context context, Arguments args) {
        return new Object[]{this.heat, this.feed.getFill(), this.feed.getMaxFill(), this.steam.getFill(), this.steam.getMaxFill(), this.feed.getTankType().getName(), this.steam.getTankType().getName(), this.field_145851_c, this.field_145848_d, this.field_145849_e};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getCoordinates(Context context, Arguments args) {
        return new Object[]{this.field_145851_c, this.field_145848_d, this.field_145849_e};
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerRBMKHeater(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIRBMKHeater(player.field_71071_by, this);
    }
}

