/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.oil;

import api.hbm.fluid.IFluidStandardTransceiver;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.recipes.CrackingRecipes;
import com.hbm.tileentity.IBufPacketReceiver;
import com.hbm.tileentity.IFluidCopiable;
import com.hbm.tileentity.TileEntityLoadedBase;
import com.hbm.util.Tuple;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineCatalyticCracker
extends TileEntityLoadedBase
implements IBufPacketReceiver,
IFluidStandardTransceiver,
IFluidCopiable {
    public FluidTank[] tanks = new FluidTank[5];
    AxisAlignedBB bb = null;

    public TileEntityMachineCatalyticCracker() {
        this.tanks[0] = new FluidTank(Fluids.BITUMEN, 4000);
        this.tanks[1] = new FluidTank(Fluids.STEAM, 8000);
        this.tanks[2] = new FluidTank(Fluids.OIL, 4000);
        this.tanks[3] = new FluidTank(Fluids.PETROLEUM, 4000);
        this.tanks[4] = new FluidTank(Fluids.SPENTSTEAM, 800);
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.field_72984_F.func_76320_a("catalyticCracker_setup_tanks");
            this.setupTanks();
            this.field_145850_b.field_72984_F.func_76318_c("catalyticCracker_update_connections");
            this.updateConnections();
            this.field_145850_b.field_72984_F.func_76318_c("catalyticCracker_do_recipe");
            if (this.field_145850_b.func_82737_E() % 5L == 0L) {
                this.crack();
            }
            this.field_145850_b.field_72984_F.func_76318_c("catalyticCracker_send_fluid");
            if (this.field_145850_b.func_82737_E() % 10L == 0L) {
                for (DirPos pos : this.getConPos()) {
                    for (int i = 2; i <= 4; ++i) {
                        if (this.tanks[i].getFill() <= 0) continue;
                        this.sendFluid(this.tanks[i], this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                    }
                }
            }
            this.field_145850_b.field_72984_F.func_76319_b();
            this.networkPackNT(25);
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        for (FluidTank tank : this.tanks) {
            tank.serialize(buf);
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        for (FluidTank tank : this.tanks) {
            tank.deserialize(buf);
        }
    }

    private void updateConnections() {
        for (DirPos pos : this.getConPos()) {
            this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            this.trySubscribe(this.tanks[1].getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
        }
    }

    private void crack() {
        Tuple.Pair<FluidStack, FluidStack> quart = CrackingRecipes.getCracking(this.tanks[0].getTankType());
        if (quart != null) {
            int left = quart.getKey().fill;
            int right = quart.getValue().fill;
            for (int i = 0; i < 2; ++i) {
                if (this.tanks[0].getFill() < 100 || this.tanks[1].getFill() < 200 || !this.hasSpace(left, right)) continue;
                this.tanks[0].setFill(this.tanks[0].getFill() - 100);
                this.tanks[1].setFill(this.tanks[1].getFill() - 200);
                this.tanks[2].setFill(this.tanks[2].getFill() + left);
                this.tanks[3].setFill(this.tanks[3].getFill() + right);
                this.tanks[4].setFill(this.tanks[4].getFill() + 2);
            }
        }
    }

    private boolean hasSpace(int left, int right) {
        return this.tanks[2].getFill() + left <= this.tanks[2].getMaxFill() && this.tanks[3].getFill() + right <= this.tanks[3].getMaxFill() && this.tanks[4].getFill() + 2 <= this.tanks[4].getMaxFill();
    }

    private void setupTanks() {
        Tuple.Pair<FluidStack, FluidStack> quart = CrackingRecipes.getCracking(this.tanks[0].getTankType());
        if (quart != null) {
            this.tanks[1].setTankType(Fluids.STEAM);
            this.tanks[2].setTankType(quart.getKey().type);
            this.tanks[3].setTankType(quart.getValue().type);
            this.tanks[4].setTankType(Fluids.SPENTSTEAM);
        } else {
            this.tanks[2].setTankType(Fluids.NONE);
            this.tanks[3].setTankType(Fluids.NONE);
            this.tanks[4].setTankType(Fluids.NONE);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        for (int i = 0; i < 5; ++i) {
            this.tanks[i].readFromNBT(nbt, "tank" + i);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        for (int i = 0; i < 5; ++i) {
            this.tanks[i].writeToNBT(nbt, "tank" + i);
        }
    }

    protected DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c + dir.offsetX * 4 + rot.offsetX * 1, this.field_145848_d, this.field_145849_e + dir.offsetZ * 4 + rot.offsetZ * 1, dir), new DirPos(this.field_145851_c + dir.offsetX * 4 - rot.offsetX * 2, this.field_145848_d, this.field_145849_e + dir.offsetZ * 4 - rot.offsetZ * 2, dir), new DirPos(this.field_145851_c - dir.offsetX * 4 + rot.offsetX * 1, this.field_145848_d, this.field_145849_e - dir.offsetZ * 4 + rot.offsetZ * 1, dir.getOpposite()), new DirPos(this.field_145851_c - dir.offsetX * 4 - rot.offsetX * 2, this.field_145848_d, this.field_145849_e - dir.offsetZ * 4 - rot.offsetZ * 2, dir.getOpposite()), new DirPos(this.field_145851_c + dir.offsetX * 2 + rot.offsetX * 3, this.field_145848_d, this.field_145849_e + dir.offsetZ * 2 + rot.offsetZ * 3, rot), new DirPos(this.field_145851_c + dir.offsetX * 2 - rot.offsetX * 4, this.field_145848_d, this.field_145849_e + dir.offsetZ * 2 - rot.offsetZ * 4, rot), new DirPos(this.field_145851_c - dir.offsetX * 2 + rot.offsetX * 3, this.field_145848_d, this.field_145849_e - dir.offsetZ * 2 + rot.offsetZ * 3, rot.getOpposite()), new DirPos(this.field_145851_c - dir.offsetX * 2 - rot.offsetX * 4, this.field_145848_d, this.field_145849_e - dir.offsetZ * 2 - rot.offsetZ * 4, rot.getOpposite())};
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 3), (double)this.field_145848_d, (double)(this.field_145849_e - 3), (double)(this.field_145851_c + 4), (double)(this.field_145848_d + 16), (double)(this.field_145849_e + 4));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[2], this.tanks[3], this.tanks[4]};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0], this.tanks[1]};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public FluidTank getTankToPaste() {
        return this.tanks[0];
    }
}

