/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.fusion;

import api.hbm.fluidmk2.IFluidStandardTransceiverMK2;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.container.ContainerFusionBreeder;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIFusionBreeder;
import com.hbm.inventory.recipes.FluidBreederRecipes;
import com.hbm.inventory.recipes.OutgasserRecipes;
import com.hbm.items.machine.IItemFluidIdentifier;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.tileentity.machine.fusion.IFusionPowerReceiver;
import com.hbm.uninos.GenNode;
import com.hbm.uninos.NodeNet;
import com.hbm.uninos.UniNodespace;
import com.hbm.uninos.networkproviders.PlasmaNetwork;
import com.hbm.uninos.networkproviders.PlasmaNetworkProvider;
import com.hbm.util.Tuple;
import com.hbm.util.fauxpointtwelve.BlockPos;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityFusionBreeder
extends TileEntityMachineBase
implements IFluidStandardTransceiverMK2,
IFusionPowerReceiver,
IGUIProvider {
    protected GenNode plasmaNode;
    public FluidTank[] tanks = new FluidTank[2];
    public double neutronEnergy;
    public double neutronEnergySync;
    public double progress;
    public static final double capacity = 10000.0;
    AxisAlignedBB bb = null;

    public TileEntityFusionBreeder() {
        super(3);
        this.tanks[0] = new FluidTank(Fluids.NONE, 16000);
        this.tanks[1] = new FluidTank(Fluids.NONE, 16000);
    }

    @Override
    public String getName() {
        return "container.fusionBreeder";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.tanks[0].setType(0, this.slots);
            if (!this.canProcessSolid() && !this.canProcessLiquid()) {
                this.progress = 0.0;
            }
            this.neutronEnergySync = this.neutronEnergy;
            for (DirPos pos : this.getConPos()) {
                if (this.tanks[0].getTankType() != Fluids.NONE) {
                    this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, pos);
                }
                if (this.tanks[1].getFill() <= 0) continue;
                this.tryProvide(this.tanks[1], this.field_145850_b, pos);
            }
            if (this.plasmaNode == null || this.plasmaNode.expired) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10)).getOpposite();
                this.plasmaNode = UniNodespace.getNode(this.field_145850_b, this.field_145851_c + dir.offsetX * 2, this.field_145848_d + 2, this.field_145849_e + dir.offsetZ * 2, PlasmaNetworkProvider.THE_PROVIDER);
                if (this.plasmaNode == null) {
                    this.plasmaNode = new GenNode<PlasmaNetwork>(PlasmaNetworkProvider.THE_PROVIDER, new BlockPos(this.field_145851_c + dir.offsetX * 2, this.field_145848_d + 2, this.field_145849_e + dir.offsetZ * 2)).setConnections(new DirPos(this.field_145851_c + dir.offsetX * 3, this.field_145848_d + 2, this.field_145849_e + dir.offsetZ * 3, dir));
                    UniNodespace.createNode(this.field_145850_b, this.plasmaNode);
                }
            }
            if (this.plasmaNode != null && this.plasmaNode.hasValidNet()) {
                ((NodeNet)this.plasmaNode.net).addReceiver((TileEntityFusionBreeder)this);
            }
            this.networkPackNT(25);
            this.neutronEnergy = 0.0;
        }
    }

    public boolean canProcessSolid() {
        if (this.slots[1] == null) {
            return false;
        }
        Tuple.Pair<ItemStack, FluidStack> output = OutgasserRecipes.getOutput(this.slots[1]);
        if (output == null) {
            return false;
        }
        FluidStack fluid = output.getValue();
        if (fluid != null) {
            if (this.tanks[1].getTankType() != fluid.type && this.tanks[1].getFill() > 0) {
                return false;
            }
            this.tanks[1].setTankType(fluid.type);
            if (this.tanks[1].getFill() + fluid.fill > this.tanks[1].getMaxFill()) {
                return false;
            }
        }
        ItemStack out = output.getKey();
        if (this.slots[2] == null || out == null) {
            return true;
        }
        return this.slots[2].func_77973_b() == out.func_77973_b() && this.slots[2].func_77960_j() == out.func_77960_j() && this.slots[2].field_77994_a + out.field_77994_a <= this.slots[2].func_77976_d();
    }

    public boolean canProcessLiquid() {
        Tuple.Pair<Integer, FluidStack> output = FluidBreederRecipes.getOutput(this.tanks[0].getTankType());
        if (output == null) {
            return false;
        }
        if (this.tanks[0].getFill() < output.getKey()) {
            return false;
        }
        FluidStack fluid = output.getValue();
        if (this.tanks[1].getTankType() != fluid.type && this.tanks[1].getFill() > 0) {
            return false;
        }
        this.tanks[1].setTankType(fluid.type);
        return this.tanks[1].getFill() + fluid.fill <= this.tanks[1].getMaxFill();
    }

    private void processSolid() {
        ItemStack out;
        Tuple.Pair<ItemStack, FluidStack> output = OutgasserRecipes.getOutput(this.slots[1]);
        this.func_70298_a(1, 1);
        this.progress = 0.0;
        if (output.getValue() != null) {
            this.tanks[1].setFill(this.tanks[1].getFill() + output.getValue().fill);
        }
        if ((out = output.getKey()) != null) {
            if (this.slots[2] == null) {
                this.slots[2] = out.func_77946_l();
            } else {
                this.slots[2].field_77994_a += out.field_77994_a;
            }
        }
    }

    private void processLiquid() {
        Tuple.Pair<Integer, FluidStack> output = FluidBreederRecipes.getOutput(this.tanks[0].getTankType());
        this.tanks[0].setFill(this.tanks[0].getFill() - output.getKey());
        this.tanks[1].setFill(this.tanks[1].getFill() + output.getValue().fill);
    }

    public void doProgress() {
        if (this.canProcessSolid()) {
            this.progress += this.neutronEnergy;
            if (this.progress > 10000.0) {
                this.processSolid();
                this.progress = 0.0;
                this.func_70296_d();
            }
        } else if (this.canProcessLiquid()) {
            this.progress += this.neutronEnergy;
            if (this.progress > 10000.0) {
                this.processLiquid();
                this.progress = 0.0;
                this.func_70296_d();
            }
        } else {
            this.progress = 0.0;
        }
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 0) {
            return stack.func_77973_b() instanceof IItemFluidIdentifier;
        }
        if (slot == 1) {
            return OutgasserRecipes.getOutput(stack) != null;
        }
        return false;
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack itemStack, int side) {
        return slot == 2;
    }

    @Override
    public int[] func_94128_d(int side) {
        return new int[]{1, 2};
    }

    public DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c + dir.offsetX * 3, this.field_145848_d + 2, this.field_145849_e + dir.offsetZ * 3, dir), new DirPos(this.field_145851_c + rot.offsetX * 2, this.field_145848_d, this.field_145849_e + rot.offsetZ * 2, rot), new DirPos(this.field_145851_c - rot.offsetX * 2, this.field_145848_d, this.field_145849_e - rot.offsetZ * 2, rot.getOpposite()), new DirPos(this.field_145851_c + dir.offsetX + rot.offsetX * 2, this.field_145848_d, this.field_145849_e + dir.offsetZ + rot.offsetZ * 2, rot), new DirPos(this.field_145851_c + dir.offsetX - rot.offsetX * 2, this.field_145848_d, this.field_145849_e + dir.offsetZ - rot.offsetZ * 2, rot.getOpposite())};
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K && this.plasmaNode != null) {
            UniNodespace.destroyNode(this.field_145850_b, this.plasmaNode);
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeDouble(this.neutronEnergySync);
        buf.writeDouble(this.progress);
        this.tanks[0].serialize(buf);
        this.tanks[1].serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.neutronEnergy = buf.readDouble();
        this.progress = buf.readDouble();
        this.tanks[0].deserialize(buf);
        this.tanks[1].deserialize(buf);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.progress = nbt.func_74769_h("progress");
        this.tanks[0].readFromNBT(nbt, "t0");
        this.tanks[1].readFromNBT(nbt, "t1");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74780_a("progress", this.progress);
        this.tanks[0].writeToNBT(nbt, "t0");
        this.tanks[1].writeToNBT(nbt, "t1");
    }

    @Override
    public boolean receivesFusionPower() {
        return false;
    }

    @Override
    public void receiveFusionPower(long fusionPower, double neutronPower) {
        this.neutronEnergy = neutronPower;
        this.doProgress();
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0]};
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[1]};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerFusionBreeder(player.field_71071_by, this);
    }

    @Override
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIFusionBreeder(player.field_71071_by, this);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 2), (double)this.field_145848_d, (double)(this.field_145849_e - 2), (double)(this.field_145851_c + 3), (double)(this.field_145848_d + 4), (double)(this.field_145849_e + 3));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

