/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity;

import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.ILookOverlay;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.tool.ItemBlowtorch;
import com.hbm.util.InventoryUtil;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public interface IRepairable {
    public boolean isDamaged();

    public List<RecipesCommon.AStack> getRepairMaterials();

    public void repair();

    public static List<RecipesCommon.AStack> getRepairMaterials(World world, int x, int y, int z, BlockDummyable dummy, EntityPlayer player) {
        ItemStack held = player.func_70694_bm();
        if (held == null || !(held.func_77973_b() instanceof ItemBlowtorch)) {
            return null;
        }
        int[] pos = dummy.findCore(world, x, y, z);
        if (pos == null) {
            return null;
        }
        TileEntity core = world.func_147438_o(pos[0], pos[1], pos[2]);
        if (!(core instanceof IRepairable)) {
            return null;
        }
        IRepairable repairable = (IRepairable)core;
        if (!repairable.isDamaged()) {
            return null;
        }
        return repairable.getRepairMaterials();
    }

    public static boolean tryRepairMultiblock(World world, int x, int y, int z, BlockDummyable dummy, EntityPlayer player) {
        int[] pos = dummy.findCore(world, x, y, z);
        if (pos == null) {
            return false;
        }
        TileEntity core = world.func_147438_o(pos[0], pos[1], pos[2]);
        if (!(core instanceof IRepairable)) {
            return false;
        }
        IRepairable repairable = (IRepairable)core;
        if (!repairable.isDamaged()) {
            return false;
        }
        List<RecipesCommon.AStack> list = repairable.getRepairMaterials();
        if (list == null || list.isEmpty() || InventoryUtil.doesPlayerHaveAStacks(player, list, true)) {
            if (!world.field_72995_K) {
                repairable.repair();
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static void addGenericOverlay(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z, BlockDummyable dummyable) {
        List<RecipesCommon.AStack> materials = IRepairable.getRepairMaterials(world, x, y, z, dummyable, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (materials == null) {
            return;
        }
        ArrayList<String> text = new ArrayList<String>();
        text.add(EnumChatFormatting.GOLD + "Repair with:");
        for (RecipesCommon.AStack stack : materials) {
            try {
                ItemStack display = stack.extractForCyclingDisplay(20);
                text.add("- " + display.func_82833_r() + " x" + display.field_77994_a);
            }
            catch (Exception ex) {
                text.add(EnumChatFormatting.RED + "- ERROR");
            }
        }
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(dummyable.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
    }

    public void tryExtinguish(World var1, int var2, int var3, int var4, EnumExtinguishType var5);

    public static enum EnumExtinguishType {
        WATER,
        FOAM,
        SAND,
        CO2;

    }
}

