/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.particle.helper;

import com.hbm.particle.ParticleSpentCasing;
import com.hbm.particle.SpentCasing;
import com.hbm.particle.helper.IParticleCreator;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class CasingCreator
implements IParticleCreator {
    public static void composeEffect(World world, EntityLivingBase player, double frontOffset, double heightOffset, double sideOffset, double frontMotion, double heightMotion, double sideMotion, double motionVariance, String casing) {
        CasingCreator.composeEffect(world, player, frontOffset, heightOffset, sideOffset, frontMotion, heightMotion, sideMotion, motionVariance, 5.0f, 10.0f, casing, false, 0, 0.0, 0);
    }

    public static void composeEffect(World world, EntityLivingBase player, double frontOffset, double heightOffset, double sideOffset, double frontMotion, double heightMotion, double sideMotion, double motionVariance, float multPitch, float multYaw, String casing) {
        CasingCreator.composeEffect(world, player, frontOffset, heightOffset, sideOffset, frontMotion, heightMotion, sideMotion, motionVariance, multPitch, multYaw, casing, false, 0, 0.0, 0);
    }

    public static void composeEffect(World world, EntityLivingBase player, double frontOffset, double heightOffset, double sideOffset, double frontMotion, double heightMotion, double sideMotion, double motionVariance, String casing, boolean smoking, int smokeLife, double smokeLift, int nodeLife) {
        CasingCreator.composeEffect(world, player, frontOffset, heightOffset, sideOffset, frontMotion, heightMotion, sideMotion, motionVariance, 5.0f, 10.0f, casing, false, 0, 0.0, 0);
    }

    public static void composeEffect(World world, EntityLivingBase player, double frontOffset, double heightOffset, double sideOffset, double frontMotion, double heightMotion, double sideMotion, double motionVariance, float mPitch, float mYaw, String casing, boolean smoking, int smokeLife, double smokeLift, int nodeLife) {
        if (player.func_70093_af()) {
            heightOffset -= (double)0.075f;
        }
        Vec3 offset = Vec3.func_72443_a((double)sideOffset, (double)heightOffset, (double)frontOffset);
        offset.func_72440_a(-player.field_70125_A / 180.0f * (float)Math.PI);
        offset.func_72442_b(-player.field_70177_z / 180.0f * (float)Math.PI);
        double x = player.field_70165_t + offset.field_72450_a;
        double y = player.field_70163_u + (double)player.func_70047_e() + offset.field_72448_b;
        double z = player.field_70161_v + offset.field_72449_c;
        Vec3 motion = Vec3.func_72443_a((double)sideMotion, (double)heightMotion, (double)frontMotion);
        motion.func_72440_a(-player.field_70125_A / 180.0f * (float)Math.PI);
        motion.func_72442_b(-player.field_70177_z / 180.0f * (float)Math.PI);
        double mX = player.field_70159_w + motion.field_72450_a + player.func_70681_au().nextGaussian() * motionVariance;
        double mY = player.field_70181_x + motion.field_72448_b + player.func_70681_au().nextGaussian() * motionVariance;
        double mZ = player.field_70179_y + motion.field_72449_c + player.func_70681_au().nextGaussian() * motionVariance;
        if (player instanceof EntityPlayer && ((EntityPlayer)player).field_71075_bZ.field_75100_b) {
            mY -= 0.04;
        }
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("type", "casingNT");
        data.func_74780_a("mX", mX);
        data.func_74780_a("mY", mY);
        data.func_74780_a("mZ", mZ);
        data.func_74776_a("yaw", player.field_70177_z);
        data.func_74776_a("pitch", player.field_70125_A);
        data.func_74776_a("mPitch", mPitch);
        data.func_74776_a("mYaw", mYaw);
        data.func_74778_a("name", casing);
        data.func_74757_a("smoking", smoking);
        data.func_74768_a("smokeLife", smokeLife);
        data.func_74780_a("smokeLift", smokeLift);
        data.func_74768_a("nodeLife", nodeLife);
        IParticleCreator.sendPacket(world, x, y, z, 50, data);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void makeParticle(World world, EntityPlayer player, TextureManager texman, Random rand, double x, double y, double z, NBTTagCompound data) {
        String name = data.func_74779_i("name");
        SpentCasing casingConfig = SpentCasing.casingMap.get(name);
        double mX = data.func_74769_h("mX");
        double mY = data.func_74769_h("mY");
        double mZ = data.func_74769_h("mZ");
        float yaw = data.func_74760_g("yaw");
        float pitch = data.func_74760_g("pitch");
        float mPitch = data.func_74760_g("mPitch");
        float mYaw = data.func_74760_g("mYaw");
        boolean smoking = data.func_74767_n("smoking");
        int smokeLife = data.func_74762_e("smokeLife");
        double smokeLift = data.func_74769_h("smokeLift");
        int nodeLife = data.func_74762_e("nodeLife");
        ParticleSpentCasing casing = new ParticleSpentCasing(texman, world, x, y, z, mX, mY, mZ, mPitch, mYaw, casingConfig, smoking, smokeLife, smokeLift, nodeLife);
        casing.field_70126_B = casing.field_70177_z = yaw;
        casing.field_70127_C = casing.field_70125_A = pitch;
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)casing);
    }
}

