/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.gui;

import com.hbm.blocks.machine.BlockPWR;
import com.hbm.inventory.gui.GUIScreenWikiRender;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class GUIScreenSlicePrinter
extends GuiScreen {
    private final int x1;
    private final int y1;
    private final int z1;
    private final int x2;
    private final int y2;
    private final int z2;
    private final int sizeX;
    private final int sizeY;
    private final int sizeZ;
    private final ForgeDirection dir;
    private HashSet<Block> whitelist;
    private int yIndex;
    private RenderBlocks renderer;
    private String dirname;
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");

    public GUIScreenSlicePrinter(int x1, int y1, int z1, int x2, int y2, int z2, ForgeDirection dir) {
        this.x1 = Math.min(x1, x2);
        this.y1 = Math.min(y1, y2);
        this.z1 = Math.min(z1, z2);
        this.x2 = Math.max(x1, x2);
        this.y2 = Math.max(y1, y2);
        this.z2 = Math.max(z1, z2);
        this.dir = dir;
        this.sizeX = this.x2 - this.x1 + 1;
        this.sizeY = this.y2 - this.y1 + 1;
        this.sizeZ = this.z2 - this.z1 + 1;
        this.dirname = dateFormat.format(new Date()).toString();
    }

    public GUIScreenSlicePrinter(int x1, int y1, int z1, int x2, int y2, int z2, ForgeDirection dir, HashSet<Block> whitelist) {
        this(x1, y1, z1, x2, y2, z2, dir);
        this.whitelist = whitelist;
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        if (this.renderer == null) {
            this.renderer = new RenderBlocks((IBlockAccess)this.field_146297_k.field_71441_e);
        }
        GuiScreen.func_73734_a((int)0, (int)0, (int)this.field_146294_l, (int)this.field_146295_m, (int)-65281);
        if (this.yIndex >= this.sizeY) {
            this.field_146297_k.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("Slices saved to: .minecraft/printer/" + this.dirname));
            this.field_146297_k.field_71439_g.func_71053_j();
            return;
        }
        GL11.glPushMatrix();
        this.setupRotation();
        this.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GL11.glShadeModel((int)7425);
        Tessellator.field_78398_a.func_78382_b();
        for (int x = 0; x < this.sizeX; ++x) {
            for (int z = 0; z < this.sizeZ; ++z) {
                TileEntity tile;
                Block block = this.field_146297_k.field_71441_e.func_147439_a(this.x1 + x, this.y1 + this.yIndex, this.z1 + z);
                if (this.whitelist != null && !this.whitelist.contains(block)) continue;
                if (block instanceof BlockPWR && (tile = this.field_146297_k.field_71441_e.func_147438_o(this.x1 + x, this.y1 + this.yIndex, this.z1 + z)) instanceof BlockPWR.TileEntityBlockPWR) {
                    BlockPWR.TileEntityBlockPWR pwr = (BlockPWR.TileEntityBlockPWR)tile;
                    if (pwr.block != null) {
                        block = pwr.block;
                    }
                }
                int dx = x;
                int dz = z;
                if (this.dir == ForgeDirection.WEST) {
                    dx = this.sizeZ - 1 - z;
                    dz = x;
                } else if (this.dir == ForgeDirection.SOUTH) {
                    dx = this.sizeX - 1 - x;
                    dz = this.sizeZ - 1 - z;
                } else if (this.dir == ForgeDirection.EAST) {
                    dx = z;
                    dz = this.sizeX - 1 - x;
                }
                this.renderer.func_147805_b(block, dx, 0, dz);
            }
        }
        Tessellator.field_78398_a.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glPopMatrix();
        File printerDir = new File(this.field_146297_k.field_71412_D, "printer");
        printerDir.mkdir();
        GUIScreenWikiRender.saveScreenshot(printerDir, this.dirname, "slice_" + this.yIndex + ".png", 0, 0, this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d, -65281);
        ++this.yIndex;
    }

    private void setupRotation() {
        double scale = -24.0;
        GL11.glTranslated((double)(this.field_146294_l / 2), (double)(this.field_146295_m / 2 - 36), (double)400.0);
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GL11.glScaled((double)1.0, (double)1.0, (double)0.5);
        GL11.glRotated((double)-30.0, (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)225.0, (double)0.0, (double)1.0, (double)0.0);
        if (this.dir == ForgeDirection.WEST || this.dir == ForgeDirection.EAST) {
            GL11.glTranslated((double)((double)this.sizeX / -2.0), (double)((double)(-this.sizeY) / 2.0), (double)((double)this.sizeZ / -2.0));
        } else {
            GL11.glTranslated((double)((double)this.sizeZ / -2.0), (double)((double)(-this.sizeY) / 2.0), (double)((double)this.sizeX / -2.0));
        }
    }
}

