/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.explosion.vanillant;

import com.hbm.explosion.vanillant.interfaces.IBlockAllocator;
import com.hbm.explosion.vanillant.interfaces.IBlockProcessor;
import com.hbm.explosion.vanillant.interfaces.IEntityProcessor;
import com.hbm.explosion.vanillant.interfaces.IExplosionSFX;
import com.hbm.explosion.vanillant.interfaces.IPlayerProcessor;
import com.hbm.explosion.vanillant.standard.BlockAllocatorStandard;
import com.hbm.explosion.vanillant.standard.BlockProcessorStandard;
import com.hbm.explosion.vanillant.standard.CustomDamageHandlerAmat;
import com.hbm.explosion.vanillant.standard.EntityProcessorStandard;
import com.hbm.explosion.vanillant.standard.ExplosionEffectAmat;
import com.hbm.explosion.vanillant.standard.ExplosionEffectStandard;
import com.hbm.explosion.vanillant.standard.PlayerProcessorStandard;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class ExplosionVNT {
    private IBlockAllocator blockAllocator;
    private IEntityProcessor entityProcessor;
    private IBlockProcessor blockProcessor;
    private IPlayerProcessor playerProcessor;
    private IExplosionSFX[] sfx;
    public World world;
    public double posX;
    public double posY;
    public double posZ;
    public float size;
    public Entity exploder;
    private Map compatPlayers = new HashMap();
    public Explosion compat;

    public ExplosionVNT(World world, double x, double y, double z, float size) {
        this(world, x, y, z, size, null);
    }

    public ExplosionVNT(World world, double x, double y, double z, float size, Entity exploder) {
        this.world = world;
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.size = size;
        this.exploder = exploder;
        this.compat = new Explosion(world, exploder, x, y, z, size){

            public Map func_77277_b() {
                return ExplosionVNT.this.compatPlayers;
            }
        };
    }

    public void explode() {
        this.compat.field_77283_e = this.exploder;
        this.compat.field_77280_f = this.size;
        boolean processBlocks = this.blockAllocator != null && this.blockProcessor != null;
        boolean processEntities = this.entityProcessor != null && this.playerProcessor != null;
        HashSet<ChunkPosition> affectedBlocks = null;
        HashMap<EntityPlayer, Vec3> affectedPlayers = null;
        if (processBlocks) {
            affectedBlocks = this.blockAllocator.allocate(this, this.world, this.posX, this.posY, this.posZ, this.size);
        }
        if (processBlocks) {
            this.compat.field_77281_g.addAll(affectedBlocks);
        }
        if (processEntities) {
            affectedPlayers = this.entityProcessor.process(this, this.world, this.posX, this.posY, this.posZ, this.size);
        }
        if (processEntities) {
            this.compatPlayers.putAll(affectedPlayers);
        }
        if (processBlocks) {
            this.blockProcessor.process(this, this.world, this.posX, this.posY, this.posZ, affectedBlocks);
        }
        if (processEntities) {
            this.playerProcessor.process(this, this.world, this.posX, this.posY, this.posZ, affectedPlayers);
        }
        if (this.sfx != null) {
            for (IExplosionSFX fx : this.sfx) {
                fx.doEffect(this, this.world, this.posX, this.posY, this.posZ, this.size);
            }
        }
    }

    public ExplosionVNT setBlockAllocator(IBlockAllocator blockAllocator) {
        this.blockAllocator = blockAllocator;
        return this;
    }

    public ExplosionVNT setEntityProcessor(IEntityProcessor entityProcessor) {
        this.entityProcessor = entityProcessor;
        return this;
    }

    public ExplosionVNT setBlockProcessor(IBlockProcessor blockProcessor) {
        this.blockProcessor = blockProcessor;
        return this;
    }

    public ExplosionVNT setPlayerProcessor(IPlayerProcessor playerProcessor) {
        this.playerProcessor = playerProcessor;
        return this;
    }

    public ExplosionVNT setSFX(IExplosionSFX ... sfx) {
        this.sfx = sfx;
        return this;
    }

    public ExplosionVNT makeStandard() {
        this.setBlockAllocator(new BlockAllocatorStandard());
        this.setBlockProcessor(new BlockProcessorStandard());
        this.setEntityProcessor(new EntityProcessorStandard());
        this.setPlayerProcessor(new PlayerProcessorStandard());
        this.setSFX(new ExplosionEffectStandard());
        return this;
    }

    public ExplosionVNT makeAmat() {
        this.setBlockAllocator(new BlockAllocatorStandard(this.size < 15.0f ? 16 : 32));
        this.setBlockProcessor(new BlockProcessorStandard().setNoDrop());
        this.setEntityProcessor(new EntityProcessorStandard().withRangeMod(2.0f).withDamageMod(new CustomDamageHandlerAmat(50.0f)));
        this.setPlayerProcessor(new PlayerProcessorStandard());
        this.setSFX(new ExplosionEffectAmat());
        return this;
    }
}

