/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.explosion;

import com.hbm.config.BombConfig;
import com.hbm.interfaces.IExplosionRay;
import com.hbm.main.MainRegistry;
import com.hbm.util.ConcurrentBitSet;
import com.hbm.util.SubChunkKey;
import com.hbm.util.SubChunkSnapshot;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.DoubleAdder;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import org.apache.logging.log4j.Level;

public class ExplosionNukeRayParallelized
implements IExplosionRay {
    private static final int WORLD_HEIGHT = 256;
    private static final int BITSET_SIZE = 65536;
    private static final int SUBCHUNK_PER_CHUNK = 16;
    private static final float NUKE_RESISTANCE_CUTOFF = 2000000.0f;
    private static final float INITIAL_ENERGY_FACTOR = 0.3f;
    private static final double RESOLUTION_FACTOR = 1.0;
    protected final World world;
    private final double explosionX;
    private final double explosionY;
    private final double explosionZ;
    private final int originX;
    private final int originY;
    private final int originZ;
    private final int strength;
    private final int radius;
    private final CompletableFuture<List<Vec3>> directionsFuture;
    private final ConcurrentMap<ChunkCoordIntPair, ConcurrentBitSet> destructionMap;
    private final ConcurrentMap<ChunkCoordIntPair, ConcurrentMap<Integer, DoubleAdder>> damageMap;
    private final ConcurrentMap<SubChunkKey, SubChunkSnapshot> snapshots;
    private final ConcurrentMap<SubChunkKey, ConcurrentLinkedQueue<RayTask>> waitingRoom;
    private final BlockingQueue<RayTask> rayQueue;
    private final ExecutorService pool;
    private final CountDownLatch latch;
    private final Thread latchWatcherThread;
    private final List<ChunkCoordIntPair> orderedChunks;
    private final BlockingQueue<SubChunkKey> highPriorityReactiveQueue;
    private final Iterator<SubChunkKey> lowPriorityProactiveIterator;
    private volatile List<Vec3> directions;
    private volatile boolean collectFinished = false;
    private volatile boolean consolidationFinished = false;
    private volatile boolean destroyFinished = false;

    public ExplosionNukeRayParallelized(World world, double x, double y, double z, int strength, int speed, int radius) {
        this.world = world;
        this.explosionX = x;
        this.explosionY = y;
        this.explosionZ = z;
        this.originX = (int)Math.floor(x);
        this.originY = (int)Math.floor(y);
        this.originZ = (int)Math.floor(z);
        this.strength = strength;
        this.radius = radius;
        int rayCount = Math.max(0, (int)(7.853981633974483 * (double)strength * (double)strength * 1.0));
        this.latch = new CountDownLatch(rayCount);
        List<SubChunkKey> sortedSubChunks = this.getAllSubChunks();
        this.lowPriorityProactiveIterator = sortedSubChunks.iterator();
        this.highPriorityReactiveQueue = new LinkedBlockingQueue<SubChunkKey>();
        int initialChunkCapacity = (int)sortedSubChunks.stream().map(SubChunkKey::getPos).distinct().count();
        this.destructionMap = new ConcurrentHashMap<ChunkCoordIntPair, ConcurrentBitSet>(initialChunkCapacity);
        this.damageMap = new ConcurrentHashMap<ChunkCoordIntPair, ConcurrentMap<Integer, DoubleAdder>>(initialChunkCapacity);
        int subChunkCount = sortedSubChunks.size();
        this.snapshots = new ConcurrentHashMap<SubChunkKey, SubChunkSnapshot>(subChunkCount);
        this.waitingRoom = new ConcurrentHashMap<SubChunkKey, ConcurrentLinkedQueue<RayTask>>(subChunkCount);
        this.orderedChunks = new ArrayList<ChunkCoordIntPair>();
        ArrayList<RayTask> initialRayTasks = new ArrayList<RayTask>(rayCount);
        for (int i = 0; i < rayCount; ++i) {
            initialRayTasks.add(new RayTask(i));
        }
        this.rayQueue = new LinkedBlockingQueue<RayTask>(initialRayTasks);
        int workers = Math.max(1, Runtime.getRuntime().availableProcessors() - 1);
        this.pool = Executors.newWorkStealingPool(workers);
        this.directionsFuture = CompletableFuture.supplyAsync(() -> this.generateSphereRays(rayCount));
        for (int i = 0; i < workers; ++i) {
            this.pool.submit(new Worker());
        }
        this.latchWatcherThread = new Thread(() -> {
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                this.collectFinished = true;
                if (BombConfig.explosionAlgorithm == 2) {
                    this.pool.submit(this::runConsolidation);
                } else {
                    this.consolidationFinished = true;
                }
            }
        }, "ExplosionNuke-LatchWatcher-" + System.nanoTime());
        this.latchWatcherThread.setDaemon(true);
        this.latchWatcherThread.start();
    }

    private static float getNukeResistance(Block b) {
        if (b.func_149688_o().func_76224_d()) {
            return 0.1f;
        }
        if (b == Blocks.field_150322_A) {
            return Blocks.field_150348_b.func_149638_a(null);
        }
        if (b == Blocks.field_150343_Z) {
            return Blocks.field_150348_b.func_149638_a(null) * 3.0f;
        }
        return b.func_149638_a(null);
    }

    private List<SubChunkKey> getAllSubChunks() {
        ArrayList<SubChunkKey> keys = new ArrayList<SubChunkKey>();
        int cr = this.radius + 15 >> 4;
        int minCX = (this.originX >> 4) - cr;
        int maxCX = (this.originX >> 4) + cr;
        int minCZ = (this.originZ >> 4) - cr;
        int maxCZ = (this.originZ >> 4) + cr;
        int minSubY = Math.max(0, this.originY - this.radius >> 4);
        int maxSubY = Math.min(15, this.originY + this.radius >> 4);
        int originSubY = this.originY >> 4;
        for (int cx = minCX; cx <= maxCX; ++cx) {
            for (int cz = minCZ; cz <= maxCZ; ++cz) {
                for (int subY = minSubY; subY <= maxSubY; ++subY) {
                    int chunkCenterX = (cx << 4) + 8;
                    double dx = (double)chunkCenterX - this.explosionX;
                    int chunkCenterY = (subY << 4) + 8;
                    double dy = (double)chunkCenterY - this.explosionY;
                    int chunkCenterZ = (cz << 4) + 8;
                    double dz = (double)chunkCenterZ - this.explosionZ;
                    if (!(dx * dx + dy * dy + dz * dz <= (double)((this.radius + 14) * (this.radius + 14)))) continue;
                    keys.add(new SubChunkKey(cx, cz, subY));
                }
            }
        }
        keys.sort(Comparator.comparingInt(key -> {
            int distCX = key.getPos().field_77276_a - (this.originX >> 4);
            int distCZ = key.getPos().field_77275_b - (this.originZ >> 4);
            int distSubY = key.getSubY() - originSubY;
            return distCX * distCX + distCZ * distCZ + distSubY * distSubY;
        }));
        return keys;
    }

    @Override
    public void cacheChunksTick(int timeBudgetMs) {
        SubChunkKey ck;
        if (this.collectFinished) {
            return;
        }
        long deadline = System.nanoTime() + (long)timeBudgetMs * 1000000L;
        while (System.nanoTime() < deadline && (ck = (SubChunkKey)this.highPriorityReactiveQueue.poll()) != null) {
            this.processCacheKey(ck);
        }
        while (System.nanoTime() < deadline && this.lowPriorityProactiveIterator.hasNext()) {
            ck = this.lowPriorityProactiveIterator.next();
            this.processCacheKey(ck);
        }
    }

    private void processCacheKey(SubChunkKey ck) {
        if (this.snapshots.containsKey(ck)) {
            return;
        }
        this.snapshots.put(ck, SubChunkSnapshot.getSnapshot(this.world, ck, BombConfig.chunkloading));
        ConcurrentLinkedQueue waiters = (ConcurrentLinkedQueue)this.waitingRoom.remove(ck);
        if (waiters != null) {
            this.rayQueue.addAll(waiters);
        }
    }

    @Override
    public void destructionTick(int timeBudgetMs) {
        if (!this.collectFinished || !this.consolidationFinished || this.destroyFinished) {
            return;
        }
        long deadline = System.nanoTime() + (long)timeBudgetMs * 1000000L;
        if (this.orderedChunks.isEmpty() && !this.destructionMap.isEmpty()) {
            this.orderedChunks.addAll(this.destructionMap.keySet());
            this.orderedChunks.sort(Comparator.comparingInt(c -> Math.abs((this.originX >> 4) - c.field_77276_a) + Math.abs((this.originZ >> 4) - c.field_77275_b)));
        }
        Iterator<ChunkCoordIntPair> it = this.orderedChunks.iterator();
        while (it.hasNext() && System.nanoTime() < deadline) {
            int subY;
            ChunkCoordIntPair cp = it.next();
            ConcurrentBitSet bs = (ConcurrentBitSet)this.destructionMap.get(cp);
            if (bs == null) {
                it.remove();
                continue;
            }
            Chunk chunk = this.world.func_72964_e(cp.field_77276_a, cp.field_77275_b);
            ExtendedBlockStorage[] storages = chunk.func_76587_i();
            boolean chunkModified = false;
            for (subY = 0; subY < storages.length; ++subY) {
                ExtendedBlockStorage storage = storages[subY];
                if (storage == null) continue;
                int startBit = 255 - ((subY << 4) + 15) << 8;
                int endBit = 255 - (subY << 4) << 8 | 0xFF;
                int bit = bs.nextSetBit(startBit);
                while (bit >= 0 && bit <= endBit && System.nanoTime() < deadline) {
                    int xGlobal = cp.field_77276_a << 4 | bit >>> 4 & 0xF;
                    int xLocal = xGlobal & 0xF;
                    int yGlobal = 255 - (bit >>> 8);
                    int yLocal = yGlobal & 0xF;
                    int zGlobal = cp.field_77275_b << 4 | bit & 0xF;
                    int zLocal = zGlobal & 0xF;
                    if (storage.func_150819_a(xLocal, yLocal, zLocal) != Blocks.field_150350_a) {
                        if (this.world.func_147438_o(xGlobal, yGlobal, zGlobal) != null) {
                            this.world.func_147475_p(xGlobal, yGlobal, zGlobal);
                        }
                        storage.func_150818_a(xLocal, yLocal, zLocal, Blocks.field_150350_a);
                        storage.func_76654_b(xLocal, yLocal, zLocal, 0);
                        chunkModified = true;
                        this.world.func_147459_d(xGlobal, yGlobal, zGlobal, Blocks.field_150350_a);
                        this.world.func_147471_g(xGlobal, yGlobal, zGlobal);
                        this.world.func_147463_c(EnumSkyBlock.Sky, xGlobal, yGlobal, zGlobal);
                        this.world.func_147463_c(EnumSkyBlock.Block, xGlobal, yGlobal, zGlobal);
                    }
                    bs.clear(bit);
                    bit = bs.nextSetBit(bit + 1);
                }
            }
            if (chunkModified) {
                chunk.func_76630_e();
                this.world.func_147458_c(cp.field_77276_a << 4, 0, cp.field_77275_b << 4, cp.field_77276_a << 4 | 0xF, 255, cp.field_77275_b << 4 | 0xF);
            }
            if (!bs.isEmpty()) continue;
            this.destructionMap.remove(cp);
            for (subY = 0; subY < 16; ++subY) {
                this.snapshots.remove(new SubChunkKey(cp, subY));
            }
            it.remove();
        }
        if (this.orderedChunks.isEmpty() && this.destructionMap.isEmpty()) {
            this.destroyFinished = true;
            if (this.pool != null) {
                this.pool.shutdown();
            }
        }
    }

    @Override
    public boolean isComplete() {
        return this.collectFinished && this.consolidationFinished && this.destroyFinished;
    }

    @Override
    public void cancel() {
        block13: {
            this.collectFinished = true;
            this.consolidationFinished = true;
            this.destroyFinished = true;
            if (this.rayQueue != null) {
                this.rayQueue.clear();
            }
            if (this.waitingRoom != null) {
                this.waitingRoom.clear();
            }
            if (this.latch != null) {
                while (this.latch.getCount() > 0L) {
                    this.latch.countDown();
                }
            }
            if (this.latchWatcherThread != null && this.latchWatcherThread.isAlive()) {
                this.latchWatcherThread.interrupt();
            }
            if (this.pool != null && !this.pool.isShutdown()) {
                this.pool.shutdownNow();
                try {
                    if (!this.pool.awaitTermination(100L, TimeUnit.MILLISECONDS)) {
                        MainRegistry.logger.log(Level.ERROR, "ExplosionNukeRayParallelized thread pool did not terminate promptly on cancel.");
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    if (this.pool.isShutdown()) break block13;
                    this.pool.shutdownNow();
                }
            }
        }
        if (this.destructionMap != null) {
            this.destructionMap.clear();
        }
        if (this.damageMap != null) {
            this.damageMap.clear();
        }
        if (this.snapshots != null) {
            this.snapshots.clear();
        }
        if (this.orderedChunks != null) {
            this.orderedChunks.clear();
        }
    }

    private List<Vec3> generateSphereRays(int count) {
        ArrayList<Vec3> list = new ArrayList<Vec3>(count);
        if (count == 0) {
            return list;
        }
        if (count == 1) {
            list.add(Vec3.func_72443_a((double)1.0, (double)0.0, (double)0.0));
            return list;
        }
        double phi = Math.PI * (3.0 - Math.sqrt(5.0));
        for (int i = 0; i < count; ++i) {
            double y = 1.0 - (double)i / (double)(count - 1) * 2.0;
            double r = Math.sqrt(1.0 - y * y);
            double t = phi * (double)i;
            list.add(Vec3.func_72443_a((double)(Math.cos(t) * r), (double)y, (double)(Math.sin(t) * r)));
        }
        return list;
    }

    private void runConsolidation() {
        this.damageMap.forEach((cp, innerDamageMap) -> {
            if (innerDamageMap.isEmpty()) {
                this.damageMap.remove(cp);
                return;
            }
            ConcurrentBitSet chunkDestructionBitSet = this.destructionMap.computeIfAbsent((ChunkCoordIntPair)cp, k -> new ConcurrentBitSet(65536));
            innerDamageMap.forEach((bitIndex, accumulatedDamageAdder) -> {
                int zLocal;
                float accumulatedDamage = (float)accumulatedDamageAdder.sum();
                if (accumulatedDamage <= 0.0f) {
                    innerDamageMap.remove(bitIndex);
                    return;
                }
                int yGlobal = 255 - (bitIndex >>> 8);
                int subY = yGlobal >> 4;
                if (subY < 0) {
                    innerDamageMap.remove(bitIndex);
                    return;
                }
                SubChunkKey snapshotKey = new SubChunkKey((ChunkCoordIntPair)cp, subY);
                SubChunkSnapshot snap = (SubChunkSnapshot)this.snapshots.get(snapshotKey);
                if (snap == null || snap == SubChunkSnapshot.EMPTY) {
                    innerDamageMap.remove(bitIndex);
                    return;
                }
                int xLocal = bitIndex >>> 4 & 0xF;
                Block originalBlock = snap.getBlock(xLocal, yGlobal & 0xF, zLocal = bitIndex & 0xF);
                if (originalBlock == Blocks.field_150350_a) {
                    innerDamageMap.remove(bitIndex);
                    return;
                }
                float resistance = ExplosionNukeRayParallelized.getNukeResistance(originalBlock);
                if ((double)accumulatedDamage >= (double)resistance * 1.0) {
                    chunkDestructionBitSet.set((int)bitIndex);
                }
                innerDamageMap.remove(bitIndex);
            });
            if (innerDamageMap.isEmpty()) {
                this.damageMap.remove(cp);
            }
        });
        this.damageMap.clear();
        this.consolidationFinished = true;
    }

    private class RayTask {
        private static final double RAY_DIRECTION_EPSILON = 1.0E-6;
        private static final double PROCESSING_EPSILON = 1.0E-9;
        private static final float MIN_EFFECTIVE_DIST_FOR_ENERGY_CALC = 0.01f;
        final int dirIndex;
        double px;
        double py;
        double pz;
        int x;
        int y;
        int z;
        float energy;
        double tMaxX;
        double tMaxY;
        double tMaxZ;
        double tDeltaX;
        double tDeltaY;
        double tDeltaZ;
        int stepX;
        int stepY;
        int stepZ;
        boolean initialised = false;
        double currentRayPosition;
        private int lastCX = Integer.MIN_VALUE;
        private int lastCZ = Integer.MIN_VALUE;
        private int lastSubY = Integer.MIN_VALUE;
        private SubChunkKey currentSubChunkKey = null;

        RayTask(int dirIdx) {
            this.dirIndex = dirIdx;
        }

        void init() {
            if (ExplosionNukeRayParallelized.this.directions == null) {
                ExplosionNukeRayParallelized.this.directions = (List)ExplosionNukeRayParallelized.this.directionsFuture.join();
            }
            Vec3 dir = (Vec3)ExplosionNukeRayParallelized.this.directions.get(this.dirIndex);
            this.energy = (float)ExplosionNukeRayParallelized.this.strength * 0.3f;
            this.px = ExplosionNukeRayParallelized.this.explosionX;
            this.py = ExplosionNukeRayParallelized.this.explosionY;
            this.pz = ExplosionNukeRayParallelized.this.explosionZ;
            this.x = ExplosionNukeRayParallelized.this.originX;
            this.y = ExplosionNukeRayParallelized.this.originY;
            this.z = ExplosionNukeRayParallelized.this.originZ;
            this.currentRayPosition = 0.0;
            double dirX = dir.field_72450_a;
            double dirY = dir.field_72448_b;
            double dirZ = dir.field_72449_c;
            double absDirX = Math.abs(dirX);
            this.stepX = absDirX < 1.0E-6 ? 0 : (dirX > 0.0 ? 1 : -1);
            double d = this.tDeltaX = this.stepX == 0 ? Double.POSITIVE_INFINITY : 1.0 / absDirX;
            this.tMaxX = this.stepX == 0 ? Double.POSITIVE_INFINITY : (this.stepX > 0 ? (double)(this.x + 1) - this.px : this.px - (double)this.x) * this.tDeltaX;
            double absDirY = Math.abs(dirY);
            this.stepY = absDirY < 1.0E-6 ? 0 : (dirY > 0.0 ? 1 : -1);
            double d2 = this.tDeltaY = this.stepY == 0 ? Double.POSITIVE_INFINITY : 1.0 / absDirY;
            this.tMaxY = this.stepY == 0 ? Double.POSITIVE_INFINITY : (this.stepY > 0 ? (double)(this.y + 1) - this.py : this.py - (double)this.y) * this.tDeltaY;
            double absDirZ = Math.abs(dirZ);
            this.stepZ = absDirZ < 1.0E-6 ? 0 : (dirZ > 0.0 ? 1 : -1);
            double d3 = this.tDeltaZ = this.stepZ == 0 ? Double.POSITIVE_INFINITY : 1.0 / absDirZ;
            this.tMaxZ = this.stepZ == 0 ? Double.POSITIVE_INFINITY : (this.stepZ > 0 ? (double)(this.z + 1) - this.pz : this.pz - (double)this.z) * this.tDeltaZ;
            this.initialised = true;
        }

        void trace() {
            if (!this.initialised) {
                this.init();
            }
            if (this.energy <= 0.0f) {
                ExplosionNukeRayParallelized.this.latch.countDown();
                return;
            }
            while (this.energy > 0.0f && this.y >= 0 && this.y < 256 && !Thread.currentThread().isInterrupted() && !(this.currentRayPosition >= (double)ExplosionNukeRayParallelized.this.radius - 1.0E-9)) {
                Block block;
                double segmentLenForProcessing;
                SubChunkSnapshot snap;
                int cx = this.x >> 4;
                int cz = this.z >> 4;
                int subY = this.y >> 4;
                if (cx != this.lastCX || cz != this.lastCZ || subY != this.lastSubY) {
                    this.currentSubChunkKey = new SubChunkKey(cx, cz, subY);
                    this.lastCX = cx;
                    this.lastCZ = cz;
                    this.lastSubY = subY;
                }
                if ((snap = (SubChunkSnapshot)ExplosionNukeRayParallelized.this.snapshots.get(this.currentSubChunkKey)) == null) {
                    boolean[] amFirst = new boolean[]{false};
                    ConcurrentLinkedQueue waiters = ExplosionNukeRayParallelized.this.waitingRoom.computeIfAbsent(this.currentSubChunkKey, k -> {
                        amFirst[0] = true;
                        return new ConcurrentLinkedQueue();
                    });
                    if (amFirst[0]) {
                        ExplosionNukeRayParallelized.this.highPriorityReactiveQueue.add(this.currentSubChunkKey);
                    }
                    waiters.add(this);
                    return;
                }
                double t_exit_voxel = Math.min(this.tMaxX, Math.min(this.tMaxY, this.tMaxZ));
                double segmentLenInVoxel = t_exit_voxel - this.currentRayPosition;
                boolean stopAfterThisSegment = false;
                if (this.currentRayPosition + segmentLenInVoxel > (double)ExplosionNukeRayParallelized.this.radius - 1.0E-9) {
                    segmentLenForProcessing = Math.max(0.0, (double)ExplosionNukeRayParallelized.this.radius - this.currentRayPosition);
                    stopAfterThisSegment = true;
                } else {
                    segmentLenForProcessing = segmentLenInVoxel;
                }
                if (snap != SubChunkSnapshot.EMPTY && segmentLenForProcessing > 1.0E-9 && (block = snap.getBlock(this.x & 0xF, this.y & 0xF, this.z & 0xF)) != Blocks.field_150350_a) {
                    float resistance = ExplosionNukeRayParallelized.getNukeResistance(block);
                    if (resistance >= 2000000.0f) {
                        this.energy = 0.0f;
                    } else {
                        double energyLossFactor = this.getEnergyLossFactor(resistance);
                        float damageDealt = (float)(energyLossFactor * segmentLenForProcessing);
                        this.energy -= damageDealt;
                        if (damageDealt > 0.0f) {
                            int bitIndex = 255 - this.y << 8 | (this.x & 0xF) << 4 | this.z & 0xF;
                            ChunkCoordIntPair chunkPos = this.currentSubChunkKey.getPos();
                            if (BombConfig.explosionAlgorithm == 2) {
                                ExplosionNukeRayParallelized.this.damageMap.computeIfAbsent(chunkPos, cp -> new ConcurrentHashMap(256)).computeIfAbsent(bitIndex, k -> new DoubleAdder()).add(damageDealt);
                            } else if (this.energy > 0.0f) {
                                ExplosionNukeRayParallelized.this.destructionMap.computeIfAbsent(chunkPos, posKey -> new ConcurrentBitSet(65536)).set(bitIndex);
                            }
                        }
                    }
                }
                this.currentRayPosition = t_exit_voxel;
                if (this.energy <= 0.0f || stopAfterThisSegment) break;
                if (this.tMaxX < this.tMaxY) {
                    if (this.tMaxX < this.tMaxZ) {
                        this.x += this.stepX;
                        this.tMaxX += this.tDeltaX;
                        continue;
                    }
                    this.z += this.stepZ;
                    this.tMaxZ += this.tDeltaZ;
                    continue;
                }
                if (this.tMaxY < this.tMaxZ) {
                    this.y += this.stepY;
                    this.tMaxY += this.tDeltaY;
                    continue;
                }
                this.z += this.stepZ;
                this.tMaxZ += this.tDeltaZ;
            }
            ExplosionNukeRayParallelized.this.latch.countDown();
        }

        private double getEnergyLossFactor(float resistance) {
            double effectiveDist = Math.max(this.currentRayPosition, (double)0.01f);
            return Math.pow((double)resistance + 1.0, 3.0 * (effectiveDist / (double)ExplosionNukeRayParallelized.this.radius)) - 1.0;
        }
    }

    private class Worker
    implements Runnable {
        private Worker() {
        }

        @Override
        public void run() {
            try {
                while (!ExplosionNukeRayParallelized.this.collectFinished && !Thread.currentThread().isInterrupted()) {
                    RayTask task = (RayTask)ExplosionNukeRayParallelized.this.rayQueue.poll(100L, TimeUnit.MILLISECONDS);
                    if (task == null) continue;
                    task.trace();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

