/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.projectile.rocketbehavior;

import com.hbm.entity.projectile.EntityArtilleryRocket;
import com.hbm.entity.projectile.rocketbehavior.IRocketSteeringBehavior;
import net.minecraft.util.Vec3;

public class RocketSteeringBallisticArc
implements IRocketSteeringBehavior {
    @Override
    public void adjustCourse(EntityArtilleryRocket rocket, double speed, double maxTurn) {
        double turnSpeed = 45.0;
        Vec3 direction = Vec3.func_72443_a((double)rocket.field_70159_w, (double)rocket.field_70181_x, (double)rocket.field_70179_y).func_72432_b();
        double horizontalMomentum = Math.sqrt(rocket.field_70159_w * rocket.field_70159_w + rocket.field_70179_y * rocket.field_70179_y);
        Vec3 targetPos = rocket.getLastTarget();
        double deltaX = targetPos.field_72450_a - rocket.field_70165_t;
        double deltaZ = targetPos.field_72449_c - rocket.field_70161_v;
        double horizontalDelta = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
        double stepsRequired = horizontalDelta / horizontalMomentum;
        Vec3 target = Vec3.func_72443_a((double)(targetPos.field_72450_a - rocket.field_70165_t), (double)(targetPos.field_72448_b - rocket.field_70163_u), (double)(targetPos.field_72449_c - rocket.field_70161_v)).func_72432_b();
        double rocketYaw = RocketSteeringBallisticArc.yaw(direction);
        double rocketPitch = RocketSteeringBallisticArc.pitch(direction);
        double targetYaw = RocketSteeringBallisticArc.yaw(target);
        double targetPitch = RocketSteeringBallisticArc.pitch(target);
        boolean debug = false;
        if (debug) {
            System.out.println("=== INITIAL ===");
            System.out.println("Rocket Yaw: " + rocketYaw);
            System.out.println("Rocket Pitch: " + rocketPitch);
            System.out.println("Target Yaw: " + targetYaw);
            System.out.println("Target Pitch: " + targetPitch);
        }
        turnSpeed = Math.min(maxTurn, turnSpeed / stepsRequired);
        if (stepsRequired <= 1.0) {
            turnSpeed = 180.0;
        }
        if (debug) {
            System.out.println("=== ADJUSTED ===");
            System.out.println("Target Pitch: " + targetPitch);
        }
        double deltaYaw = (targetYaw - rocketYaw + 180.0) % 360.0 - 180.0;
        double deltaPitch = (targetPitch - rocketPitch + 180.0) % 360.0 - 180.0;
        double turnYaw = Math.min(Math.abs(deltaYaw), turnSpeed) * Math.signum(deltaYaw);
        double turnPitch = Math.min(Math.abs(deltaPitch), turnSpeed) * Math.signum(deltaPitch);
        if (debug) {
            System.out.println("=== RESULTS ===");
            System.out.println("Delta Yaw: " + deltaYaw);
            System.out.println("Delta Pitch: " + deltaPitch);
            System.out.println("Turn Yaw: " + turnYaw);
            System.out.println("Turn Pitch: " + turnPitch);
        }
        Vec3 velocity = Vec3.func_72443_a((double)speed, (double)0.0, (double)0.0);
        velocity.func_72446_c((float)(-Math.toRadians(rocketPitch + turnPitch)));
        velocity.func_72442_b((float)Math.toRadians(rocketYaw + turnYaw + 90.0));
        rocket.field_70159_w = velocity.field_72450_a;
        rocket.field_70181_x = velocity.field_72448_b;
        rocket.field_70179_y = velocity.field_72449_c;
    }

    private static double yaw(Vec3 vec) {
        boolean pos = vec.field_72449_c >= 0.0;
        return Math.toDegrees(Math.atan(vec.field_72450_a / vec.field_72449_c)) + (double)(pos ? 180 : 0);
    }

    private static double pitch(Vec3 vec) {
        return Math.toDegrees(Math.atan(vec.field_72448_b / Math.sqrt(vec.field_72450_a * vec.field_72450_a + vec.field_72449_c * vec.field_72449_c)));
    }
}

