/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityMinecartCommandBlock;
import net.minecraft.entity.ai.EntityMinecartMobSpawner;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityMinecartChest;
import net.minecraft.entity.item.EntityMinecartEmpty;
import net.minecraft.entity.item.EntityMinecartFurnace;
import net.minecraft.entity.item.EntityMinecartHopper;
import net.minecraft.entity.item.EntityMinecartTNT;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.IMinecartCollisionHandler;

public abstract class EntityMinecartDeobf
extends Entity {
    private boolean isInReverse;
    private String entityName;
    private static final int[][][] matrix = new int[][][]{new int[][]{{0, 0, -1}, {0, 0, 1}}, new int[][]{{-1, 0, 0}, {1, 0, 0}}, new int[][]{{-1, -1, 0}, {1, 0, 0}}, new int[][]{{-1, 0, 0}, {1, -1, 0}}, new int[][]{{0, 0, -1}, {0, -1, 1}}, new int[][]{{0, -1, -1}, {0, 0, 1}}, new int[][]{{0, 0, 1}, {1, 0, 0}}, new int[][]{{0, 0, 1}, {-1, 0, 0}}, new int[][]{{0, 0, -1}, {-1, 0, 0}}, new int[][]{{0, 0, -1}, {1, 0, 0}}};
    private int turnProgress;
    private double syncPosX;
    private double syncPosY;
    private double syncPosZ;
    private double minecartYaw;
    private double minecartPitch;
    @SideOnly(value=Side.CLIENT)
    private double velocityX;
    @SideOnly(value=Side.CLIENT)
    private double velocityY;
    @SideOnly(value=Side.CLIENT)
    private double velocityZ;
    public static float defaultMaxSpeedAirLateral = 0.4f;
    public static float defaultMaxSpeedAirVertical = -1.0f;
    public static double defaultDragAir = 0.95;
    protected boolean canUseRail = true;
    protected boolean canBePushed = true;
    private static IMinecartCollisionHandler collisionHandler = null;
    private float currentSpeedRail = this.getMaxCartSpeedOnRail();
    protected float maxSpeedAirLateral = defaultMaxSpeedAirLateral;
    protected float maxSpeedAirVertical = defaultMaxSpeedAirVertical;
    protected double dragAir = defaultDragAir;

    public EntityMinecartDeobf(World p_i1712_1_) {
        super(p_i1712_1_);
        this.field_70156_m = true;
        this.func_70105_a(0.98f, 0.7f);
        this.field_70129_M = this.field_70131_O / 2.0f;
    }

    public static EntityMinecart createMinecart(World p_94090_0_, double p_94090_1_, double p_94090_3_, double p_94090_5_, int p_94090_7_) {
        switch (p_94090_7_) {
            case 1: {
                return new EntityMinecartChest(p_94090_0_, p_94090_1_, p_94090_3_, p_94090_5_);
            }
            case 2: {
                return new EntityMinecartFurnace(p_94090_0_, p_94090_1_, p_94090_3_, p_94090_5_);
            }
            case 3: {
                return new EntityMinecartTNT(p_94090_0_, p_94090_1_, p_94090_3_, p_94090_5_);
            }
            case 4: {
                return new EntityMinecartMobSpawner(p_94090_0_, p_94090_1_, p_94090_3_, p_94090_5_);
            }
            case 5: {
                return new EntityMinecartHopper(p_94090_0_, p_94090_1_, p_94090_3_, p_94090_5_);
            }
            case 6: {
                return new EntityMinecartCommandBlock(p_94090_0_, p_94090_1_, p_94090_3_, p_94090_5_);
            }
        }
        return new EntityMinecartEmpty(p_94090_0_, p_94090_1_, p_94090_3_, p_94090_5_);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(17, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(18, (Object)new Integer(1));
        this.field_70180_af.func_75682_a(19, (Object)new Float(0.0f));
        this.field_70180_af.func_75682_a(20, (Object)new Integer(0));
        this.field_70180_af.func_75682_a(21, (Object)new Integer(6));
        this.field_70180_af.func_75682_a(22, (Object)0);
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        return entity.func_70104_M() ? entity.field_70121_D : null;
    }

    public AxisAlignedBB func_70046_E() {
        return null;
    }

    public boolean func_70104_M() {
        return this.canBePushed;
    }

    public EntityMinecartDeobf(World p_i1713_1_, double p_i1713_2_, double p_i1713_4_, double p_i1713_6_) {
        this(p_i1713_1_);
        this.func_70107_b(p_i1713_2_, p_i1713_4_, p_i1713_6_);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = p_i1713_2_;
        this.field_70167_r = p_i1713_4_;
        this.field_70166_s = p_i1713_6_;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.0 - 0.3;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            boolean flag;
            if (this.func_85032_ar()) {
                return false;
            }
            this.setRollingDirection(-this.getRollingDirection());
            this.setRollingAmplitude(10);
            this.func_70018_K();
            this.setDamage(this.getDamage() + amount * 10.0f);
            boolean bl = flag = source.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)source.func_76346_g()).field_71075_bZ.field_75098_d;
            if (flag || this.getDamage() > 40.0f) {
                if (this.field_70153_n != null) {
                    this.field_70153_n.func_70078_a((Entity)this);
                }
                if (flag && !this.hasCustomInventoryName()) {
                    this.func_70106_y();
                } else {
                    this.killMinecart(source);
                }
            }
            return true;
        }
        return true;
    }

    public void killMinecart(DamageSource source) {
        this.func_70106_y();
        ItemStack itemstack = new ItemStack(Items.field_151143_au, 1);
        if (this.entityName != null) {
            itemstack.func_151001_c(this.entityName);
        }
        this.func_70099_a(itemstack, 0.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70057_ab() {
        this.setRollingDirection(-this.getRollingDirection());
        this.setRollingAmplitude(10);
        this.setDamage(this.getDamage() + this.getDamage() * 10.0f);
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void func_70106_y() {
        super.func_70106_y();
    }

    public void func_70071_h_() {
        if (this.getRollingAmplitude() > 0) {
            this.setRollingAmplitude(this.getRollingAmplitude() - 1);
        }
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 1.0f);
        }
        if (this.field_70163_u < -64.0) {
            this.func_70076_C();
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p instanceof WorldServer) {
            this.field_70170_p.field_72984_F.func_76320_a("portal");
            MinecraftServer minecraftserver = ((WorldServer)this.field_70170_p).func_73046_m();
            int portalTime = this.func_82145_z();
            if (this.field_71087_bX) {
                if (minecraftserver.func_71255_r()) {
                    if (this.field_70154_o == null && this.field_82153_h++ >= portalTime) {
                        this.field_82153_h = portalTime;
                        this.field_71088_bW = this.func_82147_ab();
                        int destination = this.field_70170_p.field_73011_w.field_76574_g == -1 ? 0 : -1;
                        this.func_71027_c(destination);
                    }
                    this.field_71087_bX = false;
                }
            } else {
                if (this.field_82153_h > 0) {
                    this.field_82153_h -= 4;
                }
                if (this.field_82153_h < 0) {
                    this.field_82153_h = 0;
                }
            }
            if (this.field_71088_bW > 0) {
                --this.field_71088_bW;
            }
            this.field_70170_p.field_72984_F.func_76319_b();
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.turnProgress > 0) {
                double interpX = this.field_70165_t + (this.syncPosX - this.field_70165_t) / (double)this.turnProgress;
                double interpY = this.field_70163_u + (this.syncPosY - this.field_70163_u) / (double)this.turnProgress;
                double interpZ = this.field_70161_v + (this.syncPosZ - this.field_70161_v) / (double)this.turnProgress;
                double deltaYaw = MathHelper.func_76138_g((double)(this.minecartYaw - (double)this.field_70177_z));
                this.field_70177_z = (float)((double)this.field_70177_z + deltaYaw / (double)this.turnProgress);
                this.field_70125_A = (float)((double)this.field_70125_A + (this.minecartPitch - (double)this.field_70125_A) / (double)this.turnProgress);
                --this.turnProgress;
                this.func_70107_b(interpX, interpY, interpZ);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            } else {
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            }
        } else {
            double deltaYaw;
            int railZ;
            int railY;
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            this.field_70181_x -= 0.04;
            int railX = MathHelper.func_76128_c((double)this.field_70165_t);
            if (BlockRailBase.func_150049_b_((World)this.field_70170_p, (int)railX, (int)((railY = MathHelper.func_76128_c((double)this.field_70163_u)) - 1), (int)(railZ = MathHelper.func_76128_c((double)this.field_70161_v)))) {
                --railY;
            }
            double groundSpeedNoRail = 0.4;
            Block block = this.field_70170_p.func_147439_a(railX, railY, railZ);
            if (this.canUseRail() && BlockRailBase.func_150051_a((Block)block)) {
                float railMaxSpeed = 1.0f;
                double maxSpeed = Math.min(railMaxSpeed, this.getCurrentCartSpeedCapOnRail());
                this.useRail(railX, railY, railZ, maxSpeed, this.getSlopeAdjustment(), block, this.field_70170_p.func_72805_g(railX, railY, railZ));
                if (block == Blocks.field_150408_cc) {
                    this.onActivatorRailPass(railX, railY, railZ, (this.field_70170_p.func_72805_g(railX, railY, railZ) & 8) != 0);
                }
            } else {
                this.limitSpeedApplyDragAndMoveWithoutRail(this.field_70122_E ? groundSpeedNoRail : (double)this.getMaxSpeedAirLateral());
            }
            this.func_145775_I();
            this.field_70125_A = 0.0f;
            double d8 = this.field_70169_q - this.field_70165_t;
            double d4 = this.field_70166_s - this.field_70161_v;
            if (d8 * d8 + d4 * d4 > 0.001) {
                this.field_70177_z = (float)(Math.atan2(d4, d8) * 180.0 / Math.PI);
                if (this.isInReverse) {
                    this.field_70177_z += 180.0f;
                }
            }
            if ((deltaYaw = (double)MathHelper.func_76142_g((float)(this.field_70177_z - this.field_70126_B))) < -170.0 || deltaYaw >= 170.0) {
                this.field_70177_z += 180.0f;
                this.isInReverse = !this.isInReverse;
            }
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            AxisAlignedBB box = this.field_70121_D.func_72314_b(0.2, 0.0, 0.2);
            List list = this.field_70170_p.func_72839_b((Entity)this, box);
            if (list != null && !list.isEmpty()) {
                for (int k = 0; k < list.size(); ++k) {
                    Entity entity = (Entity)list.get(k);
                    if (entity == this.field_70153_n || !entity.func_70104_M() || !(entity instanceof EntityMinecart)) continue;
                    entity.func_70108_f((Entity)this);
                }
            }
            if (this.field_70153_n != null && this.field_70153_n.field_70128_L) {
                if (this.field_70153_n.field_70154_o == this) {
                    this.field_70153_n.field_70154_o = null;
                }
                this.field_70153_n = null;
            }
        }
    }

    public void onActivatorRailPass(int x, int y, int z, boolean powered) {
    }

    protected void limitSpeedApplyDragAndMoveWithoutRail(double maxSpeed) {
        if (this.field_70159_w < -maxSpeed) {
            this.field_70159_w = -maxSpeed;
        }
        if (this.field_70159_w > maxSpeed) {
            this.field_70159_w = maxSpeed;
        }
        if (this.field_70179_y < -maxSpeed) {
            this.field_70179_y = -maxSpeed;
        }
        if (this.field_70179_y > maxSpeed) {
            this.field_70179_y = maxSpeed;
        }
        double moveY = this.field_70181_x;
        if (this.getMaxSpeedAirVertical() > 0.0f && this.field_70181_x > (double)this.getMaxSpeedAirVertical()) {
            moveY = this.getMaxSpeedAirVertical();
            if (Math.abs(this.field_70159_w) < (double)0.3f && Math.abs(this.field_70179_y) < (double)0.3f) {
                this.field_70181_x = moveY = (double)0.15f;
            }
        }
        if (this.field_70122_E) {
            this.field_70159_w *= 0.5;
            this.field_70181_x *= 0.5;
            this.field_70179_y *= 0.5;
        }
        this.func_70091_d(this.field_70159_w, moveY, this.field_70179_y);
        if (!this.field_70122_E) {
            this.field_70159_w *= this.getDragAir();
            this.field_70181_x *= this.getDragAir();
            this.field_70179_y *= this.getDragAir();
        }
    }

    protected void useRail(int railX, int railY, int railZ, double maxSpeed, double slopeAdjustment, Block rail, int meta) {
        double d10;
        double d9;
        double d8;
        double motion;
        double d6;
        this.field_70143_R = 0.0f;
        Vec3 vec3 = this.getClosestPositionOnRail(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70163_u = railY;
        boolean flag = false;
        boolean flag1 = false;
        if (rail == Blocks.field_150318_D) {
            flag = (this.field_70170_p.func_72805_g(railX, railY, railZ) & 8) != 0;
            boolean bl = flag1 = !flag;
        }
        if (((BlockRailBase)rail).func_150050_e()) {
            meta &= 7;
        }
        if (meta >= 2 && meta <= 5) {
            this.field_70163_u = railY + 1;
        }
        if (meta == 2) {
            this.field_70159_w -= slopeAdjustment;
        }
        if (meta == 3) {
            this.field_70159_w += slopeAdjustment;
        }
        if (meta == 4) {
            this.field_70179_y += slopeAdjustment;
        }
        if (meta == 5) {
            this.field_70179_y -= slopeAdjustment;
        }
        int[][] curveData = matrix[meta];
        double sideDeltaX = curveData[1][0] - curveData[0][0];
        double sideDeltaZ = curveData[1][2] - curveData[0][2];
        double sideDelta = Math.sqrt(sideDeltaX * sideDeltaX + sideDeltaZ * sideDeltaZ);
        double d5 = this.field_70159_w * sideDeltaX + this.field_70179_y * sideDeltaZ;
        if (d5 < 0.0) {
            sideDeltaX = -sideDeltaX;
            sideDeltaZ = -sideDeltaZ;
        }
        if ((d6 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) > 2.0) {
            d6 = 2.0;
        }
        this.field_70159_w = d6 * sideDeltaX / sideDelta;
        this.field_70179_y = d6 * sideDeltaZ / sideDelta;
        if (this.field_70153_n != null && this.field_70153_n instanceof EntityLivingBase && (motion = (double)((EntityLivingBase)this.field_70153_n).field_70701_bs) > 0.0) {
            d8 = -Math.sin(this.field_70153_n.field_70177_z * (float)Math.PI / 180.0f);
            d9 = Math.cos(this.field_70153_n.field_70177_z * (float)Math.PI / 180.0f);
            d10 = this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y;
            if (d10 < 0.01) {
                this.field_70159_w += d8 * 0.1;
                this.field_70179_y += d9 * 0.1;
                flag1 = false;
            }
        }
        if (flag1 && this.shouldDoRailFunctions()) {
            motion = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
            if (motion < 0.03) {
                this.field_70159_w *= 0.0;
                this.field_70181_x *= 0.0;
                this.field_70179_y *= 0.0;
            } else {
                this.field_70159_w *= 0.5;
                this.field_70181_x *= 0.0;
                this.field_70179_y *= 0.5;
            }
        }
        motion = 0.0;
        d8 = (double)railX + 0.5 + (double)curveData[0][0] * 0.5;
        d9 = (double)railZ + 0.5 + (double)curveData[0][2] * 0.5;
        d10 = (double)railX + 0.5 + (double)curveData[1][0] * 0.5;
        double d11 = (double)railZ + 0.5 + (double)curveData[1][2] * 0.5;
        sideDeltaX = d10 - d8;
        sideDeltaZ = d11 - d9;
        if (sideDeltaX == 0.0) {
            this.field_70165_t = (double)railX + 0.5;
            motion = this.field_70161_v - (double)railZ;
        } else if (sideDeltaZ == 0.0) {
            this.field_70161_v = (double)railZ + 0.5;
            motion = this.field_70165_t - (double)railX;
        } else {
            double d12 = this.field_70165_t - d8;
            double d13 = this.field_70161_v - d9;
            motion = (d12 * sideDeltaX + d13 * sideDeltaZ) * 2.0;
        }
        this.field_70165_t = d8 + sideDeltaX * motion;
        this.field_70161_v = d9 + sideDeltaZ * motion;
        this.func_70107_b(this.field_70165_t, this.field_70163_u + (double)this.field_70129_M, this.field_70161_v);
        this.moveMinecartOnRail(railX, railY, railZ, maxSpeed);
        if (curveData[0][1] != 0 && MathHelper.func_76128_c((double)this.field_70165_t) - railX == curveData[0][0] && MathHelper.func_76128_c((double)this.field_70161_v) - railZ == curveData[0][2]) {
            this.func_70107_b(this.field_70165_t, this.field_70163_u + (double)curveData[0][1], this.field_70161_v);
        } else if (curveData[1][1] != 0 && MathHelper.func_76128_c((double)this.field_70165_t) - railX == curveData[1][0] && MathHelper.func_76128_c((double)this.field_70161_v) - railZ == curveData[1][2]) {
            this.func_70107_b(this.field_70165_t, this.field_70163_u + (double)curveData[1][1], this.field_70161_v);
        }
        this.applyDrag();
        Vec3 vec31 = this.getClosestPositionOnRail(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (vec31 != null && vec3 != null) {
            double d14 = (vec3.field_72448_b - vec31.field_72448_b) * 0.05;
            d6 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
            if (d6 > 0.0) {
                this.field_70159_w = this.field_70159_w / d6 * (d6 + d14);
                this.field_70179_y = this.field_70179_y / d6 * (d6 + d14);
            }
            this.func_70107_b(this.field_70165_t, vec31.field_72448_b, this.field_70161_v);
        }
        int j1 = MathHelper.func_76128_c((double)this.field_70165_t);
        int i1 = MathHelper.func_76128_c((double)this.field_70161_v);
        if (j1 != railX || i1 != railZ) {
            d6 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
            this.field_70159_w = d6 * (double)(j1 - railX);
            this.field_70179_y = d6 * (double)(i1 - railZ);
        }
        if (this.shouldDoRailFunctions()) {
            // empty if block
        }
        if (flag && this.shouldDoRailFunctions()) {
            double d15 = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
            if (d15 > 0.01) {
                double d16 = 0.06;
                this.field_70159_w += this.field_70159_w / d15 * d16;
                this.field_70179_y += this.field_70179_y / d15 * d16;
            } else if (meta == 1) {
                if (this.field_70170_p.func_147439_a(railX - 1, railY, railZ).func_149721_r()) {
                    this.field_70159_w = 0.02;
                } else if (this.field_70170_p.func_147439_a(railX + 1, railY, railZ).func_149721_r()) {
                    this.field_70159_w = -0.02;
                }
            } else if (meta == 0) {
                if (this.field_70170_p.func_147439_a(railX, railY, railZ - 1).func_149721_r()) {
                    this.field_70179_y = 0.02;
                } else if (this.field_70170_p.func_147439_a(railX, railY, railZ + 1).func_149721_r()) {
                    this.field_70179_y = -0.02;
                }
            }
        }
    }

    protected void applyDrag() {
        if (this.field_70153_n != null) {
            this.field_70159_w *= 0.997;
            this.field_70181_x *= 0.0;
            this.field_70179_y *= 0.997;
        } else {
            this.field_70159_w *= 0.96;
            this.field_70181_x *= 0.0;
            this.field_70179_y *= 0.96;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3 getPositionVectorForRendering(double interpX, double interpY, double interpZ, double constant) {
        Block block;
        int z;
        int y;
        int x = MathHelper.func_76128_c((double)interpX);
        if (BlockRailBase.func_150049_b_((World)this.field_70170_p, (int)x, (int)((y = MathHelper.func_76128_c((double)interpY)) - 1), (int)(z = MathHelper.func_76128_c((double)interpZ)))) {
            --y;
        }
        if (!BlockRailBase.func_150051_a((Block)(block = this.field_70170_p.func_147439_a(x, y, z)))) {
            return null;
        }
        int meta = this.field_70170_p.func_72805_g(x, y, z);
        interpY = y;
        if (meta >= 2 && meta <= 5) {
            interpY = y + 1;
        }
        int[][] curveData = matrix[meta];
        double curveX = curveData[1][0] - curveData[0][0];
        double curveZ = curveData[1][2] - curveData[0][2];
        double curveSq = Math.sqrt(curveX * curveX + curveZ * curveZ);
        if (curveData[0][1] != 0 && MathHelper.func_76128_c((double)(interpX += (curveX /= curveSq) * constant)) - x == curveData[0][0] && MathHelper.func_76128_c((double)(interpZ += (curveZ /= curveSq) * constant)) - z == curveData[0][2]) {
            interpY += (double)curveData[0][1];
        } else if (curveData[1][1] != 0 && MathHelper.func_76128_c((double)interpX) - x == curveData[1][0] && MathHelper.func_76128_c((double)interpZ) - z == curveData[1][2]) {
            interpY += (double)curveData[1][1];
        }
        return this.getClosestPositionOnRail(interpX, interpY, interpZ);
    }

    public Vec3 getClosestPositionOnRail(double x, double y, double z) {
        Block block;
        int railZ;
        int railY;
        int railX = MathHelper.func_76128_c((double)x);
        if (BlockRailBase.func_150049_b_((World)this.field_70170_p, (int)railX, (int)((railY = MathHelper.func_76128_c((double)y)) - 1), (int)(railZ = MathHelper.func_76128_c((double)z)))) {
            --railY;
        }
        if (BlockRailBase.func_150051_a((Block)(block = this.field_70170_p.func_147439_a(railX, railY, railZ)))) {
            int l = this.field_70170_p.func_72805_g(railX, railY, railZ);
            y = railY;
            if (l >= 2 && l <= 5) {
                y = railY + 1;
            }
            int[][] aint = matrix[l];
            double delta = 0.0;
            double side1X = (double)railX + 0.5 + (double)aint[0][0] * 0.5;
            double side1Y = (double)railY + 0.5 + (double)aint[0][1] * 0.5;
            double side1Z = (double)railZ + 0.5 + (double)aint[0][2] * 0.5;
            double side2X = (double)railX + 0.5 + (double)aint[1][0] * 0.5;
            double side2Y = (double)railY + 0.5 + (double)aint[1][1] * 0.5;
            double side2Z = (double)railZ + 0.5 + (double)aint[1][2] * 0.5;
            double sideDeltaX = side2X - side1X;
            double sideDeltaYx2 = (side2Y - side1Y) * 2.0;
            double sideDeltaZ = side2Z - side1Z;
            if (sideDeltaX == 0.0) {
                x = (double)railX + 0.5;
                delta = z - (double)railZ;
            } else if (sideDeltaZ == 0.0) {
                z = (double)railZ + 0.5;
                delta = x - (double)railX;
            } else {
                double deltaX = x - side1X;
                double deltaZ = z - side1Z;
                delta = (deltaX * sideDeltaX + deltaZ * sideDeltaZ) * 2.0;
            }
            x = side1X + sideDeltaX * delta;
            y = side1Y + sideDeltaYx2 * delta;
            z = side1Z + sideDeltaZ * delta;
            if (sideDeltaYx2 < 0.0) {
                y += 1.0;
            }
            if (sideDeltaYx2 > 0.0) {
                y += 0.5;
            }
            return Vec3.func_72443_a((double)x, (double)y, (double)z);
        }
        return null;
    }

    protected void func_70037_a(NBTTagCompound p_70037_1_) {
        if (p_70037_1_.func_74767_n("CustomDisplayTile")) {
            this.func_145819_k(p_70037_1_.func_74762_e("DisplayTile"));
            this.setDisplayTileData(p_70037_1_.func_74762_e("DisplayData"));
            this.setDisplayTileOffset(p_70037_1_.func_74762_e("DisplayOffset"));
        }
        if (p_70037_1_.func_150297_b("CustomName", 8) && p_70037_1_.func_74779_i("CustomName").length() > 0) {
            this.entityName = p_70037_1_.func_74779_i("CustomName");
        }
    }

    protected void func_70014_b(NBTTagCompound p_70014_1_) {
        if (this.hasDisplayTile()) {
            p_70014_1_.func_74757_a("CustomDisplayTile", true);
            p_70014_1_.func_74768_a("DisplayTile", this.func_145820_n().func_149688_o() == Material.field_151579_a ? 0 : Block.func_149682_b((Block)this.func_145820_n()));
            p_70014_1_.func_74768_a("DisplayData", this.getDisplayTileData());
            p_70014_1_.func_74768_a("DisplayOffset", this.getDisplayTileOffset());
        }
        if (this.entityName != null && this.entityName.length() > 0) {
            p_70014_1_.func_74778_a("CustomName", this.entityName);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.0f;
    }

    public void func_70108_f(Entity entity) {
        if (!this.field_70170_p.field_72995_K && entity != this.field_70153_n) {
            double deltaZ;
            double deltaX;
            double delta;
            if (entity instanceof EntityLivingBase && !(entity instanceof EntityPlayer) && !(entity instanceof EntityIronGolem) && this.canBeRidden() && this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y > 0.01 && this.field_70153_n == null && entity.field_70154_o == null) {
                entity.func_70078_a((Entity)this);
            }
            if ((delta = (deltaX = entity.field_70165_t - this.field_70165_t) * deltaX + (deltaZ = entity.field_70161_v - this.field_70161_v) * deltaZ) >= 1.0E-4) {
                delta = MathHelper.func_76133_a((double)delta);
                deltaX /= delta;
                deltaZ /= delta;
                double pushForce = 1.0 / delta;
                if (pushForce > 1.0) {
                    pushForce = 1.0;
                }
                deltaX *= pushForce;
                deltaZ *= pushForce;
                deltaX *= 0.1;
                deltaZ *= 0.1;
                deltaX *= (double)(1.0f - this.field_70144_Y);
                deltaZ *= (double)(1.0f - this.field_70144_Y);
                deltaX *= 0.5;
                deltaZ *= 0.5;
                if (entity instanceof EntityMinecart) {
                    Vec3 vec31;
                    double d4 = entity.field_70165_t - this.field_70165_t;
                    double d5 = entity.field_70161_v - this.field_70161_v;
                    Vec3 vec3 = Vec3.func_72443_a((double)d4, (double)0.0, (double)d5).func_72432_b();
                    double d6 = Math.abs(vec3.func_72430_b(vec31 = Vec3.func_72443_a((double)MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)), (double)0.0, (double)MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f))).func_72432_b()));
                    if (d6 < 0.8) {
                        return;
                    }
                    double totalMotionX = entity.field_70159_w + this.field_70159_w;
                    double totalMotionZ = entity.field_70179_y + this.field_70179_y;
                    if (((EntityMinecart)entity).isPoweredCart() && !this.isPoweredCart()) {
                        this.field_70159_w *= 0.2;
                        this.field_70179_y *= 0.2;
                        this.func_70024_g(entity.field_70159_w - deltaX, 0.0, entity.field_70179_y - deltaZ);
                        entity.field_70159_w *= 0.95;
                        entity.field_70179_y *= 0.95;
                    } else if (((EntityMinecart)entity).isPoweredCart() && !this.isPoweredCart()) {
                        entity.field_70159_w *= 0.2;
                        entity.field_70179_y *= 0.2;
                        entity.func_70024_g(this.field_70159_w + deltaX, 0.0, this.field_70179_y + deltaZ);
                        this.field_70159_w *= 0.95;
                        this.field_70179_y *= 0.95;
                    } else {
                        this.field_70159_w *= 0.2;
                        this.field_70179_y *= 0.2;
                        this.func_70024_g((totalMotionX /= 2.0) - deltaX, 0.0, (totalMotionZ /= 2.0) - deltaZ);
                        entity.field_70159_w *= 0.2;
                        entity.field_70179_y *= 0.2;
                        entity.func_70024_g(totalMotionX + deltaX, 0.0, totalMotionZ + deltaZ);
                    }
                } else {
                    this.func_70024_g(-deltaX, 0.0, -deltaZ);
                    entity.func_70024_g(deltaX / 4.0, 0.0, deltaZ / 4.0);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double x, double y, double z, float yaw, float pitch, int theNumberThree) {
        this.syncPosX = x;
        this.syncPosY = y;
        this.syncPosZ = z;
        this.minecartYaw = yaw;
        this.minecartPitch = pitch;
        this.turnProgress = theNumberThree + 2;
        this.field_70159_w = this.velocityX;
        this.field_70181_x = this.velocityY;
        this.field_70179_y = this.velocityZ;
    }

    public void setDamage(float p_70492_1_) {
        this.field_70180_af.func_75692_b(19, (Object)Float.valueOf(p_70492_1_));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double p_70016_1_, double p_70016_3_, double p_70016_5_) {
        this.velocityX = this.field_70159_w = p_70016_1_;
        this.velocityY = this.field_70181_x = p_70016_3_;
        this.velocityZ = this.field_70179_y = p_70016_5_;
    }

    public float getDamage() {
        return this.field_70180_af.func_111145_d(19);
    }

    public void setRollingAmplitude(int p_70497_1_) {
        this.field_70180_af.func_75692_b(17, (Object)p_70497_1_);
    }

    public int getRollingAmplitude() {
        return this.field_70180_af.func_75679_c(17);
    }

    public void setRollingDirection(int p_70494_1_) {
        this.field_70180_af.func_75692_b(18, (Object)p_70494_1_);
    }

    public int getRollingDirection() {
        return this.field_70180_af.func_75679_c(18);
    }

    public abstract int getMinecartType();

    public Block func_145820_n() {
        if (!this.hasDisplayTile()) {
            return this.func_145817_o();
        }
        int i = this.func_70096_w().func_75679_c(20) & 0xFFFF;
        return Block.func_149729_e((int)i);
    }

    public Block func_145817_o() {
        return Blocks.field_150350_a;
    }

    public int getDisplayTileData() {
        return !this.hasDisplayTile() ? this.getDefaultDisplayTileData() : this.func_70096_w().func_75679_c(20) >> 16;
    }

    public int getDefaultDisplayTileData() {
        return 0;
    }

    public int getDisplayTileOffset() {
        return !this.hasDisplayTile() ? this.getDefaultDisplayTileOffset() : this.func_70096_w().func_75679_c(21);
    }

    public int getDefaultDisplayTileOffset() {
        return 6;
    }

    public void func_145819_k(int p_145819_1_) {
        this.func_70096_w().func_75692_b(20, (Object)(p_145819_1_ & 0xFFFF | this.getDisplayTileData() << 16));
        this.setHasDisplayTile(true);
    }

    public void setDisplayTileData(int p_94092_1_) {
        this.func_70096_w().func_75692_b(20, (Object)(Block.func_149682_b((Block)this.func_145820_n()) & 0xFFFF | p_94092_1_ << 16));
        this.setHasDisplayTile(true);
    }

    public void setDisplayTileOffset(int p_94086_1_) {
        this.func_70096_w().func_75692_b(21, (Object)p_94086_1_);
        this.setHasDisplayTile(true);
    }

    public boolean hasDisplayTile() {
        return this.func_70096_w().func_75683_a(22) == 1;
    }

    public void setHasDisplayTile(boolean p_94096_1_) {
        this.func_70096_w().func_75692_b(22, (Object)((byte)(p_94096_1_ ? 1 : 0)));
    }

    public void setMinecartName(String p_96094_1_) {
        this.entityName = p_96094_1_;
    }

    public String func_70005_c_() {
        return this.entityName != null ? this.entityName : super.func_70005_c_();
    }

    public boolean hasCustomInventoryName() {
        return this.entityName != null;
    }

    public String func_95999_t() {
        return this.entityName;
    }

    public void moveMinecartOnRail(int x, int y, int z, double maxSpeed) {
        double motionX = this.field_70159_w;
        double motionZ = this.field_70179_y;
        if (this.field_70153_n != null) {
            motionX *= 0.75;
            motionZ *= 0.75;
        }
        if (motionX < -maxSpeed) {
            motionX = -maxSpeed;
        }
        if (motionX > maxSpeed) {
            motionX = maxSpeed;
        }
        if (motionZ < -maxSpeed) {
            motionZ = -maxSpeed;
        }
        if (motionZ > maxSpeed) {
            motionZ = maxSpeed;
        }
        this.func_70091_d(motionX, 0.0, motionZ);
    }

    public static IMinecartCollisionHandler getCollisionHandler() {
        return collisionHandler;
    }

    public static void setCollisionHandler(IMinecartCollisionHandler handler) {
        collisionHandler = handler;
    }

    public ItemStack getCartItem() {
        return new ItemStack(Items.field_151143_au);
    }

    public boolean canUseRail() {
        return this.canUseRail;
    }

    public void setCanUseRail(boolean use) {
        this.canUseRail = use;
    }

    public boolean shouldDoRailFunctions() {
        return true;
    }

    public boolean isPoweredCart() {
        return this.getMinecartType() == 2;
    }

    public boolean canBeRidden() {
        return false;
    }

    public final float getCurrentCartSpeedCapOnRail() {
        return this.currentSpeedRail;
    }

    public final void setCurrentCartSpeedCapOnRail(float value) {
        this.currentSpeedRail = value = Math.min(value, this.getMaxCartSpeedOnRail());
    }

    public float getMaxCartSpeedOnRail() {
        return 1.2f;
    }

    public float getMaxSpeedAirLateral() {
        return this.maxSpeedAirLateral;
    }

    public void setMaxSpeedAirLateral(float value) {
        this.maxSpeedAirLateral = value;
    }

    public float getMaxSpeedAirVertical() {
        return this.maxSpeedAirVertical;
    }

    public void setMaxSpeedAirVertical(float value) {
        this.maxSpeedAirVertical = value;
    }

    public double getDragAir() {
        return this.dragAir;
    }

    public void setDragAir(double value) {
        this.dragAir = value;
    }

    public double getSlopeAdjustment() {
        return 0.0078125;
    }
}

