/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.generic;

import api.hbm.block.IToolable;
import com.hbm.blocks.IBlockSideRotation;
import com.hbm.blocks.ILookOverlay;
import com.hbm.blocks.ITooltipProvider;
import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.generic.BlockLoot;
import com.hbm.config.StructureConfig;
import com.hbm.itempool.ItemPool;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.TileEntityLoadedBase;
import com.hbm.util.BufferUtil;
import com.hbm.util.LootGenerator;
import com.hbm.util.i18n.I18nUtil;
import com.hbm.world.gen.nbt.INBTTileEntityTransformable;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;

public class BlockWandLoot
extends BlockContainer
implements ILookOverlay,
IToolable,
ITooltipProvider,
IBlockSideRotation {
    @SideOnly(value=Side.CLIENT)
    protected IIcon iconTop;

    public BlockWandLoot() {
        super(Material.field_151573_f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a("hbm:wand_loot");
        this.iconTop = iconRegister.func_94245_a("hbm:wand_loot_top");
    }

    public IIcon func_149691_a(int side, int meta) {
        return side <= 1 ? this.iconTop : this.field_149761_L;
    }

    @Override
    public int getRotationFromSide(IBlockAccess world, int x, int y, int z, int side) {
        if (side == 0) {
            return IBlockSideRotation.topToBottom(world.func_72805_g(x, y, z));
        }
        if (side == 1) {
            return world.func_72805_g(x, y, z);
        }
        return 0;
    }

    public int func_149645_b() {
        return IBlockSideRotation.getRenderType();
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemStack) {
        TileEntity te;
        int i = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (i == 0) {
            world.func_72921_c(x, y, z, 3, 2);
        }
        if (i == 1) {
            world.func_72921_c(x, y, z, 2, 2);
        }
        if (i == 2) {
            world.func_72921_c(x, y, z, 0, 2);
        }
        if (i == 3) {
            world.func_72921_c(x, y, z, 1, 2);
        }
        if (!((te = world.func_147438_o(x, y, z)) instanceof TileEntityWandLoot)) {
            return;
        }
        ((TileEntityWandLoot)te).placedRotation = player.field_70177_z;
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityWandLoot)) {
            return;
        }
        TileEntityWandLoot loot = (TileEntityWandLoot)te;
        ArrayList<String> text = new ArrayList<String>();
        text.add("Will replace with: " + loot.replaceBlock.func_149739_a());
        text.add("   meta: " + loot.replaceMeta);
        text.add("Loot pool: " + loot.poolName);
        if (loot.replaceBlock != ModBlocks.deco_loot) {
            text.add("Minimum items: " + loot.minItems);
            text.add("Maximum items: " + loot.maxItems);
        }
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean ext) {
        list.add("Define loot crates/piles in .nbt structures");
        list.add(EnumChatFormatting.GOLD + "Use screwdriver to increase/decrease minimum loot");
        list.add(EnumChatFormatting.GOLD + "Use hand drill to increase/decrease maximum loot");
        list.add(EnumChatFormatting.GOLD + "Use defuser to cycle loot types");
        list.add(EnumChatFormatting.GOLD + "Use container block to set the block that spawns with loot inside");
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        Block block;
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityWandLoot)) {
            return false;
        }
        TileEntityWandLoot loot = (TileEntityWandLoot)te;
        if (!player.func_70093_af() && (block = this.getLootableBlock(world, player.func_70694_bm())) != null) {
            loot.replaceBlock = block;
            loot.replaceMeta = player.func_70694_bm().func_77960_j();
            List poolNames = loot.getPoolNames(block == ModBlocks.deco_loot);
            if (!poolNames.contains(loot.poolName)) {
                loot.poolName = (String)poolNames.get(0);
            }
            return true;
        }
        return false;
    }

    private Block getLootableBlock(World world, ItemStack stack) {
        if (stack == null) {
            return null;
        }
        if (stack.func_77973_b() instanceof ItemBlock) {
            TileEntity te;
            Block block = ((ItemBlock)stack.func_77973_b()).field_150939_a;
            if (block == ModBlocks.deco_loot) {
                return block;
            }
            if (block instanceof ITileEntityProvider && (te = ((ITileEntityProvider)block).func_149915_a(world, 12)) instanceof IInventory) {
                return block;
            }
        }
        return null;
    }

    @Override
    public boolean onScrew(World world, EntityPlayer player, int x, int y, int z, int side, float fX, float fY, float fZ, IToolable.ToolType tool) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityWandLoot)) {
            return false;
        }
        TileEntityWandLoot loot = (TileEntityWandLoot)te;
        switch (tool) {
            case SCREWDRIVER: {
                if (player.func_70093_af()) {
                    loot.minItems--;
                    if (loot.minItems < 0) {
                        loot.minItems = 0;
                    }
                } else {
                    loot.minItems++;
                    loot.maxItems = Math.max(loot.minItems, loot.maxItems);
                }
                return true;
            }
            case HAND_DRILL: {
                if (player.func_70093_af()) {
                    loot.maxItems--;
                    if (loot.maxItems < 0) {
                        loot.maxItems = 0;
                    }
                    loot.minItems = Math.min(loot.minItems, loot.maxItems);
                } else {
                    loot.maxItems++;
                }
                return true;
            }
            case DEFUSER: {
                List poolNames = loot.getPoolNames(loot.replaceBlock == ModBlocks.deco_loot);
                int index = poolNames.indexOf(loot.poolName);
                index += player.func_70093_af() ? -1 : 1;
                index = MathHelper.func_76125_a((int)index, (int)0, (int)(poolNames.size() - 1));
                loot.poolName = (String)poolNames.get(index);
                return true;
            }
        }
        return false;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityWandLoot();
    }

    public static class TileEntityWandLoot
    extends TileEntityLoadedBase
    implements INBTTileEntityTransformable {
        private boolean triggerReplace;
        private Block replaceBlock = ModBlocks.deco_loot;
        private int replaceMeta;
        private String poolName = "LOOT_BOOKLET";
        private int minItems;
        private int maxItems = 1;
        private float placedRotation;
        private static final GameProfile FAKE_PROFILE = new GameProfile(UUID.fromString("839eb18c-50bc-400c-8291-9383f09763e7"), "[NTM]");
        private static FakePlayer fakePlayer;

        public void func_145845_h() {
            if (!this.field_145850_b.field_72995_K) {
                if (this.triggerReplace) {
                    this.replace();
                } else {
                    this.networkPackNT(15);
                }
            }
        }

        private void replace() {
            if (!(this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e) instanceof BlockWandLoot)) {
                MainRegistry.logger.warn("Somehow the block at: " + this.field_145851_c + ", " + this.field_145848_d + ", " + this.field_145849_e + " isn't a loot block but we're doing a TE update as if it is, cancelling!");
                return;
            }
            WeightedRandomChestContent[] pool = ItemPool.getPool(this.poolName);
            this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.replaceBlock, this.replaceMeta, 2);
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (te == null || te instanceof TileEntityWandLoot) {
                MainRegistry.logger.warn("TE set incorrectly at: " + this.field_145851_c + ", " + this.field_145848_d + ", " + this.field_145849_e + ". If you're using some sort of world generation mod, report it to the author!");
                te = this.replaceBlock.createTileEntity(this.field_145850_b, this.replaceMeta);
                this.field_145850_b.func_147455_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, te);
            }
            if (te instanceof IInventory) {
                int count = this.minItems;
                if (this.maxItems - this.minItems > 0) {
                    count += this.field_145850_b.field_73012_v.nextInt(this.maxItems - this.minItems);
                }
                WeightedRandomChestContent.func_76293_a((Random)this.field_145850_b.field_73012_v, (WeightedRandomChestContent[])pool, (IInventory)((IInventory)te), (int)count);
            } else if (te instanceof BlockLoot.TileEntityLoot) {
                LootGenerator.applyLoot(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.poolName);
            }
            if (!(this.field_145850_b instanceof WorldServer)) {
                return;
            }
            try {
                if (fakePlayer == null || TileEntityWandLoot.fakePlayer.field_70170_p != this.field_145850_b) {
                    fakePlayer = FakePlayerFactory.get((WorldServer)((WorldServer)this.field_145850_b), (GameProfile)FAKE_PROFILE);
                }
                TileEntityWandLoot.fakePlayer.field_70177_z = TileEntityWandLoot.fakePlayer.field_70759_as = this.placedRotation;
                ItemStack fakeStack = new ItemStack(this.replaceBlock, 1, this.replaceMeta);
                this.replaceBlock.func_149689_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, (EntityLivingBase)fakePlayer, fakeStack);
            }
            catch (Exception ex) {
                MainRegistry.logger.warn("Failed to correctly rotate loot block at: " + this.field_145851_c + ", " + this.field_145848_d + ", " + this.field_145849_e);
                MainRegistry.logger.catching((Throwable)ex);
            }
        }

        private List<String> getPoolNames(boolean loot) {
            if (loot) {
                return Arrays.asList(LootGenerator.getLootNames());
            }
            ArrayList<String> names = new ArrayList<String>();
            names.addAll(ItemPool.pools.keySet());
            return names;
        }

        @Override
        public void transformTE(World world, int coordBaseMode) {
            this.triggerReplace = !StructureConfig.debugStructures;
            this.placedRotation = MathHelper.func_76142_g((float)(this.placedRotation + (float)(coordBaseMode * 90)));
        }

        @Override
        public void func_145841_b(NBTTagCompound nbt) {
            super.func_145841_b(nbt);
            Block writeBlock = this.replaceBlock == null ? ModBlocks.deco_loot : this.replaceBlock;
            nbt.func_74778_a("block", GameRegistry.findUniqueIdentifierFor((Block)writeBlock).toString());
            nbt.func_74768_a("meta", this.replaceMeta);
            nbt.func_74768_a("min", this.minItems);
            nbt.func_74768_a("max", this.maxItems);
            nbt.func_74778_a("pool", this.poolName);
            nbt.func_74776_a("rot", this.placedRotation);
            nbt.func_74757_a("trigger", this.triggerReplace);
        }

        @Override
        public void func_145839_a(NBTTagCompound nbt) {
            super.func_145839_a(nbt);
            this.replaceBlock = Block.func_149684_b((String)nbt.func_74779_i("block"));
            this.replaceMeta = nbt.func_74762_e("meta");
            this.minItems = nbt.func_74762_e("min");
            this.maxItems = nbt.func_74762_e("max");
            this.poolName = nbt.func_74779_i("pool");
            this.placedRotation = nbt.func_74760_g("rot");
            if (this.replaceBlock == null) {
                this.replaceBlock = ModBlocks.deco_loot;
            }
            this.triggerReplace = nbt.func_74767_n("trigger");
        }

        @Override
        public void serialize(ByteBuf buf) {
            buf.writeInt(Block.func_149682_b((Block)this.replaceBlock));
            buf.writeInt(this.replaceMeta);
            buf.writeInt(this.minItems);
            buf.writeInt(this.maxItems);
            BufferUtil.writeString(buf, this.poolName);
        }

        @Override
        public void deserialize(ByteBuf buf) {
            this.replaceBlock = Block.func_149729_e((int)buf.readInt());
            this.replaceMeta = buf.readInt();
            this.minItems = buf.readInt();
            this.maxItems = buf.readInt();
            this.poolName = BufferUtil.readString(buf);
        }
    }
}

