/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.generic;

import com.hbm.blocks.ITooltipProvider;
import com.hbm.blocks.ModBlocks;
import com.hbm.handler.radiation.ChunkRadiationManager;
import com.hbm.hazard.HazardRegistry;
import com.hbm.hazard.HazardSystem;
import com.hbm.main.MainRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockHazard
extends Block
implements ITooltipProvider {
    protected float rad = 0.0f;
    private ExtDisplayEffect extEffect = null;
    private boolean beaconable = false;

    public BlockHazard() {
        this(Material.field_151573_f);
    }

    public BlockHazard(Material mat) {
        super(mat);
    }

    public BlockHazard setDisplayEffect(ExtDisplayEffect extEffect) {
        this.extEffect = extEffect;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        super.func_149734_b(world, x, y, z, rand);
        if (this.extEffect == null) {
            return;
        }
        switch (this.extEffect) {
            case RADFOG: 
            case SCHRAB: 
            case FLAMES: {
                this.sPart(world, x, y, z, rand);
                break;
            }
            case SPARKS: {
                break;
            }
            case LAVAPOP: {
                world.func_72869_a("lava", (double)((float)x + rand.nextFloat()), (double)((float)y + 1.1f), (double)((float)z + rand.nextFloat()), 0.0, 0.0, 0.0);
                break;
            }
        }
    }

    private void sPart(World world, int x, int y, int z, Random rand) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (dir == ForgeDirection.DOWN && this.extEffect == ExtDisplayEffect.FLAMES || world.func_147439_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ).func_149688_o() != Material.field_151579_a) continue;
            double ix = (double)((float)x + 0.5f + (float)dir.offsetX) + rand.nextDouble() * 3.0 - 1.5;
            double iy = (double)((float)y + 0.5f + (float)dir.offsetY) + rand.nextDouble() * 3.0 - 1.5;
            double iz = (double)((float)z + 0.5f + (float)dir.offsetZ) + rand.nextDouble() * 3.0 - 1.5;
            if (dir.offsetX != 0) {
                ix = (double)((float)x + 0.5f) + (double)dir.offsetX * 0.5 + rand.nextDouble() * (double)dir.offsetX;
            }
            if (dir.offsetY != 0) {
                iy = (double)((float)y + 0.5f) + (double)dir.offsetY * 0.5 + rand.nextDouble() * (double)dir.offsetY;
            }
            if (dir.offsetZ != 0) {
                iz = (double)((float)z + 0.5f) + (double)dir.offsetZ * 0.5 + rand.nextDouble() * (double)dir.offsetZ;
            }
            if (this.extEffect == ExtDisplayEffect.RADFOG) {
                world.func_72869_a("townaura", ix, iy, iz, 0.0, 0.0, 0.0);
            }
            if (this.extEffect == ExtDisplayEffect.SCHRAB) {
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("type", "schrabfog");
                data.func_74780_a("posX", ix);
                data.func_74780_a("posY", iy);
                data.func_74780_a("posZ", iz);
                MainRegistry.proxy.effectNT(data);
            }
            if (this.extEffect != ExtDisplayEffect.FLAMES) continue;
            world.func_72869_a("flame", ix, iy, iz, 0.0, 0.0, 0.0);
            world.func_72869_a("smoke", ix, iy, iz, 0.0, 0.0, 0.0);
            world.func_72869_a("smoke", ix, iy, iz, 0.0, 0.1, 0.0);
        }
    }

    public BlockHazard makeBeaconable() {
        this.beaconable = true;
        return this;
    }

    public boolean isBeaconBase(IBlockAccess worldObj, int x, int y, int z, int beaconX, int beaconY, int beaconZ) {
        return this.beaconable;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (this.rad > 0.0f) {
            ChunkRadiationManager.proxy.incrementRad(world, x, y, z, this.rad);
            world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
        }
    }

    public int func_149738_a(World world) {
        if (this.rad > 0.0f) {
            return 20;
        }
        return super.func_149738_a(world);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        this.rad = HazardSystem.getHazardLevelFromStack(new ItemStack((Block)this), HazardRegistry.RADIATION) * 0.1f;
        if (this.rad > 0.0f) {
            world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
        }
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean ext) {
    }

    @Override
    public EnumRarity getRarity(ItemStack stack) {
        if (this == ModBlocks.block_schraranium || this == ModBlocks.block_schraranium || this == ModBlocks.block_schrabidate || this == ModBlocks.block_solinium || this == ModBlocks.block_schrabidium_fuel) {
            return EnumRarity.rare;
        }
        return EnumRarity.common;
    }

    public static enum ExtDisplayEffect {
        RADFOG,
        SPARKS,
        SCHRAB,
        FLAMES,
        LAVAPOP;

    }
}

