/*
 * Decompiled with CFR 0.152.
 */
package xyz.acproject.danmuji.utils;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.ReflectionUtils;
import xyz.acproject.danmuji.utils.ByteUtils;
import xyz.acproject.danmuji.utils.SpringUtils;

public class SchedulingRunnableUtil
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger(SchedulingRunnableUtil.class);
    private String beanName;
    private String methodName;
    private Object[] params;

    public SchedulingRunnableUtil(String beanName, String methodName) {
        this(beanName, methodName, new Object[0]);
    }

    public SchedulingRunnableUtil(String beanName, String methodName, Object ... params) {
        this.beanName = beanName;
        this.methodName = methodName;
        this.params = params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String string = this.methodName;
        synchronized (string) {
            LOGGER.info("\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\u6267\u884c - bean\uff1a{}\uff0c\u65b9\u6cd5\uff1a{}\uff0c\u53c2\u6570\uff1a{}", (Object)this.beanName, (Object)this.methodName, (Object)this.params);
            long startTime = System.currentTimeMillis();
            try {
                Object target = SpringUtils.getBean((String)this.beanName);
                Class<ByteUtils> clazz = ByteUtils.class;
                Method method = null;
                if (null != this.params && this.params.length > 0) {
                    Class[] paramCls = new Class[this.params.length];
                    for (int i = 0; i < this.params.length; ++i) {
                        paramCls[i] = this.params[i].getClass();
                    }
                    method = target.getClass().getDeclaredMethod(this.methodName, paramCls);
                } else {
                    method = target.getClass().getDeclaredMethod(this.methodName, new Class[0]);
                }
                ReflectionUtils.makeAccessible((Method)method);
                if (null != this.params && this.params.length > 0) {
                    method.invoke(target, this.params);
                } else {
                    method.invoke(target, new Object[0]);
                }
            }
            catch (Exception ex) {
                LOGGER.error(String.format("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f02\u5e38 - bean\uff1a%s\uff0c\u65b9\u6cd5\uff1a%s\uff0c\u53c2\u6570\uff1a%s ", this.beanName, this.methodName, this.params), (Throwable)ex);
            }
            long times = System.currentTimeMillis() - startTime;
            LOGGER.info("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u7ed3\u675f - bean\uff1a{}\uff0c\u65b9\u6cd5\uff1a{}\uff0c\u53c2\u6570\uff1a{}\uff0c\u8017\u65f6\uff1a{} \u6beb\u79d2", (Object)this.beanName, (Object)this.methodName, (Object)this.params, (Object)times);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchedulingRunnableUtil that = (SchedulingRunnableUtil)o;
        if (this.params == null) {
            return this.beanName.equals(that.beanName) && this.methodName.equals(that.methodName) && that.params == null;
        }
        return this.beanName.equals(that.beanName) && this.methodName.equals(that.methodName) && Arrays.equals(this.params, that.params);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getBeanName() == null ? 0 : this.getBeanName().hashCode());
        result = 31 * result + (this.getMethodName() == null ? 0 : this.getMethodName().hashCode());
        result = 31 * result + (this.params == null ? 0 : Arrays.hashCode(this.params));
        return result;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }
}

