/*
 * Decompiled with CFR 0.152.
 */
package xyz.acproject.danmuji.utils;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OkHttp3Utils {
    private static volatile OkHttp3Utils okHttp3Utils;
    private OkHttpClient okHttpClient;
    private static final int READ_TIMEOUT = 15;
    private static final int CONNECT_TIMEOUT = 15;
    private static final int WRITE_TIMEOUT = 15;
    private static final MediaType MEDIA_TYPE_JSON;
    private static final MediaType MEDIA_TYPE_TEXT;

    private OkHttp3Utils() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.readTimeout(15L, TimeUnit.SECONDS);
        builder.connectTimeout(15L, TimeUnit.SECONDS);
        builder.writeTimeout(15L, TimeUnit.SECONDS);
        this.okHttpClient = builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OkHttp3Utils getHttp3Utils() {
        if (okHttp3Utils != null) return okHttp3Utils;
        Class<OkHttp3Utils> clazz = OkHttp3Utils.class;
        synchronized (OkHttp3Utils.class) {
            if (okHttp3Utils != null) return okHttp3Utils;
            okHttp3Utils = new OkHttp3Utils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return okHttp3Utils;
        }
    }

    public Response httpGet(String url, Map<String, String> headers, Map<String, String> datas) throws Exception {
        Headers hearderHeaders = null;
        StringBuilder stringBuilder = null;
        Request request = null;
        if (datas != null && datas.size() > 0) {
            stringBuilder = new StringBuilder(100);
            stringBuilder.append("?");
            for (Map.Entry<String, String> entry : datas.entrySet()) {
                stringBuilder.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
            }
            stringBuilder.delete(stringBuilder.length() - 1, stringBuilder.length());
        }
        if (stringBuilder != null) {
            url = stringBuilder.insert(0, url).toString();
        }
        if (headers != null && headers.size() > 0) {
            hearderHeaders = Headers.of(headers);
            request = new Request.Builder().url(url).headers(hearderHeaders).get().build();
        } else {
            request = new Request.Builder().url(url).get().build();
        }
        Response response = null;
        try {
            response = this.okHttpClient.newCall(request).execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return response;
    }

    public Response httpPostJson(String url, Map<String, String> headers, String json) throws Exception {
        RequestBody body = RequestBody.create((MediaType)MEDIA_TYPE_JSON, (String)json);
        Request request = null;
        Headers hearderHeaders = null;
        Response response = null;
        if (headers != null && headers.size() > 0) {
            hearderHeaders = Headers.of(headers);
            request = new Request.Builder().url(url).headers(hearderHeaders).post(body).build();
        } else {
            request = new Request.Builder().url(url).post(body).build();
        }
        try {
            response = this.okHttpClient.newCall(request).execute();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return response;
    }

    public Response httpPostForm(String url, Map<String, String> headers, Map<String, String> params) throws Exception {
        Request request = null;
        StringBuilder content = new StringBuilder();
        if (params != null) {
            Iterator<Map.Entry<String, String>> iterator = params.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                content.append(entry.getKey()).append("=").append(entry.getValue());
                if (!iterator.hasNext()) continue;
                content.append("&");
            }
        }
        RequestBody body = RequestBody.create((MediaType)MEDIA_TYPE_TEXT, (String)content.toString());
        Headers hearderHeaders = null;
        if (headers != null && headers.size() > 0) {
            hearderHeaders = Headers.of(headers);
            request = new Request.Builder().url(url).headers(hearderHeaders).post(body).build();
        } else {
            request = new Request.Builder().url(url).post(body).build();
        }
        Response response = null;
        try {
            response = this.okHttpClient.newCall(request).execute();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return response;
    }

    static {
        MEDIA_TYPE_JSON = MediaType.parse((String)"application/json; charset=utf-8");
        MEDIA_TYPE_TEXT = MediaType.parse((String)"application/x-www-form-urlencoded; charset=utf-8");
    }
}

