/*
 * Decompiled with CFR 0.152.
 */
package xyz.acproject.danmuji.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.InflaterOutputStream;
import org.apache.commons.compress.compressors.brotli.BrotliCompressorInputStream;
import xyz.acproject.danmuji.utils.HexUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ByteUtils {
    public static final int UNICODE_LEN = 2;

    public static byte hexToByte(String inHex) {
        return (byte)Integer.parseInt(inHex, 16);
    }

    public static byte[] hexToByteArray(String hex) {
        int m = 0;
        int n = 0;
        int byteLen = hex.length() / 2;
        byte[] ret = new byte[byteLen];
        for (int i = 0; i < byteLen; ++i) {
            m = i * 2 + 1;
            n = m + 1;
            int intVal = Integer.decode("0x" + hex.substring(i * 2, m) + hex.substring(m, n));
            ret[i] = (byte)intVal;
        }
        return ret;
    }

    public static byte[] byteMerger(byte[] byte_1, byte[] byte_2) {
        byte[] byte_3 = new byte[byte_1.length + byte_2.length];
        System.arraycopy(byte_1, 0, byte_3, 0, byte_1.length);
        System.arraycopy(byte_2, 0, byte_3, byte_1.length, byte_2.length);
        return byte_3;
    }

    public static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    public static byte[] decodeValue(ByteBuffer bytes) {
        int len = bytes.limit() - bytes.position();
        byte[] bytes1 = new byte[len];
        bytes.get(bytes1);
        return bytes1;
    }

    public static String hexStringToString(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        s = s.replace(" ", "");
        byte[] baKeyword = new byte[s.length() / 2];
        for (int i = 0; i < baKeyword.length; ++i) {
            try {
                baKeyword[i] = (byte)(0xFF & Integer.parseInt(s.substring(i * 2, i * 2 + 2), 16));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            s = new String(baKeyword, "utf-8");
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return s;
    }

    public static String hexStringTozlibInflateString(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        s = s.replace(" ", "");
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            InflaterOutputStream zos = new InflaterOutputStream(bos);
            zos.write(HexUtils.fromHexString((String)s));
            zos.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return s;
    }

    public static String BytesTozlibInflateString(byte[] bs) {
        String s = "";
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            InflaterOutputStream zos = new InflaterOutputStream(bos);
            zos.write(bs);
            zos.close();
            s = new String(bos.toByteArray(), "utf-8");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return s;
    }

    public static byte[] BytesToBrotliInflate(byte[] bs) {
        byte[] b = null;
        try (BrotliCompressorInputStream brotliCompressorInputStream = new BrotliCompressorInputStream((InputStream)new ByteArrayInputStream(bs));){
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int readByte = -1;
            while ((readByte = brotliCompressorInputStream.read()) != -1) {
                bos.write(readByte);
            }
            b = bos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] BytesTozlibInflate(byte[] bs) {
        byte[] b = null;
        ByteArrayOutputStream bos = null;
        InflaterOutputStream zos = null;
        try {
            bos = new ByteArrayOutputStream();
            zos = new InflaterOutputStream(bos);
            zos.write(bs);
            zos.close();
            byte[] byArray = b = bos.toByteArray();
            return byArray;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return b;
    }

    public static String unicodeToString(String s) {
        String unicodeCompile = "(?<=\\\\u).{4}?";
        Matcher matcher = Pattern.compile(unicodeCompile).matcher(s);
        while (matcher.find()) {
            String a = matcher.group();
            s = s.replace("\\u" + a, String.valueOf((char)Integer.valueOf(a, 16).intValue()));
        }
        return s;
    }

    public static byte[] subBytes(byte[] bytes, int begin, int count) {
        byte[] bs = new byte[count];
        System.arraycopy(bytes, begin, bs, 0, count);
        return bs;
    }

    public static int Bytes2Int_BE(byte[] bytes) {
        int addr;
        if (bytes.length == 1) {
            addr = bytes[0] & 0xFF;
        } else {
            addr = bytes[0] & 0xFF;
            addr = addr << 8 | bytes[1] & 0xFF;
            addr = addr << 8 | bytes[2] & 0xFF;
            addr = addr << 8 | bytes[3] & 0xFF;
        }
        return addr;
    }

    public static char Bytes2Char_BE(byte[] bytes) {
        if (bytes.length < 2) {
            return '\uffff';
        }
        int iRst = bytes[0] << 8 & 0xFF;
        return (char)(iRst |= bytes[1] & 0xFF);
    }

    public static int Bytes2Int_LE(byte[] bytes) {
        if (bytes.length < 4) {
            return -1;
        }
        int iRst = bytes[0] & 0xFF;
        iRst |= (bytes[1] & 0xFF) << 8;
        iRst |= (bytes[2] & 0xFF) << 16;
        return iRst |= (bytes[3] & 0xFF) << 24;
    }

    public static char Bytes2Char_LE(byte[] bytes) {
        if (bytes.length < 2) {
            return '\uffff';
        }
        int iRst = bytes[0] & 0xFF;
        return (char)(iRst |= (bytes[1] & 0xFF) << 8);
    }

    public static byte[] Chars2Bytes_LE(char[] chars) {
        if (chars == null) {
            return null;
        }
        int iCharCount = chars.length;
        byte[] rst = new byte[iCharCount * 2];
        int i = 0;
        for (i = 0; i < iCharCount; ++i) {
            rst[i * 2] = (byte)(chars[i] & 0xFF);
            rst[i * 2 + 1] = (byte)((chars[i] & 0xFF00) >> 8);
        }
        return rst;
    }

    public static byte[] String2Bytes_LE(String str) {
        if (str == null) {
            return null;
        }
        char[] chars = str.toCharArray();
        byte[] rst = ByteUtils.Chars2Bytes_LE((char[])chars);
        return rst;
    }

    public static byte[] hexStringTozlibInflateByteArray(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        s = s.replace(" ", "");
        byte[] bs = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            InflaterOutputStream zos = new InflaterOutputStream(bos);
            zos.write(HexUtils.fromHexString((String)s));
            zos.close();
            bs = bos.toByteArray();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return bs;
    }

    public static long byteslong(byte[] bs) throws Exception {
        int bytes = bs.length;
        if (bytes > 1 && (bytes % 2 != 0 || bytes > 8)) {
            throw new Exception("not support");
        }
        switch (bytes) {
            case 0: {
                return 0L;
            }
            case 1: {
                return bs[0] & 0xFF;
            }
            case 2: {
                return (bs[0] & 0xFF) << 8 | bs[1] & 0xFF;
            }
            case 4: {
                return ((long)bs[0] & 0xFFL) << 24 | ((long)bs[1] & 0xFFL) << 16 | ((long)bs[2] & 0xFFL) << 8 | (long)bs[3] & 0xFFL;
            }
            case 8: {
                return ((long)bs[0] & 0xFFL) << 56 | ((long)bs[1] & 0xFFL) << 48 | ((long)bs[2] & 0xFFL) << 40 | ((long)bs[3] & 0xFFL) << 32 | ((long)bs[4] & 0xFFL) << 24 | ((long)bs[5] & 0xFFL) << 16 | ((long)bs[6] & 0xFFL) << 8 | (long)bs[7] & 0xFFL;
            }
        }
        throw new Exception("not support");
    }

    public static String oct2Str(String ascii) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ascii.length() - 2; i += 3) {
            String h = ascii.substring(i, i + 3);
            int decimal = Integer.parseInt(h, 8);
            sb.append((char)decimal);
        }
        return sb.toString();
    }
}

