/*
 * Decompiled with CFR 0.152.
 */
package xyz.acproject.danmuji.tools.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.acproject.danmuji.tools.file.FileTools;

public class ProFileTools {
    private static final Logger log;
    private static final String STORE_DIR;

    public static Map<String, String> read(String filename) throws IOException {
        File file = new File(STORE_DIR);
        file.mkdirs();
        file = new File(STORE_DIR + "/" + filename);
        ConcurrentHashMap<String, String> profileMap = new ConcurrentHashMap<String, String>();
        if (file.createNewFile()) {
            return profileMap;
        }
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            String dataString;
            while ((dataString = bufferedReader.readLine()) != null) {
                String[] strings = dataString.split(":@:");
                if (strings.length != 2) continue;
                profileMap.put(strings[0], strings[1]);
            }
        }
        catch (FileNotFoundException e) {
            log.warn("\u6587\u4ef6{}\u4e0d\u5b58\u5728!", (Object)file.getAbsolutePath());
            throw e;
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        return profileMap;
    }

    public static void write(Map<String, String> profileMap, String filename) {
        File file = new File(STORE_DIR);
        file.mkdirs();
        file = new File(STORE_DIR + "/" + filename);
        StringBuffer stringBuffer = new StringBuffer();
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        BufferedWriter bufferedWriter = null;
        try (OutputStreamWriter os = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            bufferedWriter = new BufferedWriter(os);
            profileMap.forEach((k, v) -> {
                stringBuffer.append((String)k);
                stringBuffer.append(":@:");
                stringBuffer.append((String)v);
                stringBuffer.append("\r\n");
            });
            bufferedWriter.write(stringBuffer.toString());
            os.flush();
            bufferedWriter.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        String tmp;
        log = LoggerFactory.getLogger(ProFileTools.class);
        FileTools fileTools = new FileTools();
        try {
            tmp = URLDecoder.decode(fileTools.getBaseJarPath().toString(), "utf-8");
        }
        catch (Exception e1) {
            log.warn(e1.getMessage(), (Throwable)e1);
            tmp = System.getProperty("user.dir");
        }
        STORE_DIR = tmp;
    }
}

