/*
 * Decompiled with CFR 0.152.
 */
package xyz.acproject.danmuji.service.impl;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import xyz.acproject.danmuji.client.WebSocketProxy;
import xyz.acproject.danmuji.component.ThreadComponent;
import xyz.acproject.danmuji.conf.PublicDataConf;
import xyz.acproject.danmuji.entity.BarrageHeadHandle;
import xyz.acproject.danmuji.entity.FristSecurityData;
import xyz.acproject.danmuji.entity.room_data.LotteryInfoWeb;
import xyz.acproject.danmuji.entity.room_data.Room;
import xyz.acproject.danmuji.entity.room_data.RoomInfoAnchor;
import xyz.acproject.danmuji.entity.room_data.RoomInit;
import xyz.acproject.danmuji.entity.server_data.Conf;
import xyz.acproject.danmuji.entity.user_data.UserNav;
import xyz.acproject.danmuji.http.HttpRoomData;
import xyz.acproject.danmuji.http.HttpUserData;
import xyz.acproject.danmuji.service.ClientService;
import xyz.acproject.danmuji.service.SetService;
import xyz.acproject.danmuji.tools.CurrencyTools;
import xyz.acproject.danmuji.tools.file.GuardFileTools;
import xyz.acproject.danmuji.utils.ByteUtils;
import xyz.acproject.danmuji.utils.HexUtils;
import xyz.acproject.danmuji.ws.HandleWebsocketPackage;

@Service
public class ClientServiceImpl
implements ClientService {
    private SetService setService;
    private ThreadComponent threadComponent;

    public void startConnService(long roomid) throws Exception {
        if (roomid < 1L) {
            return;
        }
        RoomInit roomInit = HttpRoomData.httpGetRoomInit((long)roomid);
        if (roomInit.getShort_id() > 0) {
            PublicDataConf.SHORTROOMID = roomInit.getShort_id();
        }
        PublicDataConf.ROOMID = roomInit.getRoom_id();
        Room room = HttpRoomData.httpGetRoomData((long)roomid);
        try {
            if (roomInit.getRoom_id() < 1L || roomInit.getRoom_id() == null) {
                return;
            }
        }
        catch (Exception e) {
            return;
        }
        Conf conf = null;
        if (StringUtils.isNotBlank((CharSequence)PublicDataConf.USERCOOKIE)) {
            UserNav userNav = HttpUserData.httpGetUserNav();
            conf = HttpRoomData.httpGetConf((UserNav)userNav);
        } else {
            conf = HttpRoomData.httpGetConf();
        }
        if (conf == null) {
            return;
        }
        RoomInfoAnchor roomInfoAnchor = HttpRoomData.httpGetRoomInfo();
        PublicDataConf.MEDALINFOANCHOR = roomInfoAnchor.getMedalInfoAnchor();
        PublicDataConf.AUID = roomInit.getUid();
        PublicDataConf.FANSNUM = HttpRoomData.httpGetFollowersNum();
        PublicDataConf.URL = CurrencyTools.GetWsUrl((List)conf.getHost_list());
        PublicDataConf.ANCHOR_NAME = room.getUname();
        PublicDataConf.lIVE_STATUS = roomInit.getLive_status();
        if (PublicDataConf.lIVE_STATUS == 1) {
            PublicDataConf.IS_ROOM_POPULARITY = true;
        }
        if (StringUtils.isNotBlank((CharSequence)PublicDataConf.USERCOOKIE)) {
            HttpUserData.httpGetUserBarrageMsg();
        }
        FristSecurityData fristSecurityData = null;
        if (StringUtils.isNotBlank((CharSequence)PublicDataConf.USERCOOKIE)) {
            fristSecurityData = new FristSecurityData(PublicDataConf.USER.getUid(), PublicDataConf.ROOMID, conf.getToken());
        } else {
            fristSecurityData = new FristSecurityData(Long.valueOf(0L), PublicDataConf.ROOMID, conf.getToken());
            fristSecurityData.setBuvid(UUID.randomUUID() + "infoc");
        }
        byte[] byte_1 = HandleWebsocketPackage.BEhandle((BarrageHeadHandle)BarrageHeadHandle.getBarrageHeadHandle((int)(fristSecurityData.toJson().getBytes().length + 16), (char)'\u0010', (char)'\u0001', (int)7, (int)1));
        byte[] byte_2 = fristSecurityData.toJson().getBytes();
        byte[] req = ByteUtils.byteMerger((byte[])byte_1, (byte[])byte_2);
        PublicDataConf.webSocketProxy = new WebSocketProxy(PublicDataConf.URL, room);
        PublicDataConf.webSocketProxy.send(req);
        PublicDataConf.webSocketProxy.send(HexUtils.fromHexString((String)"0000001f0010000100000002000000015b6f626a656374204f626a6563745d"));
        this.threadComponent.startHeartByteThread();
        this.setService.holdSet(PublicDataConf.centerSetConf);
        LotteryInfoWeb lotteryInfoWeb = null;
        if (PublicDataConf.centerSetConf.getThank_gift().hasRdShield() || PublicDataConf.centerSetConf.getWelcome().hasRdShield() || PublicDataConf.centerSetConf.getFollow().hasRdShield()) {
            lotteryInfoWeb = HttpRoomData.httpGetLotteryInfoWeb();
            CurrencyTools.handleLotteryInfoWebByRedPackage((Long)PublicDataConf.ROOMID, (LotteryInfoWeb)lotteryInfoWeb);
        }
        if (PublicDataConf.centerSetConf.getThank_gift().hasTxShield() || PublicDataConf.centerSetConf.getWelcome().hasTxShield() || PublicDataConf.centerSetConf.getFollow().hasTxShield()) {
            if (lotteryInfoWeb == null) {
                lotteryInfoWeb = HttpRoomData.httpGetLotteryInfoWeb();
            }
            CurrencyTools.handleLotteryInfoWebByTx((Long)PublicDataConf.ROOMID, (LotteryInfoWeb)lotteryInfoWeb);
        }
        if (StringUtils.isNotBlank((CharSequence)PublicDataConf.USERCOOKIE) && PublicDataConf.centerSetConf != null && PublicDataConf.centerSetConf.getThank_gift().is_guard_local() && (GuardFileTools.read() == null || GuardFileTools.read().size() <= 0)) {
            Map guards = HttpRoomData.httpGetGuardList();
            if (guards != null && guards.size() > 0) {
                for (Map.Entry entry : guards.entrySet()) {
                    GuardFileTools.write((String)(entry.getKey() + "," + (String)entry.getValue()));
                }
            }
            if (guards != null) {
                guards.clear();
            }
        }
    }

    public void reConnService() throws Exception {
        if (!PublicDataConf.webSocketProxy.isOpen()) {
            this.threadComponent.closeAll();
            RoomInit roomInit = HttpRoomData.httpGetRoomInit((long)PublicDataConf.ROOMID);
            Room room = HttpRoomData.httpGetRoomData((long)PublicDataConf.ROOMID);
            try {
                if (roomInit.getRoom_id() < 1L || roomInit.getRoom_id() == null) {
                    return;
                }
            }
            catch (Exception e) {
                return;
            }
            if (roomInit.getShort_id() > 0) {
                PublicDataConf.SHORTROOMID = roomInit.getShort_id();
            }
            PublicDataConf.ROOMID = roomInit.getRoom_id();
            Conf conf = null;
            if (StringUtils.isNotBlank((CharSequence)PublicDataConf.USERCOOKIE)) {
                UserNav userNav = HttpUserData.httpGetUserNav();
                conf = HttpRoomData.httpGetConf((UserNav)userNav);
            } else {
                conf = HttpRoomData.httpGetConf();
            }
            if (conf == null) {
                return;
            }
            PublicDataConf.AUID = roomInit.getUid();
            PublicDataConf.FANSNUM = HttpRoomData.httpGetFollowersNum();
            PublicDataConf.URL = CurrencyTools.GetWsUrl((List)conf.getHost_list());
            PublicDataConf.ANCHOR_NAME = room.getUname();
            PublicDataConf.lIVE_STATUS = roomInit.getLive_status();
            if (PublicDataConf.lIVE_STATUS == 1) {
                PublicDataConf.IS_ROOM_POPULARITY = true;
            }
            if (StringUtils.isNotBlank((CharSequence)PublicDataConf.USERCOOKIE)) {
                HttpUserData.httpGetUserBarrageMsg();
            }
            FristSecurityData fristSecurityData = null;
            PublicDataConf.webSocketProxy = new WebSocketProxy(PublicDataConf.URL, room);
            fristSecurityData = StringUtils.isNotBlank((CharSequence)PublicDataConf.USERCOOKIE) ? new FristSecurityData(PublicDataConf.USER.getUid(), PublicDataConf.ROOMID, conf.getToken()) : new FristSecurityData(PublicDataConf.ROOMID, conf.getToken());
            byte[] byte_1 = HandleWebsocketPackage.BEhandle((BarrageHeadHandle)BarrageHeadHandle.getBarrageHeadHandle((int)(fristSecurityData.toJson().toString().getBytes().length + 16), (char)'\u0010', (char)'\u0001', (int)7, (int)1));
            byte[] byte_2 = fristSecurityData.toJson().getBytes();
            byte[] req = ByteUtils.byteMerger((byte[])byte_1, (byte[])byte_2);
            PublicDataConf.webSocketProxy.send(req);
            PublicDataConf.webSocketProxy.send(HexUtils.fromHexString((String)"0000001f0010000100000002000000015b6f626a656374204f626a6563745d"));
            this.threadComponent.startHeartByteThread();
            if (PublicDataConf.webSocketProxy.isOpen()) {
                this.setService.holdSet(PublicDataConf.centerSetConf);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeConnService() {
        boolean flag = false;
        if (PublicDataConf.webSocketProxy != null) {
            if (PublicDataConf.webSocketProxy.isOpen()) {
                WebSocketProxy webSocketProxy = PublicDataConf.webSocketProxy;
                synchronized (webSocketProxy) {
                    PublicDataConf.webSocketProxy.close();
                    try {
                        PublicDataConf.webSocketProxy.closeBlocking();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    PublicDataConf.webSocketProxy.closeConnection(1000, "\u624b\u52a8\u5173\u95ed");
                    PublicDataConf.webSocketProxy = null;
                }
                this.threadComponent.closeAll();
                PublicDataConf.init_connect();
                if (null == PublicDataConf.webSocketProxy || !PublicDataConf.webSocketProxy.isOpen()) {
                    flag = true;
                }
            } else {
                flag = true;
            }
        }
        return flag;
    }

    @Autowired
    public void setSetService(SetService setService) {
        this.setService = setService;
    }

    @Autowired
    public void setThreadComponent(ThreadComponent threadComponent) {
        this.threadComponent = threadComponent;
    }
}

