/*
 * Decompiled with CFR 0.152.
 */
package xyz.acproject.danmuji.service;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;
import xyz.acproject.danmuji.conf.CenterSetConf;
import xyz.acproject.danmuji.conf.PublicDataConf;
import xyz.acproject.danmuji.conf.set.AdvertSetConf;
import xyz.acproject.danmuji.conf.set.AutoReplySetConf;
import xyz.acproject.danmuji.conf.set.AutoSendGiftConf;
import xyz.acproject.danmuji.conf.set.BlackListSetConf;
import xyz.acproject.danmuji.conf.set.ClockInSetConf;
import xyz.acproject.danmuji.conf.set.PrivacySetConf;
import xyz.acproject.danmuji.conf.set.ThankFollowSetConf;
import xyz.acproject.danmuji.conf.set.ThankGiftSetConf;
import xyz.acproject.danmuji.conf.set.ThankWelcomeSetConf;
import xyz.acproject.danmuji.entity.user_data.UserCookie;
import xyz.acproject.danmuji.http.HttpUserData;
import xyz.acproject.danmuji.service.impl.SetServiceImpl;
import xyz.acproject.danmuji.tools.BASE64Encoder;
import xyz.acproject.danmuji.tools.RequestHeaderTools;
import xyz.acproject.danmuji.tools.file.ProFileTools;

@Service
public class DanmujiInitService {
    private static final Logger LOGGER = LogManager.getLogger(DanmujiInitService.class);
    private final SetServiceImpl checkService;

    public void init() {
        ConcurrentHashMap<String, String> profileMap = new ConcurrentHashMap<String, String>();
        String cookieString = null;
        BASE64Encoder base64Encoder = new BASE64Encoder();
        try {
            profileMap.putAll(ProFileTools.read((String)"DanmujiProfile"));
            cookieString = !StringUtils.isEmpty((CharSequence)((CharSequence)profileMap.get("ySZL4SBB"))) ? new String(base64Encoder.decode((String)profileMap.get("ySZL4SBB"))) : null;
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u672c\u5730cookie\u5931\u8d25,\u8bf7\u91cd\u65b0\u767b\u5f55" + e);
        }
        if (StringUtils.isNotBlank((CharSequence)cookieString) && StringUtils.isBlank((CharSequence)PublicDataConf.USERCOOKIE)) {
            PublicDataConf.USERCOOKIE = cookieString;
        }
        HttpUserData.httpGetUserInfo();
        if (PublicDataConf.USER == null) {
            PublicDataConf.USERCOOKIE = null;
        } else if (StringUtils.isNotBlank((CharSequence)PublicDataConf.USERCOOKIE)) {
            PublicDataConf.COOKIE = HttpUserData.httpBuvid34((UserCookie)new UserCookie().parse(PublicDataConf.USERCOOKIE));
            PublicDataConf.USERCOOKIE = PublicDataConf.COOKIE.getCookie();
            profileMap.put("ySZL4SBB", base64Encoder.encode(PublicDataConf.USERCOOKIE.getBytes()));
        }
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)profileMap.get("set")))) {
            PublicDataConf.centerSetConf = CenterSetConf.of((String)((String)profileMap.get("set")));
            if (PublicDataConf.centerSetConf.getRoomid() != null && PublicDataConf.centerSetConf.getRoomid() > 0L) {
                PublicDataConf.ROOMID_LONG = PublicDataConf.centerSetConf.getRoomid();
            } else if (PublicDataConf.ROOMID_LONG != null && PublicDataConf.ROOMID_LONG > 0L) {
                PublicDataConf.centerSetConf.setRoomid(PublicDataConf.ROOMID_LONG);
            }
            if (PublicDataConf.centerSetConf.getAdvert() == null) {
                PublicDataConf.centerSetConf.setAdvert(new AdvertSetConf());
            }
            if (PublicDataConf.centerSetConf.getFollow() == null) {
                PublicDataConf.centerSetConf.setFollow(new ThankFollowSetConf());
            }
            if (PublicDataConf.centerSetConf.getThank_gift() == null) {
                PublicDataConf.centerSetConf.setThank_gift(new ThankGiftSetConf());
            }
            if (PublicDataConf.centerSetConf.getReply() == null) {
                PublicDataConf.centerSetConf.setReply(new AutoReplySetConf());
            }
            if (PublicDataConf.centerSetConf.getClock_in() == null) {
                PublicDataConf.centerSetConf.setClock_in(new ClockInSetConf(false, "\u7b7e\u5230"));
            }
            if (PublicDataConf.centerSetConf.getWelcome() == null) {
                PublicDataConf.centerSetConf.setWelcome(new ThankWelcomeSetConf());
            }
            if (PublicDataConf.centerSetConf.getAuto_gift() == null) {
                PublicDataConf.centerSetConf.setAuto_gift(new AutoSendGiftConf());
            }
            if (PublicDataConf.centerSetConf.getPrivacy() == null) {
                PublicDataConf.centerSetConf.setPrivacy(new PrivacySetConf());
            }
            if (PublicDataConf.centerSetConf.getBlack() == null) {
                PublicDataConf.centerSetConf.setBlack(new BlackListSetConf());
            }
        } else {
            PublicDataConf.centerSetConf = new CenterSetConf(new ThankGiftSetConf(), new AdvertSetConf(), new ThankFollowSetConf(), new AutoReplySetConf(), new ClockInSetConf(), new ThankWelcomeSetConf(), new AutoSendGiftConf(), new PrivacySetConf(), new BlackListSetConf());
        }
        profileMap.put("set", base64Encoder.encode(PublicDataConf.centerSetConf.toJson().getBytes()));
        ProFileTools.write(profileMap, (String)"DanmujiProfile");
        try {
            PublicDataConf.centerSetConf = CenterSetConf.of((String)((String)profileMap.get("set")));
            LOGGER.info("\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6\u6210\u529f");
        }
        catch (Exception e) {
            LOGGER.error("\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6\u5931\u8d25" + e);
        }
        if (StringUtils.isNotEmpty((CharSequence)PublicDataConf.USERCOOKIE) && PublicDataConf.COOKIE == null) {
            int controlNum = 0;
            String cookies = PublicDataConf.USERCOOKIE;
            PublicDataConf.COOKIE = new UserCookie();
            Map cookieKeyValue = RequestHeaderTools.parseCookies((String)cookies);
            if (cookieKeyValue.containsKey("DedeUserID")) {
                PublicDataConf.COOKIE.setDedeUserID((String)cookieKeyValue.get("DedeUserID"));
                ++controlNum;
            }
            if (cookieKeyValue.containsKey("bili_jct")) {
                PublicDataConf.COOKIE.setBili_jct((String)cookieKeyValue.get("bili_jct"));
                ++controlNum;
            }
            if (cookieKeyValue.containsKey("DedeUserID__ckMd5")) {
                PublicDataConf.COOKIE.setDedeUserID__ckMd5((String)cookieKeyValue.get("DedeUserID__ckMd5"));
                ++controlNum;
            }
            if (cookieKeyValue.containsKey("sid")) {
                PublicDataConf.COOKIE.setSid((String)cookieKeyValue.get("sid"));
                ++controlNum;
            }
            if (cookieKeyValue.containsKey("SESSDATA")) {
                PublicDataConf.COOKIE.setSESSDATA((String)cookieKeyValue.get("SESSDATA"));
                ++controlNum;
            }
            if (controlNum >= 2) {
                LOGGER.info("\u7528\u6237cookie\u88c5\u8f7d\u6210\u529f");
            } else {
                LOGGER.info("\u7528\u6237cookie\u88c5\u8f7d\u5931\u8d25");
                PublicDataConf.COOKIE = null;
            }
            this.checkService.holdSet(PublicDataConf.centerSetConf);
        }
    }

    public DanmujiInitService(SetServiceImpl checkService) {
        this.checkService = checkService;
    }
}

