/*
 * Decompiled with CFR 0.152.
 */
package xyz.acproject.danmuji.http;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.CollectionUtils;
import xyz.acproject.danmuji.conf.PublicDataConf;
import xyz.acproject.danmuji.entity.room_data.CheckTx;
import xyz.acproject.danmuji.entity.room_data.LotteryInfoWeb;
import xyz.acproject.danmuji.entity.room_data.MedalInfoAnchor;
import xyz.acproject.danmuji.entity.room_data.Room;
import xyz.acproject.danmuji.entity.room_data.RoomBlock;
import xyz.acproject.danmuji.entity.room_data.RoomInfo;
import xyz.acproject.danmuji.entity.room_data.RoomInfoAnchor;
import xyz.acproject.danmuji.entity.room_data.RoomInit;
import xyz.acproject.danmuji.entity.server_data.Conf;
import xyz.acproject.danmuji.entity.user_data.UserNav;
import xyz.acproject.danmuji.entity.view.RoomGift;
import xyz.acproject.danmuji.tools.CurrencyTools;
import xyz.acproject.danmuji.utils.JodaTimeUtils;
import xyz.acproject.danmuji.utils.OkHttp3Utils;
import xyz.acproject.danmuji.utils.WbiSignUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class HttpRoomData {
    private static Logger LOGGER = LogManager.getLogger(HttpRoomData.class);

    public static Conf httpGetConf() {
        String data = null;
        JSONObject jsonObject = null;
        Conf conf = null;
        int code = -1;
        HashMap<String, String> headers = null;
        HashMap<String, String> datas = null;
        headers = new HashMap<String, String>(3);
        headers.put("referer", "https://live.bilibili.com/" + CurrencyTools.parseRoomId());
        headers.put("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Safari/537.36");
        if (StringUtils.isNotBlank((CharSequence)PublicDataConf.USERCOOKIE)) {
            headers.put("cookie", PublicDataConf.USERCOOKIE);
        }
        datas = new HashMap<String, String>(3);
        datas.put("id", PublicDataConf.ROOMID.toString());
        datas.put("type", "0");
        try {
            data = OkHttp3Utils.getHttp3Utils().httpGet("https://api.live.bilibili.com/xlive/web-room/v1/index/getDanmuInfo", headers, datas).body().string();
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            data = null;
        }
        if (data == null) {
            return null;
        }
        jsonObject = JSONObject.parseObject((String)data);
        code = jsonObject.getShort("code").shortValue();
        if (code == 0) {
            conf = (Conf)jsonObject.getObject("data", Conf.class);
        } else {
            LOGGER.error("\u672a\u77e5\u9519\u8bef,\u539f\u56e0:" + jsonObject.getString("message"));
        }
        return conf;
    }

    public static Conf httpGetConf(UserNav userNav) {
        String data = null;
        JSONObject jsonObject = null;
        Conf conf = null;
        int code = -1;
        HashMap<String, String> headers = null;
        HashMap<String, String> datas = null;
        headers = new HashMap<String, String>(3);
        headers.put("referer", "https://live.bilibili.com/" + CurrencyTools.parseRoomId());
        headers.put("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Safari/537.36");
        if (StringUtils.isNotBlank((CharSequence)PublicDataConf.USERCOOKIE)) {
            headers.put("cookie", PublicDataConf.USERCOOKIE);
        }
        Long nowTimeStamp = JodaTimeUtils.getTimestamp();
        datas = new HashMap<String, String>(5);
        datas.put("id", PublicDataConf.ROOMID.toString());
        datas.put("type", "0");
        datas.put("wts", nowTimeStamp.toString());
        datas.put("web_location", "444.8");
        String wbiSign = WbiSignUtils.getWbiSign(datas, (String)userNav.getWbiImg().getImgUrl().substring(userNav.getWbiImg().getImgUrl().lastIndexOf(47) + 1, userNav.getWbiImg().getImgUrl().lastIndexOf(46)), (String)userNav.getWbiImg().getSubUrl().substring(userNav.getWbiImg().getSubUrl().lastIndexOf(47) + 1, userNav.getWbiImg().getSubUrl().lastIndexOf(46)));
        try {
            datas.put("w_rid", wbiSign);
            data = OkHttp3Utils.getHttp3Utils().httpGet("https://api.live.bilibili.com/xlive/web-room/v1/index/getDanmuInfo", headers, datas).body().string();
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            data = null;
        }
        if (data == null) {
            return null;
        }
        jsonObject = JSONObject.parseObject(data);
        code = jsonObject.getShort("code").shortValue();
        if (code == 0) {
            conf = (Conf)jsonObject.getObject("data", Conf.class);
        } else {
            LOGGER.error("\u672a\u77e5\u9519\u8bef,\u539f\u56e0:" + jsonObject.getString("message"));
        }
        return conf;
    }

    public static Room httpGetRoomData(long roomid) {
        String data = null;
        JSONObject jsonObject = null;
        Room room = null;
        int code = -1;
        HashMap<String, String> headers = null;
        headers = new HashMap<String, String>(3);
        headers.put("referer", "https://live.bilibili.com/" + CurrencyTools.parseRoomId());
        headers.put("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Safari/537.36");
        try {
            data = OkHttp3Utils.getHttp3Utils().httpGet("https://api.live.bilibili.com/room_ex/v1/RoomNews/get?roomid=" + roomid, headers, null).body().string();
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            data = null;
        }
        if (data == null) {
            return room;
        }
        jsonObject = JSONObject.parseObject(data);
        code = jsonObject.getShort("code").shortValue();
        if (code == 0) {
            room = (Room)jsonObject.getObject("data", Room.class);
        } else {
            LOGGER.error("\u76f4\u64ad\u623f\u95f4\u53f7\u4e0d\u5b58\u5728\uff0c\u6216\u8005\u672a\u77e5\u9519\u8bef\uff0c\u8bf7\u5c1d\u8bd5\u66f4\u6362\u623f\u95f4\u53f7,\u539f\u56e0:" + jsonObject.getString("message"));
        }
        return room;
    }

    public static RoomInit httpGetRoomInit(long roomid) {
        String data = null;
        RoomInit roomInit = null;
        JSONObject jsonObject = null;
        int code = -1;
        HashMap<String, String> headers = null;
        headers = new HashMap<String, String>(2);
        headers.put("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Safari/537.36");
        try {
            data = OkHttp3Utils.getHttp3Utils().httpGet("https://api.live.bilibili.com/room/v1/Room/room_init?id=" + roomid, headers, null).body().string();
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            data = null;
        }
        if (data == null) {
            return roomInit;
        }
        jsonObject = JSONObject.parseObject(data);
        code = jsonObject.getShort("code").shortValue();
        if (code == 0) {
            roomInit = (RoomInit)jsonObject.getObject("data", RoomInit.class);
        } else {
            LOGGER.error("\u76f4\u64ad\u623f\u95f4\u53f7\u4e0d\u5b58\u5728\uff0c\u6216\u8005\u672a\u77e5\u9519\u8bef\uff0c\u8bf7\u5c1d\u8bd5\u66f4\u6362\u623f\u95f4\u53f7,\u539f\u56e0:" + jsonObject.getString("message"));
        }
        return roomInit;
    }

    public static RoomInfoAnchor httpGetRoomInfo() {
        String data = null;
        JSONObject jsonObject = null;
        RoomInfoAnchor roomInfoAnchor = new RoomInfoAnchor();
        MedalInfoAnchor medalInfoAnchor = null;
        RoomInfo roomInfo = null;
        int code = -1;
        HashMap<String, String> headers = null;
        headers = new HashMap<String, String>(3);
        headers.put("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Safari/537.36");
        headers.put("referer", "https://live.bilibili.com/" + CurrencyTools.parseRoomId());
        if (StringUtils.isNotBlank((CharSequence)PublicDataConf.USERCOOKIE)) {
            headers.put("cookie", PublicDataConf.USERCOOKIE);
        }
        try {
            data = OkHttp3Utils.getHttp3Utils().httpGet("https://api.live.bilibili.com/xlive/web-room/v1/index/getInfoByRoom?room_id=" + CurrencyTools.parseRoomId(), headers, null).body().string();
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            data = null;
        }
        if (data == null) {
            return roomInfoAnchor;
        }
        jsonObject = JSONObject.parseObject(data);
        code = jsonObject.getShort("code").shortValue();
        if (code == 0) {
            roomInfo = (RoomInfo)JSON.parseObject((String)((JSONObject)jsonObject.get((Object)"data")).getString("room_info"), RoomInfo.class);
            medalInfoAnchor = (MedalInfoAnchor)JSON.parseObject((String)jsonObject.getJSONObject("data").getJSONObject("anchor_info").getString("medal_info"), MedalInfoAnchor.class);
        } else {
            LOGGER.error("\u83b7\u53d6\u623f\u95f4\u8be6\u7ec6\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u5c1d\u8bd5:" + jsonObject.getString("message"));
        }
        roomInfoAnchor.setRoomInfo(roomInfo);
        roomInfoAnchor.setMedalInfoAnchor(medalInfoAnchor);
        return roomInfoAnchor;
    }

    public static ConcurrentHashMap<Long, String> httpGetFollowers() {
        String data = null;
        JSONObject jsonObject = null;
        Integer page = null;
        JSONArray jsonArray = null;
        int code = -1;
        ConcurrentHashMap<Long, String> followConcurrentHashMap = null;
        HashMap<String, String> headers = null;
        HashMap<String, String> datas = null;
        if (PublicDataConf.AUID == null) {
            return null;
        }
        page = PublicDataConf.FANSNUM.equals(null) || PublicDataConf.FANSNUM.equals(0L) ? Integer.valueOf(1) : Integer.valueOf((page = Integer.valueOf((int)Math.ceil((float)PublicDataConf.FANSNUM.longValue() / 20.0f))) > 5 ? 5 : page);
        followConcurrentHashMap = new ConcurrentHashMap<Long, String>();
        while (page > 0) {
            headers = new HashMap<String, String>(3);
            headers.put("referer", "https://space.bilibili.com/{" + PublicDataConf.AUID + "}/");
            headers.put("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Safari/537.36");
            datas = new HashMap<String, String>(6);
            datas.put("vmid", PublicDataConf.AUID.toString());
            datas.put("pn", String.valueOf(page));
            datas.put("ps", "50");
            datas.put("order", "desc");
            datas.put("jsonp", "jsonp");
            try {
                data = OkHttp3Utils.getHttp3Utils().httpGet("https://api.bilibili.com/x/relation/followers", headers, datas).body().string();
            }
            catch (Exception e) {
                LOGGER.error((Object)e);
                data = null;
            }
            if (data == null) {
                return null;
            }
            jsonObject = JSONObject.parseObject((String)data);
            try {
                code = jsonObject.getShort("code").shortValue();
            }
            catch (Exception e) {
                LOGGER.error("\u83b7\u53d6\u5173\u6ce8\u9519\u8bef");
                return followConcurrentHashMap;
            }
            if (code == 0) {
                PublicDataConf.FANSNUM = ((JSONObject)jsonObject.get((Object)"data")).getLong("total");
                jsonArray = ((JSONObject)jsonObject.get((Object)"data")).getJSONArray("list");
                for (Object object : jsonArray) {
                    followConcurrentHashMap.put(((JSONObject)object).getLong("mid"), ((JSONObject)object).getString("uname"));
                }
            } else {
                LOGGER.error("\u83b7\u53d6\u5173\u6ce8\u6570\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5" + jsonObject.getString("message"));
            }
            Integer n = page;
            page = page - 1;
        }
        return followConcurrentHashMap;
    }

    public static Long httpGetFollowersNum() {
        String data = null;
        JSONObject jsonObject = null;
        int code = -1;
        HashMap<String, String> headers = null;
        HashMap<String, String> datas = null;
        Long followersNum = 0L;
        if (PublicDataConf.AUID == null) {
            return followersNum;
        }
        headers = new HashMap<String, String>(3);
        headers.put("referer", "https://space.bilibili.com/{" + PublicDataConf.AUID + "}/");
        headers.put("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Safari/537.36");
        datas = new HashMap<String, String>(2);
        datas.put("vmid", PublicDataConf.AUID.toString());
        try {
            data = OkHttp3Utils.getHttp3Utils().httpGet("https://api.bilibili.com/x/relation/stat", headers, datas).body().string();
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            data = null;
        }
        if (data == null) {
            return followersNum;
        }
        jsonObject = JSONObject.parseObject((String)data);
        code = jsonObject.getShort("code").shortValue();
        if (code == 0) {
            followersNum = ((JSONObject)jsonObject.get((Object)"data")).getLong("follower");
        } else {
            LOGGER.error("\u83b7\u53d6\u5173\u6ce8\u6570\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5" + jsonObject.getString("message"));
        }
        return followersNum;
    }

    public static Map<Long, String> httpGetGuardList() {
        String data = null;
        ConcurrentHashMap<Long, String> guardMap = new ConcurrentHashMap<Long, String>();
        JSONObject jsonObject = null;
        JSONArray jsonArray = null;
        HashMap<String, String> headers = null;
        HashMap<String, String> datas = null;
        int code = -1;
        int totalSize = HttpRoomData.httpGetGuardListTotalSize();
        int page = 0;
        if (totalSize == 0) {
            return null;
        }
        page = (int)Math.ceil((float)totalSize / 29.0f);
        if (page == 0) {
            page = 1;
        }
        for (int i = 1; i <= page; ++i) {
            headers = new HashMap<String, String>(3);
            headers.put("referer", "https://live.bilibili.com/" + CurrencyTools.parseRoomId());
            headers.put("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Safari/537.36");
            datas = new HashMap<String, String>(4);
            datas.put("roomid", PublicDataConf.ROOMID.toString());
            datas.put("page", String.valueOf(i));
            datas.put("ruid", PublicDataConf.AUID.toString());
            datas.put("page_size", "29");
            try {
                data = OkHttp3Utils.getHttp3Utils().httpGet("https://api.live.bilibili.com/xlive/app-room/v1/guardTab/topList", headers, datas).body().string();
            }
            catch (Exception e) {
                LOGGER.error((Object)e);
                data = null;
            }
            if (data == null) {
                return null;
            }
            jsonObject = JSONObject.parseObject((String)data);
            code = jsonObject.getShort("code").shortValue();
            if (code == 0) {
                jsonArray = ((JSONObject)jsonObject.get((Object)"data")).getJSONArray("list");
                for (Object object : jsonArray) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    guardMap.put(((JSONObject)object).getLong("uid"), ((JSONObject)object).getString("username"));
                }
                if (i != 1) continue;
                jsonArray = ((JSONObject)jsonObject.get((Object)"data")).getJSONArray("top3");
                for (Object object : jsonArray) {
                    guardMap.put(((JSONObject)object).getLong("uid"), ((JSONObject)object).getString("username"));
                }
                continue;
            }
            LOGGER.error("\u76f4\u64ad\u623f\u95f4\u53f7\u4e0d\u5b58\u5728\uff0c\u6216\u8005\u672a\u77e5\u9519\u8bef\uff0c\u8bf7\u5c1d\u8bd5\u66f4\u6362\u623f\u95f4\u53f7,\u539f\u56e0:" + jsonObject.getString("message"));
        }
        return guardMap;
    }

    public static int httpGetGuardListTotalSize() {
        String data = null;
        HashMap<String, String> headers = null;
        HashMap<String, String> datas = null;
        int num = 0;
        JSONObject jsonObject = null;
        int code = -1;
        headers = new HashMap<String, String>(3);
        headers.put("referer", "https://live.bilibili.com/" + CurrencyTools.parseRoomId());
        headers.put("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Safari/537.36");
        datas = new HashMap<String, String>(5);
        datas.put("roomid", PublicDataConf.ROOMID.toString());
        datas.put("page", String.valueOf(1));
        datas.put("ruid", PublicDataConf.AUID.toString());
        datas.put("page_size", "29");
        try {
            data = OkHttp3Utils.getHttp3Utils().httpGet("https://api.live.bilibili.com/xlive/app-room/v1/guardTab/topList", headers, datas).body().string();
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            data = null;
        }
        if (data == null) {
            return num;
        }
        jsonObject = JSONObject.parseObject((String)data);
        code = jsonObject.getShort("code").shortValue();
        if (code == 0) {
            num = ((JSONObject)((JSONObject)jsonObject.get((Object)"data")).get((Object)"info")).getInteger("num");
        } else {
            LOGGER.error("\u76f4\u64ad\u623f\u95f4\u53f7\u4e0d\u5b58\u5728\uff0c\u6216\u8005\u672a\u77e5\u9519\u8bef\uff0c\u8bf7\u5c1d\u8bd5\u66f4\u6362\u623f\u95f4\u53f7,\u539f\u56e0:" + jsonObject.getString("message"));
        }
        return num;
    }

    public static CheckTx httpGetCheckTX() {
        String data = null;
        JSONObject jsonObject = null;
        int code = -1;
        HashMap<String, String> headers = null;
        headers = new HashMap<String, String>(3);
        headers.put("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Safari/537.36");
        headers.put("referer", "https://live.bilibili.com/" + CurrencyTools.parseRoomId());
        try {
            data = OkHttp3Utils.getHttp3Utils().httpGet("https://api.live.bilibili.com/xlive/lottery-interface/v1/Anchor/Check?roomid=" + CurrencyTools.parseRoomId(), headers, null).body().string();
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            data = null;
        }
        if (data == null) {
            return null;
        }
        jsonObject = JSONObject.parseObject(data);
        code = jsonObject.getShort("code").shortValue();
        if (code == 0) {
            if (jsonObject.get((Object)"data") != null) {
                return new CheckTx(((JSONObject)jsonObject.get((Object)"data")).getLong("room_id"), ((JSONObject)jsonObject.get((Object)"data")).getString("gift_name"), ((JSONObject)jsonObject.get((Object)"data")).getShort("time"));
            }
        } else {
            LOGGER.error("\u68c0\u67e5\u5929\u9009\u793c\u7269\u5931\u8d25,\u539f\u56e0:" + jsonObject.getString("message"));
        }
        return null;
    }

    public static LotteryInfoWeb httpGetLotteryInfoWeb() {
        String data = null;
        JSONObject jsonObject = null;
        int code = -1;
        HashMap<String, String> headers = null;
        headers = new HashMap<String, String>(3);
        headers.put("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Safari/537.36");
        headers.put("referer", "https://live.bilibili.com/" + CurrencyTools.parseRoomId());
        if (StringUtils.isNotBlank((CharSequence)PublicDataConf.USERCOOKIE)) {
            headers.put("cookie", PublicDataConf.USERCOOKIE);
        }
        try {
            data = OkHttp3Utils.getHttp3Utils().httpGet("https://api.live.bilibili.com/xlive/lottery-interface/v1/lottery/getLotteryInfoWeb?roomid=" + PublicDataConf.ROOMID, headers, null).body().string();
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            data = null;
        }
        if (data == null) {
            return null;
        }
        jsonObject = JSONObject.parseObject(data);
        code = jsonObject.getShort("code").shortValue();
        if (code == 0) {
            if (jsonObject.get((Object)"data") != null) {
                LotteryInfoWeb lotteryInfoWeb = (LotteryInfoWeb)jsonObject.getJSONObject("data").toJavaObject(LotteryInfoWeb.class);
                return lotteryInfoWeb;
            }
        } else {
            LOGGER.error("\u83b7\u53d6\u623f\u95f4\u62bd\u5956\u5931\u8d25,\u539f\u56e0:" + jsonObject.getString("message"));
        }
        return null;
    }

    public static Map<Integer, RoomGift> httpGetRoomGifts(Long roomid) {
        String data = null;
        JSONObject jsonObject = null;
        JSONArray jsonArray = null;
        int code = -1;
        HashMap<Integer, RoomGift> giftMaps = new HashMap<Integer, RoomGift>();
        HashMap<String, String> headers = null;
        headers = new HashMap<String, String>(3);
        headers.put("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Safari/537.36");
        headers.put("referer", "https://live.bilibili.com/" + roomid);
        try {
            data = OkHttp3Utils.getHttp3Utils().httpGet("https://api.live.bilibili.com/xlive/web-room/v1/giftPanel/giftConfig?platform=pc&room_id=" + roomid, headers, null).body().string();
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            data = null;
        }
        if (data == null) {
            return giftMaps;
        }
        jsonObject = JSONObject.parseObject(data);
        code = jsonObject.getShort("code").shortValue();
        if (code == 0) {
            jsonArray = ((JSONObject)jsonObject.get((Object)"data")).getJSONArray("list");
            for (Object object : jsonArray) {
                RoomGift roomGift = (RoomGift)JSONObject.parseObject((String)((JSONObject)object).toJSONString(), RoomGift.class);
                giftMaps.put(roomGift.getId(), roomGift);
            }
        } else {
            LOGGER.error("\u83b7\u53d6\u793c\u7269\u5931\u8d25,\u539f\u56e0:" + jsonObject.getString("message"));
        }
        return giftMaps;
    }

    public static List<RoomBlock> getBlockList(int page) {
        String data = null;
        JSONObject jsonObject = null;
        JSONArray jsonArray = null;
        ArrayList<Object> roomBlocks = new ArrayList<RoomBlock>();
        HashMap<String, String> headers = null;
        HashMap<String, String> datas = null;
        headers = new HashMap<String, String>(4);
        datas = new HashMap<String, String>(4);
        headers.put("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Safari/537.36");
        headers.put("referer", "https://live.bilibili.com/" + CurrencyTools.parseRoomId());
        if (StringUtils.isNotBlank((CharSequence)PublicDataConf.USERCOOKIE)) {
            headers.put("cookie", PublicDataConf.USERCOOKIE);
        }
        datas.put("roomid", String.valueOf(PublicDataConf.ROOMID));
        datas.put("page", String.valueOf(page));
        try {
            data = OkHttp3Utils.getHttp3Utils().httpGet("https://api.live.bilibili.com/liveact/ajaxGetBlockList", headers, datas).body().string();
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            data = null;
        }
        if (data == null) {
            return roomBlocks;
        }
        jsonObject = JSONObject.parseObject((String)data);
        short code = jsonObject.getShort("code");
        if (code == 0) {
            jsonArray = jsonObject.getJSONArray("data");
            if (!CollectionUtils.isEmpty((Collection)jsonArray)) {
                roomBlocks = new ArrayList(jsonArray.toJavaList(RoomBlock.class));
            }
            return roomBlocks;
        }
        return roomBlocks;
    }
}

