/*
 * Decompiled with CFR 0.152.
 */
package xyz.acproject.danmuji.http;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.CollectionUtils;
import xyz.acproject.danmuji.conf.PublicDataConf;
import xyz.acproject.danmuji.entity.Weather.Weather;
import xyz.acproject.danmuji.entity.Weather.WeatherV2;
import xyz.acproject.danmuji.entity.apex.ApexMessage;
import xyz.acproject.danmuji.entity.apex.PredatorResult;
import xyz.acproject.danmuji.entity.heart.XData;
import xyz.acproject.danmuji.utils.OkHttp3Utils;

public class HttpOtherData {
    private static Logger LOGGER = LogManager.getLogger(HttpOtherData.class);

    public static String httpGetNewEdition() {
        String data = null;
        JSONObject jsonObject = null;
        String edition = null;
        String code = "-1";
        HashMap<String, String> headers = null;
        HashMap<String, String> datas = null;
        headers = new HashMap<String, String>(2);
        headers.put("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Safari/537.36");
        datas = new HashMap<String, String>(4);
        datas.put("roomid", PublicDataConf.centerSetConf.getRoomid().toString());
        datas.put("edition", PublicDataConf.VERSION);
        datas.put("time", String.valueOf(System.currentTimeMillis()));
        try {
            data = OkHttp3Utils.getHttp3Utils().httpGet("http://bilibili.acproject.xyz/getEdition", headers, datas).body().string();
            if (data == null) {
                return edition;
            }
            jsonObject = JSONObject.parseObject((String)data);
            code = jsonObject.getString("code");
            if (code.equals("200")) {
                PublicDataConf.NEW_VERSION = edition = ((JSONObject)jsonObject.get((Object)"result")).getString("value");
            } else {
                LOGGER.error("\u672a\u77e5\u9519\u8bef,\u539f\u56e0:" + jsonObject.getString("msg"));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            edition = "\u83b7\u53d6\u516c\u544a\u5931\u8d25";
            LOGGER.error("\u8bf7\u6c42\u670d\u52a1\u5668\u8d85\u65f6\uff0c\u83b7\u53d6\u6700\u65b0\u7248\u672c\u5931\u8d25");
            data = null;
        }
        return edition;
    }

    public static String httpGetNewEditionV2ByGitHub() {
        String data = null;
        JSONObject jsonObject = null;
        String edition = null;
        HashMap<String, String> headers = null;
        Map datas = null;
        headers = new HashMap<String, String>(2);
        headers.put("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Safari/537.36");
        try {
            data = OkHttp3Utils.getHttp3Utils().httpGet("https://api.github.com/repos/BanqiJane/Bilibili_Danmuji/releases/latest", headers, datas).body().string();
            if (data == null) {
                return edition;
            }
            jsonObject = JSONObject.parseObject((String)data);
            edition = jsonObject.getString("tag_name");
            if (StringUtils.isNotBlank((CharSequence)edition)) {
                PublicDataConf.NEW_VERSION = edition;
                PublicDataConf.NEW_VERSION_DOWNLOAD_URL = jsonObject.getString("html_url");
            } else {
                LOGGER.error("\u672a\u77e5\u9519\u8bef,\u539f\u56e0:\u672a\u77e5");
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            edition = "\u83b7\u53d6\u516c\u544a\u5931\u8d25";
            LOGGER.error("\u8bf7\u6c42\u670d\u52a1\u5668\u8d85\u65f6\uff0c\u83b7\u53d6\u6700\u65b0\u7248\u672c\u5931\u8d25");
            data = null;
        }
        return edition;
    }

    public static String httpGetNewAnnounce() {
        String data = null;
        JSONObject jsonObject = null;
        String announce = null;
        String code = "-1";
        HashMap<String, String> headers = null;
        HashMap<String, String> datas = null;
        headers = new HashMap<String, String>(2);
        headers.put("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Safari/537.36");
        datas = new HashMap<String, String>(4);
        datas.put("roomid", PublicDataConf.centerSetConf.getRoomid().toString());
        datas.put("edition", PublicDataConf.VERSION);
        datas.put("time", String.valueOf(System.currentTimeMillis()));
        try {
            data = OkHttp3Utils.getHttp3Utils().httpGet("http://bilibili.acproject.xyz/getAnnounce", headers, datas).body().string();
            if (data == null) {
                return announce;
            }
            jsonObject = JSONObject.parseObject((String)data);
            code = jsonObject.getString("code");
            if (code.equals("200")) {
                announce = ((JSONObject)jsonObject.get((Object)"result")).getString("value");
            } else {
                LOGGER.error("\u672a\u77e5\u9519\u8bef,\u539f\u56e0:" + jsonObject.getString("msg"));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            announce = "\u83b7\u53d6\u6700\u65b0\u516c\u544a\u5931\u8d25";
            LOGGER.error("\u8bf7\u6c42\u670d\u52a1\u5668\u8d85\u65f6\uff0c\u83b7\u53d6\u6700\u65b0\u516c\u544a\u5931\u8d25");
            data = null;
        }
        return announce;
    }

    public static String httpGetNewAnnounceV2ByGitHub() {
        String data = null;
        Object jsonObject = null;
        String announce = null;
        String code = "-1";
        HashMap<String, String> headers = null;
        Object datas = null;
        headers = new HashMap<String, String>(2);
        headers.put("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Safari/537.36");
        try {
            data = OkHttp3Utils.getHttp3Utils().httpGet("https://cdn.jsdelivr.net/gh/BanqiJane/Bilibili_Danmuji@master/.annonce", headers, null).body().string();
            if (StringUtils.isNotBlank((CharSequence)data)) {
                data = data.replace("\n", "\r\n");
            }
            return data;
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            announce = "\u83b7\u53d6\u6700\u65b0\u516c\u544a\u5931\u8d25";
            LOGGER.error("\u8bf7\u6c42\u670d\u52a1\u5668\u8d85\u65f6\uff0c\u83b7\u53d6\u6700\u65b0\u516c\u544a\u5931\u8d25");
            data = null;
            return announce;
        }
    }

    public static Long httpGetClockInRecord() {
        String data = null;
        JSONObject jsonObject = null;
        Long uid = null;
        String code = "-1";
        HashMap<String, String> headers = null;
        HashMap<String, String> datas = null;
        headers = new HashMap<String, String>(2);
        headers.put("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Safari/537.36");
        datas = new HashMap<String, String>(4);
        datas.put("uid", PublicDataConf.USER.getUid().toString());
        datas.put("edition", PublicDataConf.VERSION);
        datas.put("time", String.valueOf(System.currentTimeMillis()));
        try {
            data = OkHttp3Utils.getHttp3Utils().httpGet("http://bilibili.acproject.xyz/getClockRecord", headers, datas).body().string();
            if (data == null) {
                return null;
            }
            jsonObject = JSONObject.parseObject((String)data);
            code = jsonObject.getString("code");
            if (code.equals("200")) {
                if (jsonObject.get((Object)"result") != null) {
                    uid = ((JSONObject)jsonObject.get((Object)"result")).getLong("uid");
                }
            } else {
                LOGGER.error("\u672a\u77e5\u9519\u8bef,\u539f\u56e0:" + jsonObject.getString("msg"));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            uid = null;
            LOGGER.error("\u8bf7\u6c42\u670d\u52a1\u5668\u8d85\u65f6\uff0c\u83b7\u53d6\u6700\u65b0\u6253\u5361\u8bb0\u5f55\u5931\u8d25");
            data = null;
        }
        return uid;
    }

    public static Long httpPOSTSetClockInRecord() {
        String data = null;
        JSONObject jsonObject = null;
        Long uid = null;
        String code = "-1";
        HashMap<String, String> headers = null;
        HashMap<String, String> datas = null;
        headers = new HashMap<String, String>(2);
        headers.put("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Safari/537.36");
        datas = new HashMap<String, String>(4);
        datas.put("uid", PublicDataConf.USER.getUid().toString());
        datas.put("edition", PublicDataConf.VERSION);
        datas.put("time", String.valueOf(System.currentTimeMillis()));
        try {
            data = OkHttp3Utils.getHttp3Utils().httpPostForm("http://bilibili.acproject.xyz/setClockRecord", headers, datas).body().string();
            if (data == null) {
                return null;
            }
            jsonObject = JSONObject.parseObject((String)data);
            code = jsonObject.getString("code");
            if (code.equals("200")) {
                if (jsonObject.get((Object)"result") != null) {
                    uid = ((JSONObject)jsonObject.get((Object)"result")).getLong("uid");
                }
            } else {
                LOGGER.error("\u672a\u77e5\u9519\u8bef,\u539f\u56e0:" + jsonObject.getString("msg"));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            uid = null;
            LOGGER.error("\u8bf7\u6c42\u670d\u52a1\u5668\u8d85\u65f6\uff0c\u83b7\u53d6\u6700\u65b0\u6253\u5361\u8bb0\u5f55\u5931\u8d25");
            data = null;
        }
        return uid;
    }

    @Deprecated
    public static String httpGetIp() {
        String data = null;
        JSONObject jsonObject = null;
        String status = null;
        String ip = null;
        HashMap<String, String> headers = null;
        headers = new HashMap<String, String>(2);
        headers.put("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Safari/537.36");
        try {
            data = OkHttp3Utils.getHttp3Utils().httpGet("http://ip-api.com/json/", headers, null).body().string();
            if (data == null) {
                return null;
            }
            jsonObject = JSONObject.parseObject((String)data);
            try {
                status = jsonObject.getString("status");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (StringUtils.isBlank((CharSequence)status)) {
                return "\u83b7\u53d6\u5931\u8d25:\u8bf7\u81ea\u884c\u83b7\u53d6\u672c\u673a\u5bf9\u516cIp\u5730\u5740";
            }
            if (status.equals("success")) {
                ip = jsonObject.getString("query");
            } else {
                LOGGER.error("\u83b7\u53d6ip\u5931\u8d25" + jsonObject.toString());
            }
        }
        catch (Exception e) {
            ip = "\u83b7\u53d6\u5931\u8d25:\u8bf7\u81ea\u884c\u83b7\u53d6\u672c\u673a\u5bf9\u516cIp\u5730\u5740";
            LOGGER.error((Object)e);
            LOGGER.error(ip);
            data = null;
        }
        return ip;
    }

    public static String httpGetIpV2() {
        String data = "";
        JSONObject jsonObject = null;
        String code = "-1";
        Object predatorResult = null;
        HashMap<String, String> headers = null;
        headers = new HashMap<String, String>(2);
        headers.put("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Safari/537.36");
        try {
            data = OkHttp3Utils.getHttp3Utils().httpGet("http://bilibili.acproject.xyz/ip", headers, null).body().string();
            if (data == null) {
                return "";
            }
            jsonObject = JSONObject.parseObject((String)data);
            code = jsonObject.getString("code");
            if (code.equals("200")) {
                data = jsonObject.getString("result");
            } else {
                LOGGER.error("ip\u83b7\u53d6\uff1a \u672a\u77e5\u9519\u8bef,\u539f\u56e0:" + jsonObject.getString("msg"));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            LOGGER.error("\u8bf7\u6c42\u670d\u52a1\u5668\u8d85\u65f6\uff0c\u83b7\u53d6ip\u5931\u8d25");
            data = "";
        }
        return data;
    }

    public static String httpPostEncsUrl() {
        String data = null;
        JSONObject jsonObject = null;
        String url = null;
        String code = "-1";
        HashMap<String, String> headers = null;
        HashMap<String, String> datas = null;
        headers = new HashMap<String, String>(2);
        headers.put("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Safari/537.36");
        datas = new HashMap<String, String>(4);
        datas.put("roomid", PublicDataConf.centerSetConf.getRoomid().toString());
        datas.put("edition", PublicDataConf.VERSION);
        datas.put("time", String.valueOf(System.currentTimeMillis()));
        try {
            data = OkHttp3Utils.getHttp3Utils().httpPostForm("http://bilibili.acproject.xyz/getEncsServer", headers, datas).body().string();
            if (data == null) {
                return url;
            }
            jsonObject = JSONObject.parseObject((String)data);
            code = jsonObject.getString("code");
            if (code.equals("200")) {
                PublicDataConf.SMALLHEART_ADRESS = url = jsonObject.getString("result");
            } else {
                LOGGER.error("\u672a\u77e5\u9519\u8bef,\u539f\u56e0:" + jsonObject.getString("msg"));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            url = null;
            LOGGER.error("\u8bf7\u6c42\u670d\u52a1\u5668\u8d85\u65f6\uff0c\u83b7\u53d6\u670d\u52a1\u5668\u94fe\u63a5\u5931\u8d25");
            data = null;
        }
        return url;
    }

    public static String httpPostencS(XData xData, long ts) {
        String data = null;
        JSONObject jsonObject = null;
        String s = null;
        String url = PublicDataConf.SMALLHEART_ADRESS;
        if (StringUtils.isBlank((CharSequence)url)) {
            return null;
        }
        HashMap<String, String> headers = null;
        headers = new HashMap<String, String>(2);
        headers.put("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Safari/537.36");
        JSONObject t = new JSONObject();
        t.put("id", (Object)xData.getId());
        t.put("device", (Object)xData.getDevice());
        t.put("ets", (Object)xData.getEts());
        t.put("benchmark", (Object)xData.getBenchmark());
        t.put("time", (Object)xData.getTime());
        t.put("ts", (Object)ts);
        t.put("ua", (Object)xData.getUa());
        JSONObject json = new JSONObject();
        json.put("t", (Object)t);
        json.put("r", (Object)xData.getSecret_rule());
        if (StringUtils.isBlank((CharSequence)url)) {
            return null;
        }
        try {
            data = OkHttp3Utils.getHttp3Utils().httpPostJson(url, headers, json.toJSONString()).body().string();
            if (data == null) {
                return null;
            }
            jsonObject = JSONObject.parseObject((String)data);
            try {
                s = jsonObject.getString("s");
            }
            catch (Exception e) {
                LOGGER.error("\u52a0\u5bc6s\u9519\u8bef");
                s = null;
            }
        }
        catch (Exception e) {
            LOGGER.error("\u8fde\u63a5\u81f3\u52a0\u5bc6\u670d\u52a1\u5668\u9519\u8bef\uff1f\u4e0d\u5b58\u5728");
            data = null;
            s = null;
        }
        return s;
    }

    @Deprecated
    public static Weather httpPostWeather(String city, Short day) {
        String data = null;
        JSONObject jsonObject = null;
        String code = "-1";
        Weather weather = null;
        HashMap<String, String> headers = null;
        HashMap<String, String> datas = null;
        headers = new HashMap<String, String>(2);
        headers.put("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Safari/537.36");
        datas = new HashMap<String, String>(3);
        datas.put("city", city);
        datas.put("day", day.toString());
        try {
            data = OkHttp3Utils.getHttp3Utils().httpPostForm("http://bilibili.acproject.xyz/getWeather", headers, datas).body().string();
            if (data == null) {
                return null;
            }
            jsonObject = JSONObject.parseObject((String)data);
            code = jsonObject.getString("code");
            if (code.equals("200")) {
                weather = (Weather)JSONObject.parseObject((String)jsonObject.getString("result"), Weather.class);
            } else {
                LOGGER.error("\u672a\u77e5\u9519\u8bef,\u539f\u56e0:" + jsonObject.getString("msg"));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            LOGGER.error("\u8bf7\u6c42\u670d\u52a1\u5668\u8d85\u65f6\uff0c\u83b7\u53d6\u670d\u52a1\u5668\u94fe\u63a5\u5931\u8d25");
            data = null;
        }
        return weather;
    }

    @Deprecated
    public static Map<String, List<Weather>> httpGetweather(String city) {
        String data = null;
        JSONObject jsonObject = null;
        int code = -1;
        HashMap<String, String> headers = null;
        headers = new HashMap<String, String>(2);
        HashMap<String, List> weathers = null;
        String cname = null;
        String ganmao = null;
        String wendu = null;
        headers.put("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Safari/537.36");
        try {
            data = OkHttp3Utils.getHttp3Utils().httpGet("http://wthrcdn.etouch.cn/weather_mini?city=" + city, headers, null).body().string();
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            LOGGER.error("\u8bf7\u6c42\u670d\u52a1\u5668\u8d85\u65f6\uff0c\u83b7\u53d6\u5929\u6c14\u5931\u8d25");
            data = null;
        }
        if (data == null) {
            return null;
        }
        try {
            jsonObject = JSONObject.parseObject((String)data);
            code = jsonObject.getShort("status").shortValue();
            if (code == 1000) {
                weathers = new HashMap<String, List>();
                cname = ((JSONObject)jsonObject.get((Object)"data")).getString("city");
                ganmao = ((JSONObject)jsonObject.get((Object)"data")).getString("ganmao");
                wendu = ((JSONObject)jsonObject.get((Object)"data")).getString("wendu");
                ArrayList<Weather> oldWeathers = new ArrayList<Weather>();
                Weather oldWeather = (Weather)JSONObject.parseObject((String)((JSONObject)jsonObject.get((Object)"data")).getString("yesterday"), Weather.class);
                oldWeather.setCity(cname);
                oldWeather.setGanmao(ganmao);
                oldWeather.setWendu(wendu);
                oldWeathers.add(oldWeather);
                weathers.put("old", oldWeathers);
                List newWeathers = JSONArray.parseArray((String)((JSONObject)jsonObject.get((Object)"data")).getString("forecast"), Weather.class);
                weathers.put("new", newWeathers);
                for (Weather weather : newWeathers) {
                    weather.setWendu(wendu);
                    weather.setGanmao(ganmao);
                    weather.setCity(cname);
                }
            } else {
                LOGGER.error("\u672a\u77e5\u9519\u8bef,\u539f\u56e0:" + jsonObject.getString("desc"));
            }
        }
        catch (Exception e) {
            weathers = null;
        }
        return weathers;
    }

    public static Map<String, WeatherV2> httpGetWeatherV2(String city) {
        String data = null;
        JSONObject jsonObject = null;
        String code = "-200";
        HashMap<String, String> headers = null;
        HashMap<String, String> datas = null;
        headers = new HashMap<String, String>(2);
        datas = new HashMap<String, String>(5);
        HashMap<String, WeatherV2> weathers = null;
        headers.put("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Safari/537.36");
        try {
            datas.put("edition", PublicDataConf.VERSION);
            datas.put("time", String.valueOf(System.currentTimeMillis()));
            datas.put("city", city);
            data = OkHttp3Utils.getHttp3Utils().httpGet("http://bilibili.acproject.xyz/weather", headers, datas).body().string();
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            LOGGER.error("\u8bf7\u6c42\u670d\u52a1\u5668\u8d85\u65f6\uff0c\u83b7\u53d6\u5929\u6c14\u5931\u8d25");
            data = null;
        }
        if (data == null) {
            return null;
        }
        try {
            jsonObject = JSONObject.parseObject(data);
            code = jsonObject.getString("code");
            if (code.equals("200")) {
                weathers = new HashMap<String, WeatherV2>();
                List weatherV2s = jsonObject.getJSONArray("result").toJavaList(WeatherV2.class);
                if (!CollectionUtils.isEmpty((Collection)weatherV2s)) {
                    int i = -1;
                    for (WeatherV2 weatherV2 : weatherV2s) {
                        weathers.put(i + "", weatherV2);
                        ++i;
                    }
                }
            } else {
                LOGGER.error("\u672a\u77e5\u9519\u8bef,\u539f\u56e0:" + jsonObject.getString("msg"));
            }
        }
        catch (Exception e) {
            weathers = null;
        }
        return weathers;
    }

    public static PredatorResult httpGetApexPredator(String key, String type) {
        String data = null;
        JSONObject jsonObject = null;
        String code = "-1";
        PredatorResult predatorResult = null;
        HashMap<String, String> headers = null;
        HashMap<String, String> datas = null;
        headers = new HashMap<String, String>(2);
        headers.put("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Safari/537.36");
        datas = new HashMap<String, String>(5);
        if (StringUtils.isNotBlank((CharSequence)key)) {
            datas.put("key", key);
        }
        if (StringUtils.isNotBlank((CharSequence)type)) {
            datas.put("type", type);
        }
        try {
            datas.put("edition", PublicDataConf.VERSION);
            datas.put("time", String.valueOf(System.currentTimeMillis()));
            data = OkHttp3Utils.getHttp3Utils().httpGet("http://bilibili.acproject.xyz/apex_banked", headers, datas).body().string();
            if (data == null) {
                return predatorResult;
            }
            jsonObject = JSONObject.parseObject((String)data);
            code = jsonObject.getString("code");
            if (code.equals("200")) {
                predatorResult = (PredatorResult)jsonObject.getObject("result", PredatorResult.class);
            } else {
                LOGGER.error("\u672a\u77e5\u9519\u8bef,\u539f\u56e0:" + jsonObject.getString("msg"));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            LOGGER.error("\u8bf7\u6c42\u670d\u52a1\u5668\u8d85\u65f6\uff0c\u83b7\u53d6apex\u4fe1\u606f\u5931\u8d25");
            data = null;
        }
        return predatorResult;
    }

    public static ApexMessage httpGetApexMessage() {
        String data = null;
        JSONObject jsonObject = null;
        String code = "-1";
        ApexMessage apexMessage = null;
        HashMap<String, String> headers = null;
        HashMap<String, String> datas = null;
        headers = new HashMap<String, String>(2);
        headers.put("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Safari/537.36");
        datas = new HashMap<String, String>(3);
        try {
            datas.put("edition", PublicDataConf.VERSION);
            datas.put("time", String.valueOf(System.currentTimeMillis()));
            data = OkHttp3Utils.getHttp3Utils().httpGet("http://bilibili.acproject.xyz/apex_message", headers, datas).body().string();
            if (data == null) {
                return apexMessage;
            }
            jsonObject = JSONObject.parseObject((String)data);
            code = jsonObject.getString("code");
            if (code.equals("200")) {
                apexMessage = (ApexMessage)jsonObject.getObject("result", ApexMessage.class);
            } else {
                LOGGER.error("\u672a\u77e5\u9519\u8bef,\u539f\u56e0:" + jsonObject.getString("msg"));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            LOGGER.error("\u8bf7\u6c42\u670d\u52a1\u5668\u8d85\u65f6\uff0c\u83b7\u53d6apex\u603b\u4fe1\u606f\u5931\u8d25");
        }
        return apexMessage;
    }
}

