/*
 * Decompiled with CFR 0.152.
 */
package xyz.acproject.danmuji.http;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xyz.acproject.danmuji.conf.PublicDataConf;
import xyz.acproject.danmuji.entity.heart.SmallHeart;
import xyz.acproject.danmuji.entity.heart.XData;
import xyz.acproject.danmuji.entity.room_data.RoomInfo;
import xyz.acproject.danmuji.http.HttpOtherData;
import xyz.acproject.danmuji.tools.CurrencyTools;
import xyz.acproject.danmuji.utils.OkHttp3Utils;

public class HttpHeartBeatData {
    private static Logger LOGGER = LogManager.getLogger(HttpHeartBeatData.class);

    public static void httpGetHeartBeatOrS(Long timestamp) {
        String data = null;
        JSONObject jsonObject = null;
        String urlString = null;
        urlString = timestamp != null ? "https://api.live.bilibili.com/relation/v1/Feed/heartBeat?_=" + timestamp : "https://api.live.bilibili.com/relation/v1/Feed/heartBeat";
        HashMap<String, String> headers = null;
        headers = new HashMap<String, String>(4);
        headers.put("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Safari/537.36");
        headers.put("referer", "https://live.bilibili.com/" + CurrencyTools.parseRoomId());
        if (StringUtils.isNotBlank((CharSequence)PublicDataConf.USERCOOKIE)) {
            headers.put("cookie", PublicDataConf.USERCOOKIE);
        }
        try {
            data = OkHttp3Utils.getHttp3Utils().httpGet(urlString, headers, null).body().string();
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            data = null;
        }
        if (data == null) {
            return;
        }
        jsonObject = JSONObject.parseObject((String)data);
        short code = jsonObject.getShort("code");
        if (code == 0) {
            if (!jsonObject.getString("msg").equals("success")) {
                LOGGER.error("\u5728\u7ebf\u5fc3\u8df3\u5305get\u53d1\u9001\u5931\u8d25" + jsonObject.toString());
            }
        } else {
            LOGGER.error("\u5728\u7ebf\u5fc3\u8df3\u5305get\u53d1\u9001\u5931\u8d25" + jsonObject.toString());
        }
    }

    public static void httpPostUserOnlineHeartBeat() {
        JSONObject jsonObject = null;
        String data = null;
        HashMap<String, String> headers = null;
        HashMap<String, String> params = null;
        if (PublicDataConf.USERBARRAGEMESSAGE == null && PublicDataConf.COOKIE == null) {
            return;
        }
        headers = new HashMap<String, String>(4);
        headers.put("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Safari/537.36");
        headers.put("referer", "https://live.bilibili.com/" + CurrencyTools.parseRoomId());
        if (StringUtils.isNotBlank((CharSequence)PublicDataConf.USERCOOKIE)) {
            headers.put("cookie", PublicDataConf.USERCOOKIE);
        }
        params = new HashMap<String, String>(4);
        params.put("csrf_token", PublicDataConf.COOKIE.getBili_jct());
        params.put("csrf", PublicDataConf.COOKIE.getBili_jct());
        params.put("visit_id", "");
        try {
            data = OkHttp3Utils.getHttp3Utils().httpPostForm("https://api.live.bilibili.com/User/userOnlineHeart", headers, params).body().string();
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            data = null;
        }
        if (data == null) {
            return;
        }
        jsonObject = JSONObject.parseObject((String)data);
        short code = jsonObject.getShort("code");
        if (code == 0) {
            if (!jsonObject.getString("message").equals("0")) {
                LOGGER.error("\u5fc3\u8df3\u5305post\u53d1\u9001\u5931\u8d25,\u672a\u77e5\u9519\u8bef,\u539f\u56e0\u672a\u77e5v" + jsonObject.toString());
            }
        } else {
            LOGGER.error("\u53d1\u8df3\u5305post\u53d1\u9001\u5931\u8d25,\u672a\u77e5\u9519\u8bef,\u539f\u56e0\u672a\u77e5" + jsonObject.toString());
        }
    }

    public static XData httpPostE(RoomInfo roomInfo) {
        JSONObject jsonObject = null;
        String data = null;
        HashMap<String, String> headers = null;
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        SmallHeart smallHeart = null;
        XData xData = null;
        StringBuilder stringBuilder = new StringBuilder(50);
        if (PublicDataConf.USERBARRAGEMESSAGE == null && PublicDataConf.COOKIE == null) {
            return null;
        }
        headers = new HashMap<String, String>(4);
        headers.put("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Safari/537.36");
        headers.put("referer", "https://live.bilibili.com/" + CurrencyTools.parseRoomId());
        if (StringUtils.isNotBlank((CharSequence)PublicDataConf.USERCOOKIE)) {
            headers.put("cookie", PublicDataConf.USERCOOKIE);
        }
        long[] ids = new long[]{roomInfo.getParent_area_id().intValue(), roomInfo.getArea_id().intValue(), 0L, PublicDataConf.ROOMID};
        stringBuilder.append("[").append("\"").append(CurrencyTools.deviceHash()).append("\"").append(",").append("\"").append(CurrencyTools.getUUID()).append("\"").append("]");
        String devices = stringBuilder.toString();
        params = new LinkedHashMap(10);
        long ts = System.currentTimeMillis();
        params.put("id", Arrays.toString(ids));
        params.put("device", devices);
        params.put("ts", String.valueOf(ts));
        params.put("is_patch", "0");
        params.put("heart_beat", "[]");
        params.put("ua", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Safari/537.36");
        params.put("csrf_token", PublicDataConf.COOKIE.getBili_jct());
        params.put("csrf", PublicDataConf.COOKIE.getBili_jct());
        params.put("visit_id", "");
        try {
            data = OkHttp3Utils.getHttp3Utils().httpPostForm("https://live-trace.bilibili.com/xlive/data-interface/v1/x25Kn/E", headers, params).body().string();
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            data = null;
        }
        if (data == null) {
            return null;
        }
        jsonObject = JSONObject.parseObject((String)data);
        short code = jsonObject.getShort("code");
        if (code == 0) {
            if (jsonObject.getString("message").equals("0")) {
                smallHeart = (SmallHeart)jsonObject.getObject("data", SmallHeart.class);
                xData = new XData(ids, devices, smallHeart.getTimestamp(), smallHeart.getSecret_key(), smallHeart.getHeartbeat_interval(), Long.valueOf(ts), smallHeart.getSecret_rule(), Boolean.valueOf(false));
            } else {
                LOGGER.error("\u5fc3\u8df3\u5305Epost\u53d1\u9001\u5931\u8d25,\u672a\u77e5\u9519\u8bef,\u539f\u56e0\u672a\u77e5v:" + jsonObject.toString());
            }
        } else {
            LOGGER.error("\u53d1\u8df3\u5305Epost\u53d1\u9001\u5931\u8d25,\u672a\u77e5\u9519\u8bef,\u539f\u56e0\u672a\u77e5:" + jsonObject.toString());
        }
        stringBuilder.delete(0, stringBuilder.length());
        return xData;
    }

    public static XData httpPostX(RoomInfo roomInfo, int num, XData xData) {
        JSONObject jsonObject = null;
        String data = null;
        HashMap<String, String> headers = null;
        HashMap<String, String> params = null;
        SmallHeart smallHeart = null;
        if (PublicDataConf.USERBARRAGEMESSAGE == null && PublicDataConf.COOKIE == null) {
            return xData;
        }
        headers = new HashMap<String, String>(4);
        headers.put("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Safari/537.36");
        headers.put("referer", "https://live.bilibili.com/" + CurrencyTools.parseRoomId());
        if (StringUtils.isNotBlank((CharSequence)PublicDataConf.USERCOOKIE)) {
            headers.put("cookie", PublicDataConf.USERCOOKIE);
        }
        params = new HashMap<String, String>(12);
        long[] ids = new long[]{roomInfo.getParent_area_id().intValue(), roomInfo.getArea_id().intValue(), num, PublicDataConf.ROOMID};
        long ts = System.currentTimeMillis();
        xData.setId(ids);
        CompletableFuture<String> completableFuture = CompletableFuture.supplyAsync(() -> {
            String s = null;
            long startTime = xData.getStartTime();
            if (startTime <= 0L) {
                startTime = System.currentTimeMillis();
            }
            while (StringUtils.isBlank(s) && System.currentTimeMillis() - startTime < (long)(xData.getTime() * 1000)) {
                s = HttpOtherData.httpPostencS((XData)xData, (long)ts);
            }
            return s;
        });
        try {
            params.put("s", completableFuture.get());
        }
        catch (InterruptedException e) {
            LOGGER.error("s \u51fd\u6570\u5904\u7406\u9519\u8bef1:{}", (Throwable)e);
        }
        catch (ExecutionException e) {
            LOGGER.error("s \u51fd\u6570\u5904\u7406\u9519\u8bef2:{}", (Throwable)e);
        }
        params.put("id", Arrays.toString(ids));
        params.put("device", xData.getDevice());
        params.put("ets", xData.getEts().toString());
        params.put("benchmark", xData.getBenchmark());
        params.put("time", xData.getTime().toString());
        params.put("ts", String.valueOf(ts));
        params.put("ua", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.138 Safari/537.36");
        params.put("csrf_token", PublicDataConf.COOKIE.getBili_jct());
        params.put("csrf", PublicDataConf.COOKIE.getBili_jct());
        params.put("visit_id", "");
        try {
            data = OkHttp3Utils.getHttp3Utils().httpPostForm("https://live-trace.bilibili.com/xlive/data-interface/v1/x25Kn/X", headers, params).body().string();
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            data = null;
        }
        if (data == null) {
            return xData;
        }
        jsonObject = JSONObject.parseObject((String)data);
        short code = jsonObject.getShort("code");
        if (code == 0) {
            if (jsonObject.getString("message").equals("0")) {
                smallHeart = (SmallHeart)jsonObject.getObject("data", SmallHeart.class);
                xData.setTs(Long.valueOf(ts));
                xData.setBenchmark(smallHeart.getSecret_key());
                xData.setEts(smallHeart.getTimestamp());
                xData.setSecret_rule(smallHeart.getSecret_rule());
                xData.setTime(smallHeart.getHeartbeat_interval());
                xData.setError(Boolean.valueOf(false));
            } else {
                LOGGER.error("\u5fc3\u8df3\u5305Xpost\u53d1\u9001\u5931\u8d25,\u672a\u77e5\u9519\u8bef,\u539f\u56e0\u672a\u77e5v:{},\u9519\u8bef\u4f53:{}", (Object)jsonObject.toString(), (Object)xData);
                xData.setError(Boolean.valueOf(true));
            }
        } else {
            LOGGER.error("\u53d1\u8df3\u5305Xpost\u53d1\u9001\u5931\u8d25,\u672a\u77e5\u9519\u8bef,\u539f\u56e0\u672a\u77e5:{},\u9519\u8bef\u4f53:{}", (Object)jsonObject.toString(), (Object)xData);
            xData.setError(Boolean.valueOf(true));
        }
        return xData;
    }
}

