/*
 * Decompiled with CFR 0.152.
 */
package xyz.acproject.danmuji.entity.base;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.servlet.http.HttpServletRequest;
import xyz.acproject.danmuji.entity.base.ResponseCode;

public class Response<T> {
    private String code;
    private String msg;
    private Object result;
    private Timestamp timestamp;

    public Response() {
    }

    public Response(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public Response(String code, String msg, Timestamp timestamp) {
        this.code = code;
        this.msg = msg;
        this.timestamp = timestamp;
    }

    public Response(String code, String msg, Object result) {
        this.code = code;
        this.msg = msg;
        this.result = result;
    }

    public Response(String code, String msg, Object result, Timestamp timestamp) {
        this.code = code;
        this.msg = msg;
        this.result = result;
        this.timestamp = timestamp;
    }

    public Response(ResponseCode code, Object result) {
        this.code = code.getCode();
        this.msg = code.getCnMsg();
        this.result = result;
    }

    public Response(ResponseCode code, Object result, Timestamp timestamp) {
        this.code = code.getCode();
        this.msg = code.getCnMsg();
        this.result = result;
        this.timestamp = timestamp;
    }

    public Response(ResponseCode code, String msg, Object result, Timestamp timestamp) {
        this.code = code.getCode();
        this.msg = code.getCnMsg();
        this.result = result;
        this.timestamp = timestamp;
    }

    public static Response success(Object result, HttpServletRequest request) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar calendar = Calendar.getInstance();
        String times = dateFormat.format(calendar.getTime());
        Timestamp timestamp = Timestamp.valueOf(times.toString());
        return new Response(ResponseCode.normal, "", result, timestamp);
    }

    public static Response error(HttpServletRequest request) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Calendar calendar = Calendar.getInstance();
        String times = dateFormat.format(calendar.getTime());
        Timestamp timestamp = Timestamp.valueOf(times.toString());
        return new Response(ResponseCode.syserror, (Object)"", timestamp);
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public Object getResult() {
        return this.result;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Timestamp timestamp) {
        this.timestamp = timestamp;
    }

    public String toString() {
        return "Response [code=" + this.code + ", msg=" + this.msg + ", result=" + this.result + ", timestamp=" + this.timestamp + "]";
    }
}

