/*
 * Decompiled with CFR 0.152.
 */
package xyz.acproject.danmuji.controller;

import com.alibaba.fastjson.JSONObject;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.DigestUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import xyz.acproject.danmuji.component.TaskRegisterComponent;
import xyz.acproject.danmuji.conf.CenterSetConf;
import xyz.acproject.danmuji.conf.PublicDataConf;
import xyz.acproject.danmuji.conf.set.AdvertSetConf;
import xyz.acproject.danmuji.conf.set.AutoReplySetConf;
import xyz.acproject.danmuji.conf.set.AutoSendGiftConf;
import xyz.acproject.danmuji.conf.set.BlackListSetConf;
import xyz.acproject.danmuji.conf.set.ClockInSetConf;
import xyz.acproject.danmuji.conf.set.PrivacySetConf;
import xyz.acproject.danmuji.conf.set.ThankFollowSetConf;
import xyz.acproject.danmuji.conf.set.ThankGiftSetConf;
import xyz.acproject.danmuji.conf.set.ThankWelcomeSetConf;
import xyz.acproject.danmuji.entity.base.Response;
import xyz.acproject.danmuji.entity.login_data.LoginData;
import xyz.acproject.danmuji.entity.login_data.Qrcode;
import xyz.acproject.danmuji.entity.other.EditionResult;
import xyz.acproject.danmuji.entity.other.InitCheckServerParam;
import xyz.acproject.danmuji.http.HttpOtherData;
import xyz.acproject.danmuji.http.HttpRoomData;
import xyz.acproject.danmuji.http.HttpUserData;
import xyz.acproject.danmuji.service.ClientService;
import xyz.acproject.danmuji.service.DanmujiInitService;
import xyz.acproject.danmuji.service.SetService;
import xyz.acproject.danmuji.tools.CurrencyTools;
import xyz.acproject.danmuji.tools.ParseSetStatusTools;
import xyz.acproject.danmuji.tools.file.JsonFileTools;
import xyz.acproject.danmuji.utils.FastJsonUtils;
import xyz.acproject.danmuji.utils.QrcodeUtils;
import xyz.acproject.danmuji.utils.SchedulingRunnableUtil;

@Controller
public class WebController {
    private SetService checkService;
    private ClientService clientService;
    @Resource
    private DanmujiInitService danmujiInitService;
    private TaskRegisterComponent taskRegisterComponent;
    private static final Logger LOGGER = LogManager.getLogger(WebController.class);

    @RequestMapping(value={"/", "index"})
    public String index(HttpServletRequest req, Model model) {
        if (StringUtils.isNotBlank((CharSequence)PublicDataConf.USERCOOKIE) && req.getSession().getAttribute("status") == null) {
            req.getSession().setAttribute("status", (Object)"login");
        }
        model.addAttribute("ANAME", (Object)PublicDataConf.ANCHOR_NAME);
        model.addAttribute("AUID", (Object)PublicDataConf.AUID);
        model.addAttribute("EDITION", (Object)PublicDataConf.VERSION);
        model.addAttribute("NEW_EDITION", (Object)PublicDataConf.NEW_VERSION);
        model.addAttribute("ROOMID", (Object)PublicDataConf.ROOMID);
        model.addAttribute("HROOMID", (Object)PublicDataConf.centerSetConf.getRoomid());
        model.addAttribute("POPU", (Object)PublicDataConf.ROOM_POPULARITY);
        model.addAttribute("MANAGER", (Object)(PublicDataConf.USERMANAGER != null ? PublicDataConf.USERMANAGER.is_manager() : false));
        if (PublicDataConf.USER != null) {
            model.addAttribute("USER", (Object)PublicDataConf.USER);
        }
        return "index";
    }

    @RequestMapping(value={"/connect"})
    public String connect(Model model) {
        model.addAttribute("ROOMID", (Object)PublicDataConf.centerSetConf.getRoomid());
        return "connect";
    }

    @RequestMapping(value={"/cookie_set"})
    public String cookie_set(Model model) {
        return "cookie_set";
    }

    @RequestMapping(value={"/danmu_widget"})
    public String danmu_widget(Model model) {
        return "danmu_widget";
    }

    @RequestMapping(value={"/login"})
    public String login(HttpServletRequest req) {
        if (req.getSession().getAttribute("status") == null) {
            return "login";
        }
        return "redirect:/";
    }

    @RequestMapping(value={"/quit"})
    public String quit(HttpServletRequest req) {
        req.getSession().setAttribute("status", null);
        req.getSession().removeAttribute("status");
        if (StringUtils.isNotBlank((CharSequence)PublicDataConf.USERCOOKIE)) {
            HttpUserData.quit();
            this.checkService.quit();
        }
        return "login";
    }

    @ResponseBody
    @GetMapping(value={"/qrcode"})
    public void qrcode(HttpServletRequest req, HttpServletResponse resp, @RequestParam(value="url") String url) {
        if (req.getSession().getAttribute("status") != null) {
            return;
        }
        QrcodeUtils.creatRrCode((String)url, (int)140, (int)140, (HttpServletResponse)resp);
    }

    @ResponseBody
    @PostMapping(value={"/qrcodeUrl"})
    public Response<?> qrcodeUrl(HttpServletRequest req) {
        if (req.getSession().getAttribute("status") != null) {
            return null;
        }
        Qrcode qrcode = HttpUserData.httpGenerateQrcode();
        req.getSession().setAttribute("auth", (Object)qrcode.getQrcode_key());
        return Response.success((Object)qrcode.getUrl(), (HttpServletRequest)req);
    }

    @ResponseBody
    @PostMapping(value={"/loginCheck"})
    public JSONObject loginCheck(HttpServletRequest req) {
        if (req.getSession().getAttribute("status") != null) {
            return null;
        }
        JSONObject jsonObject = null;
        String oauthKey = (String)req.getSession().getAttribute("auth");
        LoginData loginData = new LoginData();
        loginData.setOauthKey(oauthKey);
        String jsonString = HttpUserData.httpQrcodePoll((String)oauthKey);
        jsonObject = JSONObject.parseObject((String)jsonString);
        if (jsonObject != null && jsonObject.getJSONObject("data").getIntValue("code") == 0) {
            this.danmujiInitService.init();
            if (PublicDataConf.USER != null) {
                req.getSession().setAttribute("status", (Object)"login");
            }
        }
        return jsonObject;
    }

    @ResponseBody
    @PostMapping(value={"/customCookie"})
    public Response<?> customCookie(String cookie, HttpServletRequest req) {
        boolean flag = CurrencyTools.parseCookie((String)cookie);
        if (flag) {
            this.danmujiInitService.init();
            if (StringUtils.isNotBlank((CharSequence)PublicDataConf.USERCOOKIE)) {
                HttpUserData.httpGetUserBarrageMsg();
            }
        }
        return Response.success((Object)flag, (HttpServletRequest)req);
    }

    @ResponseBody
    @GetMapping(value={"/connectRoom"})
    public Response<?> connectRoom(HttpServletRequest req, @RequestParam(value="roomid") Long roomid) {
        boolean flag = false;
        if (null == PublicDataConf.webSocketProxy || !PublicDataConf.webSocketProxy.isOpen()) {
            try {
                this.clientService.startConnService(roomid.longValue());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (PublicDataConf.ROOMID != null) {
                PublicDataConf.centerSetConf.setRoomid(PublicDataConf.ROOMID);
                PublicDataConf.ROOMID_LONG = PublicDataConf.ROOMID;
            }
            this.checkService.connectSet(PublicDataConf.centerSetConf);
        }
        if (PublicDataConf.webSocketProxy != null && PublicDataConf.webSocketProxy.isOpen()) {
            flag = true;
        }
        return Response.success((Object)flag, (HttpServletRequest)req);
    }

    @ResponseBody
    @GetMapping(value={"/disconnectRoom"})
    public Response<?> disconnectRoom(HttpServletRequest req) {
        boolean flag = false;
        flag = this.clientService.closeConnService();
        return Response.success((Object)flag, (HttpServletRequest)req);
    }

    @ResponseBody
    @GetMapping(value={"/connectCheck"})
    public Response<?> connectCheck(HttpServletRequest req) {
        boolean flag = false;
        if (PublicDataConf.webSocketProxy != null && PublicDataConf.webSocketProxy.isOpen()) {
            flag = true;
        }
        return Response.success((Object)flag, (HttpServletRequest)req);
    }

    @ResponseBody
    @GetMapping(value={"/heartBeat"})
    public Response<?> heartBeat(HttpServletRequest req) {
        return Response.success((Object)PublicDataConf.ROOM_POPULARITY, (HttpServletRequest)req);
    }

    @ResponseBody
    @GetMapping(value={"/getSet"})
    public Response<?> get(HttpServletRequest req) {
        return Response.success((Object)PublicDataConf.centerSetConf, (HttpServletRequest)req);
    }

    @ResponseBody
    @PostMapping(value={"/sendSet"})
    public Response<?> send(HttpServletRequest req, @RequestParam(value="set") String set) {
        try {
            CenterSetConf centerSetConf = (CenterSetConf)JSONObject.parseObject((String)set, CenterSetConf.class);
            if (!StringUtils.equals((CharSequence)centerSetConf.getEdition(), (CharSequence)PublicDataConf.VERSION)) {
                return Response.success((Object)2, (HttpServletRequest)req);
            }
            if (centerSetConf.is_manager_login() && StringUtils.isNotBlank((CharSequence)centerSetConf.getManager_key())) {
                centerSetConf.setManager_key(DigestUtils.md5DigestAsHex((byte[])centerSetConf.getManager_key().getBytes()));
            } else if (StringUtils.isBlank((CharSequence)centerSetConf.getManager_key())) {
                centerSetConf.setManager_key(PublicDataConf.centerSetConf.getManager_key());
            }
            if (centerSetConf.is_dosign() && !centerSetConf.getSign_time().equals(PublicDataConf.centerSetConf.getSign_time())) {
                SchedulingRunnableUtil task = new SchedulingRunnableUtil("dosignTask", "dosign");
                this.taskRegisterComponent.removeTask((Runnable)task);
                this.taskRegisterComponent.addTask(task, CurrencyTools.dateStringToCron((String)centerSetConf.getSign_time()));
            }
            if (centerSetConf.getClock_in() != null && centerSetConf.getClock_in().is_open() && !centerSetConf.getClock_in().getTime().equals(PublicDataConf.centerSetConf.getClock_in().getTime())) {
                SchedulingRunnableUtil dakatask = new SchedulingRunnableUtil("dosignTask", "clockin");
                this.taskRegisterComponent.removeTask((Runnable)dakatask);
                this.taskRegisterComponent.addTask(dakatask, CurrencyTools.dateStringToCron((String)centerSetConf.getClock_in().getTime()));
            }
            if (centerSetConf.getAuto_gift() != null && centerSetConf.getAuto_gift().is_open() && !centerSetConf.getAuto_gift().getTime().equals(PublicDataConf.centerSetConf.getAuto_gift().getTime())) {
                SchedulingRunnableUtil autoSendGiftTask = new SchedulingRunnableUtil("dosignTask", "autosendgift");
                this.taskRegisterComponent.removeTask((Runnable)autoSendGiftTask);
                this.taskRegisterComponent.addTask(autoSendGiftTask, CurrencyTools.dateStringToCron((String)centerSetConf.getAuto_gift().getTime()));
            }
            if (centerSetConf.getAdvert() == null && PublicDataConf.centerSetConf.getAdvert() != null) {
                centerSetConf.setAdvert(PublicDataConf.centerSetConf.getAdvert());
            }
            if (centerSetConf.getAdvert() == null && PublicDataConf.centerSetConf.getAdvert() == null) {
                centerSetConf.setAdvert(new AdvertSetConf());
            }
            if (centerSetConf.getFollow() == null && PublicDataConf.centerSetConf.getFollow() != null) {
                centerSetConf.setFollow(PublicDataConf.centerSetConf.getFollow());
            }
            if (centerSetConf.getFollow() == null && PublicDataConf.centerSetConf.getFollow() == null) {
                centerSetConf.setFollow(new ThankFollowSetConf());
            }
            if (centerSetConf.getThank_gift() == null && PublicDataConf.centerSetConf.getThank_gift() != null) {
                centerSetConf.setThank_gift(PublicDataConf.centerSetConf.getThank_gift());
            }
            if (centerSetConf.getThank_gift() == null && PublicDataConf.centerSetConf.getThank_gift() == null) {
                centerSetConf.setThank_gift(new ThankGiftSetConf());
            }
            if (centerSetConf.getReply() == null && PublicDataConf.centerSetConf.getReply() != null) {
                centerSetConf.setReply(PublicDataConf.centerSetConf.getReply());
            }
            if (centerSetConf.getReply() == null && PublicDataConf.centerSetConf.getReply() == null) {
                centerSetConf.setReply(new AutoReplySetConf());
            }
            if (centerSetConf.getClock_in() == null && PublicDataConf.centerSetConf.getClock_in() != null) {
                centerSetConf.setClock_in(PublicDataConf.centerSetConf.getClock_in());
            }
            if (centerSetConf.getClock_in() == null && PublicDataConf.centerSetConf.getClock_in() == null) {
                centerSetConf.setClock_in(new ClockInSetConf(false, "\u7b7e\u5230"));
            }
            if (centerSetConf.getWelcome() == null && PublicDataConf.centerSetConf.getWelcome() != null) {
                centerSetConf.setWelcome(PublicDataConf.centerSetConf.getWelcome());
            }
            if (centerSetConf.getWelcome() == null && PublicDataConf.centerSetConf.getWelcome() == null) {
                centerSetConf.setWelcome(new ThankWelcomeSetConf());
            }
            if (centerSetConf.getAuto_gift() == null && PublicDataConf.centerSetConf.getAuto_gift() != null) {
                centerSetConf.setAuto_gift(PublicDataConf.centerSetConf.getAuto_gift());
            }
            if (centerSetConf.getAuto_gift() == null && PublicDataConf.centerSetConf.getAuto_gift() == null) {
                centerSetConf.setAuto_gift(new AutoSendGiftConf());
            }
            if (centerSetConf.getPrivacy() == null && PublicDataConf.centerSetConf.getPrivacy() != null) {
                centerSetConf.setPrivacy(PublicDataConf.centerSetConf.getPrivacy());
            }
            if (centerSetConf.getPrivacy() == null && PublicDataConf.centerSetConf.getPrivacy() == null) {
                centerSetConf.setPrivacy(new PrivacySetConf());
            }
            if (centerSetConf.getBlack() == null && PublicDataConf.centerSetConf.getBlack() != null) {
                centerSetConf.setBlack(PublicDataConf.centerSetConf.getBlack());
            }
            if (centerSetConf.getBlack() == null && PublicDataConf.centerSetConf.getBlack() == null) {
                centerSetConf.setBlack(new BlackListSetConf());
            }
            this.checkService.changeSet(centerSetConf, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.success((Object)0, (HttpServletRequest)req);
        }
        return Response.success((Object)1, (HttpServletRequest)req);
    }

    @ResponseBody
    @GetMapping(value={"/checkWebInit"})
    public Response<?> checkWebInit(HttpServletRequest req) {
        InitCheckServerParam param = new InitCheckServerParam();
        param.setInit_edition(PublicDataConf.INIT_CHECK_EDITION);
        param.setInit_announce(PublicDataConf.INIT_CHECK_ANNOUNCE);
        return Response.success((Object)param, (HttpServletRequest)req);
    }

    @ResponseBody
    @GetMapping(value={"/checkNewAnnounce"})
    public Response<?> checkNewAnnounce(HttpServletRequest req) {
        try {
            PublicDataConf.INIT_CHECK_ANNOUNCE = true;
            Response response = Response.success((Object)(StringUtils.isNotBlank((CharSequence)PublicDataConf.ANNOUNCE) ? StringUtils.replace((String)PublicDataConf.ANNOUNCE, (String)"\r\n", (String)"<br/>") : "\u516c\u544a\u83b7\u53d6\u5931\u8d25"), (HttpServletRequest)req);
            return response;
        }
        finally {
            PublicDataConf.ANNOUNCE = null;
        }
    }

    @ResponseBody
    @GetMapping(value={"/checkupdate"})
    public Response<?> checkUpdate(HttpServletRequest req) {
        String edition = PublicDataConf.centerSetConf.getPrivacy().is_open() ? PublicDataConf.VERSION : HttpOtherData.httpGetNewEditionV2ByGitHub();
        EditionResult editionResult = new EditionResult();
        editionResult.setEdition(edition);
        if (StringUtils.isNotBlank((CharSequence)edition)) {
            if (edition.equals("\u83b7\u53d6\u516c\u544a\u5931\u8d25")) {
                editionResult.setStatus(2);
                return Response.success((Object)editionResult, (HttpServletRequest)req);
            }
            PublicDataConf.INIT_CHECK_EDITION = true;
            if (!edition.equals(PublicDataConf.VERSION)) {
                editionResult.setStatus(0);
                editionResult.setUrl(PublicDataConf.NEW_VERSION_DOWNLOAD_URL);
                return Response.success((Object)editionResult, (HttpServletRequest)req);
            }
            editionResult.setStatus(1);
            return Response.success((Object)editionResult, (HttpServletRequest)req);
        }
        editionResult.setStatus(2);
        return Response.success((Object)editionResult, (HttpServletRequest)req);
    }

    @ResponseBody
    @GetMapping(value={"/getNewEdition"})
    public Response<?> getNewEdition(HttpServletRequest req) {
        String edition;
        String string = edition = PublicDataConf.centerSetConf.getPrivacy().is_open() ? PublicDataConf.VERSION : HttpOtherData.httpGetNewEditionV2ByGitHub();
        if (StringUtils.isNotBlank((CharSequence)edition)) {
            if (edition.equals("\u83b7\u53d6\u516c\u544a\u5931\u8d25")) {
                return Response.success((Object)-1, (HttpServletRequest)req);
            }
            if (!edition.equals(PublicDataConf.VERSION)) {
                return Response.success((Object)edition, (HttpServletRequest)req);
            }
            return Response.success((Object)-1, (HttpServletRequest)req);
        }
        return Response.success((Object)-1, (HttpServletRequest)req);
    }

    @ResponseBody
    @GetMapping(value={"/block"})
    public Response<?> block(@RequestParam(value="uid") long uid, @RequestParam(value="time") short time, HttpServletRequest req) {
        short code = -1;
        if (time > 720 && time <= 0) {
            code = 2;
            return Response.success((Object)code, (HttpServletRequest)req);
        }
        if (StringUtils.isNotBlank((CharSequence)PublicDataConf.USERCOOKIE)) {
            code = HttpUserData.httpPostAddBlock((long)uid, (short)time);
        }
        return Response.success((Object)code, (HttpServletRequest)req);
    }

    @ResponseBody
    @GetMapping(value={"/del_block"})
    public Response<?> del_block(@RequestParam(value="id") long id, HttpServletRequest req) {
        short code = -1;
        code = HttpUserData.httpPostDeleteBlock((long)id);
        return Response.success((Object)code, (HttpServletRequest)req);
    }

    @ResponseBody
    @GetMapping(value={"/blocks"})
    public Response<?> blocks(@RequestParam(value="page") int page, HttpServletRequest req) {
        if (page <= 0) {
            page = 1;
        }
        List roomBlockList = new ArrayList();
        if (PublicDataConf.ROOMID != null && StringUtils.isNotBlank((CharSequence)PublicDataConf.USERCOOKIE) && PublicDataConf.USERMANAGER != null && PublicDataConf.USERMANAGER.is_manager()) {
            roomBlockList = HttpRoomData.getBlockList((int)page);
        }
        return Response.success(roomBlockList, (HttpServletRequest)req);
    }

    @ResponseBody
    @GetMapping(value={"/setExport"})
    public Response<?> setExport(HttpServletRequest req) {
        boolean flag = JsonFileTools.createJsonFile((String)PublicDataConf.centerSetConf.toJson());
        if (flag) {
            return Response.success((Object)0, (HttpServletRequest)req);
        }
        return Response.success((Object)1, (HttpServletRequest)req);
    }

    @ResponseBody
    @GetMapping(value={"/setExportWeb"})
    public void setExportWeb(HttpServletResponse response) throws Exception {
        File file = JsonFileTools.createJsonFileReturnFile((String)PublicDataConf.centerSetConf.toJson());
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedInputStream fis = new BufferedInputStream(fileInputStream);
        byte[] buffer = new byte[((InputStream)fis).available()];
        ((InputStream)fis).read(buffer);
        ((InputStream)fis).close();
        response.reset();
        response.setCharacterEncoding("UTF-8");
        response.addHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(file.getName(), "UTF-8"));
        response.addHeader("Content-Length", "" + file.length());
        BufferedOutputStream outputStream = new BufferedOutputStream((OutputStream)response.getOutputStream());
        response.setContentType("application/octet-stream");
        ((OutputStream)outputStream).write(buffer);
        ((OutputStream)outputStream).flush();
    }

    @ResponseBody
    @PostMapping(value={"/setImport"})
    public Response<?> setImport(@RequestParam(value="file") MultipartFile file, HttpServletRequest req) throws IOException {
        if (!file.getResource().getFilename().endsWith(".json")) {
            return Response.success((Object)2, (HttpServletRequest)req);
        }
        String jsonString = new BufferedReader(new InputStreamReader(file.getInputStream(), "utf-8")).lines().collect(Collectors.joining(System.lineSeparator()));
        try {
            CenterSetConf centerSetConf = (CenterSetConf)FastJsonUtils.parseObject((String)jsonString, CenterSetConf.class);
            if (centerSetConf != null) {
                centerSetConf = ParseSetStatusTools.initCenterChildConfig((CenterSetConf)centerSetConf);
                BeanUtils.copyProperties((Object)centerSetConf, (Object)PublicDataConf.centerSetConf);
                this.checkService.changeSet(centerSetConf, true);
            }
        }
        catch (Exception e) {
            LOGGER.error("setImport error", (Throwable)e);
            return Response.success((Object)1, (HttpServletRequest)req);
        }
        return Response.success((Object)0, (HttpServletRequest)req);
    }

    @Autowired
    public void setCheckService(SetService checkService) {
        this.checkService = checkService;
    }

    @Autowired
    public void setClientService(ClientService clientService) {
        this.clientService = clientService;
    }

    @Autowired
    public void setTaskRegisterComponent(TaskRegisterComponent taskRegisterComponent) {
        this.taskRegisterComponent = taskRegisterComponent;
    }
}

