/*
 * Decompiled with CFR 0.152.
 */
package xyz.acproject.danmuji.controller;

import java.io.IOException;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Controller;
import xyz.acproject.danmuji.http.HttpUserData;

@Controller
@ServerEndpoint(value="/danmu/sub")
public class DanmuWebsocket {
    private Logger LOGGER = LogManager.getLogger(DanmuWebsocket.class);
    private static CopyOnWriteArraySet<DanmuWebsocket> webSocketServers = new CopyOnWriteArraySet();
    private Session session;

    @OnOpen
    public void onOpen(Session session) {
        this.session = session;
        webSocketServers.add(this);
    }

    @OnClose
    public void onClose() {
        webSocketServers.remove(this);
    }

    @OnMessage
    public void onMessage(String message) throws IOException {
        HttpUserData.httpPostSendBarrage((String)message);
    }

    @OnError
    public void onError(Session session, Throwable error) {
        this.LOGGER.error((Object)error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(String message) throws IOException {
        for (DanmuWebsocket danmuWebsocket : webSocketServers) {
            Session session = danmuWebsocket.session;
            synchronized (session) {
                danmuWebsocket.session.getBasicRemote().sendText(message);
            }
        }
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }
}

