/*
 * Decompiled with CFR 0.152.
 */
package xyz.acproject.danmuji.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.resource.ContentVersionStrategy;
import org.springframework.web.servlet.resource.ResourceResolver;
import org.springframework.web.servlet.resource.ResourceUrlEncodingFilter;
import org.springframework.web.servlet.resource.VersionResourceResolver;
import org.springframework.web.servlet.resource.VersionStrategy;
import xyz.acproject.danmuji.conf.PublicDataConf;
import xyz.acproject.danmuji.interceptors.LoginInterceptor;
import xyz.acproject.danmuji.service.DanmujiInitService;

@Configuration
public class WebMvcConfig
implements WebMvcConfigurer {
    private DanmujiInitService danmujiInitService;

    public void addInterceptors(InterceptorRegistry registry) {
        this.danmujiInitService.init();
        if (PublicDataConf.centerSetConf.is_manager_login()) {
            registry.addInterceptor((HandlerInterceptor)new LoginInterceptor()).addPathPatterns(new String[]{"/*"}).excludePathPatterns(new String[]{"/manager/login", "/manager/logins", "/test/**", "/manager/test"});
        } else {
            super.addInterceptors(registry);
        }
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        VersionResourceResolver versionResourceResolver = new VersionResourceResolver().addVersionStrategy((VersionStrategy)new ContentVersionStrategy(), new String[]{"/**"});
        registry.addResourceHandler(new String[]{"/**"}).addResourceLocations(new String[]{"classpath:/static/"}).setCachePeriod(Integer.valueOf(2592000)).resourceChain(true).addResolver((ResourceResolver)versionResourceResolver);
    }

    @Bean
    public ResourceUrlEncodingFilter resourceUrlEncodingFilter() {
        return new ResourceUrlEncodingFilter();
    }

    @Autowired
    public void setDanmujiConfig(DanmujiInitService danmujiInitService) {
        this.danmujiInitService = danmujiInitService;
    }
}

