/*
 * Decompiled with CFR 0.152.
 */
package xyz.acproject.danmuji.component.task;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import xyz.acproject.danmuji.conf.PublicDataConf;
import xyz.acproject.danmuji.http.HttpOtherData;
import xyz.acproject.danmuji.service.SetService;
import xyz.acproject.danmuji.tools.CurrencyTools;
import xyz.acproject.danmuji.utils.JodaTimeUtils;

@Component(value="dosignTask")
public class DoSignTask {
    private SetService setService;
    private static Logger LOGGER = LogManager.getLogger(DoSignTask.class);

    public void dosign() {
        if (StringUtils.isNotBlank((CharSequence)PublicDataConf.USERCOOKIE)) {
            boolean flag = CurrencyTools.signNow();
            if (flag) {
                this.setService.changeSet(PublicDataConf.centerSetConf, false);
            }
        } else {
            LOGGER.error("\u5b9a\u65f6\u4efb\u52a1\u629b\u51fa\uff1a \u672a\u767b\u5f55 \u7b7e\u5230\u5931\u8d25");
        }
    }

    public void clockin() {
        if (StringUtils.isNotBlank((CharSequence)PublicDataConf.USERCOOKIE)) {
            List userMedals = CurrencyTools.getAllUserMedals();
            if (CollectionUtils.isEmpty((Collection)userMedals)) {
                return;
            }
            int max = CurrencyTools.clockIn((List)userMedals);
            if (max == userMedals.size()) {
                Date date = new Date();
                int nowDay = JodaTimeUtils.formatToInt((Date)date, (String)"yyyyMMdd");
                if (PublicDataConf.centerSetConf.getPrivacy().is_open()) {
                    PublicDataConf.centerSetConf.getPrivacy().setClockInDay(nowDay);
                    this.setService.changeSet(PublicDataConf.centerSetConf, false);
                } else {
                    HttpOtherData.httpPOSTSetClockInRecord();
                }
            }
        } else {
            LOGGER.error("\u5b9a\u65f6\u4efb\u52a1\u629b\u51fa\uff1a \u672a\u767b\u5f55 \u6253\u5361\u5931\u8d25");
        }
    }

    public void autosendgift() {
        if (StringUtils.isNotBlank((CharSequence)PublicDataConf.USERCOOKIE)) {
            CurrencyTools.autoSendGift();
        } else {
            LOGGER.error("\u5b9a\u65f6\u4efb\u52a1\u629b\u51fa\uff1a \u672a\u767b\u5f55 \u81ea\u52a8\u9001\u793c\u5931\u8d25");
        }
    }

    @Autowired
    public void setSetService(SetService setService) {
        this.setService = setService;
    }
}

