/*
 * Decompiled with CFR 0.152.
 */
package xyz.acproject.danmuji.component;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.config.CronTask;
import org.springframework.stereotype.Component;
import xyz.acproject.danmuji.task.ScheduledTask;
import xyz.acproject.danmuji.utils.SchedulingRunnableUtil;

@Component
public class TaskRegisterComponent
implements DisposableBean {
    private final Map<SchedulingRunnableUtil, ScheduledTask> scheduledTasks = new ConcurrentHashMap(6);
    private TaskScheduler taskScheduler;

    public TaskScheduler getTaskScheduler() {
        return this.taskScheduler;
    }

    public void addTask(SchedulingRunnableUtil task, String expression) {
        this.addTask(task, new CronTask((Runnable)task, expression));
    }

    public void addTask(SchedulingRunnableUtil task, CronTask cronTask) {
        if (cronTask != null && !this.scheduledTasks.containsKey(task)) {
            this.scheduledTasks.put(task, this.scheduledTask(cronTask));
        }
    }

    public boolean hasTask(Runnable task) {
        return this.scheduledTasks.containsKey(task);
    }

    public void removeTask(Runnable task) {
        ScheduledTask scheduledTask = (ScheduledTask)this.scheduledTasks.remove(task);
        if (scheduledTask != null) {
            scheduledTask.cancel();
        }
    }

    public Map<SchedulingRunnableUtil, ScheduledTask> getScheduledTasks() {
        return this.scheduledTasks;
    }

    public ScheduledTask scheduledTask(CronTask cronTask) {
        ScheduledTask scheduledTask = new ScheduledTask();
        scheduledTask.future = this.taskScheduler.schedule(cronTask.getRunnable(), cronTask.getTrigger());
        return scheduledTask;
    }

    public int getTaskSize() {
        return this.scheduledTasks.size();
    }

    public void destroy() throws Exception {
        for (ScheduledTask task : this.scheduledTasks.values()) {
            task.cancel();
        }
        this.scheduledTasks.clear();
    }

    @Autowired
    public void setTaskScheduler(TaskScheduler taskScheduler) {
        this.taskScheduler = taskScheduler;
    }
}

