/*
 * Decompiled with CFR 0.152.
 */
package xyz.acproject.danmuji.component;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;
import xyz.acproject.danmuji.conf.PublicDataConf;
import xyz.acproject.danmuji.http.HttpOtherData;

@Component
public class ServerAddressComponent
implements ApplicationListener<WebServerInitializedEvent> {
    private int serverPort;

    public int getPort() {
        return this.serverPort;
    }

    public String getAddress() {
        InetAddress address = null;
        String addressStr = "";
        try {
            address = InetAddress.getLocalHost();
            addressStr = address.getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            addressStr = "\u83b7\u53d6\u5931\u8d25";
        }
        return "http://" + addressStr + ":" + this.serverPort;
    }

    public String getLocalAddress() {
        return "http://localhost:" + this.serverPort;
    }

    public String getRemoteAddress() {
        String ip = HttpOtherData.httpGetIp();
        if (PublicDataConf.centerSetConf.getPrivacy().is_open()) {
            ip = "\u9690\u79c1\u6a21\u5f0f\u7981\u6b62\u83b7\u53d6\u5bf9\u516cip";
        }
        return "http://" + ip + ":" + this.serverPort;
    }

    public void onApplicationEvent(WebServerInitializedEvent event) {
        this.serverPort = event.getWebServer().getPort();
    }
}

