/*
 * Decompiled with CFR 0.152.
 */
package xyz.acproject.danmuji.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import xyz.acproject.danmuji.client.WebSocketProxy;
import xyz.acproject.danmuji.conf.PublicDataConf;
import xyz.acproject.danmuji.entity.room_data.Room;
import xyz.acproject.danmuji.thread.core.ReConnThread;
import xyz.acproject.danmuji.ws.HandleWebsocketPackage;

public class Websocket
extends WebSocketClient {
    private static Logger LOGGER = LogManager.getLogger(Websocket.class);

    public Websocket(String url, Room room) throws URISyntaxException {
        super(new URI(url));
        LOGGER.info("\u5df2\u5c1d\u8bd5\u8fde\u63a5\u81f3\u670d\u52a1\u5668\u5730\u5740:" + url + ";\u771f\u5b9e\u623f\u95f4\u53f7\u4e3a:" + room.getRoomid() + ";\u4e3b\u64ad\u540d\u5b57\u4e3a:" + room.getUname());
    }

    public void onOpen(ServerHandshake handshakedata) {
        LOGGER.info("websocket connect open(\u8fde\u63a5\u7a97\u53e3\u6253\u5f00)");
    }

    public void onMessage(ByteBuffer message) {
        if (PublicDataConf.parseMessageThread != null && !PublicDataConf.parseMessageThread.FLAG) {
            try {
                HandleWebsocketPackage.handleMessage((ByteBuffer)message);
            }
            catch (Exception e) {
                LOGGER.info("\u89e3\u6790\u9519\u8bef\u65e5\u5fd7\u751f\u6210\uff0c\u8bf7\u5c06log\u5e95\u4e0b\u6587\u4ef6\u53d1\u7ed9\u7ba1\u7406\u5458,\u6216github\u5f00issue\u53d1\u9001\u9519\u8bef" + e);
            }
        }
    }

    public void onClose(int code, String reason, boolean remote) {
        LOGGER.info("websocket connect close(\u8fde\u63a5\u5df2\u7ecf\u65ad\u5f00)\uff0c\u7ea0\u9519\u7801:" + code);
        PublicDataConf.heartByteThread.HFLAG = true;
        PublicDataConf.parseMessageThread.FLAG = true;
        if (code != 1000) {
            LOGGER.info("websocket connect close(\u8fde\u63a5\u610f\u5916\u65ad\u5f00\uff0c\u6b63\u5728\u5c1d\u8bd5\u91cd\u8fde)\uff0c\u9519\u8bef\u7801:" + code);
            if (!PublicDataConf.webSocketProxy.isOpen()) {
                if (PublicDataConf.reConnThread != null) {
                    if (PublicDataConf.reConnThread.getState().toString().equals("TERMINATED")) {
                        PublicDataConf.reConnThread = new ReConnThread();
                        PublicDataConf.reConnThread.start();
                    }
                } else {
                    PublicDataConf.reConnThread = new ReConnThread();
                    PublicDataConf.reConnThread.start();
                }
            } else {
                PublicDataConf.reConnThread.RFLAG = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(Exception ex) {
        LOGGER.error("[\u9519\u8bef\u4fe1\u606f\uff0c\u8bf7\u5c06log\u6587\u4ef6\u4e0b\u7684\u65e5\u5fd7\u53d1\u9001\u7ed9\u7ba1\u7406\u5458]websocket connect error,message:" + ex.getMessage());
        LOGGER.info("\u5c1d\u8bd5\u91cd\u65b0\u94fe\u63a5");
        WebSocketProxy webSocketProxy = PublicDataConf.webSocketProxy;
        synchronized (webSocketProxy) {
            PublicDataConf.webSocketProxy.close(1006);
            if (!PublicDataConf.webSocketProxy.isOpen()) {
                if (PublicDataConf.reConnThread != null) {
                    if (PublicDataConf.reConnThread.getState().toString().equals("TERMINATED")) {
                        PublicDataConf.reConnThread = new ReConnThread();
                        PublicDataConf.reConnThread.start();
                    }
                } else {
                    PublicDataConf.reConnThread = new ReConnThread();
                    PublicDataConf.reConnThread.start();
                }
            } else {
                PublicDataConf.reConnThread.RFLAG = true;
            }
        }
    }

    public void onMessage(String message) {
    }
}

