/*********************************************************************************************************************
* RT1064DVL6A Opensourec Library RT1064DVL6A Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
* 
* ļ RT1064DVL6A Դһ
* 
* RT1064DVL6A Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
* 
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
* 
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
* 
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
* 
* ļ          zf_driver_timer
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           IAR 8.32.4 or MDK 5.33
* ƽ̨          RT1064DVL6A
*           https://seekfree.taobao.com/
* 
* ޸ļ¼
*                               ע
* 2022-09-21        SeekFree            first version
********************************************************************************************************************/

#include "fsl_gpt.h"
#include "zf_common_clock.h"
#include "zf_common_debug.h"
#include "zf_driver_gpio.h"

#include "zf_driver_timer.h"

GPT_Type *timer_index[] = GPT_BASE_PTRS;

//-------------------------------------------------------------------------------------------------------------------
//      TIMER ʼʱ
// ˵     index           TIMER ģ
// ز     void
// ʹʾ     timer_start(TIM_1);
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
void timer_start (timer_index_enum index)
{
    GPT_StartTimer(timer_index[index]);                 // ʱ
}

//-------------------------------------------------------------------------------------------------------------------
//      TIMER ֹͣʱ
// ˵     index           TIMER ģ
// ز     void
// ʹʾ     timer_stop(TIM_1);
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
void timer_stop (timer_index_enum index)
{
    GPT_StopTimer(timer_index[index]);                  // ֹͣʱ
}

//-------------------------------------------------------------------------------------------------------------------
//      TIMER ȡʱ
// ˵     index           TIMER ģ
// ز     uint16          ֵ
// ʹʾ     timer_get(TIM_1);
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
uint32 timer_get (timer_index_enum index)
{
    return GPT_GetCurrentTimerCount(timer_index[index]);
}

//-------------------------------------------------------------------------------------------------------------------
//      TIMER ʱ
// ˵     index           TIMER ģ
// ز     void
// ʹʾ     timer_clear(TIM_1);
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
void timer_clear (timer_index_enum index)
{
    // ֻڶʱѿ״̬
    if(timer_index[index]->CR & GPT_CR_EN_MASK)
    {
        timer_stop(index);
        timer_start(index);
    }
}

//-------------------------------------------------------------------------------------------------------------------
//      TIMER ʱʼ
// ˵     index           TIMER ģ
// ˵     mode            ʱʽ
// ز     void
// ʹʾ     timer_init(TIM_1, TIMER_US);
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
void timer_init (timer_index_enum index, timer_mode_enum mode)
{
    gpt_config_t gptConfig;
    
    GPT_GetDefaultConfig(&gptConfig);                   // ȡĬ
    switch(mode)
    {
        case TIMER_IPG1_2_CLOCK:
        {
            gptConfig.divider = 1;
        }break;
        
        case TIMER_US:
        {
            gptConfig.divider = CLOCK_GetFreq(kCLOCK_PerClk) / 1000000;
        }break;
        
        case TIMER_MS:
        {
            gptConfig.clockSource = kGPT_ClockSource_Osc;
            gptConfig.divider = BOARD_XTAL_FREQ / 12 / 1000;
            
        }break;
    }
        
    GPT_Init(timer_index[index], &gptConfig);           // GPTʼ ڴʱ
    GPT_Deinit(timer_index[index]);                     // GPTʼ
    GPT_Init(timer_index[index], &gptConfig);           // GPTʼ
    
    GPT_SetOscClockDivider(timer_index[index], 12);
}

