/*********************************************************************************************************************
* RT1064DVL6A Opensourec Library RT1064DVL6A Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
* 
* ļ RT1064DVL6A Դһ
* 
* RT1064DVL6A Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
* 
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
* 
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
* 
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
* 
* ļ          zf_driver_soft_spi
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           IAR 8.32.4 or MDK 5.33
* ƽ̨          RT1064DVL6A
*           https://seekfree.taobao.com/
* 
* ޸ļ¼
*                               ע
* 2022-09-21        SeekFree            first version
********************************************************************************************************************/

#include "zf_common_debug.h"

#include "zf_driver_soft_spi.h"

//-------------------------------------------------------------------------------------------------------------------
//       SPI ʱ
// ˵     void
// ز     void
// ʹʾ     soft_spi_delay(1);
// עϢ     ڲ
//-------------------------------------------------------------------------------------------------------------------
//static void soft_spi_delay (uint32 delay)
//{
//    volatile uint32 count = delay;
//    while(count --);
//}
#define soft_spi_delay(x)  for(uint32 i = x; i --; )

//-------------------------------------------------------------------------------------------------------------------
//       SPI 8bit ݶд
// ˵     *soft_spi_obj    SPI ָϢŽṹָ
// ˵     data            
// ز     uint8           ȡ
// ʹʾ     soft_spi_8bit_data_handler(soft_spi_obj, 1);
// עϢ     ڲ
//-------------------------------------------------------------------------------------------------------------------
static uint8 soft_spi_8bit_data_handler (soft_spi_info_struct *soft_spi_obj, const uint8 data)
{
    uint8 temp = 0;
    uint8 write_data = data;
    uint8 read_data = 0;

    if(soft_spi_obj->config.use_cs)
    {
        gpio_low(soft_spi_obj->cs_pin);
    }

    if(0 == soft_spi_obj->config.mode || 1 == soft_spi_obj->config.mode)        // CPOL = 0 SCK е͵ƽ
    {
        gpio_low(soft_spi_obj->sck_pin);
    }
    else                                                                        // CPOL = 1 SCK иߵƽ
    {
        gpio_high(soft_spi_obj->sck_pin);
    }

    if(0 == soft_spi_obj->config.mode % 2)                                      // CPHA = 0 һز
    {
        for(temp = 8; temp > 0; temp --)
        {
            if(0x80 & write_data)
            {
                gpio_high(soft_spi_obj->mosi_pin);
            }
            else
            {
                gpio_low(soft_spi_obj->mosi_pin);
            }
            soft_spi_delay(soft_spi_obj->delay);
            gpio_toggle_level(soft_spi_obj->sck_pin);
            write_data = write_data << 1;
            read_data = read_data << 1;
            if(soft_spi_obj->config.use_miso)
            {
                read_data |= gpio_get_level(soft_spi_obj->miso_pin);
            }
            soft_spi_delay(soft_spi_obj->delay);
            gpio_toggle_level(soft_spi_obj->sck_pin);
        }
    }
    else                                                                        // CPHA = 1 ڶز
    {
        for(temp = 8; 0 < temp; temp --)
        {
            gpio_toggle_level(soft_spi_obj->sck_pin);
            if(0x80 & write_data)
            {
                gpio_high(soft_spi_obj->mosi_pin);
            }
            else
            {
                gpio_low(soft_spi_obj->mosi_pin);
            }
            soft_spi_delay(soft_spi_obj->delay);
            gpio_toggle_level(soft_spi_obj->sck_pin);
            write_data = write_data << 1;
            read_data = read_data << 1;
            if(soft_spi_obj->config.use_miso)
            {
                read_data |= gpio_get_level(soft_spi_obj->miso_pin);
            }
            soft_spi_delay(soft_spi_obj->delay);
        }
    }

    if(soft_spi_obj->config.use_cs)
    {
        gpio_high(soft_spi_obj->cs_pin);
    }
    return read_data;
}

//-------------------------------------------------------------------------------------------------------------------
//       SPI 16bit ݶд
// ˵     *soft_spi_obj    SPI ָϢŽṹָ
// ˵     data            
// ز     uint16          ȡ
// ʹʾ     soft_spi_16bit_data_handler(soft_spi_obj, 1);
// עϢ     ڲ
//-------------------------------------------------------------------------------------------------------------------
static uint16 soft_spi_16bit_data_handler (soft_spi_info_struct *soft_spi_obj, const uint16 data)
{
    uint8 temp = 0;
    uint16 write_data = data;
    uint16 read_data = 0;

    if(soft_spi_obj->config.use_cs)
    {
        gpio_low(soft_spi_obj->cs_pin);
    }

    if(0 == soft_spi_obj->config.mode || 1 == soft_spi_obj->config.mode)        // CPOL = 0 SCK е͵ƽ
    {
        gpio_low(soft_spi_obj->sck_pin);
    }
    else                                                                        // CPOL = 1 SCK иߵƽ
    {
        gpio_high(soft_spi_obj->sck_pin);
    }

    if(0 == soft_spi_obj->config.mode % 2)                                      // CPHA = 0 һز
    {
        for(temp = 16; 0 < temp; temp --)
        {
            if(0x8000 & write_data)
            {
                gpio_high(soft_spi_obj->mosi_pin);
            }
            else
            {
                gpio_low(soft_spi_obj->mosi_pin);
            }
            soft_spi_delay(soft_spi_obj->delay);
            gpio_toggle_level(soft_spi_obj->sck_pin);
            write_data = write_data << 1;
            read_data = read_data << 1;
            if(soft_spi_obj->config.use_miso)
            {
                read_data |= gpio_get_level(soft_spi_obj->miso_pin);
            }
            soft_spi_delay(soft_spi_obj->delay);
            gpio_toggle_level(soft_spi_obj->sck_pin);
        }
    }
    else                                                                        // CPHA = 1 ڶز
    {
        for(temp = 16; 0 < temp; temp --)
        {
            gpio_toggle_level(soft_spi_obj->sck_pin);
            if(write_data & 0x8000)
            {
                gpio_high(soft_spi_obj->mosi_pin);
            }
            else
            {
                gpio_low(soft_spi_obj->mosi_pin);
            }
            soft_spi_delay(soft_spi_obj->delay);
            gpio_toggle_level(soft_spi_obj->sck_pin);
            write_data = write_data << 1;
            read_data = read_data << 1;
            if(soft_spi_obj->config.use_miso)
            {
                read_data |= gpio_get_level(soft_spi_obj->miso_pin);
            }
            soft_spi_delay(soft_spi_obj->delay);
        }
    }

    if(soft_spi_obj->config.use_cs)
    {
        gpio_high(soft_spi_obj->cs_pin);
    }
    return read_data;
}

//-------------------------------------------------------------------------------------------------------------------
//       SPI ӿд 8bit 
// ˵     *soft_spi_obj    SPI ָϢŽṹָ
// ˵     data            ͵
// ز     void
// ʹʾ     soft_spi_write_8bit(&soft_spi_obj, 1);
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
void soft_spi_write_8bit (soft_spi_info_struct *soft_spi_obj, const uint8 data)
{
    zf_assert(soft_spi_obj != NULL);
    soft_spi_8bit_data_handler(soft_spi_obj, data);
}

//-------------------------------------------------------------------------------------------------------------------
//       SPI ӿд 8bit 
// ˵     *soft_spi_obj    SPI ָϢŽṹָ
// ˵     *data           ݴŻ
// ˵     len             
// ز     void
// ʹʾ     soft_spi_write_8bit_array(&soft_spi_obj, buf, 16);
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
void soft_spi_write_8bit_array (soft_spi_info_struct *soft_spi_obj, const uint8 *data, uint32 len)
{
    zf_assert(soft_spi_obj != NULL);
    zf_assert(data != NULL);
    while(len --)
    {
        soft_spi_8bit_data_handler(soft_spi_obj, *data ++);
    }
}

//-------------------------------------------------------------------------------------------------------------------
//       SPI ӿд 16bit 
// ˵     *soft_spi_obj    SPI ָϢŽṹָ
// ˵     data            ͵
// ز     void
// ʹʾ     soft_spi_write_16bit(&soft_spi_obj, 1);
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
void soft_spi_write_16bit (soft_spi_info_struct *soft_spi_obj, uint16 data)
{
    zf_assert(soft_spi_obj != NULL);
    soft_spi_16bit_data_handler(soft_spi_obj, data);
}

//-------------------------------------------------------------------------------------------------------------------
//       SPI ӿд 16bit 
// ˵     *soft_spi_obj    SPI ָϢŽṹָ
// ˵     *data           ݴŻ
// ˵     len             
// ز     void
// ʹʾ     soft_spi_write_16bit_array(&soft_spi_obj, buf, 16);
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
void soft_spi_write_16bit_array (soft_spi_info_struct *soft_spi_obj, const uint16 *data, uint32 len)
{
    zf_assert(soft_spi_obj != NULL);
    zf_assert(data != NULL);
    while(len --)
    {
        soft_spi_16bit_data_handler(soft_spi_obj, *data ++);
    }
}

//-------------------------------------------------------------------------------------------------------------------
//       SPI ӿ򴫸ļĴд 8bit 
// ˵     *soft_spi_obj    SPI ָϢŽṹָ
// ˵     register_name   Ĵַ
// ˵     data            ͵
// ز     void
// ʹʾ     soft_spi_write_8bit_register(&soft_spi_obj, 1, 1);
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
void soft_spi_write_8bit_register (soft_spi_info_struct *soft_spi_obj, const uint8 register_name, const uint8 data)
{
    zf_assert(soft_spi_obj != NULL);
    soft_spi_8bit_data_handler(soft_spi_obj, register_name);
    soft_spi_8bit_data_handler(soft_spi_obj, data);
}

//-------------------------------------------------------------------------------------------------------------------
//       SPI ӿ򴫸ļĴд 8bit 
// ˵     *soft_spi_obj    SPI ָϢŽṹָ
// ˵     register_name   Ĵַ
// ˵     *data           ݴŻ
// ˵     len             
// ز     void
// ʹʾ     soft_spi_write_8bit_registers(&soft_spi_obj, 1, buf, 16);
//-------------------------------------------------------------------------------------------------------------------
void soft_spi_write_8bit_registers (soft_spi_info_struct *soft_spi_obj, const uint8 register_name, const uint8 *data, uint32 len)
{
    zf_assert(soft_spi_obj != NULL);
    zf_assert(data != NULL);
    soft_spi_8bit_data_handler(soft_spi_obj, register_name);
    while(len --)
    {
        soft_spi_8bit_data_handler(soft_spi_obj, *data ++);
    }
}

//-------------------------------------------------------------------------------------------------------------------
//       SPI ӿ򴫸ļĴд 16bit 
// ˵     *soft_spi_obj    SPI ָϢŽṹָ
// ˵     register_name   Ĵַ
// ˵     data            ͵
// ز     void
// ʹʾ     soft_spi_write_16bit_register(&soft_spi_obj, 1, 1);
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
void soft_spi_write_16bit_register (soft_spi_info_struct *soft_spi_obj, const uint16 register_name, uint16 data)
{
    zf_assert(soft_spi_obj != NULL);
    soft_spi_16bit_data_handler(soft_spi_obj, register_name);
    soft_spi_16bit_data_handler(soft_spi_obj, data);
}

//-------------------------------------------------------------------------------------------------------------------
//       SPI ӿ򴫸ļĴд 16bit 
// ˵     *soft_spi_obj    SPI ָϢŽṹָ
// ˵     register_name   Ĵַ
// ˵     *data           ݴŻ
// ˵     len             
// ز     void
// ʹʾ     soft_spi_write_16bit_registers(&soft_spi_obj, 1, buf, 16);
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
void soft_spi_write_16bit_registers (soft_spi_info_struct *soft_spi_obj, const uint16 register_name, const uint16 *data, uint32 len)
{
    zf_assert(soft_spi_obj != NULL);
    zf_assert(data != NULL);
    soft_spi_16bit_data_handler(soft_spi_obj, register_name);
    while(len --)
    {
        soft_spi_16bit_data_handler(soft_spi_obj, *data ++);
    }
}

//-------------------------------------------------------------------------------------------------------------------
//       SPI ӿڶ 8bit 
// ˵     *soft_spi_obj    SPI ָϢŽṹָ
// ˵     data            ͵
// ز     uint8           ضȡ 8bit 
// ʹʾ     soft_spi_read_8bit(&soft_spi_obj);
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
uint8 soft_spi_read_8bit (soft_spi_info_struct *soft_spi_obj)
{
    zf_assert(soft_spi_obj != NULL);
    return soft_spi_8bit_data_handler(soft_spi_obj, 0);
}

//-------------------------------------------------------------------------------------------------------------------
//       SPI ӿڶ 8bit 
// ˵     *soft_spi_obj    SPI ָϢŽṹָ
// ˵     *data           ݴŻ
// ˵     len             
// ز     void
// ʹʾ     soft_spi_read_8bit_array(&soft_spi_obj, buf, 16);
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
void soft_spi_read_8bit_array (soft_spi_info_struct *soft_spi_obj, uint8 *data, uint32 len)
{
    zf_assert(soft_spi_obj != NULL);
    zf_assert(data != NULL);
    while(len --)
    {
        *data ++ = soft_spi_8bit_data_handler(soft_spi_obj, 0);
    }
}

//-------------------------------------------------------------------------------------------------------------------
//       SPI ӿڶ 16bit 
// ˵     *soft_spi_obj    SPI ָϢŽṹָ
// ˵     data            ͵
// ز     uint16          ضȡ 16bit 
// ʹʾ     soft_spi_read_16bit(&soft_spi_obj);
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
uint16 soft_spi_read_16bit (soft_spi_info_struct *soft_spi_obj)
{
    zf_assert(soft_spi_obj != NULL);
    return soft_spi_16bit_data_handler(soft_spi_obj, 0);
}

//-------------------------------------------------------------------------------------------------------------------
//       SPI ӿڶ 16bit 
// ˵     *soft_spi_obj    SPI ָϢŽṹָ
// ˵     *data           ݴŻ
// ˵     len             
// ز     void
// ʹʾ     soft_spi_read_16bit_array(&soft_spi_obj, buf, 16);
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
void soft_spi_read_16bit_array (soft_spi_info_struct *soft_spi_obj, uint16 *data, uint32 len)
{
    zf_assert(soft_spi_obj != NULL);
    zf_assert(data != NULL);
    while(len --)
    {
        *data ++ = soft_spi_16bit_data_handler(soft_spi_obj, 0);
    }
}

//-------------------------------------------------------------------------------------------------------------------
//       SPI ӿڴӴļĴ 8bit 
// ˵     *soft_spi_obj    SPI ָϢŽṹָ
// ˵     register_name   Ĵַ
// ˵     data            ͵
// ز     uint8           ضȡ 8bit 
// ʹʾ     soft_spi_read_8bit_register(&soft_spi_obj, 0x01, 0x01);
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
uint8 soft_spi_read_8bit_register (soft_spi_info_struct *soft_spi_obj, const uint8 register_name)
{
    zf_assert(soft_spi_obj != NULL);
    soft_spi_8bit_data_handler(soft_spi_obj, register_name);
    return soft_spi_8bit_data_handler(soft_spi_obj, 0);
}

//-------------------------------------------------------------------------------------------------------------------
//       SPI ӿڴӴļĴ 8bit 
// ˵     *soft_spi_obj    SPI ָϢŽṹָ
// ˵     register_name   Ĵַ
// ˵     *data           ݴŻ
// ˵     len             
// ز     void
// ʹʾ     soft_spi_read_8bit_registers(&soft_spi_obj, 0x01, buf, 16);
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
void soft_spi_read_8bit_registers (soft_spi_info_struct *soft_spi_obj, const uint8 register_name, uint8 *data, uint32 len)
{
    zf_assert(soft_spi_obj != NULL);
    zf_assert(data != NULL);
    soft_spi_8bit_data_handler(soft_spi_obj, register_name);
    while(len --)
    {
        *data ++ = soft_spi_8bit_data_handler(soft_spi_obj, 0);
    }
}

//-------------------------------------------------------------------------------------------------------------------
//       SPI ӿڴӴļĴ 16bit 
// ˵     *soft_spi_obj    SPI ָϢŽṹָ
// ˵     register_name   Ĵַ
// ˵     data            ͵
// ز     uint16          ضȡ 16bit 
// ʹʾ     soft_spi_read_16bit_register(&soft_spi_obj, 0x0101);
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
uint16 soft_spi_read_16bit_register (soft_spi_info_struct *soft_spi_obj, const uint16 register_name)
{
    zf_assert(soft_spi_obj != NULL);
    soft_spi_16bit_data_handler(soft_spi_obj, register_name);
    return soft_spi_16bit_data_handler(soft_spi_obj, 0);
}

//-------------------------------------------------------------------------------------------------------------------
//       SPI ӿڴӴļĴ 16bit 
// ˵     *soft_spi_obj    SPI ָϢŽṹָ
// ˵     register_name   Ĵַ
// ˵     *data           ݴŻ
// ˵     len             
// ز     void
// ʹʾ     soft_spi_read_16bit_registers(&soft_spi_obj, 0x0101, buf, 16);
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
void soft_spi_read_16bit_registers (soft_spi_info_struct *soft_spi_obj, const uint16 register_name, uint16 *data, uint32 len)
{
    zf_assert(soft_spi_obj != NULL);
    zf_assert(data != NULL);
    soft_spi_16bit_data_handler(soft_spi_obj, register_name);
    while(len --)
    {
        *data ++ = soft_spi_16bit_data_handler(soft_spi_obj, 0);
    }
}

//-------------------------------------------------------------------------------------------------------------------
//       SPI 8bit ݴ ͬʱе
// ˵     *soft_spi_obj    SPI ָϢŽṹָ
// ˵     write_buffer    ͵ݻַ
// ˵     read_buffer     ʱյݵĴ洢ַ(Ҫ NULL)
// ˵     len             ͵ֽ
// ز     void
// ʹʾ     soft_spi_transfer_8bit(&soft_spi_obj, buf, buf, 1);
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
void soft_spi_transfer_8bit (soft_spi_info_struct *soft_spi_obj, const uint8 *write_buffer, uint8 *read_buffer, uint32 len)
{
    zf_assert(soft_spi_obj != NULL);
    zf_assert(write_buffer != NULL);
    while(len --)
    {
        if(read_buffer != NULL)
        {
            *read_buffer = soft_spi_8bit_data_handler(soft_spi_obj, *write_buffer);
            write_buffer ++;
            read_buffer ++;
        }
        else
        {
            soft_spi_8bit_data_handler(soft_spi_obj, *write_buffer);
            write_buffer ++;
        }
    }
}

//-------------------------------------------------------------------------------------------------------------------
//       SPI 16bit ݴ ͬʱе
// ˵     *soft_spi_obj    SPI ָϢŽṹָ
// ˵     write_buffer    ͵ݻַ
// ˵     read_buffer     ʱյݵĴ洢ַ(Ҫ NULL)
// ˵     len             ͵ֽ
// ز     void
// ʹʾ     soft_spi_transfer_16bit(&soft_spi_obj, buf, buf, 1);
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
void soft_spi_transfer_16bit (soft_spi_info_struct *soft_spi_obj, const uint16 *write_buffer, uint16 *read_buffer, uint32 len)
{
    zf_assert(soft_spi_obj != NULL);
    zf_assert(write_buffer != NULL);
    while(len --)
    {
        if(read_buffer != NULL)
        {
            *read_buffer = soft_spi_16bit_data_handler(soft_spi_obj, *write_buffer);
            write_buffer ++;
            read_buffer ++;
        }
        else
        {
            soft_spi_16bit_data_handler(soft_spi_obj, *write_buffer);
            write_buffer ++;
        }
    }
}

//-------------------------------------------------------------------------------------------------------------------
//       SPI ӿڳʼ
// ˵     *soft_spi_obj    SPI ָϢŽṹָ
// ˵     mode            SPI ģʽ  zf_driver_spi.h  spi_mode_enum ö嶨
// ˵     delay            SPI ʱ ʱӸߵƽʱ Խ SPI Խ
// ˵     sck_pin         ѡ SCK   zf_driver_gpio.h  gpio_pin_enum ö嶨
// ˵     mosi_pin        ѡ MOSI   zf_driver_gpio.h  gpio_pin_enum ö嶨
// ˵     miso_pin        ѡ MISO  Ҫ  SOFT_SPI_PIN_NULL
// ˵     cs_pin          ѡ CS  Ҫ  SOFT_SPI_PIN_NULL
// ز     void
// ʹʾ     spi_init(SPI_1, 0, 1*1000*1000, A5, A7, A6, A4);
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
void soft_spi_init (soft_spi_info_struct *soft_spi_obj, uint8 mode, uint32 delay, gpio_pin_enum sck_pin, gpio_pin_enum mosi_pin, uint32 miso_pin, uint32 cs_pin)
{
    zf_assert(soft_spi_obj != NULL);
    zf_assert(sck_pin != mosi_pin);                                             // sck_pin   mosi_pin ôͬһţ
    zf_assert(sck_pin != miso_pin);                                             // sck_pin   miso_pin ôͬһţ
    zf_assert(sck_pin != cs_pin);                                               // sck_pin   cs_pin   ôͬһţ
    zf_assert(mosi_pin != miso_pin);                                            // mosi_pin  miso_pin ôͬһţ
    zf_assert(mosi_pin != cs_pin);                                              // mosi_pin  cs_pin   ôͬһţ
    zf_assert((miso_pin != cs_pin) || (cs_pin == SOFT_SPI_PIN_NULL));           // miso_pin  cs_pin   ôͬһţ

    zf_assert(4 > mode);                                                        //  zf_driver_spi.h  spi_mode_enum ö嶨

    soft_spi_obj->config.mode = mode;
    soft_spi_obj->delay = delay;

    soft_spi_obj->sck_pin = sck_pin;
    soft_spi_obj->mosi_pin = mosi_pin;
    if(0 == mode || 1 == mode)
    {
        gpio_init(sck_pin, GPO, GPIO_LOW, GPO_PUSH_PULL);                       // IO ʼ
    }
    else
    {
        gpio_init(sck_pin, GPO, GPIO_HIGH, GPO_PUSH_PULL);                      // IO ʼ
    }
    gpio_init(mosi_pin, GPO, GPIO_HIGH, GPO_PUSH_PULL);                         // IO ʼ

    if(SOFT_SPI_PIN_NULL == miso_pin)
    {
        soft_spi_obj->config.use_miso = 0;
    }
    else
    {
        soft_spi_obj->config.use_miso = 1;
        soft_spi_obj->miso_pin = (gpio_pin_enum)miso_pin;
        gpio_init(soft_spi_obj->miso_pin, GPI, GPIO_HIGH, GPI_FLOATING_IN);     // IO ʼ
    }
    if(SOFT_SPI_PIN_NULL == cs_pin)
    {
        soft_spi_obj->config.use_cs = 0;
    }
    else
    {
        soft_spi_obj->config.use_cs = 1;
        soft_spi_obj->cs_pin = (gpio_pin_enum)cs_pin;
        gpio_init(soft_spi_obj->cs_pin, GPO, GPIO_HIGH, GPO_PUSH_PULL);         // IO ʼ
    }
}
