/*********************************************************************************************************************
* RT1064DVL6A Opensourec Library RT1064DVL6A Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
* 
* ļ RT1064DVL6A Դһ
* 
* RT1064DVL6A Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
* 
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
* 
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
* 
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
* 
* ļ          zf_driver_pit
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           IAR 8.32.4 or MDK 5.33
* ƽ̨          RT1064DVL6A
*           https://seekfree.taobao.com/
* 
* ޸ļ¼
*                               ע
* 2022-09-21        SeekFree            first version
********************************************************************************************************************/

#ifndef _zf_driver_pit_h_
#define _zf_driver_pit_h_

#include "zf_common_typedef.h"
#include "fsl_pit.h"

typedef enum                                                                    // ö PIT
{
    PIT_CH0 = kPIT_Chnl_0,
    PIT_CH1,
    PIT_CH2,
    PIT_CH3,
    PIT_MAX,
}pit_index_enum;

#define PIT_SOURCE_CLOCK CLOCK_GetFreq(kCLOCK_PerClk)                           // PITʱʱ


void pit_enable (pit_index_enum pit_chn);
void pit_disable (pit_index_enum pit_chn);

void pit_init (pit_index_enum pit_chn, uint32 period);

//====================================================궨庯====================================================

//-------------------------------------------------------------------------------------------------------------------
//      PIT־λȡ
// ˵     pit_chn           ʹõ PIT 
// ˵     ms              PIT  ms 
// ز     void
// ʹʾ     pit_flag_clear(PIT_CH0);
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
#define pit_flag_get(pit_chn)       PIT_GetStatusFlags(PIT, (pit_chnl_t)pit_chn)

//-------------------------------------------------------------------------------------------------------------------
//      PIT־λ
// ˵     pit_chn           ʹõ PIT 
// ˵     ms              PIT  ms 
// ز     void
// ʹʾ     pit_flag_clear(PIT_CH0);
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
#define pit_flag_clear(pit_chn)     PIT_ClearStatusFlags(PIT, (pit_chnl_t)pit_chn, kPIT_TimerFlag)


//-------------------------------------------------------------------------------------------------------------------
//      TIM PIT жϳʼ ms 
// ˵     pit_chn           ʹõ PIT 
// ˵     ms              PIT  ms 
// ز     void
// ʹʾ     pit_ms_init(PIT_CH0, 1);
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
#define pit_ms_init(pit_chn, ms)  (pit_init((pit_chn), (ms) * (PIT_SOURCE_CLOCK / 1000)))

//-------------------------------------------------------------------------------------------------------------------
//      TIM PIT жϳʼ us 
// ˵     pit_chn           ʹõ PIT 
// ˵     us              PIT  us 
// ز     void
// ʹʾ     pit_us_init(PIT_CH0, 100);
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
#define pit_us_init(pit_chn, us)  (pit_init((pit_chn), (us) * (PIT_SOURCE_CLOCK / 1000000)))

//====================================================궨庯====================================================

#endif
