/*********************************************************************************************************************
* RT1064DVL6A Opensourec Library RT1064DVL6A Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
* 
* ļ RT1064DVL6A Դһ
* 
* RT1064DVL6A Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
* 
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
* 
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
* 
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
* 
* ļ          zf_driver_exti
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           IAR 8.32.4 or MDK 5.33
* ƽ̨          RT1064DVL6A
*           https://seekfree.taobao.com/
* 
* ޸ļ¼
*                               ע
* 2022-09-21        SeekFree            first version
********************************************************************************************************************/

#include "zf_driver_exti.h"


#define GPIO_EXTI_CONFIG         SPEED_100MHZ | HYS_EN | PULL_EN | PULLUP_100K   // GPIOжŲ

//-------------------------------------------------------------------------------------------------------------------
//      EXTI жʹ
// ˵     pin             ѡ EXTI  (ѡΧ zf_driver_gpio.h  gpio_pin_enum öֵȷ)
// ز     void
// ʹʾ     exti_enable(B0);
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
void exti_enable (gpio_pin_enum pin)
{
    GPIO_PortEnableInterrupts(PORTPTR[pin >> 5],1 << (pin & 0x1f));
}

//-------------------------------------------------------------------------------------------------------------------
//      EXTI жʧ
// ˵     pin             ѡ EXTI  (ѡΧ zf_driver_gpio.h  gpio_pin_enum öֵȷ)
// ز     void
// ʹʾ     exti_disable(B0);
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
void exti_disable (gpio_pin_enum pin)
{
    GPIO_PortDisableInterrupts(PORTPTR[pin >> 5],1 << (pin & 0x1f)); 
}

//-------------------------------------------------------------------------------------------------------------------
//      EXTI жϳʼ
// ˵     pin             ѡ EXTI  (ѡΧ zf_driver_gpio.h  gpio_pin_enum öֵȷ)
// ˵     trigger         ѡ񴥷źŷʽ [EXTI_TRIGGER_RISING/EXTI_TRIGGER_FALLING/EXTI_TRIGGER_BOTH]
// ز     void
// ʹʾ     exti_init(B0, EXTI_TRIGGER_RISING);
// עϢ     ͬһ±ŲͬʱʼΪⲿж  A0  B0 ͬʱʼΪⲿж
//-------------------------------------------------------------------------------------------------------------------
void exti_init (gpio_pin_enum pin, exti_trigger_enum trigger)
{
    gpio_pin_config_t gpio_config;
    
    gpio_iomuxc(pin, GPIO_EXTI_CONFIG);
    
    gpio_config.direction = kGPIO_DigitalInput;         
    gpio_config.interruptMode = (gpio_interrupt_mode_t)trigger;  
    GPIO_PinInit(PORTPTR[pin >> 5], pin & 0x1f, &gpio_config);                      // ʼGPIO
    GPIO_PortEnableInterrupts(PORTPTR[pin >> 5],1 << (pin & 0x1f));                 // GPIOж

    EnableIRQ((IRQn_Type)((IRQn_Type)((pin >> 4) - 2) + GPIO1_Combined_0_15_IRQn)); // ʹIRQ
    
    //NVIC_SetPriority((IRQn_Type)((IRQn_Type)((pin>>4)-2) + GPIO1_Combined_0_15_IRQn),0);// ȼ Χ0-15 ԽСȼԽ
}
