/*********************************************************************************************************************
* RT1064DVL6A Opensourec Library RT1064DVL6A Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
* 
* ļ RT1064DVL6A Դһ
* 
* RT1064DVL6A Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
* 
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
* 
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
* 
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
* 
* ļ          zf_driver_delay
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           IAR 8.32.4 or MDK 5.33
* ƽ̨          RT1064DVL6A
*           https://seekfree.taobao.com/
* 
* ޸ļ¼
*                               ע
* 2022-09-21        SeekFree            first version
********************************************************************************************************************/


#include "zf_common_clock.h"
#include "fsl_gpt.h"

#include "zf_driver_delay.h"

static uint8 system_init_flag;

#define SYSTEM_DELAY_GPT 					GPT2	                                    // ѡʹõGPTʱ

//-------------------------------------------------------------------------------------------------------------------
//  @brief      gptʼ
//  @param      void            
//  @return     void
//  Sample usage:               ûãûʹhļеĺ궨
//-------------------------------------------------------------------------------------------------------------------
void system_delay_init(void)
{
    gpt_config_t gptConfig;
    
    system_init_flag = 1;
    GPT_GetDefaultConfig(&gptConfig);                                                   // ȡĬ
    gptConfig.clockSource = kGPT_ClockSource_Osc;
    gptConfig.divider = 1;
    GPT_Init(SYSTEM_DELAY_GPT, &gptConfig);                                             // GPTʼ ڴʱ
    GPT_Deinit(SYSTEM_DELAY_GPT);                                                       // GPTʼ
    GPT_Init(SYSTEM_DELAY_GPT, &gptConfig);                                             // GPTʼ
}

//-------------------------------------------------------------------------------------------------------------------
//      system ʱ
// ˵     time			Ҫʱʱ
// ˵     num			    ҪʱĴ
// ز     void
// ʹʾ     system_delay(1000000, (time));
// עϢ     û ûʹ zf_driver_delay.h ļеĺ궨
//-------------------------------------------------------------------------------------------------------------------
void system_delay (uint32 time, uint32 num)
{
    if(0 == system_init_flag)
    {
        system_delay_init();
    }
    
    while(num --)
    {
        GPT_SetOutputCompareValue(SYSTEM_DELAY_GPT, kGPT_OutputCompare_Channel1, time); // öʱʱ
        GPT_StartTimer(SYSTEM_DELAY_GPT);                                               // ʱ
        while(!GPT_GetStatusFlags(SYSTEM_DELAY_GPT, kGPT_OutputCompare1Flag));
        GPT_ClearStatusFlags(SYSTEM_DELAY_GPT, kGPT_OutputCompare1Flag);
        GPT_StopTimer(SYSTEM_DELAY_GPT);
    }
}
