/*********************************************************************************************************************
* RT1064DVL6A Opensourec Library RT1064DVL6A Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
* 
* ļ RT1064DVL6A Դһ
* 
* RT1064DVL6A Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
* 
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
* 
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
* 
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
* 
* ļ          zf_device_wireless_uart
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           IAR 8.32.4 or MDK 5.33
* ƽ̨          RT1064DVL6A
*           https://seekfree.taobao.com/
* 
* ޸ļ¼
*                               ע
* 2022-09-21        SeekFree            first version
********************************************************************************************************************/
/*********************************************************************************************************************
* ߶壺
*                   ------------------------------------
*                   ģܽ            Ƭܽ
*                   RX                  鿴 zf_device_wireless_uart.h  WIRELESS_UART_RX_PINx 궨
*                   TX                  鿴 zf_device_wireless_uart.h  WIRELESS_UART_TX_PINx 궨
*                   RTS                 鿴 zf_device_wireless_uart.h  WIRELESS_UART_RTS_PINx 궨
*                   VCC                 3.3VԴ
*                   GND                 Դ
*                   
*                   ------------------------------------
********************************************************************************************************************/

#include "zf_common_clock.h"
#include "zf_common_debug.h"
#include "zf_common_fifo.h"
#include "zf_driver_delay.h"
#include "zf_driver_gpio.h"
#include "zf_driver_uart.h"
#include "zf_device_type.h"

#include "zf_device_wireless_uart.h"

static  fifo_struct         wireless_uart_fifo;
static  uint8               wireless_uart_buffer[WIRELESS_UART_BUFFER_SIZE];    // ݴ

static          uint8       wireless_uart_data;
static volatile uint32      wireless_auto_baud_flag = 0;
static volatile uint8       wireless_auto_baud_data[3] = {0x00, 0x01, 0x03};

//-------------------------------------------------------------------------------------------------------------------
//      תģ 
// ˵     data            8bit 
// ز     uint32          ʣ෢ͳ
// ʹʾ     wireless_uart_send_byte(data);
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
uint32 wireless_uart_send_byte (const uint8 data)
{
    uint16 time_count = WIRELESS_UART_TIMEOUT_COUNT;
    while(time_count)
    {
        if(!gpio_get_level(WIRELESS_UART_RTS_PIN))
        {
            uart_write_byte(WIRELESS_UART_INDEX, data);                         // 
            break;
        }
        time_count --;
        system_delay_ms(1);
    }
    return (0 < time_count);
}

//-------------------------------------------------------------------------------------------------------------------
//      תģ ݿ
// ˵     *buff           ͻ
// ˵     len             ݳ
// ز     uint32          ʣ෢ͳ
// ʹʾ     wireless_uart_send_buff(buff, 64);
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
uint32 wireless_uart_send_buff (const uint8 *buff, uint32 len)
{
    zf_assert(buff != NULL);
    uint16 time_count = 0;
    while(0 != len)
    {
        if(!gpio_get_level(WIRELESS_UART_RTS_PIN))                              // RTSΪ͵ƽ 
        {
            if(30 <= len)                                                       // ݷ 30byte ÿ
            {
                uart_write_buffer(WIRELESS_UART_INDEX, buff, 30);               // 
                buff += 30;                                                     // ַƫ
                len -= 30;                                                      // 
                time_count = 0;
            }
            else                                                                //  30byte һԷ
            {
                uart_write_buffer(WIRELESS_UART_INDEX, buff, len);              // 
                len = 0;
                break;
            }
        }
        else                                                                    // RTSΪߵƽ ģæ
        {
            if(WIRELESS_UART_TIMEOUT_COUNT <= (++ time_count))                  // ȴʱ
            {
                break;                                                          // ˳
            }
            system_delay_ms(1);
        }
    }
    return len;
}

//-------------------------------------------------------------------------------------------------------------------
//      תģ ַ
// ˵     *str            Ҫ͵ַַ
// ز     uint32          ʣ෢ͳ
// ʹʾ     wireless_uart_send_string("Believe in yourself.");
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
uint32 wireless_uart_send_string (const char *str)
{
    zf_assert(str != NULL);
    uint16 time_count = 0;
    uint32 len = strlen(str);
    while(0 != len)
    {
        if(!gpio_get_level(WIRELESS_UART_RTS_PIN))                              // RTSΪ͵ƽ 
        {
            if(30 <= len)                                                       // ݷ 30byte ÿ
            {
                uart_write_buffer(WIRELESS_UART_INDEX, (const uint8 *)str, 30); // 
                str += 30;                                                      // ַƫ
                len -= 30;                                                      // 
                time_count = 0;
            }
            else                                                                //  30byte һԷ
            {
                uart_write_buffer(WIRELESS_UART_INDEX, (const uint8 *)str, len);// 
                len = 0;
                break;
            }
        }
        else                                                                    // RTSΪߵƽ ģæ
        {
            if(WIRELESS_UART_TIMEOUT_COUNT <= (++ time_count))                  // ȴʱ
            {
                break;                                                          // ˳
            }
            system_delay_ms(1);
        }
    }
    return len;
}

//-------------------------------------------------------------------------------------------------------------------
//      תģ ͷͼλ鿴ͼ
// ˵     *image_addr     Ҫ͵ͼַ
// ˵     image_size      ͼĴС
// ز     void
// ʹʾ     wireless_uart_send_image(&mt9v03x_image[0][0], MT9V03X_IMAGE_SIZE);
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
void wireless_uart_send_image (const uint8 *image_addr, uint32 image_size)
{
    zf_assert(image_addr != NULL);
    extern uint8 camera_send_image_frame_header[4];
    wireless_uart_send_buff(camera_send_image_frame_header, 4);
    wireless_uart_send_buff((uint8 *)image_addr, image_size);
}

//-------------------------------------------------------------------------------------------------------------------
//      תģ ȡ
// ˵     *buff           ջ
// ˵     len             ȡݳ
// ز     uint32          ʵʶȡݳ
// ʹʾ     wireless_uart_read_buff(buff, 32);
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
uint32 wireless_uart_read_buff (uint8 *buff, uint32 len)
{
    zf_assert(buff != NULL);
    uint32 data_len = len;
    fifo_read_buffer(&wireless_uart_fifo, buff, &data_len, FIFO_READ_AND_CLEAN);
    return data_len;
}

//-------------------------------------------------------------------------------------------------------------------
//      תģ жϻص
// ˵     void
// ز     void
// ʹʾ     wireless_uart_callback();
// עϢ     ú ISR ļ жϳ򱻵
//              ɴжϷ wireless_module_uart_handler() 
//               wireless_module_uart_handler() ñ
//-------------------------------------------------------------------------------------------------------------------
void wireless_uart_callback (void)
{
    uart_query_byte(WIRELESS_UART_INDEX, &wireless_uart_data);
    fifo_write_buffer(&wireless_uart_fifo, &wireless_uart_data, 1);
#if WIRELESS_UART_AUTO_BAUD_RATE                                                // Զ
    if(wireless_auto_baud_flag == 1 && fifo_used(&wireless_uart_fifo) == 3)
    {
        wireless_auto_baud_flag = 3;
        fifo_read_buffer(&wireless_uart_fifo, (uint8 *)wireless_auto_baud_data, (uint32 *)&wireless_auto_baud_flag, FIFO_READ_AND_CLEAN);
    }
#endif
}

//-------------------------------------------------------------------------------------------------------------------
//      תģ ʼ
// ˵     void
// ز     void
// ʹʾ     wireless_uart_init();
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
uint8 wireless_uart_init (void)
{
    uint8 return_state = 0;
    set_wireless_type(WIRELESS_UART, wireless_uart_callback);

    fifo_init(&wireless_uart_fifo, FIFO_DATA_8BIT, wireless_uart_buffer, WIRELESS_UART_BUFFER_SIZE);
    gpio_init(WIRELESS_UART_RTS_PIN, GPI, GPIO_HIGH, GPI_PULL_UP);
#if(0 == WIRELESS_UART_AUTO_BAUD_RATE)                                          // رԶ
    // ʹõĲΪ115200 ΪתģĬϲ ģ鲢޸ĴڵĲ
    uart_init (WIRELESS_UART_INDEX, WIRELESS_UART_BUAD_RATE, WIRELESS_UART_RX_PIN, WIRELESS_UART_TX_PIN);   // ʼ
    uart_rx_interrupt(WIRELESS_UART_INDEX, 1);
#elif(1 == WIRELESS_UART_AUTO_BAUD_RATE)                                        // Զ
    uint8 rts_init_status = 0;
    uint16 time_count = 0;

    wireless_auto_baud_flag = WIRELESS_UART_AUTO_BAUD_RATE_INIT;
    wireless_auto_baud_data[0] = 0;
    wireless_auto_baud_data[1] = 1;
    wireless_auto_baud_data[2] = 3;

    rts_init_status = gpio_get_level(WIRELESS_UART_RTS_PIN);
    gpio_init(WIRELESS_UART_RTS_PIN, GPO, rts_init_status, GPO_PUSH_PULL);      // ʼ

    uart_init (WIRELESS_UART_INDEX, WIRELESS_UART_BUAD_RATE, WIRELESS_UART_RX_PIN, WIRELESS_UART_TX_PIN);   // ʼ
    uart_rx_interrupt(WIRELESS_UART_INDEX, 1);

    system_delay_ms(5);                                                         // ģϵ֮Ҫʱȴ
    gpio_set_level(WIRELESS_UART_RTS_PIN, !rts_init_status);                    // RTSߣԶģʽ
    system_delay_ms(100);                                                       // RTS֮ʱ20ms
    gpio_toggle_level(WIRELESS_UART_RTS_PIN);                                   // RTSȡ

    do
    {
        wireless_auto_baud_flag = WIRELESS_UART_AUTO_BAUD_RATE_START;
        uart_write_byte(WIRELESS_UART_INDEX, wireless_auto_baud_data[0]);       // ض ģԶжϲ
        uart_write_byte(WIRELESS_UART_INDEX, wireless_auto_baud_data[1]);       // ض ģԶжϲ
        uart_write_byte(WIRELESS_UART_INDEX, wireless_auto_baud_data[2]);       // ض ģԶжϲ
        system_delay_ms(20);

        if(WIRELESS_UART_AUTO_BAUD_RATE_GET_ACK != wireless_auto_baud_flag)     // ԶǷ
        {
            return_state = 1;                                                   // 뵽 ˵Զʧ
            break;
        }

        time_count = 0;
        if( 0xa5 != wireless_auto_baud_data[0] &&                               // ԶǷȷ
            0xff != wireless_auto_baud_data[1] &&                               // ԶǷȷ
            0xff != wireless_auto_baud_data[2] )                                // ԶǷȷ
        {
            return_state = 1;                                                   // 뵽 ˵Զʧ
            break;
        }
        wireless_auto_baud_flag = WIRELESS_UART_AUTO_BAUD_RATE_SUCCESS;

        gpio_init(WIRELESS_UART_RTS_PIN, GPI, 0, GPI_PULL_UP);                  // ʼ
        system_delay_ms(10);                                                    // ʱȴ ģ׼
    }while(0);
#endif
    return return_state;
}
