/*********************************************************************************************************************
* RT1064DVL6A Opensourec Library RT1064DVL6A Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
* 
* ļ RT1064DVL6A Դһ
* 
* RT1064DVL6A Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
* 
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
* 
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
* 
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
* 
* ļ          zf_device_type
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           IAR 8.32.4 or MDK 5.33
* ƽ̨          RT1064DVL6A
*           https://seekfree.taobao.com/
* 
* ޸ļ¼
*                               ע
* 2022-09-21        SeekFree            first version
********************************************************************************************************************/

#ifndef _zf_device_type_h_
#define _zf_device_type_h_

#include "zf_common_typedef.h"

typedef enum
{
    NO_CAMERE = 0,                                                              // ͷ
    CAMERA_BIN_IIC,                                                             // С IIC 汾
    CAMERA_BIN_UART,                                                            // С UART 汾
    CAMERA_GRAYSCALE,                                                           // 
    CAMERA_COLOR,                                                               // ͫ
}camera_type_enum;

typedef enum
{
    NO_WIRELESS = 0,                                                            // 豸
    WIRELESS_UART,                                                              // ߴ
    BLUETOOTH_CH9141,                                                           //  CH9141
    WIFI_UART,                                                                  // Wi-Fi 
    WIFI_SPI,                                                                   // Wi-Fi SPI
}wireless_type_enum;

typedef     void (*callback_function)       (void);

extern      camera_type_enum                camera_type;                           
extern      callback_function               camera_uart_handler;                                          
            
extern      camera_type_enum                flexio_camera_type;                           
extern      callback_function               flexio_camera_vsync_handler;                                  
extern      callback_function               flexio_camera_uart_handler;                                   
            
extern      wireless_type_enum              wireless_type;
extern      callback_function               wireless_module_uart_handler;    
extern      callback_function               wireless_module_spi_handler;

void        type_default_callback           (void);
void        set_camera_type                 (camera_type_enum type_set, callback_function vsync_callback, callback_function dma_callback, callback_function uart_callback);
void        set_flexio_camera_type          (camera_type_enum type_set, callback_function vsync_callback, callback_function dma_callback, callback_function uart_callback);
void        set_wireless_type               (wireless_type_enum type_set, callback_function wireless_callback);



#endif
