/*********************************************************************************************************************
* RT1064DVL6A Opensourec Library RT1064DVL6A Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
* 
* ļ RT1064DVL6A Դһ
* 
* RT1064DVL6A Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
* 
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
* 
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
* 
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
* 
* ļ          zf_device_tsl1401
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           IAR 8.32.4 or MDK 5.33
* ƽ̨          RT1064DVL6A
*           https://seekfree.taobao.com/
* 
* ޸ļ¼
*                               ע
* 2022-09-21        SeekFree            first version
********************************************************************************************************************/
/*********************************************************************************************************************
* ߶壺
*                   ------------------------------------
*                   ģܽ            Ƭܽ
*                   CLK                 鿴 zf_device_tsl1401.h  TSL1401_CLK_PIN 궨
*                   SI                  鿴 zf_device_tsl1401.h  TSL1401_SI_PIN 궨
*                   AO[x]               鿴 zf_device_tsl1401.h  TSL1401_AO_PIN_BUFFER 궨
*                   VCC                 3.3VԴ
*                   GND                 Դ
*                   ------------------------------------
********************************************************************************************************************/

#include "zf_common_clock.h"
#include "zf_common_debug.h"
#include "zf_driver_adc.h"
#include "zf_driver_delay.h"
#include "zf_driver_gpio.h"
#include "zf_driver_pit.h"

#include "zf_device_tsl1401.h"

uint16 tsl1401_data[2][TSL1401_DATA_LEN];                                       // TSL1401 ݴ

static uint8 tsl1401_init_state = 0;
uint8 tsl1401_finish_flag;                                                      // TSL1401 ׼־λ

//-------------------------------------------------------------------------------------------------------------------
//      TSL1401  TSL1401 ݲɼ
// ˵     void
// ز     void
// ʹʾ     tsl1401_collect_pit_handler();
// עϢ     ú isr.c жӦ TSL1401_PIT_INDEX жϷ
//-------------------------------------------------------------------------------------------------------------------
void tsl1401_collect_pit_handler (void)
{
    if(!tsl1401_init_state)
    {
        return;
    }

    uint8 i = 0;

    TSL1401_CLK(1);
    TSL1401_SI(0);
    TSL1401_CLK(0);
    TSL1401_SI(1);
    TSL1401_CLK(1);
    TSL1401_SI(0);

    for(i = 0; i < TSL1401_DATA_LEN; i ++)
    {
        TSL1401_CLK(0);
        tsl1401_data[0][i] = adc_convert(TSL1401_AO_PIN);
        tsl1401_data[1][i] = adc_convert(TSL1401_AO_PIN2);
        TSL1401_CLK(1);
    }
    //ɼɱ־λ1
    tsl1401_finish_flag = 1;
}

//-------------------------------------------------------------------------------------------------------------------
//      TSL1401  CCD ͼλ鿴ͼ
// ˵     uart_n          ں
// ˵     index           Ӧĸ TSL1401 [0-1]
// ز     void
// ʹʾ     tsl1401_send_data(DEBUG_UART_INDEX, 1);
// עϢ     øúǰȳʼ
//-------------------------------------------------------------------------------------------------------------------
void tsl1401_send_data (uart_index_enum uart_n, uint8 index)
{
    uint8 i;

    uart_write_byte(uart_n, 0x00);
    uart_write_byte(uart_n, 0xff);
    uart_write_byte(uart_n, 0x01);
    uart_write_byte(uart_n, 0x00);

    for(i=0; i<TSL1401_DATA_LEN; i++)
    {
        uart_write_byte(uart_n, tsl1401_data[index][i] >> 8);                      // ͸8λ
        uart_write_byte(uart_n, tsl1401_data[index][i] & 0xFF);                    // ͸ߵ8λ
    }
}

//-------------------------------------------------------------------------------------------------------------------
//      TSL1401  TSL1401 ʼ
// ˵     void
// ز     void
// ʹʾ     tsl1401_init();
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
void tsl1401_init (void)     
{
    tsl1401_init_state = 1;
    adc_init(TSL1401_AO_PIN, TSL1401_AD_RESOLUTION);
    adc_init(TSL1401_AO_PIN2, TSL1401_AD_RESOLUTION);
    gpio_init(TSL1401_CLK_PIN, GPO, GPIO_LOW, GPO_PUSH_PULL);
    gpio_init(TSL1401_SI_PIN, GPO, GPIO_LOW, GPO_PUSH_PULL);
    pit_ms_init(TSL1401_PIT_INDEX, TSL1401_EXPOSURE_TIME);
}

