/*********************************************************************************************************************
* RT1064DVL6A Opensourec Library RT1064DVL6A Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
* 
* ļ RT1064DVL6A Դһ
* 
* RT1064DVL6A Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
* 
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
* 
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
* 
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
* 
* ļ          zf_device_scc8660_flexio
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           IAR 8.32.4 or MDK 5.33
* ƽ̨          RT1064DVL6A
*           https://seekfree.taobao.com/
* 
* ޸ļ¼
*                               ע
* 2022-09-21        SeekFree            first version
********************************************************************************************************************/
/*********************************************************************************************************************
* ߶壺
*                   ------------------------------------
*                   ģܽ            Ƭܽ
*                   TXD                 鿴 zf_device_scc8660_flexio.h  SCC8660_FLEXIO_COF_UART_TX 궨
*                   RXD                 鿴 zf_device_scc8660_flexio.h  SCC8660_FLEXIO_COF_UART_RX 궨
*                   PCLK                鿴 zf_device_scc8660_flexio.h  SCC8660_FLEXIO_PCLK_PIN 궨
*                   VSY                 鿴 zf_device_scc8660_flexio.h  SCC8660_FLEXIO_VSYNC_PIN 궨
*                   D0-D7               鿴 zf_device_scc8660_flexio.h  SCC8660_FLEXIO_DATA_PIN 궨 Ӹö忪ʼ˸
*                   VCC                 3.3VԴ
*                   GND                 Դ
*                   
*                   ------------------------------------
********************************************************************************************************************/

#ifndef _zf_device_scc8660_flexio_h_
#define _zf_device_scc8660_flexio_h_

#include "zf_common_typedef.h"

//--------------------------------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------------------------------
#define SCC8660_FLEXIO_COF_UART         (UART_4     )                           // ͷʹõĴ
#define SCC8660_FLEXIO_COF_BAUR         (9600       )                           // ͫôڲ
#define SCC8660_FLEXIO_COF_UART_TX      (UART4_RX_C17)                          // ͫ UART-TX  ҪڵƬ RX 
#define SCC8660_FLEXIO_COF_UART_RX      (UART4_TX_C16)                          // ͫ UART-RX  ҪڵƬ TX 

#define SCC8660_FLEXIO_DMA_CH           (DMA_CH0)                               // ͷDMAɼͨ

#define SCC8660_FLEXIO_VSYNC_PIN        C7                                      // ж
#define SCC8660_FLEXIO_VSYNC_IRQN       GPIO2_Combined_0_15_IRQn                // жϺ
    
    
#define SCC8660_FLEXIO_DATA_PIN         FLEXIO2_D08_C8                          // D0  D0ΪFLEXIO2_D08_C8 ôD1ʹõΪFLEXIO2_D09_C9
#define SCC8660_FLEXIO_PCLK_PIN         FLEXIO2_D05_C5                          // ʱ
#define SCC8660_FLEXIO_HREF_PIN         FLEXIO2_D06_C6                          // ź


#define SCC8660_FLEXIO_INIT_TIMEOUT    (0x0080)                                 // Ĭϵͷʼʱʱ Ϊλ

//--------------------------------------------------------------------------------------------------
// ͷĬϲ ڴ޸ͷ
//--------------------------------------------------------------------------------------------------
#define SCC8660_FLEXIO_W               (160)                                    // ʵͼֱʿ ѡΪ160 180
#define SCC8660_FLEXIO_H               (120)                                    // ʵͼֱʸ߶ ѡΪ120 160
#define SCC8660_FLEXIO_IMAGE_SIZE      (SCC8660_FLEXIO_W * 2 * SCC8660_FLEXIO_H)// ͼС SCC8660_W*2*SCC8660_H ܳ 65535

#define SCC8660_FLEXIO_AUTO_EXP_DEF    (0  )                                    // Զع     ĬϲԶع  Χ [0-1] 0Ϊر
#define SCC8660_FLEXIO_BRIGHT_DEF      (800)                                    //      ֶعĬϣ300   ֶعʱΧ0-65535   ԶعƼֵ100 Զعʱ÷Χ0-255
#define SCC8660_FLEXIO_FPS_DEF         (50 )                                    // ͼ֡     Ĭϣ50        ѡΪ60 50 30 25 ʵ֡ʻҪSCC8660_PCLK_DIV
#define SCC8660_FLEXIO_PCLK_DIV_DEF    (2  )                                    // PCLKƵϵ Ĭϣ2         ѡΪ<0:1/1> <1:2/3> <2:1/2> <3:1/3> <4:1/4> <5:1/8>
                                                                                //              ƵϵԽPCLKƵԽͣPCLKԼDVPӿڵĸţPCLKƵӰ֡ʡ뱣Ĭϡ
                                                                                //              FPSΪ50֡pclkƵϵѡΪ5ͷ֡Ϊ50*1/8=6.25֡
                                                                                //              £SCC8660_PCLK_DIVԽͼԽ
#define SCC8660_FLEXIO_PCLK_MODE_DEF   (0  )                                    // PCLKģʽ     Ĭϣ0         ѡΪ[0,1] 0ź 1ź <ͨΪ0ʹSTM32DCMIӿڲɼҪΪ1>
#define SCC8660_FLEXIO_COLOR_MODE_DEF  (0  )                                    // ͼɫģʽ Ĭϣ0         ѡΪ[0,1] 0ɫģʽ   1ģʽɫʱͶߣ
#define SCC8660_FLEXIO_DATA_FORMAT_DEF (0  )                                    // ݸʽ Ĭϣ0         ѡΪ[0-3] 0RGB565 1RGB565(ֽڽ) 2YUV422(YUYV) 3YUV422(UYVY)
#define SCC8660_FLEXIO_MANUAL_WB_DEF   (0  )                                    // ֶƽ   Ĭϣ0         ѡΪ[0,0x65-0xa0] 0رֶƽ⣬Զƽ    ֶƽ ֶƽʱ Χ0x65-0xa0

// ͷö
typedef enum
{
    SCC8660_FLEXIO_INIT                = 0x00,                                  // ͷʼ
    SCC8660_FLEXIO_AUTO_EXP,                                                    // Զع
    SCC8660_FLEXIO_BRIGHT,                                                      // 
    SCC8660_FLEXIO_FPS,                                                         // ͷ֡
    SCC8660_FLEXIO_SET_COL,                                                     // ͼ
    SCC8660_FLEXIO_SET_ROW,                                                     // ͼ
    SCC8660_FLEXIO_PCLK_DIV,                                                    // ʱӷƵ
    SCC8660_FLEXIO_PCLK_MODE,                                                   // ʱģʽ
    SCC8660_FLEXIO_COLOR_MODE,                                                  // ɫģʽ
    SCC8660_FLEXIO_DATA_FORMAT,                                                 // ݸʽ
    SCC8660_FLEXIO_MANUAL_WB,                                                   // ֶƽ
    SCC8660_FLEXIO_CONFIG_FINISH,                                               // λҪռλ
            
    SCC8660_FLEXIO_GET_WHO_AM_I        = 0xEF,                                  // ˭жͷͺ
    SCC8660_FLEXIO_SET_BRIGHT          = 0xF0,                                  // 
    SCC8660_FLEXIO_GET_STATUS          = 0XF1,                                  // ȡͷ
    SCC8660_FLEXIO_GET_VERSION         = 0xF2,                                  // ̼汾
    SCC8660_FLEXIO_SET_MANUAL_WB       = 0xF3,                                  // ֶƽ
        
    SCC8660_FLEXIO_SET_REG_ADDR        = 0xFE, 
    SCC8660_FLEXIO_SET_REG_DATA        = 0xFF, 
}scc8660_flexio_cmd_enum;

extern vuint8       scc8660_flexio_finish_flag;                                 // һͼɼɱ־λ
extern uint16       scc8660_flexio_image[SCC8660_FLEXIO_H][SCC8660_FLEXIO_W];


uint16      scc8660_flexio_get_id              (void);
uint16      scc8660_flexio_get_parameter       (uint16 config);
uint16      scc8660_flexio_get_version         (void);
uint8       scc8660_flexio_set_bright          (uint16 data);
uint8       scc8660_flexio_set_white_balance   (uint16 data);
uint8       scc8660_flexio_set_reg             (uint8 addr, uint16 data);

// RT1064˵ӿڶԲɼͷһCSIӿ һFLEXIOӿ
// ֻҪʹһͷʱƼʹCSIӿڲɼͷҲǵmt9v03x_initʼͷ
// ҪɼͷʱԷֱmt9v03x_init  mt9v03x_flexio_initʼͷ
uint8       scc8660_flexio_init                 (void);

#endif
