/*********************************************************************************************************************
* RT1064DVL6A Opensourec Library RT1064DVL6A Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
* 
* ļ RT1064DVL6A Դһ
* 
* RT1064DVL6A Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
* 
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
* 
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
* 
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
* 
* ļ          zf_device_scc8660_flexio
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           IAR 8.32.4 or MDK 5.33
* ƽ̨          RT1064DVL6A
*           https://seekfree.taobao.com/
* 
* ޸ļ¼
*                               ע
* 2022-09-21        SeekFree            first version
********************************************************************************************************************/
/*********************************************************************************************************************
* ߶壺
*                   ------------------------------------
*                   ģܽ            Ƭܽ
*                   TXD                 鿴 zf_device_scc8660_flexio.h  SCC8660_FLEXIO_COF_UART_TX 궨
*                   RXD                 鿴 zf_device_scc8660_flexio.h  SCC8660_FLEXIO_COF_UART_RX 궨
*                   PCLK                鿴 zf_device_scc8660_flexio.h  SCC8660_FLEXIO_PCLK_PIN 궨
*                   VSY                 鿴 zf_device_scc8660_flexio.h  SCC8660_FLEXIO_VSYNC_PIN 궨
*                   D0-D7               鿴 zf_device_scc8660_flexio.h  SCC8660_FLEXIO_DATA_PIN 궨 Ӹö忪ʼ˸
*                   VCC                 3.3VԴ
*                   GND                 Դ
*                   
*                   ------------------------------------
********************************************************************************************************************/

#include "zf_common_debug.h"
#include "zf_common_interrupt.h"
#include "zf_driver_delay.h"
#include "zf_driver_exti.h"
#include "zf_driver_gpio.h"
#include "zf_driver_uart.h"
#include "zf_device_camera.h"
#include "zf_device_type.h"
#include "zf_driver_flexio_csi.h"

#include "zf_device_scc8660_flexio.h"

vuint8 scc8660_flexio_finish_flag = 0;                                                  // һͼɼɱ־λ

AT_DTCM_SECTION_ALIGN(uint16 scc8660_flexio_image[SCC8660_FLEXIO_H][SCC8660_FLEXIO_W], 4);

// Ҫõͷ ޸Ĳ
static int16 scc8660_flexio_set_confing_buffer[SCC8660_FLEXIO_CONFIG_FINISH][2]=
{
    {SCC8660_FLEXIO_INIT,              0},                                              // ͷʼʼ

    {SCC8660_FLEXIO_AUTO_EXP,          SCC8660_FLEXIO_AUTO_EXP_DEF},                    // Զع
    {SCC8660_FLEXIO_BRIGHT,            SCC8660_FLEXIO_BRIGHT_DEF},                      // 
    {SCC8660_FLEXIO_FPS,               SCC8660_FLEXIO_FPS_DEF},                         // ͼ֡
    {SCC8660_FLEXIO_SET_COL,           SCC8660_FLEXIO_W},                               // ͼ
    {SCC8660_FLEXIO_SET_ROW,           SCC8660_FLEXIO_H},                               // ͼ
    {SCC8660_FLEXIO_PCLK_DIV,          SCC8660_FLEXIO_PCLK_DIV_DEF},                    // PCLKƵϵ
    {SCC8660_FLEXIO_PCLK_MODE,         SCC8660_FLEXIO_PCLK_MODE_DEF},                   // PCLKģʽ
    {SCC8660_FLEXIO_COLOR_MODE,        SCC8660_FLEXIO_COLOR_MODE_DEF},                  // ͼɫģʽ
    {SCC8660_FLEXIO_DATA_FORMAT,       SCC8660_FLEXIO_DATA_FORMAT_DEF},                 // ݸʽ
    {SCC8660_FLEXIO_MANUAL_WB,         SCC8660_FLEXIO_MANUAL_WB_DEF}                    // ֶƽ
};

// ͷڲȡ ޸Ĳ
static int16 scc8660_flexio_get_confing_buffer[SCC8660_FLEXIO_CONFIG_FINISH - 1][2]=
{
    {SCC8660_FLEXIO_AUTO_EXP,          0},
    {SCC8660_FLEXIO_BRIGHT,            0},                                              //           
    {SCC8660_FLEXIO_FPS,               0},                                              // ͼ֡           
    {SCC8660_FLEXIO_SET_COL,           0},                                              // ͼ           
    {SCC8660_FLEXIO_SET_ROW,           0},                                              // ͼ          
    {SCC8660_FLEXIO_PCLK_DIV,          0},                                              // PCLKƵϵ      
    {SCC8660_FLEXIO_PCLK_MODE,         0},                                              // PCLKģʽ      
    {SCC8660_FLEXIO_COLOR_MODE,        0},                                              // ͼɫģʽ
    {SCC8660_FLEXIO_DATA_FORMAT,       0},                                              // ݸʽ    
    {SCC8660_FLEXIO_MANUAL_WB,         0},                                              // ƽ
};

//-------------------------------------------------------------------------------------------------------------------
//      ͷڲϢ ڲ
// ˵     buff            Ϣĵַ
// ز     uint8           1-ʧ 0-ɹ
// ʹʾ     if(scc8660_flexio_set_config(scc8660_flexio_set_confing_buffer)){}
// עϢ     øúǰȳʼ
//-------------------------------------------------------------------------------------------------------------------
static uint8 scc8660_flexio_set_config (int16 buff[SCC8660_FLEXIO_CONFIG_FINISH][2])
{
    uint8 return_state = 1;
    uint8  uart_buffer[4];
    uint16 temp;
    uint16 timeout_count = 0;
    uint32 loop_count = 0;
    uint32 uart_buffer_index = 0;

    // ò  οֲ
    // ʼͷ³ʼ
    for(loop_count = SCC8660_FLEXIO_MANUAL_WB; loop_count < SCC8660_FLEXIO_SET_REG_DATA; loop_count --)
    {
        uart_buffer[0] = 0xA5;
        uart_buffer[1] = buff[loop_count][0];
        temp = buff[loop_count][1];
        uart_buffer[2] = temp >> 8;
        uart_buffer[3] = (uint8)temp;
        uart_write_buffer(SCC8660_FLEXIO_COF_UART, uart_buffer, 4);

        system_delay_ms(2);
    }

    do
    {
        if(3 <= fifo_used(&camera_receiver_fifo))
        {
            uart_buffer_index = 3;
            fifo_read_buffer(&camera_receiver_fifo, uart_buffer, &uart_buffer_index, FIFO_READ_AND_CLEAN);
            if((0xff == uart_buffer[1]) || (0xff == uart_buffer[2]))
            {
                return_state = 0;
                break;
            }
        }
        system_delay_ms(1);
    }while(SCC8660_FLEXIO_INIT_TIMEOUT > timeout_count ++);

    // ϲֶͷõȫᱣͷ51Ƭeeprom
    // set_exposure_timeõعݲ洢eeprom
    return return_state;
}

//-------------------------------------------------------------------------------------------------------------------
//      ȡͷڲϢ ڲ
// ˵     buff            Ϣĵַ
// ز     uint8           1-ʧ 0-ɹ
// ʹʾ     if(scc8660_flexio_get_config(scc8660_flexio_get_confing_buffer)){}
// עϢ     øúǰȳʼ
//-------------------------------------------------------------------------------------------------------------------
static uint8 scc8660_flexio_get_config (int16 buff[SCC8660_FLEXIO_CONFIG_FINISH-1][2])
{
    uint8 return_state = 0;
    uint8  uart_buffer[4];
    uint16 temp;
    uint16 timeout_count = 0;
    uint32 loop_count = 0;
    uint32 uart_buffer_index = 0;

    for(loop_count = SCC8660_FLEXIO_MANUAL_WB - 1; loop_count >= 1; loop_count --)
    {
        uart_buffer[0] = 0xA5;
        uart_buffer[1] = SCC8660_FLEXIO_GET_STATUS;
        temp = buff[loop_count][0];
        uart_buffer[2] = temp >> 8;
        uart_buffer[3] = (uint8)temp;
        uart_write_buffer(SCC8660_FLEXIO_COF_UART, uart_buffer, 4);

        timeout_count = 0;    
        do
        {
            if(3 <= fifo_used(&camera_receiver_fifo))
            {
                uart_buffer_index = 3;
                fifo_read_buffer(&camera_receiver_fifo, uart_buffer, &uart_buffer_index, FIFO_READ_AND_CLEAN);
                buff[loop_count][1] = uart_buffer[1] << 8 | uart_buffer[2];
                break;
            }
            system_delay_ms(1);
        }while(SCC8660_FLEXIO_INIT_TIMEOUT > timeout_count ++);
        if(timeout_count > SCC8660_FLEXIO_INIT_TIMEOUT)                                // ʱ
        {
            return_state = 1;
            break;
        }
    }
    return return_state;
}

//-------------------------------------------------------------------------------------------------------------------
//      ȡͷ ID
// ˵     void
// ز     uint16          0-ȡ N-汾
// ʹʾ     scc8660_flexio_flexio_get_id();                               // øúǰȳʼ
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
uint16 scc8660_flexio_get_id (void)
{
    uint16 temp;
    uint8  uart_buffer[4];
    uint16 timeout_count = 0;
    uint16 return_value = 0;
    uint32 uart_buffer_index = 0;

    uart_buffer[0] = 0xA5;
    uart_buffer[1] = SCC8660_FLEXIO_GET_WHO_AM_I;
    temp = 0;
    uart_buffer[2] = temp >> 8;
    uart_buffer[3] = (uint8)temp;
    uart_write_buffer(SCC8660_FLEXIO_COF_UART, uart_buffer, 4);

    do
    {
        if(3 <= fifo_used(&camera_receiver_fifo))
        {
            uart_buffer_index = 3;
            fifo_read_buffer(&camera_receiver_fifo, uart_buffer, &uart_buffer_index, FIFO_READ_AND_CLEAN);
            return_value = uart_buffer[1] << 8 | uart_buffer[2];
            break;
        }
        system_delay_ms(1);
    }while(SCC8660_FLEXIO_INIT_TIMEOUT > timeout_count ++);
    return return_value;
}

//-------------------------------------------------------------------------------------------------------------------
//      ͷعʱ
// ˵     light           عʱԽͼԽͷյݷֱʼFPSعʱõݹôͷֵ
// ز     uint16          
// ʹʾ     scc8660_flexio_get_parameter();                                        // øúǰȳʼ
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
uint16 scc8660_flexio_get_parameter (uint16 config)
{
    uint8  uart_buffer[4];
    uint16 timeout_count = 0;
    uint16 return_value = 0;
    uint32 uart_buffer_index = 0;

    uart_buffer[0] = 0xA5;
    uart_buffer[1] = SCC8660_FLEXIO_GET_WHO_AM_I;
    uart_buffer[2] = 0x00;
    uart_buffer[3] = config;
    uart_write_buffer(SCC8660_FLEXIO_COF_UART, uart_buffer, 4);

    do
    {
        if(3 <= fifo_used(&camera_receiver_fifo))
        {
            uart_buffer_index = 3;
            fifo_read_buffer(&camera_receiver_fifo, uart_buffer, &uart_buffer_index, FIFO_READ_AND_CLEAN);
            return_value = uart_buffer[1] << 8 | uart_buffer[2];
            break;
        }
        system_delay_ms(1);
    }while(SCC8660_FLEXIO_INIT_TIMEOUT > timeout_count ++);
    return return_value;
}

//-------------------------------------------------------------------------------------------------------------------
//      ȡɫͷ̼汾
// ˵     void
// ز     uint16          汾
// ʹʾ     scc8660_flexio_get_version();                                          // øúǰȳʼͷô
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
uint16 scc8660_flexio_get_version (void)
{
    uint16 temp;
    uint8  uart_buffer[4];
    uint16 timeout_count = 0;
    uint16 return_value = 0;
    uint32 uart_buffer_index = 0;

    uart_buffer[0] = 0xA5;
    uart_buffer[1] = SCC8660_FLEXIO_GET_STATUS;
    temp           = SCC8660_FLEXIO_GET_VERSION;
    uart_buffer[2] = temp >> 8;
    uart_buffer[3] = (uint8)temp;

    uart_write_buffer(SCC8660_FLEXIO_COF_UART, uart_buffer, 4);

    do
    {
        if(3 <= fifo_used(&camera_receiver_fifo))
        {
            uart_buffer_index = 3;
            fifo_read_buffer(&camera_receiver_fifo, uart_buffer, &uart_buffer_index, FIFO_READ_AND_CLEAN);
            return_value = uart_buffer[1] << 8 | uart_buffer[2];
            break;
        }
        system_delay_ms(1);
    }while(SCC8660_FLEXIO_INIT_TIMEOUT > timeout_count ++);
    return return_value;
}

//-------------------------------------------------------------------------------------------------------------------
//      ͼ
// ˵     data            Ҫõֵ
// ز     uint8           1-ʧ 0-ɹ
// ʹʾ     scc8660_flexio_set_bright(data);                                       // ͨúõĲᱻ51Ƭ
// עϢ     øúǰȳʼͷô
//-------------------------------------------------------------------------------------------------------------------
uint8 scc8660_flexio_set_bright (uint16 data)
{
    uint8 return_state = 0;
    uint8  uart_buffer[4];
    uint16 temp;
    uint16 timeout_count = 0;
    uint32 uart_buffer_index = 0;

    uart_buffer[0] = 0xA5;
    uart_buffer[1] = SCC8660_FLEXIO_SET_BRIGHT;
    uart_buffer[2] = data >> 8;
    uart_buffer[3] = (uint8)data;

    uart_write_buffer(SCC8660_FLEXIO_COF_UART, uart_buffer, 4);

    do
    {
        if(3 <= fifo_used(&camera_receiver_fifo))
        {
            uart_buffer_index = 3;
            fifo_read_buffer(&camera_receiver_fifo, uart_buffer, &uart_buffer_index, FIFO_READ_AND_CLEAN);
            temp = uart_buffer[1] << 8 | uart_buffer[2];
            break;
        }
        system_delay_ms(1);
    }while(SCC8660_FLEXIO_INIT_TIMEOUT > timeout_count ++);
    if((temp != data) || (SCC8660_FLEXIO_INIT_TIMEOUT <= timeout_count))
    {
        return_state = 1;
    }
    return return_state;
}

//-------------------------------------------------------------------------------------------------------------------
//      ðƽ
// ˵     data            Ҫõֵ
// ز     uint8           1-ʧ 0-ɹ
// ʹʾ     scc8660_flexio_set_white_balance(data);                // øúǰȳʼͷô
// עϢ     ͨúõĲᱻ51Ƭ
//-------------------------------------------------------------------------------------------------------------------
uint8 scc8660_flexio_set_white_balance (uint16 data)
{
    uint8 return_state = 0;
    uint8  uart_buffer[4];
    uint16 temp;
    uint16 timeout_count = 0;
    uint32 uart_buffer_index = 0;

    uart_buffer[0] = 0xA5;
    uart_buffer[1] = SCC8660_FLEXIO_SET_MANUAL_WB;
    uart_buffer[2] = data >> 8;
    uart_buffer[3] = (uint8)data;

    uart_write_buffer(SCC8660_FLEXIO_COF_UART, uart_buffer, 4);

    do
    {
        if(3 <= fifo_used(&camera_receiver_fifo))
        {
            uart_buffer_index = 3;
            fifo_read_buffer(&camera_receiver_fifo, uart_buffer, &uart_buffer_index, FIFO_READ_AND_CLEAN);
            temp = uart_buffer[1] << 8 | uart_buffer[2];
            break;
        }
        system_delay_ms(1);
    }while(SCC8660_FLEXIO_INIT_TIMEOUT > timeout_count ++);
    if((temp != data) || (SCC8660_FLEXIO_INIT_TIMEOUT <= timeout_count))
    {
        return_state = 1;
    }
    return return_state;
}

//-------------------------------------------------------------------------------------------------------------------
//      ͷڲĴд
// ˵     addr            ͷڲĴַ
// ˵     data            Ҫд
// ز     uint8           1-ʧ 0-ɹ
// ʹʾ     scc8660_flexio_set_reg(addr, data);                    // øúǰȳʼ
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
uint8 scc8660_flexio_set_reg (uint8 addr, uint16 data)
{
    uint8 return_state = 0;
    uint8  uart_buffer[4];
    uint16 temp;
    uint16 timeout_count = 0;
    uint32 uart_buffer_index = 0;

    uart_buffer[0] = 0xA5;
    uart_buffer[1] = SCC8660_FLEXIO_SET_REG_ADDR;
    uart_buffer[2] = 0x00;
    uart_buffer[3] = (uint8)addr;
    uart_write_buffer(SCC8660_FLEXIO_COF_UART, uart_buffer, 4);

    system_delay_ms(10);
    uart_buffer[0] = 0xA5;
    uart_buffer[1] = SCC8660_FLEXIO_SET_REG_DATA;
    temp           = data;
    uart_buffer[2] = temp >> 8;
    uart_buffer[3] = (uint8)temp;
    uart_write_buffer(SCC8660_FLEXIO_COF_UART, uart_buffer, 4);

    do
    {
        if(3 <= fifo_used(&camera_receiver_fifo))
        {
            uart_buffer_index = 3;
            fifo_read_buffer(&camera_receiver_fifo, uart_buffer, &uart_buffer_index, FIFO_READ_AND_CLEAN);
            temp = uart_buffer[1] << 8 | uart_buffer[2];
            break;
        }
        system_delay_ms(1);
    }while(SCC8660_FLEXIO_INIT_TIMEOUT > timeout_count ++);
    if((temp != data) || (SCC8660_FLEXIO_INIT_TIMEOUT <= timeout_count))
    {
        return_state = 1;
    }
    return return_state;
}

//-------------------------------------------------------------------------------------------------------------------
//  @brief      SCC8660 ͷжϺ
//  @param      NULL
//  @return     void					
//  @since      v1.0
//  Sample usage:	
//  @note       úISRļ 5жϳ򱻵
//-------------------------------------------------------------------------------------------------------------------
static void scc8660_flexio_uart_callback(void)
{
    uint8 data = 0;
    uart_query_byte(SCC8660_FLEXIO_COF_UART, &data);
    
    if(0xA5 == data)
    {
        fifo_clear(&camera_receiver_fifo);
    }
    
    fifo_write_element(&camera_receiver_fifo, data);
}

//-------------------------------------------------------------------------------------------------------------------
//  @brief      SCC8660 ͷɼжϺ
//  @param      NULL
//  @return     void					
//  @since      v1.0
//  Sample usage:	
//  @note       úisr.cеCSI_IRQHandler
//-------------------------------------------------------------------------------------------------------------------
static void scc8660_flexio_vsync_callback(void)
{
    if(exti_flag_get(SCC8660_FLEXIO_VSYNC_PIN))
    {
        exti_flag_clear(SCC8660_FLEXIO_VSYNC_PIN);
        flexio_csi_dma_restart((uint8 *)scc8660_flexio_image[0]);
    }
}

//-------------------------------------------------------------------------------------------------------------------
//  @brief      SCC8660 ͷDMAж
//  @param      NULL
//  @return     void			
//  @since      v1.0
//  Sample usage:				
//-------------------------------------------------------------------------------------------------------------------
static void scc8660_flexio_dma_callback(edma_handle_t *handle, void *param, bool transferDone, uint32_t tcds)
{
    // һͼӲɼʼɼʱ3.8MS(50FPS188*120ֱ)
	scc8660_flexio_finish_flag = 1; 
}

//-------------------------------------------------------------------------------------------------------------------
//      SCC8660 ͷʼ
// ˵     void
// ز     uint8           1-ʧ 0-ɹ
// ʹʾ     scc8660_flexio_init();
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
uint8 scc8660_flexio_init (void)
{
    uint8 return_state = 0;
    
    set_flexio_camera_type(CAMERA_COLOR, &scc8660_flexio_vsync_callback, NULL, &scc8660_flexio_uart_callback);                                              // ͷ
    camera_fifo_init();
    
    // ʼ ͷ
    uart_init(SCC8660_FLEXIO_COF_UART, SCC8660_FLEXIO_COF_BAUR, SCC8660_FLEXIO_COF_UART_RX, SCC8660_FLEXIO_COF_UART_TX);
    uart_rx_interrupt(SCC8660_FLEXIO_COF_UART, 1);
    system_delay_ms(200);

    fifo_clear(&camera_receiver_fifo);

    scc8660_flexio_get_version();                                                      // ȡõķʽ

    do
    {
        if(scc8660_flexio_set_config(scc8660_flexio_set_confing_buffer))
        {
            // ˶Ϣ ʾλ
            // ôǴͨųʱ˳
            // һ½û ûܾǻ
            zf_log(0, "SCC8660 set config error.");
            set_flexio_camera_type(NO_CAMERE, NULL, NULL, NULL);
            return_state = 1;
            break;
        }

        // ȡñڲ鿴Ƿȷ
        if(scc8660_flexio_get_config(scc8660_flexio_get_confing_buffer))
        {
            // ˶Ϣ ʾλ
            // ôǴͨųʱ˳
            // һ½û ûܾǻ
            zf_log(0, "SCC8660 get config error.");
            set_flexio_camera_type(NO_CAMERE, NULL, NULL, NULL);
            return_state = 1;
            break;
        }
        
        flexio_csi_init(SCC8660_FLEXIO_DATA_PIN, SCC8660_FLEXIO_PCLK_PIN, SCC8660_FLEXIO_HREF_PIN, SCC8660_FLEXIO_W * 2, SCC8660_FLEXIO_H, (uint8 *)scc8660_flexio_image[0], scc8660_flexio_dma_callback);
        flexio_csi_enable_rxdma();
        NVIC_SetPriority(DMA0_DMA16_IRQn, 1);                   // DMAжȼ Χ0-15 ԽСȼԽ
        interrupt_enable(DMA0_DMA16_IRQn);
        
        //óж
        exti_init(SCC8660_FLEXIO_VSYNC_PIN, EXTI_TRIGGER_FALLING);
        NVIC_SetPriority(SCC8660_FLEXIO_VSYNC_IRQN, 0);         // óжȼ Χ0-15 ԽСȼԽ
    }while(0);

    return return_state;
}
