/*********************************************************************************************************************
* RT1064DVL6A Opensourec Library RT1064DVL6A Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
* 
* ļ RT1064DVL6A Դһ
* 
* RT1064DVL6A Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
* 
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
* 
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
* 
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
* 
* ļ          zf_device_mt9v03x_flexio
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           IAR 8.32.4 or MDK 5.33
* ƽ̨          RT1064DVL6A
*           https://seekfree.taobao.com/
* 
* ޸ļ¼
*                               ע
* 2022-09-21        SeekFree            first version
********************************************************************************************************************/
/*********************************************************************************************************************
* ߶壺
*                   ------------------------------------
*                   ģܽ            Ƭܽ
*                   TXD                 鿴 zf_device_mt9v03x_flexio.h  MT9V03X_FLEXIO_COF_UART_TX 궨
*                   RXD                 鿴 zf_device_mt9v03x_flexio.h  MT9V03X_FLEXIO_COF_UART_RX 궨
*                   PCLK                鿴 zf_device_mt9v03x_flexio.h  MT9V03X_FLEXIO_PCLK_PIN 궨
*                   VSY                 鿴 zf_device_mt9v03x_flexio.h  MT9V03X_FLEXIO_VSYNC_PIN 궨
*                   D0-D7               鿴 zf_device_mt9v03x_flexio.h  MT9V03X_FLEXIO_DATA_PIN 궨 Ӹö忪ʼ˸
*                   VCC                 3.3VԴ
*                   GND                 Դ
*                   
*                   ------------------------------------
********************************************************************************************************************/

#ifndef _zf_device_mt9v03x_flexio_h_
#define _zf_device_mt9v03x_flexio_h_

#include "zf_common_typedef.h"

//--------------------------------------------------------------------------------------------------
// 
//--------------------------------------------------------------------------------------------------
#define MT9V03X_FLEXIO_COF_UART        (UART_4     )                            // ͷʹõĴ
#define MT9V03X_FLEXIO_COF_BAUR        (9600       )                            // ôڲ
#define MT9V03X_FLEXIO_COF_UART_TX     (UART4_RX_C17)                           //  UART-TX  ҪڵƬ RX 
#define MT9V03X_FLEXIO_COF_UART_RX     (UART4_TX_C16)                           //  UART-RX  ҪڵƬ TX 

#define MT9V03X_FLEXIO_COF_IIC_DELAY   (800)                                    //  IIC ʱ
#define MT9V03X_FLEXIO_COF_IIC_SCL     (C17)                                    //  IIC-SCL 
#define MT9V03X_FLEXIO_COF_IIC_SDA     (C16)                                    //  IIC-SDA 

#define MT9V03X_FLEXIO_DMA_CH           (DMA_CH0)                               // ͷDMAɼͨ

#define MT9V03X_FLEXIO_VSYNC_PIN        C7                                      // ж
#define MT9V03X_FLEXIO_VSYNC_IRQN       GPIO2_Combined_0_15_IRQn                // жϺ
    
    
#define MT9V03X_FLEXIO_DATA_PIN         FLEXIO2_D08_C8                          // D0  D0ΪFLEXIO2_D08_C8 ôD1ʹõΪFLEXIO2_D09_C9
#define MT9V03X_FLEXIO_PCLK_PIN         FLEXIO2_D05_C5                          // ʱ
#define MT9V03X_FLEXIO_HREF_PIN         FLEXIO2_D06_C6                          // ź


#define MT9V03X_FLEXIO_INIT_TIMEOUT    (0x0080)                                 // Ĭϵͷʼʱʱ Ϊλ

//--------------------------------------------------------------------------------------------------
// ͷĬϲ ڴ޸ͷ
//--------------------------------------------------------------------------------------------------
#define MT9V03X_FLEXIO_W               (188)                                    // ͼ     Χ [1-752]
#define MT9V03X_FLEXIO_H               (120)                                    // ͼ߶     Χ [1-480]
#define MT9V03X_FLEXIO_IMAGE_SIZE      (MT9V03X_W * MT9V03X_H)                  // 
    
#define MT9V03X_FLEXIO_AUTO_EXP_DEF    (0  )                                    // Զع     ĬϲԶع  Χ [0-63] 0Ϊر
                                                                                //                  Զع⿪  EXP_TIMEԶعʱ
                                                                                //                  һǲҪԶع ߷ǳȵԳԶع⣬ͼȶ
#define MT9V03X_FLEXIO_EXP_TIME_DEF    (512)                                    // عʱ         ͷյԶعʱ䣬ùΪعֵ
#define MT9V03X_FLEXIO_FPS_DEF         (50 )                                    // ͼ֡         ͷյԶFPSΪFPS
#define MT9V03X_FLEXIO_LR_OFFSET_DEF   (0  )                                    // ͼƫ   ֵ ƫ   ֵ ƫ  Ϊ188 376 752ʱ޷ƫ
                                                                                //                  ͷƫݺԶƫƣüƫ
#define MT9V03X_FLEXIO_UD_OFFSET_DEF   (0  )                                    // ͼƫ   ֵ ƫ   ֵ ƫ  Ϊ120 240 480ʱ޷ƫ
                                                                                //                  ͷƫݺԶƫƣüƫ
#define MT9V03X_FLEXIO_GAIN_DEF        (32 )                                    // ͼ         Χ [16-64]  عʱ̶¸ıͼ̶
#define MT9V03X_FLEXIO_PCLK_MODE_DEF   (0  )                                    // ʱģʽ     Χ [0-1]    Ĭϣ0 ѡΪ[0ź,1ź]
                                                                                //                  ͨΪ0ʹCH32V307DVPӿڻSTM32DCMIӿڲɼҪΪ1
                                                                                //                   MT9V034 V1.5 Լϰ汾ָ֧

// ͷö
typedef enum
{
    MT9V03X_FLEXIO_INIT = 0,                                                    // ͷʼ
    MT9V03X_FLEXIO_AUTO_EXP,                                                    // Զع
    MT9V03X_FLEXIO_EXP_TIME,                                                    // عʱ
    MT9V03X_FLEXIO_FPS,                                                         // ͷ֡
    MT9V03X_FLEXIO_SET_COL,                                                     // ͼ
    MT9V03X_FLEXIO_SET_ROW,                                                     // ͼ
    MT9V03X_FLEXIO_LR_OFFSET,                                                   // ͼƫ
    MT9V03X_FLEXIO_UD_OFFSET,                                                   // ͼƫ
    MT9V03X_FLEXIO_GAIN,                                                        // ͼƫ
    MT9V03X_FLEXIO_PCLK_MODE,                                                   // ʱģʽ(MT9V034 V1.5Լϰ汾ָ֧)
    MT9V03X_FLEXIO_CONFIG_FINISH,                                               // λҪռλ
    
    MT9V03X_FLEXIO_COLOR_GET_WHO_AM_I = 0xEF,   
    MT9V03X_FLEXIO_SET_EXP_TIME = 0XF0,                                         // عʱ
    MT9V03X_FLEXIO_GET_STATUS,                                                  // ȡͷ
    MT9V03X_FLEXIO_GET_VERSION,                                                 // ̼汾
    
    MT9V03X_FLEXIO_SET_ADDR = 0XFE,                                             // Ĵַ
    MT9V03X_FLEXIO_SET_DATA                                                     // Ĵ
}m9v03x_flexio_cmd_enum;

// ͷӿö
typedef enum
{
    MT9V03X_FLEXIO_UART,
    MT9V03X_FLEXIO_SCCB,
}m9v03x_flexio_type_enum;

extern vuint8   mt9v03x_flexio_finish_flag;                                     // һͼɼɱ־λ
extern uint8    mt9v03x_flexio_image[MT9V03X_FLEXIO_H][MT9V03X_FLEXIO_W];

uint16      mt9v03x_flexio_get_version         (void);
uint8       mt9v03x_flexio_set_exposure_time   (uint16 light);
uint8       mt9v03x_flexio_set_reg             (uint8 addr, uint16 data);

// RT1064˵ӿڶԲɼͷһCSIӿ һFLEXIOӿ
// ֻҪʹһͷʱƼʹCSIӿڲɼͷҲǵmt9v03x_initʼͷ
// ҪɼͷʱԷֱmt9v03x_init  mt9v03x_flexio_initʼͷ
uint8       mt9v03x_flexio_init                (void);

#endif
