/*********************************************************************************************************************
* RT1064DVL6A Opensourec Library RT1064DVL6A Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
* 
* ļ RT1064DVL6A Դһ
* 
* RT1064DVL6A Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
* 
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
* 
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
* 
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
* 
* ļ          zf_device_mt9v03x_flexio
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           IAR 8.32.4 or MDK 5.33
* ƽ̨          RT1064DVL6A
*           https://seekfree.taobao.com/
* 
* ޸ļ¼
*                               ע
* 2022-09-21        SeekFree            first version
********************************************************************************************************************/
/*********************************************************************************************************************
* ߶壺
*                   ------------------------------------
*                   ģܽ            Ƭܽ
*                   TXD                 鿴 zf_device_mt9v03x_flexio.h  MT9V03X_FLEXIO_COF_UART_TX 궨
*                   RXD                 鿴 zf_device_mt9v03x_flexio.h  MT9V03X_FLEXIO_COF_UART_RX 궨
*                   PCLK                鿴 zf_device_mt9v03x_flexio.h  MT9V03X_FLEXIO_PCLK_PIN 궨
*                   VSY                 鿴 zf_device_mt9v03x_flexio.h  MT9V03X_FLEXIO_VSYNC_PIN 궨
*                   D0-D7               鿴 zf_device_mt9v03x_flexio.h  MT9V03X_FLEXIO_DATA_PIN 궨 Ӹö忪ʼ˸
*                   VCC                 3.3VԴ
*                   GND                 Դ
*                   
*                   ------------------------------------
********************************************************************************************************************/

#include "zf_common_debug.h"
#include "zf_common_interrupt.h"
#include "zf_driver_delay.h"
#include "zf_driver_exti.h"
#include "zf_driver_gpio.h"
#include "zf_driver_uart.h"
#include "zf_driver_soft_iic.h"
#include "zf_device_camera.h"
#include "zf_device_type.h"
#include "zf_driver_flexio_csi.h"
#include "zf_device_config.h"

#include "zf_device_mt9v03x_flexio.h"

vuint8  mt9v03x_flexio_finish_flag = 0;                                               	// һͼɼɱ־λ

AT_DTCM_SECTION_ALIGN(uint8 mt9v03x_flexio_image[MT9V03X_FLEXIO_H][MT9V03X_FLEXIO_W], 4);

static m9v03x_flexio_type_enum mt9v03x_flexio_type;  
static  uint16    mt9v03x_flexio_version = 0x00;

// Ҫõͷ ޸Ĳ
static int16 mt9v03x_flexio_set_confing_buffer[MT9V03X_FLEXIO_CONFIG_FINISH][2]=
{
    {MT9V03X_FLEXIO_INIT,              0},                                              // ͷʼʼ

    {MT9V03X_FLEXIO_AUTO_EXP,          MT9V03X_FLEXIO_AUTO_EXP_DEF},                    // Զع
    {MT9V03X_FLEXIO_EXP_TIME,          MT9V03X_FLEXIO_EXP_TIME_DEF},                    // عʱ
    {MT9V03X_FLEXIO_FPS,               MT9V03X_FLEXIO_FPS_DEF},                         // ͼ֡
    {MT9V03X_FLEXIO_SET_COL,           MT9V03X_FLEXIO_W},                               // ͼ
    {MT9V03X_FLEXIO_SET_ROW,           MT9V03X_FLEXIO_H},                               // ͼ
    {MT9V03X_FLEXIO_LR_OFFSET,         MT9V03X_FLEXIO_LR_OFFSET_DEF},                   // ͼƫ
    {MT9V03X_FLEXIO_UD_OFFSET,         MT9V03X_FLEXIO_UD_OFFSET_DEF},                   // ͼƫ
    {MT9V03X_FLEXIO_GAIN,              MT9V03X_FLEXIO_GAIN_DEF},                        // ͼ
    {MT9V03X_FLEXIO_PCLK_MODE,         MT9V03X_FLEXIO_PCLK_MODE_DEF},                   // ʱģʽ
};

// ͷڲȡ ޸Ĳ
static int16 mt9v03x_flexio_get_confing_buffer[MT9V03X_FLEXIO_CONFIG_FINISH - 1][2]=
{
    {MT9V03X_FLEXIO_AUTO_EXP,          0},                                              // Զع
    {MT9V03X_FLEXIO_EXP_TIME,          0},                                              // عʱ
    {MT9V03X_FLEXIO_FPS,               0},                                              // ͼ֡
    {MT9V03X_FLEXIO_SET_COL,           0},                                              // ͼ
    {MT9V03X_FLEXIO_SET_ROW,           0},                                              // ͼ
    {MT9V03X_FLEXIO_LR_OFFSET,         0},                                              // ͼƫ
    {MT9V03X_FLEXIO_UD_OFFSET,         0},                                              // ͼƫ
    {MT9V03X_FLEXIO_GAIN,              0},                                              // ͼ
    {MT9V03X_FLEXIO_PCLK_MODE,         0},                                              // ʱģʽ PCLKģʽ <  MT9V034 V1.5 Լϰ汾ָ֧ >
};

//-------------------------------------------------------------------------------------------------------------------
//      ͷڲϢ
// ˵     buff            Ϣĵַ
// ز     uint8           1-ʧ 0-ɹ
// ʹʾ     mt9v03x_flexio_set_config(mt9v03x_set_confing_buffer);
// עϢ     ڲ
//-------------------------------------------------------------------------------------------------------------------
static uint8 mt9v03x_flexio_set_config (int16 buff[MT9V03X_FLEXIO_CONFIG_FINISH][2])
{
    uint8 return_state = 1;
    uint8  uart_buffer[4];
    uint16 temp;
    uint16 timeout_count = 0;
    uint32 loop_count = 0;
    uint32 uart_buffer_index = 0;

    switch(mt9v03x_flexio_version)
    {
        case 0x0230:    loop_count = MT9V03X_FLEXIO_PCLK_MODE;  break;
        default:        loop_count = MT9V03X_FLEXIO_GAIN;       break;
    }
    // ò  οֲ
    // ʼͷ³ʼ
    for(; loop_count < MT9V03X_FLEXIO_SET_DATA; loop_count --)
    {
        uart_buffer[0] = 0xA5;
        uart_buffer[1] = buff[loop_count][0];
        temp = buff[loop_count][1];
        uart_buffer[2] = temp >> 8;
        uart_buffer[3] = (uint8)temp;
        uart_write_buffer(MT9V03X_FLEXIO_COF_UART, uart_buffer, 4);

        system_delay_ms(2);
    }

    do
    {
        if(3 <= fifo_used(&camera_receiver_fifo))
        {
            uart_buffer_index = 3;
            fifo_read_buffer(&camera_receiver_fifo, uart_buffer, &uart_buffer_index, FIFO_READ_AND_CLEAN);
            if((0xff == uart_buffer[1]) || (0xff == uart_buffer[2]))
            {
                return_state = 0;
                break;
            }
        }
        system_delay_ms(1);
    }while(MT9V03X_FLEXIO_INIT_TIMEOUT > timeout_count ++);
    // ϲֶͷõȫᱣͷ51Ƭeeprom
    // set_exposure_timeõعݲ洢eeprom
    return return_state;
}

//-------------------------------------------------------------------------------------------------------------------
//      ȡͷڲϢ
// ˵     buff            Ϣĵַ
// ز     uint8           1-ʧ 0-ɹ
// ʹʾ     mt9v03x_flexio_get_config(mt9v03x_flexio_get_confing_buffer);
// עϢ     ڲ
//-------------------------------------------------------------------------------------------------------------------
static uint8 mt9v03x_flexio_get_config (int16 buff[MT9V03X_FLEXIO_CONFIG_FINISH - 1][2])
{
    uint8 return_state = 0;
    uint8  uart_buffer[4];
    uint16 temp;
    uint16 timeout_count = 0;
    uint32 loop_count = 0;
    uint32 uart_buffer_index = 0;

    switch(mt9v03x_flexio_version)
    {
        case 0x0230:    loop_count = MT9V03X_FLEXIO_PCLK_MODE;  break;
        default:        loop_count = MT9V03X_FLEXIO_GAIN;       break;
    }

    for(loop_count = loop_count - 1; loop_count >= 1; loop_count --)
    {
        if(mt9v03x_flexio_version < 0x0230 && buff[loop_count][0] == MT9V03X_FLEXIO_PCLK_MODE)
        {
            continue;
        }
        uart_buffer[0] = 0xA5;
        uart_buffer[1] = MT9V03X_FLEXIO_GET_STATUS;
        temp = buff[loop_count][0];
        uart_buffer[2] = temp >> 8;
        uart_buffer[3] = (uint8)temp;
        uart_write_buffer(MT9V03X_FLEXIO_COF_UART, uart_buffer, 4);

        timeout_count = 0;    
        do
        {
            if(3 <= fifo_used(&camera_receiver_fifo))
            {
                uart_buffer_index = 3;
                fifo_read_buffer(&camera_receiver_fifo, uart_buffer, &uart_buffer_index, FIFO_READ_AND_CLEAN);
                buff[loop_count][1] = uart_buffer[1] << 8 | uart_buffer[2];
                break;
            }
            system_delay_ms(1);
        }while(MT9V03X_FLEXIO_INIT_TIMEOUT > timeout_count ++);
        if(timeout_count > MT9V03X_FLEXIO_INIT_TIMEOUT)                                // ʱ
        {
            return_state = 1;
            break;
        }
    }
    return return_state;
}

//-------------------------------------------------------------------------------------------------------------------
//      ȡͷ̼汾
// ˵     void
// ز     uint16          0-ȡ N-汾
// ʹʾ     mt9v03x_flexio_get_version();                          // øúǰȳʼ
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
uint16 mt9v03x_flexio_get_version (void)
{
    uint16 temp;
    uint8  uart_buffer[4];
    uint16 timeout_count = 0;
    uint16 return_value = 0;
    uint32 uart_buffer_index = 0;

    uart_buffer[0] = 0xA5;
    uart_buffer[1] = MT9V03X_FLEXIO_GET_STATUS;
    temp = MT9V03X_FLEXIO_GET_VERSION;
    uart_buffer[2] = temp >> 8;
    uart_buffer[3] = (uint8)temp;
    uart_write_buffer(MT9V03X_FLEXIO_COF_UART, uart_buffer, 4);

    do
    {
        if(3 <= fifo_used(&camera_receiver_fifo))
        {
            uart_buffer_index = 3;
            fifo_read_buffer(&camera_receiver_fifo, uart_buffer, &uart_buffer_index, FIFO_READ_AND_CLEAN);
            return_value = uart_buffer[1] << 8 | uart_buffer[2];
            break;
        }
        system_delay_ms(1);
    }while(MT9V03X_FLEXIO_INIT_TIMEOUT > timeout_count ++);
    return return_value;
}

//-------------------------------------------------------------------------------------------------------------------
//      ͷعʱ
// ˵     light           趨عʱ
// ز     uint8           1-ʧ 0-ɹ
// ʹʾ     mt9v03x_flexio_set_exposure_time(100);                 // øúǰȳʼ
// עϢ     عʱԽͼԽ
//              ͷյݷֱʼFPSعʱõݹ
//              ôͷֵ
//-------------------------------------------------------------------------------------------------------------------
uint8 mt9v03x_flexio_set_exposure_time (uint16 light)
{
    uint8 return_state = 0;
    if(MT9V03X_FLEXIO_UART == mt9v03x_flexio_type)
    {
        uint8  uart_buffer[4];
        uint16 temp;
        uint16 timeout_count = 0;
        uint32 uart_buffer_index = 0;

        uart_buffer[0] = 0xA5;
        uart_buffer[1] = MT9V03X_FLEXIO_SET_EXP_TIME;
        temp = light;
        uart_buffer[2] = temp >> 8;
        uart_buffer[3] = (uint8)temp;
        uart_write_buffer(MT9V03X_FLEXIO_COF_UART, uart_buffer, 4);

        do
        {
            if(3 <= fifo_used(&camera_receiver_fifo))
            {
                uart_buffer_index = 3;
                fifo_read_buffer(&camera_receiver_fifo, uart_buffer, &uart_buffer_index, FIFO_READ_AND_CLEAN);
                temp = uart_buffer[1] << 8 | uart_buffer[2];
                break;
            }
            system_delay_ms(1);
        }while(MT9V03X_FLEXIO_INIT_TIMEOUT > timeout_count ++);
        if((temp != light) || (MT9V03X_FLEXIO_INIT_TIMEOUT <= timeout_count))
        {
            return_state = 1;
        }
    }
    else
    {
        return_state = mt9v03x_set_exposure_time_sccb(light);
    }   
    return return_state;
}

//-------------------------------------------------------------------------------------------------------------------
//      ͷڲĴд
// ˵     addr            ͷڲĴַ
// ˵     data            Ҫд
// ز     uint8           1-ʧ 0-ɹ
// ʹʾ     mt9v03x_flexio_set_reg(addr, data);                    // øúǰȳʼ
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
uint8 mt9v03x_flexio_set_reg (uint8 addr, uint16 data)
{
    uint8 return_state = 0;
    if(MT9V03X_FLEXIO_UART == mt9v03x_flexio_type)
    {
        uint8  uart_buffer[4];
        uint16 temp;
        uint16 timeout_count = 0;
        uint32 uart_buffer_index = 0;

        uart_buffer[0] = 0xA5;
        uart_buffer[1] = MT9V03X_FLEXIO_SET_ADDR;
        temp = addr;
        uart_buffer[2] = temp >> 8;
        uart_buffer[3] = (uint8)temp;
        uart_write_buffer(MT9V03X_FLEXIO_COF_UART, uart_buffer, 4);

        system_delay_ms(10);
        uart_buffer[0] = 0xA5;
        uart_buffer[1] = MT9V03X_FLEXIO_SET_DATA;
        temp = data;
        uart_buffer[2] = temp >> 8;
        uart_buffer[3] = (uint8)temp;
        uart_write_buffer(MT9V03X_FLEXIO_COF_UART, uart_buffer, 4);

        do
        {
            if(3 <= fifo_used(&camera_receiver_fifo))
            {
                uart_buffer_index = 3;
                fifo_read_buffer(&camera_receiver_fifo, uart_buffer, &uart_buffer_index, FIFO_READ_AND_CLEAN);
                temp = uart_buffer[1] << 8 | uart_buffer[2];
                break;
            }
            system_delay_ms(1);
        }while(MT9V03X_FLEXIO_INIT_TIMEOUT > timeout_count ++);
        if((temp != data) || (MT9V03X_FLEXIO_INIT_TIMEOUT <= timeout_count))
        {
            return_state = 1;
        }
    }
    else
    {
        return_state = mt9v03x_set_reg_sccb(addr, data);
    }
    return return_state;
}

//-------------------------------------------------------------------------------------------------------------------
//  @brief      MT9V03XͷжϺ
//  @param      NULL
//  @return     void					
//  @since      v1.0
//  Sample usage:	
//  @note       úISRļ 5жϳ򱻵
//-------------------------------------------------------------------------------------------------------------------
static void mt9v03x_flexio_uart_callback(void)
{
    uint8 data = 0;
    uart_query_byte(MT9V03X_FLEXIO_COF_UART, &data);
    
    if(0xA5 == data)
    {
        fifo_clear(&camera_receiver_fifo);
    }
    
    fifo_write_element(&camera_receiver_fifo, data);
}

//-------------------------------------------------------------------------------------------------------------------
//  @brief      MT9V03XͷɼжϺ
//  @param      NULL
//  @return     void					
//  @since      v1.0
//  Sample usage:	
//  @note       úisr.cеCSI_IRQHandler
//-------------------------------------------------------------------------------------------------------------------
static void mt9v03x_flexio_vsync_callback(void)
{
    if(exti_flag_get(MT9V03X_FLEXIO_VSYNC_PIN))
    {
        exti_flag_clear(MT9V03X_FLEXIO_VSYNC_PIN);
        flexio_csi_dma_restart(mt9v03x_flexio_image[0]);
    }
}

//-------------------------------------------------------------------------------------------------------------------
//  @brief      MT9V03XͷDMAж
//  @param      NULL
//  @return     void			
//  @since      v1.0
//  Sample usage:				
//-------------------------------------------------------------------------------------------------------------------
static void mt9v03x_flexio_dma_callback(edma_handle_t *handle, void *param, bool transferDone, uint32_t tcds)
{
    // һͼӲɼʼɼʱ3.8MS(50FPS188*120ֱ)
	mt9v03x_flexio_finish_flag = 1; 
}

//-------------------------------------------------------------------------------------------------------------------
//      MT9V03X ͷʼ
// ˵     void
// ز     uint8           1-ʧ 0-ɹ
// ʹʾ     zf_log(mt9v03x_init(), "mt9v03x init error");
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
uint8 mt9v03x_flexio_init (void)
{
    uint8 return_state = 0;
    soft_iic_info_struct mt9v03x_flexio_iic_struct;
    do
    {
        system_delay_ms(200);
        set_flexio_camera_type(CAMERA_GRAYSCALE, &mt9v03x_flexio_vsync_callback, NULL, &mt9v03x_flexio_uart_callback);              // ͷ
        
        // ȳSCCBͨѶ
        mt9v03x_flexio_type = MT9V03X_FLEXIO_SCCB;
        soft_iic_init(&mt9v03x_flexio_iic_struct, 0, MT9V03X_FLEXIO_COF_IIC_DELAY, MT9V03X_FLEXIO_COF_IIC_SCL, MT9V03X_FLEXIO_COF_IIC_SDA);
        if(mt9v03x_set_config_sccb(&mt9v03x_flexio_iic_struct, mt9v03x_flexio_set_confing_buffer))
        {
            // SCCBͨѶʧܣԴͨѶ
            mt9v03x_flexio_type = MT9V03X_FLEXIO_UART;
            camera_fifo_init();
            set_camera_type(CAMERA_GRAYSCALE, NULL, NULL, &mt9v03x_flexio_uart_callback);   // ͷ
            uart_init (MT9V03X_FLEXIO_COF_UART, MT9V03X_FLEXIO_COF_BAUR, MT9V03X_FLEXIO_COF_UART_RX, MT9V03X_FLEXIO_COF_UART_TX);   //ʼ ͷ    
            uart_rx_interrupt(MT9V03X_FLEXIO_COF_UART, 1);
            fifo_clear(&camera_receiver_fifo);
            mt9v03x_flexio_version = mt9v03x_flexio_get_version();                          // ȡõķʽ
            
            if(mt9v03x_flexio_set_config(mt9v03x_flexio_set_confing_buffer))
            {
                // ˶Ϣ ʾλ
                // ôͨųʱ˳
                // һ½û ûܾǻ
                zf_log(0, "MT9V03X FLEXIO set config error.");
                set_camera_type(NO_CAMERE, NULL, NULL, NULL);
                return_state = 1;
                break;
            }
            
            // ȡñڲ鿴Ƿȷ
            if(mt9v03x_flexio_get_config(mt9v03x_flexio_get_confing_buffer))
            {
                // ˶Ϣ ʾλ
                // ôǴͨųʱ˳
                // һ½û ûܾǻ
                zf_log(0, "MT9V03X FLEXIO get config error.");
                set_camera_type(NO_CAMERE, NULL, NULL, NULL);
                return_state = 1;
                break;
            }
        }

        flexio_csi_init(MT9V03X_FLEXIO_DATA_PIN, MT9V03X_FLEXIO_PCLK_PIN, MT9V03X_FLEXIO_HREF_PIN, MT9V03X_FLEXIO_W, MT9V03X_FLEXIO_H, mt9v03x_flexio_image[0], mt9v03x_flexio_dma_callback);
        flexio_csi_enable_rxdma();
        NVIC_SetPriority(DMA0_DMA16_IRQn, 1);                   // DMAжȼ Χ0-15 ԽСȼԽ
        interrupt_enable(DMA0_DMA16_IRQn);
        
        //óж
        exti_init(MT9V03X_FLEXIO_VSYNC_PIN, EXTI_TRIGGER_FALLING);
        NVIC_SetPriority(MT9V03X_FLEXIO_VSYNC_IRQN, 0);         // óжȼ Χ0-15 ԽСȼԽ
        
    }while(0);

    return return_state;
}
