/*********************************************************************************************************************
* RT1064DVL6A Opensourec Library RT1064DVL6A Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
* 
* ļ RT1064DVL6A Դһ
* 
* RT1064DVL6A Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
* 
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
* 
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
* 
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
* 
* ļ          zf_device_imu963ra
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           IAR 8.32.4 or MDK 5.33
* ƽ̨          RT1064DVL6A
*           https://seekfree.taobao.com/
* 
* ޸ļ¼
*                               ע
* 2022-09-21        SeekFree            first version
********************************************************************************************************************/
/*********************************************************************************************************************
* ߶壺
*                   ------------------------------------
*                   ģܽ            Ƭܽ
*                   // Ӳ SPI 
*                   SCL/SPC             鿴 zf_device_imu963ra.h  IMU963RA_SPC_PIN 궨
*                   SDA/DSI             鿴 zf_device_imu963ra.h  IMU963RA_SDI_PIN 궨
*                   SA0/SDO             鿴 zf_device_imu963ra.h  IMU963RA_SDO_PIN 궨
*                   CS                  鿴 zf_device_imu963ra.h  IMU963RA_CS_PIN  궨
*                   VCC                 3.3VԴ
*                   GND                 Դ
*                   
*
*                   //  IIC 
*                   SCL/SPC             鿴 zf_device_imu963ra.h  IMU963RA_SCL_PIN 궨
*                   SDA/DSI             鿴 zf_device_imu963ra.h  IMU963RA_SDA_PIN 궨
*                   VCC                 3.3VԴ
*                   GND                 Դ
*                   
*                   ------------------------------------
********************************************************************************************************************/

#include "zf_common_clock.h"
#include "zf_common_debug.h"
#include "zf_driver_delay.h"
#include "zf_driver_spi.h"
#include "zf_driver_soft_iic.h"

#include "zf_device_imu963ra.h"

int16 imu963ra_gyro_x = 0, imu963ra_gyro_y = 0, imu963ra_gyro_z = 0;
int16 imu963ra_acc_x = 0,  imu963ra_acc_y = 0,  imu963ra_acc_z = 0;
int16 imu963ra_mag_x = 0,  imu963ra_mag_y = 0,  imu963ra_mag_z = 0;

#if IMU963RA_USE_SOFT_IIC
static soft_iic_info_struct imu963ra_iic_struct;

//-------------------------------------------------------------------------------------------------------------------
//      IMU963RA дĴ
// ˵     reg             Ĵַ
// ˵     data            
// ز     void
// ʹʾ     imu963ra_write_acc_gyro_register(IMU963RA_SLV0_CONFIG, 0x00);
// עϢ     ڲ
//-------------------------------------------------------------------------------------------------------------------
#define imu963ra_write_acc_gyro_register(reg,data)       (soft_iic_write_8bit_register(&imu963ra_iic_struct,reg,data))

//-------------------------------------------------------------------------------------------------------------------
//      IMU963RA Ĵ
// ˵     reg             Ĵַ
// ز     uint8           
// ʹʾ     imu963ra_read_acc_gyro_register(IMU963RA_STATUS_MASTER);
// עϢ     ڲ
//-------------------------------------------------------------------------------------------------------------------
#define imu963ra_read_acc_gyro_register(reg)             (soft_iic_sccb_read_register(&imu963ra_iic_struct,reg))

//-------------------------------------------------------------------------------------------------------------------
//      IMU963RA  ڲ
// ˵     reg             Ĵַ
// ˵     data            ݻ
// ˵     len             ݳ
// ز     void
// ʹʾ     imu963ra_read_acc_gyro_registers(IMU963RA_OUTX_L_A, dat, 6);
// עϢ     ڲ
//-------------------------------------------------------------------------------------------------------------------
#define imu963ra_read_acc_gyro_registers(reg,data,len)   (soft_iic_read_8bit_registers(&imu963ra_iic_struct,reg,data,len))
#else
//-------------------------------------------------------------------------------------------------------------------
//      IMU963RA дĴ
// ˵     reg             Ĵַ
// ˵     data            
// ز     void
// ʹʾ     imu963ra_write_acc_gyro_register(IMU963RA_SLV0_CONFIG, 0x00);
// עϢ     ڲ
//-------------------------------------------------------------------------------------------------------------------
static void imu963ra_write_acc_gyro_register(uint8 reg, uint8 data)
{
    IMU963RA_CS(0);
    spi_write_8bit_register(IMU963RA_SPI, reg | IMU963RA_SPI_W, data);

    IMU963RA_CS(1);
}

//-------------------------------------------------------------------------------------------------------------------
//      IMU963RA Ĵ
// ˵     reg             Ĵַ
// ز     uint8           
// ʹʾ     imu963ra_read_acc_gyro_register(IMU963RA_STATUS_MASTER);
// עϢ     ڲ
//-------------------------------------------------------------------------------------------------------------------
static uint8 imu963ra_read_acc_gyro_register(uint8 reg)
{
    uint8 data = 0;
    IMU963RA_CS(0);
    data = spi_read_8bit_register(IMU963RA_SPI, reg | IMU963RA_SPI_R);

    IMU963RA_CS(1);
    return data;
}

//-------------------------------------------------------------------------------------------------------------------
//      IMU963RA  ڲ
// ˵     reg             Ĵַ
// ˵     data            ݻ
// ˵     len             ݳ
// ز     void
// ʹʾ     imu963ra_read_acc_gyro_registers(IMU963RA_OUTX_L_A, dat, 6);
// עϢ     ڲ
//-------------------------------------------------------------------------------------------------------------------
static void imu963ra_read_acc_gyro_registers(uint8 reg, uint8 *data, uint32 len)
{
    IMU963RA_CS(0);
    spi_read_8bit_registers(IMU963RA_SPI, reg | IMU963RA_SPI_R, data, len);

    IMU963RA_CS(1);
}
#endif

//-------------------------------------------------------------------------------------------------------------------
//      IMU963RA Ϊ IIC д
// ˵     addr            Ŀַ
// ˵     reg             ĿĴ
// ˵     data            
// ز     uint8           1-ʧ 0-ɹ
// ʹʾ     imu963ra_write_mag_register(IMU963RA_MAG_ADDR, IMU963RA_MAG_CONTROL2, 0x80);
// עϢ     ڲ
//-------------------------------------------------------------------------------------------------------------------
static uint8 imu963ra_write_mag_register (uint8 addr, uint8 reg, uint8 data)
{
    uint8 return_state = 0;
    uint16 timeout_count = 0;

    addr = addr << 1;
    imu963ra_write_acc_gyro_register(IMU963RA_SLV0_CONFIG, 0x00);               // ӻ0
    imu963ra_write_acc_gyro_register(IMU963RA_SLV0_ADD, addr | 0);              // õشżƵַעҪ8λI2Cַ 0x2C
    imu963ra_write_acc_gyro_register(IMU963RA_SLV0_SUBADD, reg);                // ҪдļĴַ
    imu963ra_write_acc_gyro_register(IMU963RA_DATAWRITE_SLV0, data);            // Ҫд
    imu963ra_write_acc_gyro_register(IMU963RA_MASTER_CONFIG, 0x4C);             // ڵһͨѶ  I2Cʹ
    
    // ȴͨѶɹ
    while(0 == (0x80 & imu963ra_read_acc_gyro_register(IMU963RA_STATUS_MASTER)))
    {
        if(timeout_count ++ > IMU963RA_TIMEOUT_COUNT)
        {
            return_state = 1;
            break;
        }
        system_delay_ms(2);
    }
    return return_state;
}

//-------------------------------------------------------------------------------------------------------------------
//      IMU963RA Ϊ IIC ƶ
// ˵     addr            Ŀַ
// ˵     reg             ĿĴ
// ز     uint8           ȡ
// ʹʾ     imu963ra_read_mag_register(IMU963RA_MAG_ADDR, IMU963RA_MAG_CHIP_ID);
// עϢ     ڲ
//-------------------------------------------------------------------------------------------------------------------
static uint8 imu963ra_read_mag_register (uint8 addr, uint8 reg)
{
    uint16 timeout_count = 0;

    addr = addr << 1;
    imu963ra_write_acc_gyro_register(IMU963RA_SLV0_ADD, addr | 1);              // õشżƵַעҪ8λI2Cַ 0x2C
    imu963ra_write_acc_gyro_register(IMU963RA_SLV0_SUBADD, reg);                // ҪȡļĴַ
    imu963ra_write_acc_gyro_register(IMU963RA_SLV0_CONFIG, 0x01);    
    imu963ra_write_acc_gyro_register(IMU963RA_MASTER_CONFIG, 0x4C);             // ڵһͨѶ  I2Cʹ
    
    // ȴͨѶɹ
    while(0 == (0x01 & imu963ra_read_acc_gyro_register(IMU963RA_STATUS_MASTER)))
    {
        if(timeout_count ++ > IMU963RA_TIMEOUT_COUNT)
        {
            break;
        }
        system_delay_ms(2);
    }
    
    return (imu963ra_read_acc_gyro_register(IMU963RA_SENSOR_HUB_1));            // ضȡ
}

//-------------------------------------------------------------------------------------------------------------------
//      IMU963RA Ϊ IIC Զд
// ˵     addr            Ŀַ
// ˵     reg             ĿĴ
// ز     void
// ʹʾ     imu963ra_connect_mag(IMU963RA_MAG_ADDR, IMU963RA_MAG_OUTX_L);
// עϢ     ڲ
//-------------------------------------------------------------------------------------------------------------------
static void imu963ra_connect_mag (uint8 addr, uint8 reg)
{
    addr = addr << 1;
    
    imu963ra_write_acc_gyro_register(IMU963RA_SLV0_ADD, addr | 1);              // õشżƵַעҪ8λI2Cַ 0x2C
    imu963ra_write_acc_gyro_register(IMU963RA_SLV0_SUBADD, reg);                // ҪȡļĴַ
    imu963ra_write_acc_gyro_register(IMU963RA_SLV0_CONFIG, 0x06);    
    imu963ra_write_acc_gyro_register(IMU963RA_MASTER_CONFIG, 0x6C);             // ڵһͨѶ  I2Cʹ
}   


//-------------------------------------------------------------------------------------------------------------------
//      IMU963RA Լ ڲ
// ˵     void
// ز     uint8           1-Լʧ 0-Լɹ
// ʹʾ     imu963ra_acc_gyro_self_check();
// עϢ     ڲ
//-------------------------------------------------------------------------------------------------------------------
static uint8 imu963ra_acc_gyro_self_check (void)
{
    uint8 return_state = 0;
    uint8 dat = 0;
    uint16 timeout_count = 0;

    while(0x6B != dat)                                                          // ж ID Ƿȷ
    {
        if(timeout_count++ > IMU963RA_TIMEOUT_COUNT)
        {
            return_state = 1;
            break;
        }
        dat = imu963ra_read_acc_gyro_register(IMU963RA_WHO_AM_I);
        system_delay_ms(10);
    }
    return return_state;
}

//-------------------------------------------------------------------------------------------------------------------
//      IMU963RA Լ ڲ
// ˵     void
// ز     uint8           1-Լʧ 0-Լɹ
// ʹʾ     imu963ra_mag_self_check();
// עϢ     ڲ
//-------------------------------------------------------------------------------------------------------------------
static uint8 imu963ra_mag_self_check (void)
{
    uint8 return_state = 0;
    uint8 dat = 0;
    uint16 timeout_count = 0;

    while(0xff != dat)                                                          // ж ID Ƿȷ
    {
        if(timeout_count++ > IMU963RA_TIMEOUT_COUNT)
        {
            return_state = 1;
            break;
        }
        dat = imu963ra_read_mag_register(IMU963RA_MAG_ADDR, IMU963RA_MAG_CHIP_ID);
        system_delay_ms(10);
    }
    return return_state;
}

//-------------------------------------------------------------------------------------------------------------------
//      ȡ IMU963RA ٶȼ
// ˵     void
// ز     void
// ʹʾ     imu963ra_get_acc();
// עϢ     ִиúֱӲ鿴Ӧı
//-------------------------------------------------------------------------------------------------------------------
void imu963ra_get_acc (void)
{
    uint8 dat[6];

    imu963ra_read_acc_gyro_registers(IMU963RA_OUTX_L_A, dat, 6);
    imu963ra_acc_x = (int16)(((uint16)dat[1]<<8 | dat[0]));
    imu963ra_acc_y = (int16)(((uint16)dat[3]<<8 | dat[2]));
    imu963ra_acc_z = (int16)(((uint16)dat[5]<<8 | dat[4]));
}


//-------------------------------------------------------------------------------------------------------------------
//      ȡIMU963RA
// ˵     void
// ز     void
// ʹʾ     imu963ra_get_gyro();
// עϢ     ִиúֱӲ鿴Ӧı
//-------------------------------------------------------------------------------------------------------------------
void imu963ra_get_gyro (void)
{
    uint8 dat[6];

    imu963ra_read_acc_gyro_registers(IMU963RA_OUTX_L_G, dat, 6);
    imu963ra_gyro_x = (int16)(((uint16)dat[1]<<8 | dat[0]));
    imu963ra_gyro_y = (int16)(((uint16)dat[3]<<8 | dat[2]));
    imu963ra_gyro_z = (int16)(((uint16)dat[5]<<8 | dat[4]));
}


//-------------------------------------------------------------------------------------------------------------------
//      ȡ IMU963RA 
// ˵     void
// ز     void
// ʹʾ     imu963ra_get_mag();
// עϢ     ִиúֱӲ鿴Ӧı
//-------------------------------------------------------------------------------------------------------------------
void imu963ra_get_mag (void)
{
    uint8 temp_status;
    uint8 dat[6];

    imu963ra_write_acc_gyro_register(IMU963RA_FUNC_CFG_ACCESS, 0x40);
    temp_status = imu963ra_read_acc_gyro_register(IMU963RA_STATUS_MASTER);
    if(0x01 & temp_status)
    {
        imu963ra_read_acc_gyro_registers(IMU963RA_SENSOR_HUB_1, dat, 6);
        imu963ra_mag_x = (int16)(((uint16)dat[1]<<8 | dat[0]));
        imu963ra_mag_y = (int16)(((uint16)dat[3]<<8 | dat[2]));
        imu963ra_mag_z = (int16)(((uint16)dat[5]<<8 | dat[4]));
    }
    imu963ra_write_acc_gyro_register(IMU963RA_FUNC_CFG_ACCESS, 0x00);
}

//-------------------------------------------------------------------------------------------------------------------
//       IMU963RA ٶȼתΪʵ
// ˵     gyro_value      ļٶȼ
// ز     void
// ʹʾ     float data = imu963ra_acc_transition(imu963ra_acc_x);           // λΪ g(m/s^2)
// עϢ
//-------------------------------------------------------------------------------------------------------------------
float imu963ra_acc_transition (int16 acc_value)
{
    float acc_data = 0;
    switch(IMU963RA_ACC_SAMPLE)
    {
        case 0x30: acc_data = (float)acc_value / 16393; break;                  // 0x30 ٶΪ:2G      ȡļٶȼ  16393 תΪλݣλg(m/s^2)
        case 0x38: acc_data = (float)acc_value / 8197;  break;                  // 0x38 ٶΪ:4G      ȡļٶȼ  8197  תΪλݣλg(m/s^2)
        case 0x3C: acc_data = (float)acc_value / 4098;  break;                  // 0x3C ٶΪ:8G      ȡļٶȼ  4098  תΪλݣλg(m/s^2)
        case 0x34: acc_data = (float)acc_value / 2049;  break;                  // 0x34 ٶΪ:16G     ȡļٶȼ  2049  תΪλݣλg(m/s^2)
        default: break;
    }
    return acc_data;
}

//-------------------------------------------------------------------------------------------------------------------
//       IMU963RA תΪʵ
// ˵     gyro_value      
// ز     void
// ʹʾ     float data = imu963ra_gyro_transition(imu963ra_gyro_x);         // λΪ/s
// עϢ
//-------------------------------------------------------------------------------------------------------------------
float imu963ra_gyro_transition (int16 gyro_value)
{
    float gyro_data = 0;
    switch(IMU963RA_GYR_SAMPLE)
    {
        case 0x52: gyro_data = (float)gyro_value / 228.6f;  break;              //  0x52 Ϊ:125dps  ȡݳ 228.6   תΪλݣλΪ/s
        case 0x50: gyro_data = (float)gyro_value / 114.3f;  break;              //  0x50 Ϊ:250dps  ȡݳ 114.3   תΪλݣλΪ/s
        case 0x54: gyro_data = (float)gyro_value / 57.1f;   break;              //  0x54 Ϊ:500dps  ȡݳ 57.1    תΪλݣλΪ/s
        case 0x58: gyro_data = (float)gyro_value / 28.6f;   break;              //  0x58 Ϊ:1000dps ȡݳ 28.6    תΪλݣλΪ/s
        case 0x5C: gyro_data = (float)gyro_value / 14.3f;   break;              //  0x5C Ϊ:2000dps ȡݳ 14.3    תΪλݣλΪ/s
        case 0x51: gyro_data = (float)gyro_value / 7.1f;    break;              //  0x51 Ϊ:4000dps ȡݳ 7.1     תΪλݣλΪ/s
        default: break;
    }
    return gyro_data;
}

//-------------------------------------------------------------------------------------------------------------------
//       IMU963RA شżתΪʵ
// ˵     mag_value       ĵشż
// ز     void
// ʹʾ     float data = imu963ra_mag_transition(imu963ra_mag_x);          // λΪG(˹)
// עϢ
//-------------------------------------------------------------------------------------------------------------------
float imu963ra_mag_transition (int16 mag_value)
{
    float mag_data = 0;
    switch(IMU963RA_MAG_SAMPLE)
    {
        case 0x19: mag_data = (float)mag_value / 3000;  break;                  //  0x19 Ϊ:8G     ȡļٶȼ 3000 תΪλݣλG(˹)
        case 0x09: mag_data = (float)mag_value / 12000; break;                  //  0x09 Ϊ:2G     ȡļٶȼ 12000תΪλݣλG(˹)
        default: break;
    }
    return mag_data;
}

//-------------------------------------------------------------------------------------------------------------------
//      ʼ IMU963RA
// ˵     void
// ز     uint8           1-ʼʧ 0-ʼɹ
// ʹʾ     imu963ra_init();
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
uint8 imu963ra_init (void)
{
    uint8 return_state = 0;
    system_delay_ms(10);                                                        // ϵʱ

#if IMU963RA_USE_SOFT_IIC
    soft_iic_init(&imu963ra_iic_struct, IMU963RA_DEV_ADDR, IMU963RA_SOFT_IIC_DELAY, IMU963RA_SCL_PIN, IMU963RA_SDA_PIN);
#else
    spi_init(IMU963RA_SPI, SPI_MODE0, IMU963RA_SPI_SPEED, IMU963RA_SPC_PIN, IMU963RA_SDI_PIN, IMU963RA_SDO_PIN, SPI_CS_NULL);
    gpio_init(IMU963RA_CS_PIN, GPO, GPIO_LOW, GPO_PUSH_PULL);
#endif

    do
    {
        imu963ra_write_acc_gyro_register(IMU963RA_FUNC_CFG_ACCESS, 0x00);       // رHUBĴ
        imu963ra_write_acc_gyro_register(IMU963RA_CTRL3_C, 0x01);               // λ豸
        system_delay_ms(2);                             
        imu963ra_write_acc_gyro_register(IMU963RA_FUNC_CFG_ACCESS, 0x00);       // رHUBĴ
        if(imu963ra_acc_gyro_self_check())                   
        {                   
            zf_log(0, "IMU963RA acc and gyro self check error.");                    
            return_state = 1;
            break;            
        }
                            
        imu963ra_write_acc_gyro_register(IMU963RA_INT1_CTRL, 0x03);             //  ٶݾж
        imu963ra_write_acc_gyro_register(IMU963RA_CTRL1_XL, IMU963RA_ACC_SAMPLE);   // üٶȼ 8G Լ 52hz ԼٶϢӵһ˲
        // IMU963RA_CTRL1_XL Ĵ
        // Ϊ:0x30 ٶΪ:2G      ȡļٶȼ 16393תΪλݣλg(m/s^2)
        // Ϊ:0x38 ٶΪ:4G      ȡļٶȼ 8197 תΪλݣλg(m/s^2)
        // Ϊ:0x3C ٶΪ:8G      ȡļٶȼ 4098 תΪλݣλg(m/s^2)
        // Ϊ:0x34 ٶΪ:16G     ȡļٶȼ 2049 תΪλݣλg(m/s^2)
        
        imu963ra_write_acc_gyro_register(IMU963RA_CTRL2_G, IMU963RA_GYR_SAMPLE);    // Ǽ 2000dps Լ 208hz
        // IMU963RA_CTRL2_G Ĵ
        // Ϊ:0x52 Ϊ:125dps  ȡݳ228.6   תΪλݣλΪ/s
        // Ϊ:0x50 Ϊ:250dps  ȡݳ114.3   תΪλݣλΪ/s
        // Ϊ:0x54 Ϊ:500dps  ȡݳ57.1    תΪλݣλΪ/s
        // Ϊ:0x58 Ϊ:1000dps ȡݳ28.6    תΪλݣλΪ/s
        // Ϊ:0x5C Ϊ:2000dps ȡݳ14.3    תΪλݣλΪ/s
        // Ϊ:0x51 Ϊ:4000dps ȡݳ7.1     תΪλݣλΪ/s
        
        imu963ra_write_acc_gyro_register(IMU963RA_CTRL3_C, 0x44);               // ʹֵͨ˲
        imu963ra_write_acc_gyro_register(IMU963RA_CTRL4_C, 0x02);               // ʹֵͨ˲
        imu963ra_write_acc_gyro_register(IMU963RA_CTRL5_C, 0x00);               // ٶȼ
        imu963ra_write_acc_gyro_register(IMU963RA_CTRL6_C, 0x00);               // ٶȼƸģʽ ǵͨ˲ 133hz
        imu963ra_write_acc_gyro_register(IMU963RA_CTRL7_G, 0x00);               // Ǹģʽ رոͨ˲
        imu963ra_write_acc_gyro_register(IMU963RA_CTRL9_XL, 0x01);              // رI3Cӿ

        imu963ra_write_acc_gyro_register(IMU963RA_FUNC_CFG_ACCESS, 0x40);       // HUBĴ õشż
        imu963ra_write_acc_gyro_register(IMU963RA_MASTER_CONFIG, 0x80);         // λI2C
        system_delay_ms(2);                             
        imu963ra_write_acc_gyro_register(IMU963RA_MASTER_CONFIG, 0x00);         // λ־
        system_delay_ms(2);
        
        imu963ra_write_mag_register(IMU963RA_MAG_ADDR, IMU963RA_MAG_CONTROL2, 0x80);// λӵ
        system_delay_ms(2);
        imu963ra_write_mag_register(IMU963RA_MAG_ADDR, IMU963RA_MAG_CONTROL2, 0x00);
        system_delay_ms(2);
        
        
        if(imu963ra_mag_self_check())
        {
            zf_log(0, "IMU963RA mag self check error.");
            return_state = 1;
            break;            
        }

        imu963ra_write_mag_register(IMU963RA_MAG_ADDR, IMU963RA_MAG_CONTROL1, IMU963RA_MAG_SAMPLE); // ô8G 100hz ģʽ
        // IMU963RA_MAG_ADDR Ĵ
        // Ϊ:0x19 Ϊ:8G     ȡļٶȼ 3000 תΪλݣλG(˹)
        // Ϊ:0x09 Ϊ:2G     ȡļٶȼ 12000תΪλݣλG(˹)
        
        imu963ra_write_mag_register(IMU963RA_MAG_ADDR, IMU963RA_MAG_FBR, 0x01);
        imu963ra_connect_mag(IMU963RA_MAG_ADDR, IMU963RA_MAG_OUTX_L);
        
        imu963ra_write_acc_gyro_register(IMU963RA_FUNC_CFG_ACCESS, 0x00);       // رHUBĴ

        system_delay_ms(20);                                                    // ȴƻȡ
    }while(0);
    return return_state;
}
