/*********************************************************************************************************************
* RT1064DVL6A Opensourec Library RT1064DVL6A Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
*
* ļ RT1064DVL6A Դһ
*
* RT1064DVL6A Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
*
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
*
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
*
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
*
* ļ          zf_device_imu660ra
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           IAR 8.32.4 or MDK 5.33
* ƽ̨          RT1064DVL6A
*           https://seekfree.taobao.com/
*
* ޸ļ¼
*                               ע
* 2022-09-21        SeekFree            first version
********************************************************************************************************************/
/*********************************************************************************************************************
* ߶壺
*                   ------------------------------------
*                   ģܽ            Ƭܽ
*                   // Ӳ SPI 
*                   SCL/SPC           鿴 zf_device_imu660ra.h  IMU660RA_SPC_PIN 궨
*                   SDA/DSI           鿴 zf_device_imu660ra.h  IMU660RA_SDI_PIN 궨
*                   SA0/SDO           鿴 zf_device_imu660ra.h  IMU660RA_SDO_PIN 궨
*                   CS                鿴 zf_device_imu660ra.h  IMU660RA_CS_PIN 궨
*                   VCC               3.3VԴ
*                   GND               Դ
*                   
*
*                   //  IIC 
*                   SCL/SPC           鿴 zf_device_imu660ra.h  IMU660RA_SCL_PIN 궨
*                   SDA/DSI           鿴 zf_device_imu660ra.h  IMU660RA_SDA_PIN 궨
*                   VCC               3.3VԴ
*                   GND               Դ
*                   
*                   ------------------------------------
********************************************************************************************************************/

#ifndef _zf_device_imu660ra_h_
#define _zf_device_imu660ra_h_

#include "zf_common_typedef.h"

// IMU660RA_USE_SOFT_IICΪ0ʾʹӲSPI Ϊ1ʾʹIIC
// IMU660RA_USE_SOFT_IICҪȱ벢س򣬵ƬģҪϵͨѶ
#define IMU660RA_USE_SOFT_IIC         (0)                                       // ĬʹӲ SPI ʽ


#if IMU660RA_USE_SOFT_IIC                                                       //  ɫĲȷ ɫҵľûõ
//==================================================== IIC ====================================================
#define IMU660RA_SOFT_IIC_DELAY     (100)                                       //  IIC ʱʱ ֵԽС IIC ͨԽ
#define IMU660RA_SCL_PIN            (C23)                                       //  IIC SCL   IMU660RA  SCL 
#define IMU660RA_SDA_PIN            (C22)                                       //  IIC SDA   IMU660RA  SDA 
//==================================================== IIC ====================================================
#else

//====================================================Ӳ SPI ====================================================
#define IMU660RA_SPI_SPEED          (10 * 1000 * 1000)                          // Ӳ SPI 
#define IMU660RA_SPI                (SPI_4)                                     // Ӳ SPI 
#define IMU660RA_SPC_PIN            (SPI4_SCK_C23 )                             // Ӳ SPI SCK 
#define IMU660RA_SDI_PIN            (SPI4_MOSI_C22)                             // Ӳ SPI MOSI 
#define IMU660RA_SDO_PIN            (SPI4_MISO_C21)                             // Ӳ SPI MISO 
//====================================================Ӳ SPI ====================================================
#endif
#define IMU660RA_CS_PIN             (C20)                                       // CS Ƭѡ
#define IMU660RA_CS(x)              ((x) ? (gpio_high(IMU660RA_CS_PIN)) : (gpio_low(IMU660RA_CS_PIN)))
    
#define IMU660RA_TIMEOUT_COUNT      (0x00FF)                                    // IMU660 ʱ


//================================================ imu660ra ڲַ================================================
#define IMU660RA_DEV_ADDR           (0x69)                                      // SA0ӵأ0x68 SA00x69 ģĬ
#define IMU660RA_SPI_W              (0x00)
#define IMU660RA_SPI_R              (0x80)
    
#define IMU660RA_CHIP_ID            (0x00)
#define IMU660RA_PWR_CONF           (0x7C)
#define IMU660RA_PWR_CTRL           (0x7D)
#define IMU660RA_INIT_CTRL          (0x59)
#define IMU660RA_INIT_DATA          (0x5E)
#define IMU660RA_INT_STA            (0x21)
#define IMU660RA_ACC_ADDRESS        (0x0C)
#define IMU660RA_GYRO_ADDRESS       (0x12)
#define IMU660RA_ACC_CONF           (0x40)
#define IMU660RA_ACC_RANGE          (0x41)
#define IMU660RA_GYR_CONF           (0x42)
#define IMU660RA_GYR_RANGE          (0x43)

#define IMU660RA_ACC_SAMPLE         (0x02)                                      // ٶȼ
// Ϊ:0x00 ٶȼΪ:2g         ȡļٶȼ  16384   תΪλ λg(m/s^2)
// Ϊ:0x01 ٶȼΪ:4g         ȡļٶȼ  8192    תΪλ λg(m/s^2)
// Ϊ:0x02 ٶȼΪ:8g         ȡļٶȼ  4096    תΪλ λg(m/s^2)
// Ϊ:0x03 ٶȼΪ:16g        ȡļٶȼ  2048    תΪλ λg(m/s^2)

#define IMU660RA_GYR_SAMPLE         (0x00)                                      // 
// Ϊ:0x00 Ϊ:2000dps     ȡ  16.4       תΪλ λΪ/s
// Ϊ:0x01 Ϊ:1000dps     ȡ  32.8       תΪλ λΪ/s
// Ϊ:0x02 Ϊ:500 dps     ȡ  65.6       תΪλ λΪ/s
// Ϊ:0x03 Ϊ:250 dps     ȡ  131.2      תΪλ λΪ/s
// Ϊ:0x04 Ϊ:125 dps     ȡ  262.4      תΪλ λΪ/s



extern int16 imu660ra_gyro_x, imu660ra_gyro_y, imu660ra_gyro_z;                   //       gyro ()
extern int16 imu660ra_acc_x, imu660ra_acc_y, imu660ra_acc_z;                      // ٶȼ     acc (accelerometer ٶȼ)


void  imu660ra_get_acc            (void);                                         // ȡ IMU660RA ٶȼ
void  imu660ra_get_gyro           (void);                                         // ȡ IMU660RA 
float imu660ra_acc_transition     (int16 acc_value);                              //  IMU660RA ٶȼתΪʵ
float imu660ra_gyro_transition    (int16 gyro_value);                             //  IMU660RA תΪʵ
uint8 imu660ra_init               (void);                                         // ʼ IMU660RA

#endif

