/*********************************************************************************************************************
* RT1064DVL6A Opensourec Library RT1064DVL6A Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
* 
* ļ RT1064DVL6A Դһ
* 
* RT1064DVL6A Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
* 
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
* 
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
* 
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
* 
* ļ          zf_device_icm20602
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           IAR 8.32.4 or MDK 5.33
* ƽ̨          RT1064DVL6A
*           https://seekfree.taobao.com/
* 
* ޸ļ¼
*                               ע
* 2022-09-21        SeekFree            first version
********************************************************************************************************************/
/*********************************************************************************************************************
* ߶壺
*                   ------------------------------------
*                   ģܽ            Ƭܽ
*                   // Ӳ SPI 
*                   SCL/SPC             鿴 zf_device_icm20602.h  ICM20602_SPC_PIN 궨
*                   SDA/SDI             鿴 zf_device_icm20602.h  ICM20602_SDI_PIN 궨
*                   SA0/SDO             鿴 zf_device_icm20602.h  ICM20602_SDO_PIN 궨
*                   CS                  鿴 zf_device_icm20602.h  ICM20602_CS_PIN 궨
*                   VCC                 3.3VԴ
*                   GND                 Դ
*                   
*
*                   //  IIC 
*                   SCL/SPC             鿴 zf_device_icm20602.h  ICM20602_SCL_PIN 궨
*                   SDA/SDI             鿴 zf_device_icm20602.h  ICM20602_SDA_PIN 궨
*                   VCC                 3.3VԴ
*                   GND                 Դ
*                   
*                   ------------------------------------
********************************************************************************************************************/

#ifndef _zf_device_icm20602_h_
#define _zf_device_icm20602_h_

#include "zf_common_typedef.h"

#define ICM20602_USE_SOFT_IIC       (0)                                         // ĬʹӲ SPI ʽ
#if ICM20602_USE_SOFT_IIC                                                       //  ɫĲȷ ɫҵľûõ
//==================================================== IIC ====================================================
#define ICM20602_SOFT_IIC_DELAY     (100)                                       //  IIC ʱʱ ֵԽС IIC ͨԽ
#define ICM20602_SCL_PIN            (B23)                                       //  IIC SCL   ICM20602  SCL 
#define ICM20602_SDA_PIN            (B22)                                       //  IIC SDA   ICM20602  SDA 
//==================================================== IIC ====================================================
#else
//====================================================Ӳ SPI ====================================================
#define ICM20602_SPI_SPEED          (10 * 1000 * 1000)                          // Ӳ SPI 
#define ICM20602_SPI                (SPI_4)                                     // Ӳ SPI 
#define ICM20602_SPC_PIN            (SPI4_SCK_C23)                              // Ӳ SPI SCK 
#define ICM20602_SDI_PIN            (SPI4_MOSI_C22)                             // Ӳ SPI MOSI 
#define ICM20602_SDO_PIN            (SPI4_MISO_C21)                             // Ӳ SPI MISO 
//====================================================Ӳ SPI ====================================================
#endif
#define ICM20602_CS_PIN             (C20)                                       // CS Ƭѡ
#define ICM20602_CS(x)              ((x) ? (gpio_high(ICM20602_CS_PIN)) : (gpio_low(ICM20602_CS_PIN)))

#define ICM20602_TIMEOUT_COUNT      (0x00FF)                                    // ICM20602 ʱ


//================================================ ICM20602 ڲַ================================================
#define ICM20602_DEV_ADDR           (0x69)                                      // SA0ӵأ0x68 SA00x69 ģĬ
#define ICM20602_SPI_W              (0x00)
#define ICM20602_SPI_R              (0x80)

#define ICM20602_XG_OFFS_TC_H       (0x04)
#define ICM20602_XG_OFFS_TC_L       (0x05)
#define ICM20602_YG_OFFS_TC_H       (0x07)
#define ICM20602_YG_OFFS_TC_L       (0x08)
#define ICM20602_ZG_OFFS_TC_H       (0x0A)
#define ICM20602_ZG_OFFS_TC_L       (0x0B)
#define ICM20602_SELF_TEST_X_ACCEL  (0x0D)
#define ICM20602_SELF_TEST_Y_ACCEL  (0x0E)
#define ICM20602_SELF_TEST_Z_ACCEL  (0x0F)
#define ICM20602_XG_OFFS_USRH       (0x13)
#define ICM20602_XG_OFFS_USRL       (0x14)
#define ICM20602_YG_OFFS_USRH       (0x15)
#define ICM20602_YG_OFFS_USRL       (0x16)
#define ICM20602_ZG_OFFS_USRH       (0x17)
#define ICM20602_ZG_OFFS_USRL       (0x18)
#define ICM20602_SMPLRT_DIV         (0x19)
#define ICM20602_CONFIG             (0x1A)
#define ICM20602_GYRO_CONFIG        (0x1B)
#define ICM20602_ACCEL_CONFIG       (0x1C)
#define ICM20602_ACCEL_CONFIG_2     (0x1D)
#define ICM20602_LP_MODE_CFG        (0x1E)
#define ICM20602_ACCEL_WOM_X_THR    (0x20)
#define ICM20602_ACCEL_WOM_Y_THR    (0x21)
#define ICM20602_ACCEL_WOM_Z_THR    (0x22)
#define ICM20602_FIFO_EN            (0x23)
#define ICM20602_FSYNC_INT          (0x36)
#define ICM20602_INT_PIN_CFG        (0x37)
#define ICM20602_INT_ENABLE         (0x38)
#define ICM20602_FIFO_WM_INT_STATUS (0x39)
#define ICM20602_INT_STATUS         (0x3A)
#define ICM20602_ACCEL_XOUT_H       (0x3B)
#define ICM20602_ACCEL_XOUT_L       (0x3C)
#define ICM20602_ACCEL_YOUT_H       (0x3D)
#define ICM20602_ACCEL_YOUT_L       (0x3E)
#define ICM20602_ACCEL_ZOUT_H       (0x3F)
#define ICM20602_ACCEL_ZOUT_L       (0x40)
#define ICM20602_TEMP_OUT_H         (0x41)
#define ICM20602_TEMP_OUT_L         (0x42)
#define ICM20602_GYRO_XOUT_H        (0x43)
#define ICM20602_GYRO_XOUT_L        (0x44)
#define ICM20602_GYRO_YOUT_H        (0x45)
#define ICM20602_GYRO_YOUT_L        (0x46)
#define ICM20602_GYRO_ZOUT_H        (0x47)
#define ICM20602_GYRO_ZOUT_L        (0x48)
#define ICM20602_SELF_TEST_X_GYRO   (0x50)
#define ICM20602_SELF_TEST_Y_GYRO   (0x51)
#define ICM20602_SELF_TEST_Z_GYRO   (0x52)
#define ICM20602_FIFO_WM_TH1        (0x60)
#define ICM20602_FIFO_WM_TH2        (0x61)
#define ICM20602_SIGNAL_PATH_RESET  (0x68)
#define ICM20602_ACCEL_INTEL_CTRL   (0x69)
#define ICM20602_USER_CTRL          (0x6A)
#define ICM20602_PWR_MGMT_1         (0x6B)
#define ICM20602_PWR_MGMT_2         (0x6C)
#define ICM20602_I2C_IF             (0x70)
#define ICM20602_FIFO_COUNTH        (0x72)
#define ICM20602_FIFO_COUNTL        (0x73)
#define ICM20602_FIFO_R_W           (0x74)
#define ICM20602_WHO_AM_I           (0x75)
#define ICM20602_XA_OFFSET_H        (0x77)
#define ICM20602_XA_OFFSET_L        (0x78)
#define ICM20602_YA_OFFSET_H        (0x7A)
#define ICM20602_YA_OFFSET_L        (0x7B)
#define ICM20602_ZA_OFFSET_H        (0x7D)
#define ICM20602_ZA_OFFSET_L        (0x7E)


#define ICM20602_ACC_SAMPLE         (0x10)                                      // ٶȼ
// Ϊ:0x00 ٶȼΪ:2g          ȡļٶȼ 16384      תΪλݣλg(m/s^2)
// Ϊ:0x08 ٶȼΪ:4g          ȡļٶȼ 8192       תΪλݣλg(m/s^2)
// Ϊ:0x10 ٶȼΪ:8g          ȡļٶȼ 4096       תΪλݣλg(m/s^2)
// Ϊ:0x18 ٶȼΪ:16g         ȡļٶȼ 2048       תΪλݣλg(m/s^2)

#define ICM20602_GYR_SAMPLE         (0x18)                                      // 
// Ϊ:0x00 Ϊ:250 dps     ȡݳ131           תΪλݣλΪ/s
// Ϊ:0x08 Ϊ:500 dps     ȡݳ65.5          תΪλݣλΪ/s
// Ϊ:0x10 Ϊ:1000dps     ȡݳ32.8          תΪλݣλΪ/s
// Ϊ:0x18 Ϊ:2000dps     ȡݳ16.4          תΪλݣλΪ/s

//================================================ ICM20602 ڲַ================================================

extern int16 icm20602_gyro_x, icm20602_gyro_y, icm20602_gyro_z;                 // 
extern int16 icm20602_acc_x, icm20602_acc_y, icm20602_acc_z;                    // ٶȼ

void    icm20602_get_acc            (void);
void    icm20602_get_gyro           (void);
float   icm20602_acc_transition     (int16 acc_value);                          //  ICM20602 ٶȼתΪʵ
float   icm20602_gyro_transition    (int16 gyro_value);                         //  ICM20602 תΪʵ
uint8   icm20602_init               (void);

#endif

