/*********************************************************************************************************************
* RT1064DVL6A Opensourec Library RT1064DVL6A Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
* 
* ļ RT1064DVL6A Դһ
* 
* RT1064DVL6A Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
* 
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
* 
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
* 
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
* 
* ļ          zf_device_icm20602
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           IAR 8.32.4 or MDK 5.33
* ƽ̨          RT1064DVL6A
*           https://seekfree.taobao.com/
* 
* ޸ļ¼
*                               ע
* 2022-09-21        SeekFree            first version
********************************************************************************************************************/
/*********************************************************************************************************************
* ߶壺
*                   ------------------------------------
*                   ģܽ            Ƭܽ
*                   // Ӳ SPI 
*                   SCL/SPC             鿴 zf_device_icm20602.h  ICM20602_SPC_PIN 궨
*                   SDA/SDI             鿴 zf_device_icm20602.h  ICM20602_SDI_PIN 궨
*                   SA0/SDO             鿴 zf_device_icm20602.h  ICM20602_SDO_PIN 궨
*                   CS                  鿴 zf_device_icm20602.h  ICM20602_CS_PIN 궨
*                   VCC                 3.3VԴ
*                   GND                 Դ
*                   
*
*                   //  IIC 
*                   SCL/SPC             鿴 zf_device_icm20602.h  ICM20602_SCL_PIN 궨
*                   SDA/SDI             鿴 zf_device_icm20602.h  ICM20602_SDA_PIN 궨
*                   VCC                 3.3VԴ
*                   GND                 Դ
*                   
*                   ------------------------------------
********************************************************************************************************************/

#include "zf_common_clock.h"
#include "zf_common_debug.h"
#include "zf_driver_delay.h"
#include "zf_driver_spi.h"
#include "zf_driver_soft_iic.h"

#include "zf_device_icm20602.h"

int16 icm20602_gyro_x = 0, icm20602_gyro_y = 0, icm20602_gyro_z = 0;            //       gyro ()
int16 icm20602_acc_x = 0, icm20602_acc_y = 0, icm20602_acc_z = 0;               // ٶȼ    acc (accelerometer ٶȼ)

#if ICM20602_USE_SOFT_IIC
static soft_iic_info_struct icm20602_iic_struct;

//-------------------------------------------------------------------------------------------------------------------
//      ICM20602 дĴ
// ˵     reg             Ĵַ
// ˵     data            
// ز     void
// ʹʾ     icm20602_write_register(ICM20602_PWR_MGMT_1, 0x80);
// עϢ     ڲ
//-------------------------------------------------------------------------------------------------------------------
#define icm20602_write_register(reg, data)      (soft_iic_write_8bit_register(&icm20602_iic_struct, (reg), (data)))

//-------------------------------------------------------------------------------------------------------------------
//      ICM20602 Ĵ
// ˵     reg             Ĵַ
// ز     uint8           
// ʹʾ     icm20602_read_register(ICM20602_WHO_AM_I);
// עϢ     ڲ
//-------------------------------------------------------------------------------------------------------------------
#define icm20602_read_register(reg)             (soft_iic_read_8bit_register(&icm20602_iic_struct, (reg)))

//-------------------------------------------------------------------------------------------------------------------
//      ICM20602 
// ˵     reg             Ĵַ
// ˵     data            ݻ
// ˵     len             ݳ
// ز     void
// ʹʾ     icm20602_read_registers(ICM20602_ACCEL_XOUT_H, dat, 6);
// עϢ     ڲ
//-------------------------------------------------------------------------------------------------------------------
#define icm20602_read_registers(reg, data, len) (soft_iic_read_8bit_registers(&icm20602_iic_struct, (reg), (data), (len)))
#else
//-------------------------------------------------------------------------------------------------------------------
//      ICM20602 дĴ
// ˵     reg             Ĵַ
// ˵     data            
// ز     void
// ʹʾ     icm20602_write_register(ICM20602_PWR_MGMT_1, 0x80);
// עϢ     ڲ
//-------------------------------------------------------------------------------------------------------------------
static void icm20602_write_register(uint8 reg, uint8 data)
{
    ICM20602_CS(0);
    spi_write_8bit_register(ICM20602_SPI, reg | ICM20602_SPI_W, data);
    ICM20602_CS(1);
}

//-------------------------------------------------------------------------------------------------------------------
//      ICM20602 Ĵ
// ˵     reg             Ĵַ
// ز     uint8           
// ʹʾ     icm20602_read_register(ICM20602_WHO_AM_I);
// עϢ     ڲ
//-------------------------------------------------------------------------------------------------------------------
static uint8 icm20602_read_register(uint8 reg)
{
    uint8 data = 0;
    ICM20602_CS(0);
    data = spi_read_8bit_register(ICM20602_SPI, reg | ICM20602_SPI_R);
    ICM20602_CS(1);
    return data;
}

//-------------------------------------------------------------------------------------------------------------------
//      ICM20602 
// ˵     reg             Ĵַ
// ˵     data            ݻ
// ˵     len             ݳ
// ز     void
// ʹʾ     icm20602_read_registers(ICM20602_ACCEL_XOUT_H, dat, 6);
// עϢ     ڲ
//-------------------------------------------------------------------------------------------------------------------
static void icm20602_read_registers(uint8 reg, uint8 *data, uint32 len)
{
    ICM20602_CS(0);
    spi_read_8bit_registers(ICM20602_SPI, reg | ICM20602_SPI_R, data, len);
    ICM20602_CS(1);
}
#endif

//-------------------------------------------------------------------------------------------------------------------
//      ICM20602 Լ
// ˵     void
// ز     uint8           1-Լʧ 0-Լɹ
// ʹʾ     icm20602_self_check();
// עϢ     ڲ
//-------------------------------------------------------------------------------------------------------------------
static uint8 icm20602_self_check (void)
{
    uint8 dat = 0, return_state = 0;
    uint16 timeout_count = 0;

    while(0x12 != dat)                                                          // ж ID Ƿȷ
    {
        if(timeout_count ++ > ICM20602_TIMEOUT_COUNT)
        {
            return_state =  1;
            break;
        }
        dat = icm20602_read_register(ICM20602_WHO_AM_I);
        system_delay_ms(10);
    }
    return return_state;
}

//-------------------------------------------------------------------------------------------------------------------
//      ȡ ICM20602 ٶȼ
// ˵     void
// ز     void
// ʹʾ     icm20602_get_acc();                                             // ִиúֱӲ鿴Ӧı
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
void icm20602_get_acc (void)
{
    uint8 dat[6];

    icm20602_read_registers(ICM20602_ACCEL_XOUT_H, dat, 6);
    icm20602_acc_x = (int16)(((uint16)dat[0] << 8 | dat[1]));
    icm20602_acc_y = (int16)(((uint16)dat[2] << 8 | dat[3]));
    icm20602_acc_z = (int16)(((uint16)dat[4] << 8 | dat[5]));
}

//-------------------------------------------------------------------------------------------------------------------
//      ȡICM20602
// ˵     void
// ز     void
// ʹʾ     icm20602_get_gyro();                                            // ִиúֱӲ鿴Ӧı
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
void icm20602_get_gyro (void)
{
    uint8 dat[6];

    icm20602_read_registers(ICM20602_GYRO_XOUT_H, dat, 6);
    icm20602_gyro_x = (int16)(((uint16)dat[0] << 8 | dat[1]));
    icm20602_gyro_y = (int16)(((uint16)dat[2] << 8 | dat[3]));
    icm20602_gyro_z = (int16)(((uint16)dat[4] << 8 | dat[5]));
}

//-------------------------------------------------------------------------------------------------------------------
//       ICM20602 ٶȼתΪʵ
// ˵     gyro_value      ļٶȼ
// ز     void
// ʹʾ     float data = icm20602_acc_transition(icm20602_acc_x);           // λΪ g(m/s^2)
// עϢ
//-------------------------------------------------------------------------------------------------------------------
float icm20602_acc_transition (int16 acc_value)
{
    float acc_data = 0;
    switch(ICM20602_ACC_SAMPLE)
    {
        case 0x00: acc_data = (float)acc_value / 16384; break;                  // 0x00 ٶȼΪ:2g     ȡļٶȼ  16384      תΪλݣλg(m/s^2)
        case 0x08: acc_data = (float)acc_value / 8192;  break;                  // 0x08 ٶȼΪ:4g     ȡļٶȼ  8192       תΪλݣλg(m/s^2)
        case 0x10: acc_data = (float)acc_value / 4096;  break;                  // 0x10 ٶȼΪ:8g     ȡļٶȼ  4096       תΪλݣλg(m/s^2)
        case 0x18: acc_data = (float)acc_value / 2048;  break;                  // 0x18 ٶȼΪ:16g    ȡļٶȼ  2048       תΪλݣλg(m/s^2)
        default: break;
    }
    return acc_data;
}

//-------------------------------------------------------------------------------------------------------------------
//       ICM20602 תΪʵ
// ˵     gyro_value      
// ز     void
// ʹʾ     float data = icm20602_gyro_transition(icm20602_gyro_x);         // λΪ/s
// עϢ
//-------------------------------------------------------------------------------------------------------------------
float icm20602_gyro_transition (int16 gyro_value)
{
    float gyro_data = 0;
    switch(ICM20602_GYR_SAMPLE)
    {
        case 0x00: gyro_data = (float)gyro_value / 131.0f;  break;              // 0x00 Ϊ:250 dps     ȡݳ 131           תΪλݣλΪ/s
        case 0x08: gyro_data = (float)gyro_value / 65.5f;   break;              // 0x08 Ϊ:500 dps     ȡݳ 65.5          תΪλݣλΪ/s
        case 0x10: gyro_data = (float)gyro_value / 32.8f;   break;              // 0x10 Ϊ:1000dps     ȡݳ 32.8          תΪλݣλΪ/s
        case 0x18: gyro_data = (float)gyro_value / 16.4f;   break;              // 0x18 Ϊ:2000dps     ȡݳ 16.4          תΪλݣλΪ/s
        default: break;
    }
    return gyro_data;
}

//-------------------------------------------------------------------------------------------------------------------
//      ʼ ICM20602
// ˵     void
// ز     uint8           1-ʼʧ 0-ʼɹ
// ʹʾ     icm20602_init();
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
uint8 icm20602_init (void)
{
    uint8 val = 0x0, return_state = 0;
    uint16 timeout_count = 0;

    system_delay_ms(10);                                                        // ϵʱ

#if ICM20602_USE_SOFT_IIC
    soft_iic_init(&icm20602_iic_struct, ICM20602_DEV_ADDR, ICM20602_SOFT_IIC_DELAY, ICM20602_SCL_PIN, ICM20602_SDA_PIN);
#else
    spi_init(ICM20602_SPI, SPI_MODE0, ICM20602_SPI_SPEED, ICM20602_SPC_PIN, ICM20602_SDI_PIN, ICM20602_SDO_PIN, SPI_CS_NULL);
    gpio_init(ICM20602_CS_PIN, GPO, GPIO_HIGH, GPO_PUSH_PULL);
#endif

    do
    {
        if(icm20602_self_check())
        {
            // ˶Ϣ ʾλ
            // ô ICM20602 Լʱ˳
            // һ½û ûܾǻ
            zf_log(0, "icm20602 self check error.");
            return_state = 1;
            break;
        }

        icm20602_write_register(ICM20602_PWR_MGMT_1, 0x80);                     // λ豸
        system_delay_ms(2);

        do
        {                                                                       // ȴλɹ
            val = icm20602_read_register(ICM20602_PWR_MGMT_1);
            if(timeout_count ++ > ICM20602_TIMEOUT_COUNT)
            {
                // ˶Ϣ ʾλ
                // ô ICM20602 Լʱ˳
                // һ½û ûܾǻ
                zf_log(0, "icm20602 reset error.");
                return_state = 1;
                break;
            }
        }while(0x41 != val);
        if(1 == return_state)
        {
            break;
        }

        icm20602_write_register(ICM20602_PWR_MGMT_1,     0x01);                 // ʱ
        icm20602_write_register(ICM20602_PWR_MGMT_2,     0x00);                 // Ǻͼٶȼ
        icm20602_write_register(ICM20602_CONFIG,         0x01);                 // 176HZ 1KHZ
        icm20602_write_register(ICM20602_SMPLRT_DIV,     0x07);                 //  SAMPLE_RATE = INTERNAL_SAMPLE_RATE / (1 + SMPLRT_DIV)
        icm20602_write_register(ICM20602_GYRO_CONFIG,    ICM20602_GYR_SAMPLE);  // 2000 dps
        icm20602_write_register(ICM20602_ACCEL_CONFIG,   ICM20602_ACC_SAMPLE);  // 8g
        icm20602_write_register(ICM20602_ACCEL_CONFIG_2, 0x03);                 // Average 4 samples   44.8HZ   //0x23 Average 16 samples
        // ICM20602_GYRO_CONFIG Ĵ
        // Ϊ:0x00 Ϊ:250 dps     ȡݳ131           תΪλݣλΪ/s
        // Ϊ:0x08 Ϊ:500 dps     ȡݳ65.5          תΪλݣλΪ/s
        // Ϊ:0x10 Ϊ:1000dps     ȡݳ32.8          תΪλݣλΪ/s
        // Ϊ:0x18 Ϊ:2000dps     ȡݳ16.4          תΪλݣλΪ/s

        // ICM20602_ACCEL_CONFIG Ĵ
        // Ϊ:0x00 ٶȼΪ:2g          ȡļٶȼ 16384      תΪλݣλg(m/s^2)
        // Ϊ:0x08 ٶȼΪ:4g          ȡļٶȼ 8192       תΪλݣλg(m/s^2)
        // Ϊ:0x10 ٶȼΪ:8g          ȡļٶȼ 4096       תΪλݣλg(m/s^2)
        // Ϊ:0x18 ٶȼΪ:16g         ȡļٶȼ 2048       תΪλݣλg(m/s^2)
    }while(0);
    return return_state;
}
