/*********************************************************************************************************************
* RT1064DVL6A Opensourec Library RT1064DVL6A Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
* 
* ļ RT1064DVL6A Դһ
* 
* RT1064DVL6A Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
* 
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
* 
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
* 
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
* 
* ļ          zf_device_gps_tau1201
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           IAR 8.32.4 or MDK 5.33
* ƽ̨          RT1064DVL6A
*           https://seekfree.taobao.com/
* 
* ޸ļ¼
*                               ע
* 2022-09-21        SeekFree            first version
********************************************************************************************************************/
/*********************************************************************************************************************
* ߶壺
*                   ------------------------------------
*                   ģܽ            Ƭܽ
*                   RX                  鿴 zf_device_gps_tau1201.h  GPS_TAU1201_RX 궨
*                   TX                  鿴 zf_device_gps_tau1201.h  GPS_TAU1201_TX 궨
*                   VCC                 3.3VԴ
*                   GND                 Դ
*                   ------------------------------------
********************************************************************************************************************/

#ifndef _zf_device_gps_tau1201_h_
#define _zf_device_gps_tau1201_h_

#include "zf_common_typedef.h"

//--------------------------------------------------------------------------------------------------
//
//--------------------------------------------------------------------------------------------------
#define GPS_TAU1201_UART    (UART_4)
#define GPS_TAU1201_RX      (UART4_TX_C16)                                      // GPS RXӵƬ
#define GPS_TAU1201_TX      (UART4_RX_C17)                                      // GPS TX

#define ANGLE_TO_RAD(x)    ((x) * PI / 180.0)                                   // ǶתΪ
#define RAD_TO_ANGLE(x)    ((x) * 180.0 / PI)                                   // תΪǶ
#define PI                 (3.1415926535898)

typedef struct
{
    uint16      year;  
    uint8       month; 
    uint8       day;
    uint8       hour;
    uint8       minute;
    uint8       second;
}gps_time_struct;

typedef struct
{
    gps_time_struct    time;                                                    // ʱ
    
    uint8       state;                                                          // Ч״̬  1λЧ  0λЧ
    
    uint16      latitude_degree;                                                // 
    uint16      latitude_cent;                                                  // 
    uint16      latitude_second;                                                // 
    uint16      longitude_degree;                                               // 
    uint16      longitude_cent;                                                 // 
    uint16      longitude_second;                                               // 
    
    double      latitude;                                                       // γ
    double      longitude;                                                      // 
    
    int8        ns;                                                             // γȰ N򣩻 Sϰ
    int8        ew;                                                             // Ȱ E W
    
    float       speed;                                                          // ٶȣ/ÿСʱ
    float       direction;                                                      // 溽000.0~359.9 ȣ汱Ϊο׼
    
    // ϢGNGGAлȡ
    uint8       satellite_used;                                                 // ڶλ
    float       height;                                                         // ߶   
}gps_info_struct;

typedef enum
{
    GPS_STATE_RECEIVING,    // ڽ
    GPS_STATE_RECEIVED,     // ݽ
    GPS_STATE_PARSING,      // ڽ
}gps_state_enum;

extern gps_info_struct  gps_tau1201;
extern uint8            gps_tau1201_flag;


double      get_two_points_distance     (double lat1, double lng1, double lat2, double lng2);
double      get_two_points_azimuth      (double lat1, double lon1, double lat2, double lon2);

uint8       gps_data_parse              (void);

void        gps_uart_callback           (void);

void        gps_init                    (void);

#endif
