/*********************************************************************************************************************
* RT1064DVL6A Opensourec Library RT1064DVL6A Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
* 
* ļ RT1064DVL6A Դһ
* 
* RT1064DVL6A Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
* 
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
* 
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
* 
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
* 
* ļ          zf_device_bluetooth_ch9141
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           IAR 8.32.4 or MDK 5.33
* ƽ̨          RT1064DVL6A
*           https://seekfree.taobao.com/
* 
* ޸ļ¼
*                               ע
* 2022-09-21        SeekFree            first version
********************************************************************************************************************/
/*********************************************************************************************************************
* ߶壺
*                   ------------------------------------
*                   ģܽ            Ƭܽ
*                   RX                  鿴 zf_device_bluetooth_ch9141.h  CH9141_RX_PINx 궨
*                   TX                  鿴 zf_device_bluetooth_ch9141.h  CH9141_TX_PINx 궨
*                   RTS                 鿴 zf_device_bluetooth_ch9141.h  CH9141_RTS_PINx 궨
*                   VCC                 3.3VԴ
*                   GND                 Դ
*                   
*                   ------------------------------------
********************************************************************************************************************/

#include "zf_common_clock.h"
#include "zf_common_debug.h"
#include "zf_common_fifo.h"
#include "zf_driver_gpio.h"
#include "zf_driver_uart.h"
#include "zf_driver_delay.h"
#include "zf_device_type.h"

#include "zf_device_bluetooth_ch9141.h"

static  fifo_struct     bluetooth_ch9141_fifo;
static  uint8           bluetooth_ch9141_buffer[BLUETOOTH_CH9141_BUFFER_SIZE];  // ݴ

static  uint8           bluetooth_ch9141_data;

//-------------------------------------------------------------------------------------------------------------------
//      תģ 
// ˵     data            8bit 
// ز     uint32          ʣ෢ͳ
// ʹʾ     bluetooth_ch9141_send_byte(0x5A);
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
uint32 bluetooth_ch9141_send_byte (const uint8 data)
{
    uint16 time_count = BLUETOOTH_CH9141_TIMEOUT_COUNT;
    while(time_count)
    {
        if(!gpio_get_level(BLUETOOTH_CH9141_RTS_PIN))
        {
            uart_write_byte(BLUETOOTH_CH9141_INDEX, data);                      // 
            break;
        }
        time_count --;
        system_delay_ms(1);
    }
    return (0 < time_count);
}

//-------------------------------------------------------------------------------------------------------------------
//      תģ ͺ
// ˵     buff             Ҫ͵ݵַ
// ز     len              ͳ
// ʹʾ     uint32           ʣδ͵ֽ
// ʹʾ     bluetooth_ch9141_send_buff(buff, 16);
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
uint32 bluetooth_ch9141_send_buff (const uint8 *buff, uint32 len)
{
    zf_assert(buff != NULL);
    uint16 time_count = 0;
    while(0 != len)
    {
        if(!gpio_get_level(BLUETOOTH_CH9141_RTS_PIN))                           // RTSΪ͵ƽ 
        {
            if(30 <= len)                                                       // ݷ 30byte ÿ
            {
                uart_write_buffer(BLUETOOTH_CH9141_INDEX, buff, 30);            // 
                buff += 30;                                                     // ַƫ
                len -= 30;                                                      // 
                time_count = 0;
            }
            else                                                                //  30byte һԷ
            {
                uart_write_buffer(BLUETOOTH_CH9141_INDEX, buff, len);           // 
                len = 0;
                break;
            }
        }
        else                                                                    // RTSΪߵƽ ģæ
        {
            if(BLUETOOTH_CH9141_TIMEOUT_COUNT <= (++ time_count))               // ȴʱ
            {
                break;                                                          // ˳
            }
            system_delay_ms(1);
        }
    }
    return len;
}

//-------------------------------------------------------------------------------------------------------------------
//      תģ ַ
// ˵     *str            Ҫ͵ַַ
// ز     uint32          ʣ෢ͳ
// ʹʾ     bluetooth_ch9141_send_string("Trust yourself.");
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
uint32 bluetooth_ch9141_send_string (const char *str)
{
    zf_assert(str != NULL);
    uint16 time_count = 0;
    uint32 len = strlen(str);
    while(0 != len)
    {
        if(!gpio_get_level(BLUETOOTH_CH9141_RTS_PIN))                           // RTSΪ͵ƽ 
        {
            if(30 <= len)                                                       // ݷ 30byte ÿ
            {
                uart_write_buffer(BLUETOOTH_CH9141_INDEX, (const uint8 *)str, 30);   // 
                str += 30;                                                      // ַƫ
                len -= 30;                                                      // 
                time_count = 0;
            }
            else                                                                //  30byte һԷ
            {
                uart_write_buffer(BLUETOOTH_CH9141_INDEX, (const uint8 *)str, len);// 
                len = 0;
                break;
            }
        }
        else                                                                    // RTSΪߵƽ ģæ
        {
            if(BLUETOOTH_CH9141_TIMEOUT_COUNT <= (++ time_count))               // ȴʱ
            {
                break;                                                          // ˳
            }
            system_delay_ms(1);
        }
    }
    return len;
}

//-------------------------------------------------------------------------------------------------------------------
//      תģ ͷͼλ鿴ͼ
// ˵     *image_addr     Ҫ͵ͼַ
// ˵     image_size      ͼĴС
// ز     void
// ʹʾ     bluetooth_ch9141_send_image(&mt9v03x_image[0][0], MT9V03X_IMAGE_SIZE);
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
void bluetooth_ch9141_send_image (const uint8 *image_addr, uint32 image_size)
{
    zf_assert(image_addr != NULL);

    extern uint8 camera_send_image_frame_header[4];
    bluetooth_ch9141_send_buff(camera_send_image_frame_header, 4);
    bluetooth_ch9141_send_buff((uint8 *)image_addr, image_size);
}

//-------------------------------------------------------------------------------------------------------------------
//      תģ ȡ
// ˵     buff            洢ݵַ
// ˵     len             
// ز     uint32          ʵʶȡֽ
// ʹʾ     bluetooth_ch9141_read_buff(buff, 16);
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
uint32 bluetooth_ch9141_read_buff (uint8 *buff, uint32 len)
{
    zf_assert(buff != NULL);
    uint32 data_len = len;
    fifo_read_buffer(&bluetooth_ch9141_fifo, buff, &data_len, FIFO_READ_AND_CLEAN);
    return data_len;
}

//-------------------------------------------------------------------------------------------------------------------
//      תģ жϻص
// ˵     void
// ز     void
// ʹʾ     
// עϢ     ú ISR ļĴжϳ򱻵
//              ɴжϷ wireless_module_uart_handler() 
//               wireless_module_uart_handler() ñ
//-------------------------------------------------------------------------------------------------------------------
void bluetooth_ch9141_uart_callback (void)
{
    uart_query_byte(BLUETOOTH_CH9141_INDEX, &bluetooth_ch9141_data);            // ȡ
    fifo_write_buffer(&bluetooth_ch9141_fifo, &bluetooth_ch9141_data, 1);       //  FIFO
}

//-------------------------------------------------------------------------------------------------------------------
//      תģ ʼ
// ˵     void
// ز     uint8           ʼ״̬ 0-ɹ 1-ʧ
// ʹʾ     bluetooth_ch9141_init();
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
uint8 bluetooth_ch9141_init (void)
{
    uint8 return_state = 0;
    set_wireless_type(BLUETOOTH_CH9141, &bluetooth_ch9141_uart_callback);

    fifo_init(&bluetooth_ch9141_fifo, FIFO_DATA_8BIT, bluetooth_ch9141_buffer, BLUETOOTH_CH9141_BUFFER_SIZE);
    // ʹõĲΪ115200 ΪתģĬϲ ʹλ޸ģ
    gpio_init(BLUETOOTH_CH9141_RTS_PIN, GPI, 1, GPI_PULL_UP);                   // ʼ
    uart_init(BLUETOOTH_CH9141_INDEX, BLUETOOTH_CH9141_BUAD_RATE, BLUETOOTH_CH9141_RX_PIN, BLUETOOTH_CH9141_TX_PIN);
    uart_rx_interrupt(BLUETOOTH_CH9141_INDEX, 1);

    return return_state;
}
