/*********************************************************************************************************************
* RT1064DVL6A Opensourec Library RT1064DVL6A Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
* 
* ļ RT1064DVL6A Դһ
* 
* RT1064DVL6A Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
* 
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
* 
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
* 
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
* 
* ļ          zf_common_interrupt
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           IAR 8.32.4 or MDK 5.33
* ƽ̨          RT1064DVL6A
*           https://seekfree.taobao.com/
* 
* ޸ļ¼
*                               ע
* 2022-09-21        SeekFree            first version
********************************************************************************************************************/

#include "zf_common_interrupt.h"
#include "fsl_common_arm.h"

static uint32 interrupt_nest_count = 0;

//-------------------------------------------------------------------------------------------------------------------
//      ȫжʹ
// ˵     primask         0:ȫж  1:ɲ
// ز     void
// ʹʾ     interrupt_global_enable();
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
void interrupt_global_enable (uint32 primask)
{
    if(interrupt_nest_count)
    {
        interrupt_nest_count --;
    }
    EnableGlobalIRQ(primask);
}

//-------------------------------------------------------------------------------------------------------------------
//      ȫж
// ˵     void
// ز     uint32          رж֮ǰĿ״̬ 0δر 1ѹر
// ʹʾ     interrupt_global_disable();
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
uint32 interrupt_global_disable (void)
{
    interrupt_nest_count++;
    return DisableGlobalIRQ();
}

//-------------------------------------------------------------------------------------------------------------------
//      ָжʹ
// ˵     irqn            ָжϺ ɲ鿴 isr.c ӦжϷıע
// ز     void
// ʹʾ     interrupt_enable(UART1_IRQn);
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
void interrupt_enable (IRQn_Type irqn)
{
    EnableIRQ(irqn);
}

//-------------------------------------------------------------------------------------------------------------------
//      ָж
// ˵     irqn            ָжϺ ɲ鿴 isr.c ӦжϷıע
// ز     void
// ʹʾ     interrupt_disable(UART1_IRQn);
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
void interrupt_disable (IRQn_Type irqn)
{
    DisableIRQ(irqn);
}

//-------------------------------------------------------------------------------------------------------------------
//      ָжȼ
// ˵     irqn            ָжϺ ɲ鿴 isr.c ӦжϷıע
// ˵     priority        жȼ 0-15 ԽԽ
// ز     void
// ʹʾ     interrupt_set_priority(UART1_IRQn, 0);
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
void interrupt_set_priority (IRQn_Type irqn, uint8 priority)
{
    NVIC_SetPriority(irqn, priority);
}

//-------------------------------------------------------------------------------------------------------------------
//      жʼ
// ˵     void
// ز     void
// ʹʾ     interrupt_init();
// עϢ       clock_init ڲ
//-------------------------------------------------------------------------------------------------------------------
void interrupt_init (void)
{
    // жȼ飬ռʽȼ0-15 ȼ
    NVIC_SetPriorityGrouping(3);
}
